/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.periodgrab.ui;

import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.infograb.base.BaseTaskPanel;
import com.huawei.ism.tool.infograb.base.IDetailContainer;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.InfoGrabUserOpData;
import com.huawei.ism.tool.infograb.entity.UserOpDeviceDetail;
import com.huawei.ism.tool.infograb.grab.GrabEngine;
import com.huawei.ism.tool.infograb.intf.worktaker.IGrabRefreshUI;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabUtil;
import com.huawei.ism.tool.infograb.periodgrab.PeriodGrabThread;
import com.huawei.ism.tool.infograb.periodgrab.context.PeriodGrabConfig;
import com.huawei.ism.tool.infograb.periodgrab.entity.PeriodGrabTask;
import com.huawei.ism.tool.infograb.periodgrab.ui.PeriodGrabTaskPanel;
import com.huawei.ism.tool.infograb.service.InfoGrabService;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodGrabAction
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeriodGrabAction.class);
    private volatile boolean monitorRunning = false;
    private InfoGrabService grabService = InfoGrabService.getInstance();
    private Thread monitorThread = null;
    private PeriodGrabTaskPanel taskPanel;

    public PeriodGrabAction(PeriodGrabTaskPanel taskPanel) {
        this.taskPanel = taskPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.monitorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                LOGGER.info("Click collect device btn.");
                PeriodGrabAction.this.doMonitor();
            }
        }, "MonitorThread");
        this.monitorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMonitor() {
        Object object = GrabEngine.BLOCKING_QUEUE_LOCK;
        synchronized (object) {
            if (this.monitorRunning) {
                DialogUtils.showInfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.remind.waitcollectionstop"));
                return;
            }
            List<GrabDevNode2> currSelectedNodesList = ((IDetailContainer)((Object)GrabContext.getInstance().getCurrentTask().getTaskDetailContainer())).getSelectedDevNode();
            if (!this.grabService.preCheckResultFolder()) {
                LOGGER.info("Not collect, please check the file's read or write right! ");
                DialogUtils.showInfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.resultfolder.error"));
                return;
            }
            if (!this.grabService.checkDiskCapactity((long)currSelectedNodesList.size() * 0x500000L)) {
                WarningDialog periodWarningDialog = DialogUtils.showYesNoDialog((Window)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.remind.diskcapactityinsufficient"));
                if (0 == periodWarningDialog.getValue()) {
                    LOGGER.info("Select the disk may result in the acquisition failed due to insufficient capacity!");
                    for (GrabDevNode2 devNode : currSelectedNodesList) {
                        this.grabService.refreshPeriodStopStatus(devNode);
                    }
                }
                return;
            }
            if (!GrabUtil.checkAtLeastOneNode(currSelectedNodesList)) {
                LOGGER.info("Not select an devNode");
                return;
            }
            this.checkDevNodeConfigure(currSelectedNodesList);
        }
    }

    private void checkDevNodeConfigure(List<GrabDevNode2> currSelectedNodesList) {
        if (!this.grabService.isSelectedNodesStopped(currSelectedNodesList)) {
            LOGGER.info("The devNode is busy");
            DialogUtils.showInfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.option.error.grab"));
            return;
        }
        this.refreshUI();
        BaseTaskPanel currentTaskPanel = GrabContext.getInstance().getCurrentTask();
        for (GrabDevNode2 devNode : currSelectedNodesList) {
            if (devNode.isCollectStop()) {
                devNode.setCollectStop(false);
            }
            if (!devNode.isCollectDone()) continue;
            devNode.setCollectDone(false);
            int oldProcess = GrabContext.getInstance().getCurrentTask().getTask().getTaskCurruentProcess();
            int newProcess = oldProcess - 1;
            currentTaskPanel.getTask().setTaskCurruentProcess(newProcess);
            currentTaskPanel.refreshTaskProcess();
        }
        this.clearOldData(currSelectedNodesList);
        this.setChoosenNodeRunning(currSelectedNodesList);
        PeriodGrabTask curTask = (PeriodGrabTask)GrabContext.getInstance().getCurrentTask().getTask();
        curTask.setTaskStartTime(System.currentTimeMillis());
        this.initMonitorFlowThreads(currSelectedNodesList);
    }

    private void initMonitorFlowThreads(List<GrabDevNode2> currSelectedNodes) {
        for (GrabDevNode2 currNode : currSelectedNodes) {
            GrabEngine.getInstance().addOneMonitorThread(currNode, (IGrabRefreshUI)((Object)this.taskPanel.getTaskDetailContainer()));
        }
        this.saveUserOpData(currSelectedNodes);
    }

    private void saveUserOpData(List<GrabDevNode2> currSelectedDevs) {
        LOGGER.info("begin save periodGrab's userOpData.");
        InfoGrabUserOpData infoGrabUserOpData = this.createPeriodUserOpData(currSelectedDevs);
        for (GrabDevNode2 devNode2 : currSelectedDevs) {
            ConcurrentHashMap<GrabDevNode2, PeriodGrabThread> currThreadMap = GrabEngine.getInstance().getCurrMonitorThreadMap();
            UserOpDeviceDetail userOpDeviceDetail = currThreadMap.get((Object)devNode2).getUserOpDeviceDetail();
            if (null == userOpDeviceDetail) continue;
            infoGrabUserOpData.getDeviceDetailList().add(userOpDeviceDetail);
        }
        infoGrabUserOpData.setDeviceList2String();
        infoGrabUserOpData.setDeviceSn("");
        infoGrabUserOpData.setDeviceType("");
        infoGrabUserOpData.setDeviceVersion("");
        infoGrabUserOpData.setAuthWay("");
        infoGrabUserOpData.setProxyWay("");
        infoGrabUserOpData.setIpv("");
        infoGrabUserOpData.setTaskResult(UserOpTaskResult.SUCCESS);
        GrabContext.getInstance().getInfoGrabUserOpDatas().add(infoGrabUserOpData);
    }

    private InfoGrabUserOpData createPeriodUserOpData(List<GrabDevNode2> currSelectedDev) {
        InfoGrabUserOpData userOpData = new InfoGrabUserOpData();
        String type = "PeriodGrab";
        userOpData.setTaskType(type);
        int devNums = currSelectedDev.size();
        userOpData.setDeviceNums(devNums);
        if (!currSelectedDev.isEmpty()) {
            PeriodGrabConfig monitorConfig = GrabContext.getInstance().getMonitorConfigMap().get((Object)currSelectedDev.get(0));
            JSONObject periodConfig = new JSONObject();
            periodConfig.put("cpuThreshold", (Object)monitorConfig.getCpuThreshold());
            periodConfig.put("memThreshold", (Object)monitorConfig.getMemThreshold());
            periodConfig.put("ioPs", (Object)monitorConfig.getIopsThreshold());
            periodConfig.put("bandwidthThreshold", (Object)monitorConfig.getBandwidthThreshold());
            periodConfig.put("monitorTime", (Object)monitorConfig.getMonitorTime());
            periodConfig.put("freqAndUnit", (Object)monitorConfig.getMonitorFreqAndUnit());
            userOpData.setPeriodConfigInfo(periodConfig.toJSONString());
        }
        return userOpData;
    }

    private void refreshUI() {
        JLabel taskStatus = this.taskPanel.getTaskStatus();
        taskStatus.setText(ResourceUtil.getString((String)"infograb.task.status.collecting"));
        taskStatus.setIcon(ResourceUtil.getImage((String)"loading.gif"));
        taskStatus.repaint();
    }

    private void clearOldData(List<GrabDevNode2> currSelectedNodes) {
        ConcurrentHashMap<GrabDevNode2, List<ExecuteResult>> currResultMap = GrabContext.getInstance().getExecuteResultMap();
        for (GrabDevNode2 node : currSelectedNodes) {
            currResultMap.remove((Object)node);
        }
    }

    private void setChoosenNodeRunning(List<GrabDevNode2> currSelectedNodes) {
        InfoGrabService.getInstance().setNodesRunning(currSelectedNodes);
    }

    public Thread getMonitorThread() {
        return this.monitorThread;
    }
}

