/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.periodgrab.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.periodgrab.context.PeriodGrabConfig;
import com.huawei.ism.tool.infograb.periodgrab.context.PeriodGrabContext;
import com.huawei.ism.tool.infograb.periodgrab.ui.PeriodGrabTaskDetailContainer;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class PeriodGrabSetupDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(PeriodGrabSetupDialog.class);
    private static final String FREQ_MINUTER = ResourceUtil.getString((String)"infograb.task.status.freq_min_unit");
    private static final String FREQ_SECOND = ResourceUtil.getString((String)"infograb.task.status.freq_second_unit");
    private static final String DAY = ResourceUtil.getString((String)"infograb.task.status.day");
    private static final String HOUR = ResourceUtil.getString((String)"infograb.task.status.hour");
    private static final String MINUTER = ResourceUtil.getString((String)"infograb.task.status.min");
    private static final String SECOND = ResourceUtil.getString((String)"infograb.task.status.s");
    private JButton confirmBtn = null;
    private JButton cancelBtn = null;
    private JLabel monitorTimeLabel;
    private JLabel monitorFrequency;
    private IsmTextField timeTextField;
    private JComboBox<String> timeUnitPeriodComoBox;
    private IsmTextField frequencyTextField;
    private JComboBox<String> freqUnitComboBox;
    private JComponent frequencyInput;
    private GrabDevNode2 device;
    private PeriodGrabTaskDetailContainer container;
    private JLabel cpuTHLabel;
    private JLabel periodMemTHLabel;
    private JLabel iopsTHLabel;
    private JLabel bandwidthTHLabel;
    private IsmTextField cpuTHField;
    private IsmTextField memTHField;
    private IsmTextField iopsTHField;
    private IsmTextField bandwidthTHField;
    private JComboBox<String> periodCpuTHUnitComboBox;
    private JComboBox<String> memTHUnitComboBox;
    private JComboBox<String> iopsTHUnitComboBox;
    private JComboBox<String> periodBandwidthTHUnitComboBox;

    public PeriodGrabSetupDialog(Window parent, PeriodGrabTaskDetailContainer taskDetailContainer, GrabDevNode2 devNode) {
        super(parent);
        this.setMinimumSize(new Dimension(350, 400));
        this.setResizable(false);
        this.setTitle(ResourceUtil.getString((String)"infograb.period.grab.setting.title"));
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
        this.setModal(true);
        this.device = devNode;
        this.container = taskDetailContainer;
        this.initUI();
        this.initData();
        this.initLayout();
        this.initListener();
    }

    private void initData() {
        String[] freqUnit;
        PeriodGrabConfig monitorConfig = GrabContext.getInstance().getMonitorConfigMap().get((Object)this.device);
        String timeAndUnit = monitorConfig.getMonitorTimeAndUnit();
        String freqAndUnit = monitorConfig.getMonitorFreqAndUnit();
        String[] timeUnit = timeAndUnit.split(":");
        if (timeUnit.length > 1) {
            this.timeTextField.setText(timeUnit[0]);
            if (DAY.equals(timeUnit[1])) {
                this.timeUnitPeriodComoBox.setSelectedItem(DAY);
            } else if (HOUR.equals(timeUnit[1])) {
                this.timeUnitPeriodComoBox.setSelectedItem(HOUR);
            } else if (MINUTER.equals(timeUnit[1])) {
                this.timeUnitPeriodComoBox.setSelectedItem(MINUTER);
            } else if (SECOND.equals(timeUnit[1])) {
                this.timeUnitPeriodComoBox.setSelectedItem(SECOND);
            }
        }
        if ((freqUnit = freqAndUnit.split(":")).length >= 1) {
            this.frequencyTextField.setText(freqUnit[0]);
            if (FREQ_MINUTER.equals(freqUnit[1])) {
                this.freqUnitComboBox.setSelectedItem(FREQ_MINUTER);
            } else if (FREQ_SECOND.equals(freqUnit[1])) {
                this.freqUnitComboBox.setSelectedItem(FREQ_SECOND);
            }
        }
        int cpuTh = (int)monitorConfig.getCpuThreshold();
        this.cpuTHField.setText(cpuTh + "");
        int memTh = (int)monitorConfig.getMemThreshold();
        this.memTHField.setText(memTh + "");
        int iopsTh = (int)monitorConfig.getIopsThreshold();
        this.iopsTHField.setText(iopsTh + "");
        int bwTh = (int)monitorConfig.getBandwidthThreshold();
        if (bwTh >= 1024) {
            this.bandwidthTHField.setText(bwTh / 1024 + "");
            this.periodBandwidthTHUnitComboBox.setSelectedItem("Mbps");
        } else {
            this.bandwidthTHField.setText(bwTh + "");
            this.periodBandwidthTHUnitComboBox.setSelectedItem("Kbps");
        }
    }

    private void initListener() {
    }

    private void initUI() {
        this.monitorTimeLabel = new JLabel(ResourceUtil.getString((String)"infograb.task.status.monitor_time"));
        this.monitorFrequency = new JLabel(ResourceUtil.getString((String)"infograb.task.status.monitor_frequency"));
        this.timeTextField = IsmTextField.getNameTextField((String)"\\d{0,2}", (String)"", (int)5, (int)2);
        this.timeUnitPeriodComoBox = new JComboBox();
        this.timeUnitPeriodComoBox.addItem(ResourceUtil.getString((String)"infograb.task.status.day"));
        this.timeUnitPeriodComoBox.addItem(ResourceUtil.getString((String)"infograb.task.status.hour"));
        this.timeUnitPeriodComoBox.addItem(ResourceUtil.getString((String)"infograb.task.status.min"));
        this.timeUnitPeriodComoBox.setPreferredSize(new Dimension(50, 21));
        this.frequencyTextField = IsmTextField.getNameTextField((String)"\\d{0,2}", (String)"", (int)5, (int)2);
        this.freqUnitComboBox = new JComboBox();
        this.freqUnitComboBox.setPreferredSize(new Dimension(50, 21));
        this.freqUnitComboBox.addItem(ResourceUtil.getString((String)"infograb.task.status.freq_min_unit"));
        this.freqUnitComboBox.addItem(ResourceUtil.getString((String)"infograb.task.status.freq_second_unit"));
        this.cpuTHLabel = new JLabel(ResourceUtil.getString((String)"infograb.task.setting.cpu"));
        this.periodMemTHLabel = new JLabel(ResourceUtil.getString((String)"infograb.task.setting.mem"));
        this.iopsTHLabel = new JLabel(ResourceUtil.getString((String)"infograb.task.setting.iops"));
        this.bandwidthTHLabel = new JLabel(ResourceUtil.getString((String)"infograb.task.setting.bandwidth"));
        this.cpuTHField = IsmTextField.getNameTextField((String)"\\d{0,2}", (String)"", (int)5, (int)2);
        this.memTHField = IsmTextField.getNameTextField((String)"\\d{0,2}", (String)"", (int)5, (int)2);
        this.iopsTHField = IsmTextField.getNameTextField((String)"\\d{0,5}", (String)"", (int)5, (int)2);
        this.bandwidthTHField = IsmTextField.getNameTextField((String)"\\d{0,6}", (String)"", (int)5, (int)2);
        this.periodCpuTHUnitComboBox = new JComboBox();
        this.periodCpuTHUnitComboBox.addItem("%     ");
        this.periodCpuTHUnitComboBox.setEnabled(false);
        this.memTHUnitComboBox = new JComboBox();
        this.memTHUnitComboBox.addItem("%     ");
        this.memTHUnitComboBox.setEnabled(false);
        this.iopsTHUnitComboBox = new JComboBox();
        this.iopsTHUnitComboBox.addItem("IOPS");
        this.iopsTHUnitComboBox.setEnabled(false);
        this.periodBandwidthTHUnitComboBox = new JComboBox();
        this.periodBandwidthTHUnitComboBox.addItem("Kbps");
        this.periodBandwidthTHUnitComboBox.addItem("Mbps");
        this.periodBandwidthTHUnitComboBox.setSelectedItem(PeriodGrabContext.getDefaultBwThUnit());
        this.confirmBtn = UiMethod.createButton(ResourceUtil.getString((String)"infograb.switch_root_confirm"), 'O');
        this.cancelBtn = UiMethod.createButton(ResourceUtil.getString((String)"infograb.switch_root_cancel"), 'C');
        this.confirmBtn.addActionListener(this);
        this.cancelBtn.addActionListener(this);
    }

    private void initLayout() {
        Box timePeriodComponent = UCD.buildHBoxLeft((Component[])new Component[]{this.monitorTimeLabel, this.timeTextField, this.timeUnitPeriodComoBox});
        Box frequencyComponent = UCD.buildHBoxLeft((Component[])new Component[]{this.monitorFrequency, this.frequencyTextField, this.freqUnitComboBox});
        this.frequencyInput = UCD.buildVerticalBox(null, (Component[])new Component[]{timePeriodComponent, frequencyComponent});
        this.frequencyInput.setBorder(BorderFactory.createTitledBorder(ResourceUtil.getString((String)"infograb.item.category.period.setting")));
        JComponent frequencyInput2 = UCD.buildVerticalBox(null, (Component[])new Component[]{timePeriodComponent, frequencyComponent});
        frequencyInput2.setBorder(BorderFactory.createTitledBorder(ResourceUtil.getString((String)"infograb.item.category.period.setting")));
        Box cpuSettingCom = UCD.buildHBoxLeft((Component[])new Component[]{this.cpuTHLabel, this.cpuTHField, this.periodCpuTHUnitComboBox});
        Box memSettingCom = UCD.buildHBoxLeft((Component[])new Component[]{this.periodMemTHLabel, this.memTHField, this.memTHUnitComboBox});
        Box iopsSettingCom = UCD.buildHBoxLeft((Component[])new Component[]{this.iopsTHLabel, this.iopsTHField, this.iopsTHUnitComboBox});
        Box bandwidthSettingCom = UCD.buildHBoxLeft((Component[])new Component[]{this.bandwidthTHLabel, this.bandwidthTHField, this.periodBandwidthTHUnitComboBox});
        JComponent settingComp = UCD.buildVerticalBox((Border)BorderFactory.createTitledBorder(ResourceUtil.getString((String)"infograb.task.setting.title")), (Component[])new Component[]{cpuSettingCom, memSettingCom, iopsSettingCom, bandwidthSettingCom});
        Box contentArea = UiMethod.createVerticalBox(settingComp, frequencyInput2, UCD.buildHBoxRight((Component[])new Component[]{this.confirmBtn, this.cancelBtn}));
        this.add((Component)UiMethod.buildFrameSpace(contentArea, 12), "Center");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        LOGGER.info((Object)"setting config.");
        if (null != event) {
            Object source = event.getSource();
            if (source == this.confirmBtn) {
                String timeText = this.timeTextField.getText().trim();
                String frequencyText = this.frequencyTextField.getText().trim();
                if (StringUtils.isNULLStr((String)timeText) || StringUtils.isNULLStr((String)frequencyText)) {
                    DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.task.status.not_time_frequency"));
                    return;
                }
                this.confirm();
            } else if (source == this.cancelBtn) {
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    private void confirm() {
        PeriodGrabConfig monitorConfig = new PeriodGrabConfig();
        String timeText = this.timeTextField.getText().trim();
        String frequencyText = this.frequencyTextField.getText().trim();
        String timeUnit = String.valueOf(this.timeUnitPeriodComoBox.getSelectedItem());
        String freqUnit = String.valueOf(this.freqUnitComboBox.getSelectedItem());
        long monitorTimeLong = 0L;
        if (DAY.equals(timeUnit)) {
            monitorTimeLong = Long.valueOf(timeText) * 24L * 60L * 60L;
        } else if (HOUR.endsWith(timeUnit)) {
            monitorTimeLong = Long.valueOf(timeText) * 60L * 60L;
        } else if (MINUTER.endsWith(timeUnit)) {
            monitorTimeLong = Long.valueOf(timeText) * 60L;
        }
        long monitorFreq = 0L;
        if (FREQ_MINUTER.equals(freqUnit)) {
            monitorFreq = Long.valueOf(frequencyText) * 60L;
        } else if (FREQ_SECOND.equals(freqUnit)) {
            monitorFreq = Long.valueOf(frequencyText);
        }
        if (monitorTimeLong == 0L || monitorFreq == 0L) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.task.status.tims.zero"));
            return;
        }
        long monitorCount = monitorTimeLong / monitorFreq;
        if (monitorCount == 0L) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.task.status.monitor.input_erro"));
            return;
        }
        monitorConfig.setMonitorTime(monitorTimeLong);
        monitorConfig.setMonitorFreq(monitorFreq);
        StringBuilder timeAndUnit = new StringBuilder();
        timeAndUnit.append(timeText);
        timeAndUnit.append(':');
        timeAndUnit.append(timeUnit);
        monitorConfig.setMonitorTimeAndUnit(timeAndUnit.toString());
        StringBuilder freqAndUnitStrBui = new StringBuilder();
        freqAndUnitStrBui.append(frequencyText);
        freqAndUnitStrBui.append(':');
        freqAndUnitStrBui.append(freqUnit);
        monitorConfig.setMonitorFreqAndUnit(freqAndUnitStrBui.toString());
        monitorConfig.setCpuThreshold(this.cpuTHField.getText().trim());
        monitorConfig.setMemThreshold(this.memTHField.getText().trim());
        monitorConfig.setIopsThreshold(this.iopsTHField.getText().trim());
        monitorConfig.setBandwidthThreshold(this.bandwidthTHField.getText().trim() + ":" + ((String)this.periodBandwidthTHUnitComboBox.getSelectedItem()).trim());
        GrabContext.getInstance().getMonitorConfigMap().put(this.device, monitorConfig);
        this.container.refreshModify(this.device);
        this.setVisible(false);
        this.dispose();
    }
}

