/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.periodgrab.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IDeviceManage;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.listener.INodeObserver;
import com.huawei.ism.tool.infograb.base.IDetailContainer;
import com.huawei.ism.tool.infograb.base.ITaskDetailRefreshUI;
import com.huawei.ism.tool.infograb.context.CollectStatusEnum;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.GrabResultEntity;
import com.huawei.ism.tool.infograb.entity.Item;
import com.huawei.ism.tool.infograb.periodgrab.context.PeriodGrabConfig;
import com.huawei.ism.tool.infograb.periodgrab.entity.PeriodGrabResult;
import com.huawei.ism.tool.infograb.periodgrab.entity.PeriodGrabTask;
import com.huawei.ism.tool.infograb.periodgrab.entity.PeriodGrabTimeUtil;
import com.huawei.ism.tool.infograb.periodgrab.ui.PeriodGrabAction;
import com.huawei.ism.tool.infograb.periodgrab.ui.PeriodGrabTaskPanel;
import com.huawei.ism.tool.infograb.periodgrab.ui.StopPeriodGrabAction;
import com.huawei.ism.tool.infograb.service.CollectStatusCache;
import com.huawei.ism.tool.infograb.service.InfoGrabService;
import com.huawei.ism.tool.infograb.ui.InfoGrabIsmTable;
import com.huawei.ism.tool.infograb.ui.InfoGrabMainFrame;
import com.huawei.ism.tool.infograb.ui.action.AddDeviceAction;
import com.huawei.ism.tool.infograb.ui.action.BatchImportAction;
import com.huawei.ism.tool.infograb.ui.action.DelDeviceAction;
import com.huawei.ism.tool.infograb.ui.action.DetailListerListener;
import com.huawei.ism.tool.infograb.ui.action.ListSelectListener;
import com.huawei.ism.tool.infograb.ui.support.DeviceSetupIcon;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.obase.ui.tablecompositer.IpAddressStrategy;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.RolloverButton;
import com.huawei.ism.ui.swing.plaf.armor.ArmorListUI;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ListUI;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodGrabTaskDetailContainer
extends JSplitPane
implements ITaskDetailRefreshUI,
IDetailContainer {
    private static final long serialVersionUID = 2064556641440433799L;
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoGrabMainFrame.class);
    private static String collectingString = CollectStatusEnum.COLLECTING.toString();
    private ReentrantLock lockUI = new ReentrantLock();
    private int moniDeviceType = 0;
    private int moniDeviceIp = 1;
    private int moniTimes = 2;
    private int moniCPU = 3;
    private int moniMemory = 4;
    private int moniIOP = 5;
    private int moniBandWidth = 6;
    private int moniStatus = 7;
    private int moniLeftTime = 8;
    private int moniOptions = 9;
    private Dimension defaultSize;
    private RolloverButton addDevBtn;
    private RolloverButton deletePeriodDevBtn;
    private RolloverButton batchImportBtn;
    private RolloverButton collectBtn;
    private RolloverButton stopCollectBtn;
    private final String[] tableHeaders = this.initColumnName();
    private DefaultTableModel deviceTableModel;
    private InfoGrabIsmTable devTable;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private transient PeriodGrabAction monitorDeviceAction;
    private transient StopPeriodGrabAction stopCollectAction = new StopPeriodGrabAction();
    private transient CollectStatusCache statusCache = CollectStatusCache.getInstance();
    private List<String> hostdeviceTypeL3 = new LinkedList<String>();
    private List<String> dataBasedeviceTypeL3 = new LinkedList<String>();
    private List<String> switchdeviceTypeL3 = new LinkedList<String>();
    private PeriodGrabTaskPanel taskPanel;

    public PeriodGrabTaskDetailContainer(PeriodGrabTaskPanel taskPanel) {
        super(1, false);
        this.setDividerSize(0);
        this.taskPanel = taskPanel;
        this.initUIComponent();
        this.layoutComponent();
        this.initListener();
        this.initDevType();
    }

    private void initUIComponent() {
        this.defaultSize = new Dimension(850, 550);
        this.addDevBtn = new RolloverButton(ResourceUtil.getString((String)"infograb.button.adddevice"));
        this.addDevBtn.setMnemonic('A');
        this.deletePeriodDevBtn = new RolloverButton(ResourceUtil.getString((String)"infograb.button.deletedevice"));
        this.deletePeriodDevBtn.setMnemonic('E');
        this.batchImportBtn = new RolloverButton(ResourceUtil.getString((String)"infograb.button.batchimport"));
        this.batchImportBtn.setMnemonic('B');
        this.collectBtn = new RolloverButton(ResourceUtil.getString((String)"infinfograb.button.domonitor"));
        this.collectBtn.setMnemonic('O');
        this.stopCollectBtn = new RolloverButton(ResourceUtil.getString((String)"infinfograb.button.stopmonitor"));
        this.stopCollectBtn.setMnemonic('S');
        this.deviceTableModel = new DefaultTableModel(this.tableHeaders, new int[0]);
        this.devTable = new InfoGrabIsmTable((TableModel)this.deviceTableModel);
        this.devTable.setName("_Table_devTable");
        this.addNodeObserver();
    }

    private void addNodeObserver() {
        IDeviceManage devMng = (IDeviceManage)PublicServiceManage.getInstance().getService(IDeviceManage.class);
        devMng.addInfoGrabNodeObservers((INodeObserver)this);
    }

    private void layoutComponent() {
        this.buttonGroup.add((AbstractButton)this.collectBtn);
        this.buttonGroup.add((AbstractButton)this.stopCollectBtn);
        JComponent tableTopBtnArea = UiMethod.buildCompsLeft(new Component[]{this.addDevBtn, this.deletePeriodDevBtn, this.batchImportBtn, this.collectBtn, this.stopCollectBtn});
        JComponent tableArea = this.tablePanel();
        JComponent taskDetailArea = UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{tableTopBtnArea, new JSeparator(), tableArea});
        taskDetailArea.setAlignmentX(0.0f);
        this.setAlignmentX(0.0f);
        this.add(taskDetailArea);
    }

    private void initListener() {
        this.monitorDeviceAction = new PeriodGrabAction(this.taskPanel);
        this.addDevBtn.addActionListener((ActionListener)new AddDeviceAction());
        this.deletePeriodDevBtn.addActionListener((ActionListener)new DelDeviceAction());
        this.batchImportBtn.addActionListener((ActionListener)((Object)new BatchImportAction(GrabContext.getInstance().getCurrInfoGrabFrame())));
        this.collectBtn.addActionListener((ActionListener)this.monitorDeviceAction);
        this.stopCollectBtn.addActionListener((ActionListener)this.stopCollectAction);
        this.getDevTable().addMouseListener(new DetailListerListener());
        this.getDevTable().getSelectionModel().addListSelectionListener(new ListSelectListener());
    }

    private JComponent tablePanel() {
        TableScrollPane tsp = new TableScrollPane((IsmTable)this.devTable, true, true, true);
        tsp.setPreferredSize(this.defaultSize);
        tsp.setMinimumSize(new Dimension(tsp.getPreferredSize().width, 600));
        tsp.setBorder(null);
        return tsp;
    }

    private String[] initColumnName() {
        String[] columnName = new String[]{ResourceUtil.getString((String)"infograb.devicetable.head.devicetype"), ResourceUtil.getString((String)"infograb.devicetable.head.ip"), ResourceUtil.getString((String)"infograb.item.monitor.times"), ResourceUtil.getString((String)"infograb.item.monitor.cpu"), ResourceUtil.getString((String)"infograb.item.monitor.memory"), ResourceUtil.getString((String)"infograb.item.monitor.iops"), ResourceUtil.getString((String)"infograb.item.monitor.bandwidth"), ResourceUtil.getString((String)"infograb.devicetable.head.status"), ResourceUtil.getString((String)"infograb.item.monitor.lefttime"), ResourceUtil.getString((String)"infograb.devicetable.head.operation")};
        return columnName;
    }

    private TableRow<GrabDevNode2, String> createTableRow(GrabDevNode2 dev, PeriodGrabConfig monitorConfig) {
        DefaultTableRow row = new DefaultTableRow(this.getTableColumn(), (Object)dev, (Object)dev.getDeviceSerialNumber());
        row.setValueAt(this.moniDeviceType, (Object)dev.getItDeviceType().toString());
        row.setValueAt(this.moniDeviceIp, (Object)new IpAddressStrategy(dev.getIp()));
        row.setValueAt(this.moniTimes, (Object)0);
        row.setValueAt(this.moniCPU, (Object)"--");
        row.setValueAt(this.moniMemory, (Object)"--");
        row.setValueAt(this.moniIOP, (Object)"--");
        row.setValueAt(this.moniBandWidth, (Object)"--");
        row.setValueAt(this.moniLeftTime, (Object)PeriodGrabTimeUtil.format(monitorConfig.getMonitorTime()));
        row.setValueAt(this.moniStatus, (Object)this.getStatusCell(CollectStatusEnum.NOT_COLLECT));
        row.setValueAt(this.moniOptions, (Object)new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"infograb.setup"), new DeviceSetupIcon(dev, this).getAction()));
        return row;
    }

    private IsmTableCell getStatusCell(CollectStatusEnum status) {
        return this.statusCache.getTableCellFromStatus(status);
    }

    @Override
    public List<GrabDevNode2> getSelectedDevNode() {
        int[] rowIndexs = this.getDevTable().getSelectedRows();
        ArrayList<GrabDevNode2> resultsList = new ArrayList<GrabDevNode2>();
        GrabDevNode2 devNode = null;
        if (rowIndexs == null || rowIndexs.length == 0) {
            return resultsList;
        }
        for (int index : rowIndexs) {
            index = this.getDevTable().convertRowIndexToModel(index);
            TableRow row = this.getDeviceTableModel().getRow(index);
            devNode = (GrabDevNode2)((Object)row.getUserObject());
            resultsList.add(devNode);
        }
        return resultsList;
    }

    @Override
    public List<GrabDevNode2> getAllDevNode() {
        List rows = this.getDevTable().getAllRows();
        ArrayList<GrabDevNode2> resultsList = new ArrayList<GrabDevNode2>();
        GrabDevNode2 devNode = null;
        if (rows == null || rows.isEmpty()) {
            return resultsList;
        }
        for (TableRow row : rows) {
            devNode = (GrabDevNode2)((Object)row.getUserObject());
            resultsList.add(devNode);
        }
        return resultsList;
    }

    private void initDevType() {
        this.hostdeviceTypeL3.add("Linux");
        this.hostdeviceTypeL3.add("AIX");
        this.hostdeviceTypeL3.add("HP-UX");
        this.hostdeviceTypeL3.add("Solaris");
        this.hostdeviceTypeL3.add("VMware");
        this.hostdeviceTypeL3.add("Windows");
        this.hostdeviceTypeL3.add("FusionSphere");
        this.dataBasedeviceTypeL3.add("Oracle");
        this.dataBasedeviceTypeL3.add("MySQL");
        this.dataBasedeviceTypeL3.add("SQLServer");
        this.dataBasedeviceTypeL3.add("DB2");
        this.switchdeviceTypeL3.add("Brocade");
        this.switchdeviceTypeL3.add("Cisco");
    }

    public int getListIndex(Point point, JList detailList) {
        ListUI obj = detailList.getUI();
        if (obj instanceof ArmorListUI) {
            ArmorListUI ui = (ArmorListUI)detailList.getUI();
            return ui.locationToRow(point);
        }
        return detailList.getSelectedIndex();
    }

    public void fireNodeAdd(DevNode device) {
        final GrabDevNode2 dev = ToolUtils.toGrabNewNode(device);
        final PeriodGrabTask task = (PeriodGrabTask)this.taskPanel.getTask();
        if (this.taskPanel.getTask().getId().equals(GrabContext.getInstance().getCurrentTask().getTask().getId())) {
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    GrabDevNode2 lastNodePeriod = GrabContext.getInstance().getCurrentChosenDevNode();
                    if (lastNodePeriod != null) {
                        TableRow row = PeriodGrabTaskDetailContainer.this.getDeviceTableModel().getTableRowBy((Object)lastNodePeriod.getDeviceSerialNumber());
                        this.setRow(lastNodePeriod, row);
                    }
                    GrabContext.getInstance().setCurrentChosenDevNode(null);
                    PeriodGrabConfig monitorConfig = task.getMonitorConfig();
                    TableRow row = PeriodGrabTaskDetailContainer.this.createTableRow(dev, monitorConfig);
                    List oldRows = PeriodGrabTaskDetailContainer.this.getDeviceTableModel().getAllRows();
                    if (!oldRows.contains(row)) {
                        oldRows.add(0, row);
                    }
                    PeriodGrabTaskDetailContainer.this.getDevTable().getRowSorter().setSortKeys(new ArrayList());
                    PeriodGrabTaskDetailContainer.this.getDeviceTableModel().removeAll();
                    PeriodGrabTaskDetailContainer.this.getDeviceTableModel().addRows(oldRows);
                }

                private void setRow(GrabDevNode2 lastNodePeriod, TableRow rowParm) {
                    if (rowParm != null) {
                        rowParm.setValueAt(PeriodGrabTaskDetailContainer.this.moniDeviceType, (Object)lastNodePeriod.getItDeviceType().toString());
                    }
                }
            });
            int oldMaxProcess = this.taskPanel.getTask().getTaskMaxProcess();
            int newMaxProcess = ++oldMaxProcess;
            this.taskPanel.getTask().setTaskMaxProcess(newMaxProcess);
            this.taskPanel.refreshTaskProcess();
            GrabContext.getInstance().getTaskMap().put(dev, task);
            GrabContext.getInstance().getMonitorConfigMap().put(dev, task.getMonitorConfig());
            AtomicInteger devCount = GrabContext.getInstance().getDevCount();
            devCount.set(devCount.incrementAndGet());
            GrabContext.getInstance().setDevCount(devCount);
        }
    }

    public void fireNodeDelete(DevNode devDele) {
        if (this.taskPanel.getTask().getId().equals(GrabContext.getInstance().getCurrentTask().getTask().getId())) {
            TableRow row = this.getDeviceTableModel().getTableRowBy((Object)devDele.getDeviceSerialNumber().toUpperCase(Locale.ENGLISH));
            this.getDeviceTableModel().removeRow(new TableRow[]{row});
            int oldMaxProcess = ((PeriodGrabTask)this.taskPanel.getTask()).getTaskMaxProcess();
            int newMaxProcess = --oldMaxProcess;
            if (null != row && row.getValueAt(this.moniStatus).toString().equals(ResourceUtil.getString((String)"infograb.dev.status.collectfinished"))) {
                int oldProcess = this.taskPanel.getTask().getTaskCurruentProcess();
                int newProcess = oldProcess - 1;
                this.taskPanel.getTask().setTaskCurruentProcess(newProcess);
            }
            this.taskPanel.getTask().setTaskMaxProcess(newMaxProcess);
            this.taskPanel.refreshTaskProcess();
            AtomicInteger devAtoCount = GrabContext.getInstance().getDevCount();
            devAtoCount.set(devAtoCount.decrementAndGet());
            GrabContext.getInstance().setDevCount(devAtoCount);
        }
    }

    public void fireNodeModify(DevNode dev) {
        GrabDevNode2 node;
        TableRow rowTable;
        if (this.taskPanel.getTask().getId().equals(GrabContext.getInstance().getCurrentTask().getTask().getId()) && (rowTable = this.getDeviceTableModel().getTableRowBy((Object)dev.getDeviceSerialNumber())) != null && (node = (GrabDevNode2)((Object)rowTable.getUserObject())) != null) {
            node.setLoginUser(dev.getLoginUser());
            node.setPort(dev.getPort());
        }
    }

    public void refreshModify(GrabDevNode2 devNode) {
        TableRow row;
        if (this.taskPanel.getTask().getId().equals(GrabContext.getInstance().getCurrentTask().getTask().getId()) && (row = this.getDeviceTableModel().getTableRowBy((Object)devNode.getDeviceSerialNumber())) != null) {
            PeriodGrabConfig monitorConfig = GrabContext.getInstance().getMonitorConfigMap().get((Object)devNode);
            row.setValueAt(this.moniLeftTime, (Object)PeriodGrabTimeUtil.format(monitorConfig.getMonitorTime()));
            this.getDevTable().repaint();
        }
    }

    private List<TableRow> findLoadingRows() {
        LinkedList<TableRow> loadingRowsList = new LinkedList<TableRow>();
        List<TableRow> allRows = this.getAllTableRow();
        for (TableRow row : allRows) {
            if (!this.isLoadingRow((TableRow<GrabDevNode2, String>)row)) continue;
            loadingRowsList.add(row);
        }
        return loadingRowsList;
    }

    private List<TableRow> getAllTableRow() {
        return this.getDeviceTableModel().getAllRows();
    }

    private boolean isLoadingRow(TableRow<GrabDevNode2, String> row) {
        IsmTableCell.IconCell iconCell = (IsmTableCell.IconCell)row.getValueAt(this.moniStatus);
        return iconCell.toString().equals(collectingString);
    }

    @Override
    public void changeSelectNodeStatus(final GrabDevNode2 devNode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableRow changeRow = PeriodGrabTaskDetailContainer.this.getTableRow(devNode.getDeviceSerialNumber());
                if (null != changeRow) {
                    changeRow.setValueAt(PeriodGrabTaskDetailContainer.this.moniStatus, (Object)PeriodGrabTaskDetailContainer.this.getStatusCell(CollectStatusEnum.COLLECTING));
                }
                PeriodGrabTaskDetailContainer.this.getDevTable().repaint();
            }
        });
    }

    private TableRow<GrabDevNode2, String> getTableRow(String id) {
        List tableRowsList = this.getDeviceTableModel().getAllRows();
        for (TableRow row : tableRowsList) {
            if (!((String)row.getIdentifier()).equals(id)) continue;
            return row;
        }
        return null;
    }

    @Override
    public void collectCallback(GrabDevNode2 devNode) {
    }

    @Override
    public void refurbishDetailList() {
        TableRow row;
        GrabDevNode2 lastNode = GrabContext.getInstance().getCurrentChosenDevNode();
        GrabDevNode2 devNode = this.getCurrentChosenDevNode();
        if (lastNode != null && (row = this.getDeviceTableModel().getTableRowBy((Object)lastNode.getDeviceSerialNumber())) != null) {
            TableRow currentRow;
            row.setValueAt(this.moniDeviceType, (Object)lastNode.getItDeviceType().toString());
            if (null != devNode && null != (currentRow = this.getDeviceTableModel().getTableRowBy((Object)devNode.getDeviceSerialNumber()))) {
                currentRow.setValueAt(this.moniDeviceType, (Object)new IsmTableCell.ComboCell(new IsmTableCell[]{new IsmTableCell.LabelCell(devNode.getItDeviceType().toString()), new IsmTableCell.IconCell((Icon)GrabContext.SEE_IMAGE, "")}));
            }
        }
        GrabContext.getInstance().setCurrentChosenDevNode(devNode);
        this.getDevTable().repaint();
    }

    public GrabDevNode2 getCurrentChosenDevNode() {
        int[] rows = this.getDevTable().getSelectedRows();
        if (rows == null || rows.length == 0) {
            LOGGER.info("Not select devNode.");
            return null;
        }
        int index = this.getDevTable().convertRowIndexToModel(rows[0]);
        TableRow rowTable = this.getDeviceTableModel().getRow(index);
        GrabDevNode2 devNode = (GrabDevNode2)((Object)rowTable.getUserObject());
        return devNode;
    }

    public void refreshStopStatus(GrabDevNode2 dev) {
        this.lockUI.lock();
        try {
            TableRow<GrabDevNode2, String> changeRow = this.getTableRow(dev.getDeviceSerialNumber());
            if (null != changeRow) {
                changeRow.setValueAt(this.moniStatus, (Object)this.getStatusCell(CollectStatusEnum.COLLECT_STOP));
            }
            this.getDevTable().repaint();
        }
        finally {
            this.lockUI.unlock();
        }
    }

    @Override
    public void fireItemFinished(Item item, GrabDevNode2 devNode) {
    }

    @Override
    public void refreshPregress(final List<ExecuteResult> currResultsList) {
        if (currResultsList.isEmpty()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (ExecuteResult currResult : currResultsList) {
                    if (currResult == null) continue;
                    GrabDevNode2 dev = currResult.getDevNode();
                    PeriodGrabResult monitorResult = currResult.getMonitorResult();
                    TableRow changeRow = PeriodGrabTaskDetailContainer.this.getTableRow(dev.getDeviceSerialNumber());
                    if (null == changeRow) {
                        LOGGER.error("Collect call back error,no such devNode.");
                        return;
                    }
                    PeriodGrabTaskDetailContainer.this.lockUI.lock();
                    try {
                        PeriodGrabTaskDetailContainer.this.changeRow(currResult, monitorResult, (TableRow<GrabDevNode2, String>)changeRow);
                    }
                    finally {
                        PeriodGrabTaskDetailContainer.this.lockUI.unlock();
                    }
                    PeriodGrabTaskDetailContainer.this.refreshLink(currResult);
                    PeriodGrabTaskDetailContainer.this.refreshTaskStatus();
                }
                PeriodGrabTaskDetailContainer.this.getDevTable().repaint();
            }
        });
    }

    private void refreshLink(ExecuteResult currResult) {
        if (ResourceUtil.getString((String)"infograb.complete").equals(currResult.getCheckResult())) {
            currResult.getDevNode().setCollectDone(true);
            int oldProcess = this.taskPanel.getTask().getTaskCurruentProcess();
            int newProcess = oldProcess + 1;
            this.taskPanel.getTask().setTaskCurruentProcess(newProcess);
            this.taskPanel.refreshTaskProcess();
        }
    }

    private void changeRow(ExecuteResult currResult, PeriodGrabResult monitorResult, TableRow<GrabDevNode2, String> changeRow) {
        changeRow.setValueAt(this.moniStatus, (Object)this.getStatusCell(currResult.getNowStatus()));
        long leftTime = monitorResult.getLeftTime();
        String bandWidthUse = monitorResult.getBandWidthUse();
        String cpu = monitorResult.getCpuUse();
        String iops = monitorResult.getIopsUse();
        String memory = monitorResult.getMemoryUse();
        long monitorTimes = monitorResult.getMonitorTimes();
        changeRow.setValueAt(this.moniTimes, (Object)monitorTimes);
        if (bandWidthUse != null) {
            changeRow.setValueAt(this.moniBandWidth, (Object)bandWidthUse);
        }
        if (cpu != null) {
            changeRow.setValueAt(this.moniCPU, (Object)cpu);
        }
        if (iops != null) {
            changeRow.setValueAt(this.moniIOP, (Object)iops);
        }
        if (memory != null) {
            changeRow.setValueAt(this.moniMemory, (Object)memory);
        }
        changeRow.setValueAt(this.moniLeftTime, (Object)PeriodGrabTimeUtil.format(leftTime));
    }

    public void refreshTaskStatus() {
        List rows = this.devTable.getAllRows();
        ArrayList<String> devStatus = new ArrayList<String>();
        for (TableRow tableRow : rows) {
            devStatus.add(tableRow.getValueAt(this.moniStatus).toString());
        }
        this.taskPanel.refreshTaskStatus(devStatus);
    }

    public int getTableColumn() {
        return this.tableHeaders.length;
    }

    public RolloverButton getAddDevBtn() {
        return this.addDevBtn;
    }

    public void setAddDevBtn(RolloverButton addRollDevBtn) {
        this.addDevBtn = addRollDevBtn;
    }

    public RolloverButton getDeletePeriodDevBtn() {
        return this.deletePeriodDevBtn;
    }

    public void setDeletePeriodDevBtn(RolloverButton deletePeriodDevBtn) {
        this.deletePeriodDevBtn = deletePeriodDevBtn;
    }

    public RolloverButton getBatchImportBtn() {
        return this.batchImportBtn;
    }

    public void setBatchImportBtn(RolloverButton batchRollImportBtn) {
        this.batchImportBtn = batchRollImportBtn;
    }

    public RolloverButton getCollectBtn() {
        return this.collectBtn;
    }

    public void setCollectBtn(RolloverButton collectRollBtn) {
        this.collectBtn = collectRollBtn;
    }

    public DefaultTableModel getDeviceTableModel() {
        return this.deviceTableModel;
    }

    public void setDeviceTableModel(DefaultTableModel deviceDefTableModel) {
        this.deviceTableModel = deviceDefTableModel;
    }

    public InfoGrabIsmTable getDevTable() {
        return this.devTable;
    }

    public void setDevTable(InfoGrabIsmTable devTable) {
        this.devTable = devTable;
    }

    public StopPeriodGrabAction getStopCollectAction() {
        return this.stopCollectAction;
    }

    public PeriodGrabAction getMonitorDeviceAction() {
        return this.monitorDeviceAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshLoadingPic() {
        this.lockUI.lock();
        try {
            List<TableRow> loadingRowsList = this.findLoadingRows();
            if (loadingRowsList.isEmpty()) {
                InfoGrabService.getInstance().stopGifLoading();
                return;
            }
            for (TableRow row : loadingRowsList) {
                row.setValueAt(this.moniStatus, (Object)this.getStatusCell(CollectStatusEnum.COLLECTING));
            }
        }
        finally {
            this.lockUI.unlock();
        }
        this.getDevTable().repaint();
    }

    @Override
    public void saveData2Scene() {
    }

    @Override
    public void updateProgress(int progress) {
    }

    @Override
    public GrabDevNode2 getGrabDevNode() {
        return null;
    }

    @Override
    public void initDevThread(GrabDevNode2 dev) {
    }

    @Override
    public void updateItemProgress(GrabDevNode2 devNode) {
    }

    @Override
    public void addItemProgress(int progress) {
    }

    @Override
    public void notifyDevGrabEnd(GrabResultEntity entity) {
    }

    @Override
    public void refreshPregress(GrabResultEntity entity) {
    }
}

