/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.periodgrab.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.infograb.base.BaseTask;
import com.huawei.ism.tool.infograb.periodgrab.context.PeriodGrabConfig;
import com.huawei.ism.tool.infograb.periodgrab.context.PeriodGrabContext;
import com.huawei.ism.tool.infograb.periodgrab.entity.PeriodGrabTask;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class PeriodGrabTaskDetailDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 8986091258814503745L;
    private static final String DAY = ResourceUtil.getString((String)"infograb.task.status.day");
    private static final String HOUR = ResourceUtil.getString((String)"infograb.task.status.hour");
    private static final String MINUTER = ResourceUtil.getString((String)"infograb.task.status.min");
    private static final String SECOND = ResourceUtil.getString((String)"infograb.task.status.s");
    private static final String FREQ_MINUTER = ResourceUtil.getString((String)"infograb.task.status.freq_min_unit");
    private static final String FREQ_SECOND = ResourceUtil.getString((String)"infograb.task.status.freq_second_unit");
    private JLabel taskNameLabel = null;
    private JLabel taskTypeLabel = null;
    private transient PeriodGrabTask task = null;
    private JLabel monitorTimeLabel;
    private JLabel monitorFrequency;
    private IsmTextField timeTextField;
    private JComboBox<String> timeUnitComoBox;
    private IsmTextField frequencyTextField;
    private JComboBox<String> freqUnitComboBox;
    private JButton closeBtn;
    private JLabel periodCpuTHLabel;
    private JLabel periodMemTHLabel;
    private JLabel periodIopsTHLabel;
    private JLabel periodBandwidthPeriodTHLabel;
    private IsmTextField periodCpuTHField;
    private IsmTextField periodMemTHField;
    private IsmTextField periodIopsTHField;
    private IsmTextField periodBandwidthTHField;
    private JComboBox<String> periodCpuTHUnitComboBox;
    private JComboBox<String> periodMemTHUnitComboBox;
    private JComboBox<String> periodIopsTHUnitComboBox;
    private JComboBox<String> periodBandwidthTHUnitComboBox;

    public PeriodGrabTaskDetailDialog(Window parent, BaseTask task) {
        super(parent);
        this.setMinimumSize(new Dimension(450, 450));
        this.setResizable(false);
        this.setTitle(ResourceUtil.getString((String)"ingograb.task.detail"));
        if (task instanceof PeriodGrabTask) {
            this.task = (PeriodGrabTask)task;
        }
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
        this.setModal(true);
        this.initUI();
        this.initData();
        this.initLayout();
    }

    private void setUnEditable() {
        UIManager.put("ComboBox.disabledForeground", new Color(0, 0, 0));
        this.timeTextField.setEditable(false);
        this.timeUnitComoBox.setEnabled(false);
        this.frequencyTextField.setEditable(false);
        this.freqUnitComboBox.setEnabled(false);
        this.periodCpuTHField.setEditable(false);
        this.periodMemTHField.setEditable(false);
        this.periodIopsTHField.setEditable(false);
        this.periodBandwidthTHField.setEditable(false);
        this.periodBandwidthTHUnitComboBox.setEnabled(false);
    }

    private void initLayout() {
        Box timeComponent = UCD.buildHBoxLeft((Component[])new Component[]{this.monitorTimeLabel, this.timeTextField, this.timeUnitComoBox});
        Box frequencyComponent = UCD.buildHBoxLeft((Component[])new Component[]{this.monitorFrequency, this.frequencyTextField, this.freqUnitComboBox});
        this.setUnEditable();
        JComponent frequencyInput = UCD.buildVerticalBox(null, (Component[])new Component[]{timeComponent, frequencyComponent});
        frequencyInput.setBorder(BorderFactory.createTitledBorder(ResourceUtil.getString((String)"infograb.item.category.period.setting")));
        JComponent frequencyLayout = UCD.buildVerticalBox(null, (Component[])new Component[]{frequencyInput});
        Box cpuSetting = UCD.buildHBoxLeft((Component[])new Component[]{this.periodCpuTHLabel, this.periodCpuTHField, this.periodCpuTHUnitComboBox});
        Box memSettingCom = UCD.buildHBoxLeft((Component[])new Component[]{this.periodMemTHLabel, this.periodMemTHField, this.periodMemTHUnitComboBox});
        Box iopsSetting = UCD.buildHBoxLeft((Component[])new Component[]{this.periodIopsTHLabel, this.periodIopsTHField, this.periodIopsTHUnitComboBox});
        Box bandwidthSetting = UCD.buildHBoxLeft((Component[])new Component[]{this.periodBandwidthPeriodTHLabel, this.periodBandwidthTHField, this.periodBandwidthTHUnitComboBox});
        JComponent settingComp = UCD.buildVerticalBox((Border)BorderFactory.createTitledBorder(ResourceUtil.getString((String)"infograb.task.setting.title")), (Component[])new Component[]{cpuSetting, memSettingCom, iopsSetting, bandwidthSetting});
        Box contentArea = UiMethod.createVerticalBox(UCD.buildHBoxLeft((Component[])new Component[]{this.taskNameLabel}), UCD.buildHBoxLeft((Component[])new Component[]{this.taskTypeLabel}), settingComp, frequencyLayout, UCD.buildHBoxRight((Component[])new Component[]{this.closeBtn}));
        this.add((Component)UiMethod.buildFrameSpace(contentArea, 12), "Center");
    }

    private void initData() {
        this.taskNameLabel.setText(ResourceUtil.getString((String)"infograb.task.name") + this.task.getTaskName());
        this.taskTypeLabel.setText(ResourceUtil.getString((String)"infograb.task.type") + this.task.getTaskType());
        PeriodGrabConfig config = this.task.getMonitorConfig();
        String timeAndUnit = config.getMonitorTimeAndUnit();
        String freqAndUnit = config.getMonitorFreqAndUnit();
        String[] timeUnitStr = timeAndUnit.split(":");
        this.timeTextField.setText(timeUnitStr[0]);
        if (DAY.equals(timeUnitStr[1])) {
            this.timeUnitComoBox.setSelectedItem(DAY);
        } else if (HOUR.equals(timeUnitStr[1])) {
            this.timeUnitComoBox.setSelectedItem(HOUR);
        } else if (MINUTER.equals(timeUnitStr[1])) {
            this.timeUnitComoBox.setSelectedItem(MINUTER);
        } else if (SECOND.equals(timeUnitStr[1])) {
            this.timeUnitComoBox.setSelectedItem(SECOND);
        }
        String[] freqUnit = freqAndUnit.split(":");
        this.frequencyTextField.setText(freqUnit[0]);
        if (FREQ_MINUTER.equals(freqUnit[1])) {
            this.freqUnitComboBox.setSelectedItem(FREQ_MINUTER);
        } else if (FREQ_SECOND.equals(freqUnit[1])) {
            this.freqUnitComboBox.setSelectedItem(FREQ_SECOND);
        }
        int cpuTh = (int)config.getCpuThreshold();
        this.periodCpuTHField.setText(cpuTh + "");
        int memTh = (int)config.getMemThreshold();
        this.periodMemTHField.setText(memTh + "");
        int iopsTh = (int)config.getIopsThreshold();
        this.periodIopsTHField.setText(iopsTh + "");
        int bwTh = (int)config.getBandwidthThreshold();
        if (bwTh >= 1024) {
            this.periodBandwidthTHField.setText(bwTh / 1024 + "");
            this.periodBandwidthTHUnitComboBox.setSelectedItem("Mbps");
        } else {
            this.periodBandwidthTHField.setText(bwTh + "");
            this.periodBandwidthTHUnitComboBox.setSelectedItem("Kbps");
        }
    }

    private void initUI() {
        this.taskTypeLabel = new JLabel();
        this.taskNameLabel = new JLabel();
        this.monitorTimeLabel = new JLabel(ResourceUtil.getString((String)"infograb.task.status.monitor_time"));
        this.monitorFrequency = new JLabel(ResourceUtil.getString((String)"infograb.task.status.monitor_frequency"));
        this.timeTextField = IsmTextField.getNameTextField((String)"\\d{0,2}", (String)"", (int)5, (int)2);
        this.frequencyTextField = IsmTextField.getNameTextField((String)"\\d{0,2}", (String)"", (int)5, (int)2);
        this.timeUnitComoBox = new JComboBox();
        this.timeUnitComoBox.addItem(ResourceUtil.getString((String)"infograb.task.status.day"));
        this.timeUnitComoBox.addItem(ResourceUtil.getString((String)"infograb.task.status.hour"));
        this.timeUnitComoBox.addItem(ResourceUtil.getString((String)"infograb.task.status.min"));
        this.timeUnitComoBox.setPreferredSize(new Dimension(50, 21));
        this.freqUnitComboBox = new JComboBox();
        this.freqUnitComboBox.setPreferredSize(new Dimension(50, 21));
        this.freqUnitComboBox.addItem(ResourceUtil.getString((String)"infograb.task.status.freq_min_unit"));
        this.freqUnitComboBox.addItem(ResourceUtil.getString((String)"infograb.task.status.freq_second_unit"));
        this.closeBtn = UiMethod.createButton(ResourceUtil.getString((String)"infograb.button.close"), 'C');
        this.periodCpuTHLabel = new JLabel(ResourceUtil.getString((String)"infograb.task.setting.cpu"));
        this.periodMemTHLabel = new JLabel(ResourceUtil.getString((String)"infograb.task.setting.mem"));
        this.periodIopsTHLabel = new JLabel(ResourceUtil.getString((String)"infograb.task.setting.iops"));
        this.periodBandwidthPeriodTHLabel = new JLabel(ResourceUtil.getString((String)"infograb.task.setting.bandwidth"));
        this.periodCpuTHField = IsmTextField.getNameTextField((String)"\\d{0,2}", (String)"", (int)5, (int)2);
        this.periodMemTHField = IsmTextField.getNameTextField((String)"\\d{0,2}", (String)"", (int)5, (int)2);
        this.periodIopsTHField = IsmTextField.getNameTextField((String)"\\d{0,5}", (String)"", (int)5, (int)2);
        this.periodBandwidthTHField = IsmTextField.getNameTextField((String)"\\d{0,6}", (String)"", (int)5, (int)2);
        this.periodCpuTHUnitComboBox = new JComboBox();
        this.periodCpuTHUnitComboBox.addItem("%     ");
        this.periodCpuTHUnitComboBox.setEnabled(false);
        this.periodMemTHUnitComboBox = new JComboBox();
        this.periodMemTHUnitComboBox.addItem("%     ");
        this.periodMemTHUnitComboBox.setEnabled(false);
        this.periodIopsTHUnitComboBox = new JComboBox();
        this.periodIopsTHUnitComboBox.addItem("IOPS");
        this.periodIopsTHUnitComboBox.setEnabled(false);
        this.periodBandwidthTHUnitComboBox = new JComboBox();
        this.periodBandwidthTHUnitComboBox.addItem("Kbps");
        this.periodBandwidthTHUnitComboBox.addItem("Mbps");
        this.periodBandwidthTHUnitComboBox.setSelectedItem(PeriodGrabContext.getDefaultBwThUnit());
        this.closeBtn.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source;
        if (null != event && (source = event.getSource()) == this.closeBtn) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

