/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.periodgrab.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.infograb.base.BaseTask;
import com.huawei.ism.tool.infograb.base.BaseTaskPanel;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.periodgrab.entity.PeriodGrabTask;
import com.huawei.ism.tool.infograb.periodgrab.ui.PeriodGrabTaskDetailContainer;
import com.huawei.ism.tool.infograb.periodgrab.ui.PeriodGrabTaskDetailDialog;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class PeriodGrabTaskPanel
extends BaseTaskPanel {
    private static final long serialVersionUID = -546022648701081750L;
    private JLabel taskStatus;
    private JLabel taskProcess;
    private JLabel taskNameLabel;
    private JLabel taskTypeLabel;
    private transient BaseTask task = this.getTask();
    private JComponent contentPan = this.getContentPan();
    private ToolHyperLinkLabel taskMonitorConfig;
    private PeriodGrabTaskDetailContainer taskDetailContainer;

    public PeriodGrabTaskPanel(BaseTask task) {
        super(task);
        this.initUI();
        this.initLayout();
        this.initListener();
    }

    private void initListener() {
        this.taskMonitorConfig.addClickListener(new ToolHyperLinkLabel.ClickListener(){
            private static final long serialVersionUID = -2226165153616418736L;

            @Override
            public void clickLink(MouseEvent e) {
                new PeriodGrabTaskDetailDialog((Window)GrabContext.getInstance().getCurrInfoGrabFrame(), PeriodGrabTaskPanel.this.task).setVisible(true);
            }
        });
    }

    private void initUI() {
        this.taskStatus = new JLabel(ResourceUtil.getString((String)"infograb.task.status.not_add_device"));
        this.taskStatus.setIcon(ResourceUtil.getImage((String)"warning.png"));
        this.taskProcess = new JLabel("0/0");
        this.taskMonitorConfig = new ToolHyperLinkLabel(ResourceUtil.getString((String)"infograb.devicetable.cell.details"));
        String taskName = ((PeriodGrabTask)this.task).getTaskName();
        this.taskNameLabel = new JLabel(taskName);
        String taskType = ResourceUtil.getString((String)"infograb.task.task.type") + " : " + this.task.getTaskType();
        this.taskTypeLabel = new JLabel(taskType);
        this.setBackground(Color.white);
    }

    private void initLayout() {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        topPanel.add(Box.createHorizontalStrut(3));
        topPanel.add(this.taskNameLabel);
        topPanel.add(Box.createHorizontalGlue());
        topPanel.add(this.taskMonitorConfig);
        topPanel.add(Box.createHorizontalStrut(3));
        JPanel bottomPan = new JPanel();
        bottomPan.setLayout(new BoxLayout(bottomPan, 0));
        bottomPan.add(Box.createHorizontalStrut(3));
        bottomPan.add(this.taskTypeLabel);
        bottomPan.add(Box.createHorizontalGlue());
        JPanel panelPeriod = new JPanel();
        panelPeriod.setLayout(new BoxLayout(panelPeriod, 1));
        panelPeriod.add(Box.createHorizontalStrut(3));
        panelPeriod.add(topPanel);
        panelPeriod.add(Box.createHorizontalStrut(3));
        panelPeriod.add(Box.createHorizontalStrut(3));
        panelPeriod.add(bottomPan);
        JPanel bottomPan0 = new JPanel();
        bottomPan0.setLayout(new BoxLayout(bottomPan0, 0));
        bottomPan0.add(Box.createHorizontalStrut(3));
        bottomPan0.add(this.taskStatus);
        bottomPan0.add(Box.createHorizontalGlue());
        bottomPan0.add(this.taskProcess);
        bottomPan0.add(Box.createHorizontalStrut(3));
        panelPeriod.add(Box.createHorizontalStrut(3));
        panelPeriod.add(new JSeparator(0));
        panelPeriod.add(Box.createHorizontalStrut(3));
        panelPeriod.add(bottomPan0);
        panelPeriod.add(Box.createHorizontalStrut(3));
        this.contentPan.setLayout(new BoxLayout(this.contentPan, 0));
        this.contentPan.add(panelPeriod);
        this.contentPan.setBorder(BorderFactory.createLineBorder(new Color(Integer.parseInt("990000", 16)), 1));
        this.contentPan.setPreferredSize(new Dimension(200, 58));
        this.setMaximumSize(new Dimension(200, 63));
        this.add(this.contentPan);
    }

    public void setTaskDetailContainer(PeriodGrabTaskDetailContainer taskDetailContainer) {
        this.taskDetailContainer = taskDetailContainer;
    }

    @Override
    public JComponent getTaskDetailContainer() {
        return this.taskDetailContainer;
    }

    public JLabel getTaskNameLabel() {
        return this.taskNameLabel;
    }

    public ToolHyperLinkLabel getTaskCategory() {
        return this.taskMonitorConfig;
    }

    public JLabel getTaskStatus() {
        return this.taskStatus;
    }

    public JLabel getTaskProcess() {
        return this.taskProcess;
    }

    @Override
    public void refreshTaskProcess() {
        this.task = this.getTask();
        if (this.task.getTaskMaxProcess() == 0) {
            this.taskStatus.setText(ResourceUtil.getString((String)"infograb.task.status.not_add_device"));
            this.taskStatus.setIcon(ResourceUtil.getImage((String)"warning.png"));
            this.taskProcess.setText("0/0");
            this.task.setTaskCurruentProcess(0);
        } else {
            if (this.task.getTaskCurruentProcess() == 0) {
                this.taskStatus.setText(ResourceUtil.getString((String)"infograb.task.status.not_start_collect"));
                this.taskStatus.setIcon(ResourceUtil.getImage((String)"warning.png"));
            }
            this.taskProcess.setText(this.task.getTaskCurruentProcess() + "/" + this.task.getTaskMaxProcess());
        }
        this.repaint();
    }

    public void refreshTaskStatus(List<String> devStatusList) {
        if (devStatusList.contains(ResourceUtil.getString((String)"infograb.dev.status.collecting"))) {
            this.taskStatus.setText(ResourceUtil.getString((String)"infograb.task.status.collecting"));
            this.taskStatus.setIcon(ResourceUtil.getImage((String)"loading.gif"));
        } else if (devStatusList.contains(ResourceUtil.getString((String)"infograb.dev.status.noecollect")) || devStatusList.contains(ResourceUtil.getString((String)"infograb.dev.status.collectstopped")) || devStatusList.contains(ResourceUtil.getString((String)"infograb.dev.status.collectfailed")) || devStatusList.contains(ResourceUtil.getString((String)"infograb.dev.status.waittogo"))) {
            this.taskStatus.setText(ResourceUtil.getString((String)"infograb.task.status.part_not_collect"));
            this.taskStatus.setIcon(ResourceUtil.getImage((String)"warning.png"));
        } else {
            this.taskStatus.setText(ResourceUtil.getString((String)"infograb.task.status.all_collect_done"));
            this.taskStatus.setIcon(ResourceUtil.getImage((String)"success.png"));
        }
        this.repaint();
    }
}

