/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.periodgrab.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.infograb.base.BaseTask;
import com.huawei.ism.tool.infograb.base.IDetailContainer;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.grab.GrabEngine;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabUtil;
import com.huawei.ism.tool.infograb.periodgrab.PeriodGrabThread;
import com.huawei.ism.tool.infograb.periodgrab.ui.PeriodGrabAction;
import com.huawei.ism.tool.infograb.periodgrab.ui.PeriodGrabTaskDetailContainer;
import com.huawei.ism.tool.infograb.periodgrab.ui.PeriodGrabTaskPanel;
import com.huawei.ism.tool.infograb.service.InfoGrabService;
import com.huawei.ism.ui.swing.dialog.CustMsgProgressDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.util.SwingUtil;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopPeriodGrabAction
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StopPeriodGrabAction.class);
    private InfoGrabService grabService = InfoGrabService.getInstance();
    private ProgressDialog busywaitDialog = null;

    @Override
    public void actionPerformed(ActionEvent e) {
        this.busywaitDialog = new CustMsgProgressDialog((Window)GrabContext.getInstance().getCurrInfoGrabFrame(), ResourceUtil.getString((String)"infograb.remind.waitforstopcollect"), 415);
        new Thread(new Runnable(){

            @Override
            public void run() {
                StopPeriodGrabAction.this.doEndMonitiorThread();
            }
        }, "stopMonitorThread").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEndMonitiorThread() {
        List<GrabDevNode2> currSelectedNodesList = ((IDetailContainer)((Object)GrabContext.getInstance().getCurrentTask().getTaskDetailContainer())).getSelectedDevNode();
        if (currSelectedNodesList.isEmpty()) {
            DialogUtils.showInfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.remind.no.selected.devnode"));
            LOGGER.info("The device is not selected, can not be terminated");
            return;
        }
        if (this.checkDevNodeStatus(currSelectedNodesList)) {
            WarningDialog warningDialog = DialogUtils.showYesNoDialog((Window)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.remind.isendgrabinfo"));
            if (1 == warningDialog.getValue() || -1 == warningDialog.getValue()) {
                LOGGER.info("you cancal end period grabinfo");
                return;
            }
        } else {
            DialogUtils.showInfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.remind.nohavegrabrunning"));
            LOGGER.info("The selected device is not running,period grab can not be terminated!");
            return;
        }
        if (this.checkCollectionThreadStatus()) {
            DialogUtils.showInfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.remind.waitcollectionstart"));
            LOGGER.info("starting collection function,please wait");
            return;
        }
        ConcurrentHashMap<GrabDevNode2, PeriodGrabThread> currThreadMap = GrabEngine.getInstance().getCurrMonitorThreadMap();
        if (!GrabUtil.checkAtLeastOneNode(currSelectedNodesList)) {
            LOGGER.info("Not select an devNode");
            return;
        }
        ArrayList<PeriodGrabThread> monitorThreads = new ArrayList<PeriodGrabThread>();
        BaseTask task = GrabContext.getInstance().getCurrentTask().getTask();
        if (task.getTaskCurruentProcess() != task.getTaskMaxProcess()) {
            JLabel taskStatus = ((PeriodGrabTaskPanel)GrabContext.getInstance().getCurrentTask()).getTaskStatus();
            taskStatus.setText(ResourceUtil.getString((String)"infograb.task.status.part_not_collect"));
            taskStatus.setIcon(ResourceUtil.getImage((String)"warning.png"));
            GrabContext.getInstance().getCurrentTask().repaint();
        }
        this.markTaskStopped(currSelectedNodesList, currThreadMap, monitorThreads);
        Object object = GrabEngine.BLOCKING_QUEUE_LOCK;
        synchronized (object) {
            GrabEngine.getInstance().getLbkqBlockingQueue().removeAll(monitorThreads);
        }
        this.startCheckStatusThread(currSelectedNodesList);
        this.showDialogInDispatchThread();
    }

    private void startCheckStatusThread(List<GrabDevNode2> currSelectedNodesList) {
        Runnable checkTaskRunnable = this.buildGrabStoppedCheckTask(currSelectedNodesList);
        Thread thread = new Thread(checkTaskRunnable, "Hide bzy dialig Task - Peridod");
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread1, Throwable throwable) {
                LOGGER.error(thread1.getName() + ":" + throwable.getMessage());
            }
        });
        thread.start();
    }

    private void markTaskStopped(List<GrabDevNode2> currSelectedNodesList, Map<GrabDevNode2, PeriodGrabThread> currThreadMap, List<PeriodGrabThread> monitorThreads) {
        for (GrabDevNode2 devNode : currSelectedNodesList) {
            PeriodGrabThread currThread = currThreadMap.get((Object)devNode);
            if (null == currThread) continue;
            monitorThreads.add(currThread);
            currThread.setStop(true);
        }
    }

    private Runnable buildGrabStoppedCheckTask(final List<GrabDevNode2> currSelectedNodesList) {
        return new Runnable(){

            @Override
            public void run() {
                LOGGER.info("start check task running status...");
                do {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("stop buzywaitDialog failed..");
                    }
                } while (!StopPeriodGrabAction.this.allChoosedDevStoped(currSelectedNodesList));
                LOGGER.info("all task has stopped.");
                StopPeriodGrabAction.this.hideBusywaitDialog();
                StopPeriodGrabAction.this.refreshFrameUI(currSelectedNodesList);
            }
        };
    }

    private void showDialogInDispatchThread() {
        SwingUtil.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (StopPeriodGrabAction.this.busywaitDialog != null) {
                    StopPeriodGrabAction.this.busywaitDialog.setVisible(true);
                }
            }
        });
    }

    private void hideBusywaitDialog() {
        if (this.busywaitDialog != null) {
            this.busywaitDialog.setVisible(false);
            this.busywaitDialog.dispose();
            this.busywaitDialog = null;
        }
    }

    private boolean allChoosedDevStoped(List<GrabDevNode2> currSelectedNodesList) {
        int i = 0;
        for (GrabDevNode2 devNode : currSelectedNodesList) {
            if (InfoGrabService.getInstance().findNodeStatus(devNode).booleanValue() && !devNode.isCollectStop() && !devNode.isCollectDone()) continue;
            ++i;
        }
        return i == currSelectedNodesList.size();
    }

    private boolean checkDevNodeStatus(List<GrabDevNode2> currSelectedNodes) {
        for (GrabDevNode2 devNode2 : currSelectedNodes) {
            if (!this.grabService.findNodeStatus(devNode2).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean checkCollectionThreadStatus() {
        Thread grabThread;
        PeriodGrabAction collectDeviceAction = ((PeriodGrabTaskDetailContainer)GrabContext.getInstance().getCurrentTask().getTaskDetailContainer()).getMonitorDeviceAction();
        return null != collectDeviceAction && null != (grabThread = collectDeviceAction.getMonitorThread()) && Thread.State.RUNNABLE == grabThread.getState();
    }

    private void refreshFrameUI(List<GrabDevNode2> currSelectedNodes) {
        for (GrabDevNode2 devNode2 : currSelectedNodes) {
            if (this.grabService.findNodeStatus(devNode2).booleanValue()) {
                ((PeriodGrabTaskDetailContainer)GrabContext.getInstance().getCurrentTask().getTaskDetailContainer()).refreshStopStatus(devNode2);
            }
            this.grabService.setNodesStopped(devNode2);
        }
    }
}

