/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.report;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import freemarker.cache.CacheStorage;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;

public final class TemplateFactory {
    private static final String UTF8ENCODE = "UTF-8";
    private static final String TEMPLATE_DICTIONARY = "/config/template/html/";
    private static final Configuration CONFIGURATION = new Configuration();
    private static final int MAX = 200;

    private TemplateFactory() {
    }

    public static String processorFtl(String ftlPath, Object data) {
        CharArrayWriter arrayWriter = new CharArrayWriter();
        try {
            Template template = CONFIGURATION.getTemplate(ftlPath, UTF8ENCODE);
            template.process(data, (Writer)arrayWriter);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(TemplateFactory.class).error("build freemarker template faild.");
        }
        arrayWriter.flush();
        return arrayWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean processorFtl(String ftlPath, Object data, String outHtmlFilePath) {
        boolean flag;
        block7: {
            flag = false;
            BufferedWriter writer = null;
            try {
                String htmlFilePath = ToolUtils.getCanonicalFilePath(outHtmlFilePath);
                File file = new File(htmlFilePath);
                ToolUtils.createDir(file.getParent());
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FilePathUtils.checkFile((String)htmlFilePath)), ApplicationContext.APP_CHARSET));
                Template template = CONFIGURATION.getTemplate(ftlPath, UTF8ENCODE);
                template.process(data, (Writer)writer);
                flag = true;
                StreamUtils.closeResource(writer, writer);
                writer = null;
                data = null;
            }
            catch (IOException e) {
                ToolLoggerFactory.getLogger(TemplateFactory.class).error("build freemarker template faild.");
            }
            catch (TemplateException e2) {
                ToolLoggerFactory.getLogger(TemplateFactory.class).error("build freemarker template faild.");
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                StreamUtils.closeResource(writer, writer);
                writer = null;
                data = null;
            }
        }
        return flag;
    }

    protected static Configuration getCONFIGURATION() {
        return CONFIGURATION;
    }

    static {
        ClassTemplateLoader classTemplateLoader = new ClassTemplateLoader(TemplateFactory.class, TEMPLATE_DICTIONARY);
        MultiTemplateLoader loader = new MultiTemplateLoader(new TemplateLoader[]{classTemplateLoader});
        CONFIGURATION.setCacheStorage((CacheStorage)new MruCacheStorage(10, 200));
        CONFIGURATION.setLocale(Locale.getDefault());
        CONFIGURATION.clearEncodingMap();
        CONFIGURATION.setEncoding(Locale.CHINESE, UTF8ENCODE);
        CONFIGURATION.setTemplateLoader((TemplateLoader)loader);
        CONFIGURATION.setNewBuiltinClassResolver(TemplateClassResolver.SAFER_RESOLVER);
    }
}

