/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.service;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.infograb.context.CollectStatusEnum;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class CollectStatusCache {
    private static final CollectStatusCache INSTANCE = new CollectStatusCache();
    private int currLoading = 0;
    private Map<CollectStatusEnum, IsmTableCell> statusMap = new HashMap<CollectStatusEnum, IsmTableCell>();
    private Map<Integer, IsmTableCell> loadingMap = new HashMap<Integer, IsmTableCell>();

    private CollectStatusCache() {
        this.statusMap.put(CollectStatusEnum.COLLECT_FAILED, (IsmTableCell)new IsmTableCell.IconCell((Icon)GrabContext.FAILED_IMAGE, CollectStatusEnum.COLLECT_FAILED.toString()));
        this.statusMap.put(CollectStatusEnum.COLLECT_SUCC, (IsmTableCell)new IsmTableCell.IconCell((Icon)GrabContext.SUCCESS_IMAGE, CollectStatusEnum.COLLECT_SUCC.toString()));
        this.statusMap.put(CollectStatusEnum.COLLECT_FINISHED_NOTALL, (IsmTableCell)new IsmTableCell.IconCell((Icon)GrabContext.SUCCESS_NOTALL_IMAGE, CollectStatusEnum.COLLECT_FINISHED_NOTALL.toString()));
        this.statusMap.put(CollectStatusEnum.NOT_COLLECT, (IsmTableCell)new IsmTableCell.IconCell((Icon)GrabContext.NOT_GRAB_IMAGE, CollectStatusEnum.NOT_COLLECT.toString()));
        this.statusMap.put(CollectStatusEnum.WAIT_TOGO, (IsmTableCell)new IsmTableCell.IconCell((Icon)GrabContext.WAIT_TOGO_IMAGE, CollectStatusEnum.WAIT_TOGO.toString()));
        this.statusMap.put(CollectStatusEnum.COLLECT_STOP, (IsmTableCell)new IsmTableCell.IconCell((Icon)GrabContext.SUCCESS_NOTALL_IMAGE, CollectStatusEnum.COLLECT_STOP.toString()));
        this.loadingMap.put(0, (IsmTableCell)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"loading0.png"), CollectStatusEnum.COLLECTING.toString()));
        this.loadingMap.put(1, (IsmTableCell)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"loading1.png"), CollectStatusEnum.COLLECTING.toString()));
        this.loadingMap.put(2, (IsmTableCell)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"loading2.png"), CollectStatusEnum.COLLECTING.toString()));
        this.loadingMap.put(3, (IsmTableCell)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"loading3.png"), CollectStatusEnum.COLLECTING.toString()));
        this.loadingMap.put(4, (IsmTableCell)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"loading4.png"), CollectStatusEnum.COLLECTING.toString()));
        this.loadingMap.put(5, (IsmTableCell)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"loading5.png"), CollectStatusEnum.COLLECTING.toString()));
        this.loadingMap.put(6, (IsmTableCell)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"loading6.png"), CollectStatusEnum.COLLECTING.toString()));
        this.loadingMap.put(7, (IsmTableCell)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"loading7.png"), CollectStatusEnum.COLLECTING.toString()));
    }

    public IsmTableCell getTableCellFromStatus(CollectStatusEnum currStatus) {
        if (CollectStatusEnum.COLLECTING.equals((Object)currStatus)) {
            return this.loadingMap.get(this.currLoading);
        }
        return this.statusMap.get((Object)currStatus);
    }

    public IsmTableCell getTableCellByStatus(CollectStatusEnum currStatus) {
        if (currStatus.equals((Object)CollectStatusEnum.COLLECTING)) {
            return new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"loading.gif"), CollectStatusEnum.COLLECTING.toString());
        }
        return this.statusMap.get((Object)currStatus);
    }

    public static CollectStatusCache getInstance() {
        return INSTANCE;
    }

    public int getCurrLoading() {
        return this.currLoading;
    }

    public void setCurrLoading(int currLoading) {
        this.currLoading = currLoading;
    }
}

