/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.service;

import com.huawei.ism.tool.infograb.entity.HPStorageListData;
import com.huawei.ism.tool.infograb.service.XlsClusterItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class HandleStorageXlsData {
    private static final String REPORT_TITLE = "report_title";
    private static final String HOST_GROUP1 = "host_group1";
    private static final String LUN_GROUP2 = "lun_group2";
    private static final String MAPPING_VIEW_ID = "mapping_view_id";
    private static final String MAPPING_VIEW_NAME = "mapping_view_name";
    private static final String HOST_GROUP_ID = "host_group_id";
    private static final String HOST_GROUP_NAME = "host_group_name";
    private static final String HOST_ID = "host_id";
    private static final String HOST_NAME = "host_name";
    private static final String HOST_TYPE = "host_type";
    private static final String INITIATOR_WWN = "initiator_wwn";
    private static final String PORT = "port";
    private static final String ACCESS_MODEL = "access_model";
    private static final String LUN_GROUP_ID = "lun_group_id";
    private static final String LUN_GROUP_NAME = "lun_group_name";
    private static final String LUN_ID = "lun_id";
    private static final String LUN_NAME = "lun_name";
    private static final String HOSTGROUP_ID = "hostgroup_id";
    private static final String CAPACITY = "capacity";
    private static final String STATUS = "status";
    private static final String LUN_WWN = "lun_wwn";
    private static final String TAKEOVER_LUN_WWN = "takeover_lun_wwn";
    private static final String REMOTE_REPLICATION = "remote_replication";
    private static final String HYPER_METRO = "hyper_metro";
    private static final String LUN_TYPE = "lun_type";
    private static final String MAPPING_VIEW = "MappingView";
    private static final String HOST_GROUP = "host_group";
    private static final String LUN_GROUP = "lun_group";
    private static final String NA = "NA";
    private static final String ID_FORMATTER = "%03d";

    public static Map<String, Map<String, List<String>>> dealStorageXlsData(Map<String, Map<String, List<String>>> dataMap, List<XlsClusterItem> xlsStorageItemList, XlsClusterItem xlsClusterItemHost, XlsClusterItem xlsClusterItemLun) {
        XlsClusterItem hostXlsClusterItem = xlsStorageItemList.get(1);
        XlsClusterItem lunXlsClusterItem = xlsStorageItemList.get(2);
        xlsStorageItemList.remove(1);
        xlsStorageItemList.remove(1);
        HashMap<String, Map<String, List<String>>> dealData = new HashMap<String, Map<String, List<String>>>();
        dealData.put(REPORT_TITLE, dataMap.get(REPORT_TITLE));
        Map<String, Map<String, List<String>>> dealDataMap = HandleStorageXlsData.dealDataBySameNumMap(dataMap, xlsStorageItemList, xlsClusterItemHost, xlsClusterItemLun);
        if (!dealDataMap.isEmpty()) {
            dealData.putAll(dealDataMap);
            return dealData;
        }
        xlsStorageItemList.add(hostXlsClusterItem);
        xlsStorageItemList.add(lunXlsClusterItem);
        return dataMap;
    }

    private static Map<String, Map<String, List<String>>> dealDataBySameNumMap(Map<String, Map<String, List<String>>> dataMap, List<XlsClusterItem> xlsStorageItemList, XlsClusterItem xlsClusterItemHost, XlsClusterItem xlsClusterItemLun) {
        Map<String, List<String>> hostStorageInfo = dataMap.get(HOST_GROUP1);
        Map<String, List<String>> lunStorageInfo = dataMap.get(LUN_GROUP2);
        HashMap<String, Map<String, List<String>>> dealData = new HashMap<String, Map<String, List<String>>>();
        Map<String, List<String>> scenarioMap = HandleStorageXlsData.getScenarioMap(lunStorageInfo);
        if (scenarioMap.isEmpty()) {
            return dealData;
        }
        int numKeyFlag = 1;
        int mappingViewNameIndex = 1;
        boolean isHuaweiDevice = HandleStorageXlsData.isHuaweiDevice(lunStorageInfo);
        for (Map.Entry<String, List<String>> entry : scenarioMap.entrySet()) {
            List<String> allIdList = entry.getValue();
            for (String keyId : allIdList) {
                HPStorageListData hpStorageListData = HandleStorageXlsData.dealHostInfoByScenario(hostStorageInfo, keyId, entry.getKey(), mappingViewNameIndex, isHuaweiDevice);
                HandleStorageXlsData.addXlsStorageItem(xlsStorageItemList, xlsClusterItemHost, numKeyFlag);
                Map<String, List<String>> hostAfterStorageInfo = HandleStorageXlsData.getHostAfterStorageInfo(hpStorageListData, isHuaweiDevice);
                dealData.put(HOST_GROUP + numKeyFlag, hostAfterStorageInfo);
                HandleStorageXlsData.dealLunInfoByScenario(lunStorageInfo, keyId, hpStorageListData, entry.getKey(), mappingViewNameIndex);
                HandleStorageXlsData.addXlsStorageItem(xlsStorageItemList, xlsClusterItemLun, ++numKeyFlag);
                Map<String, List<String>> lunAfterStorageInfo = HandleStorageXlsData.getLunAfterStorageInfo(hpStorageListData, isHuaweiDevice);
                dealData.put(LUN_GROUP + numKeyFlag, lunAfterStorageInfo);
                ++numKeyFlag;
                ++mappingViewNameIndex;
            }
        }
        return dealData;
    }

    private static Map<String, List<String>> getScenarioMap(Map<String, List<String>> lunStorageInfo) {
        List<String> lunMappingId;
        List<String> lunHostId = lunStorageInfo.get(HOST_ID);
        List<String> lunHostGroupId = lunStorageInfo.get(HOSTGROUP_ID);
        HashMap<String, List<String>> scenarioMap = new HashMap<String, List<String>>();
        if (HandleStorageXlsData.checkHasUsableId(lunHostId)) {
            scenarioMap.put(HOST_ID, HandleStorageXlsData.getSameIds(lunHostId));
        }
        if (HandleStorageXlsData.checkHasUsableId(lunHostGroupId)) {
            scenarioMap.put(HOST_GROUP_ID, HandleStorageXlsData.getSameIds(lunHostGroupId));
        }
        if (!scenarioMap.containsKey(HOST_GROUP_ID) && HandleStorageXlsData.checkHasUsableId(lunMappingId = lunStorageInfo.get(MAPPING_VIEW_ID))) {
            scenarioMap.put(MAPPING_VIEW_ID, HandleStorageXlsData.getSameIds(lunMappingId));
        }
        return scenarioMap;
    }

    private static List<String> getSameIds(List<String> allIds) {
        ArrayList<String> sameIds = new ArrayList<String>();
        for (String id : allIds) {
            if (NA.equalsIgnoreCase(id) || sameIds.contains(id)) continue;
            sameIds.add(id);
        }
        return sameIds;
    }

    private static void addXlsStorageItem(List<XlsClusterItem> xlsStorageItemList, XlsClusterItem xlsClusterItem, int numKeyFlag) {
        XlsClusterItem xlsItemNewHost = new XlsClusterItem();
        xlsItemNewHost.copyeItem(xlsClusterItem);
        xlsItemNewHost.setStorageId(NA);
        xlsItemNewHost.setMigrateItemKey(xlsItemNewHost.getMigrateItemKey() + numKeyFlag);
        xlsStorageItemList.add(xlsItemNewHost);
    }

    private static void dealLunInfoByScenario(Map<String, List<String>> lunStorageInfo, String keyId, HPStorageListData storageListData, String scenario, int nameIndex) {
        List<String> mappingViewIds = lunStorageInfo.get(HOST_GROUP_ID.equals(scenario) ? HOSTGROUP_ID : scenario);
        boolean isHuaweiDevice = HandleStorageXlsData.isHuaweiDevice(lunStorageInfo);
        for (int index = 0; index < mappingViewIds.size(); ++index) {
            if (!keyId.equalsIgnoreCase(mappingViewIds.get(index))) continue;
            String mappingViewName = lunStorageInfo.get(MAPPING_VIEW_NAME).get(index);
            if (NA.equalsIgnoreCase(mappingViewName)) {
                mappingViewName = MAPPING_VIEW + String.format(Locale.ENGLISH, ID_FORMATTER, nameIndex);
            }
            HandleStorageXlsData.addLunData2ListData(storageListData, lunStorageInfo, index, mappingViewName, isHuaweiDevice);
        }
    }

    private static void addLunData2ListData(HPStorageListData storageListData, Map<String, List<String>> lunStorageInfo, int index, String mappingViewName, boolean isHuaweiDevice) {
        storageListData.getLunGroupId().add(lunStorageInfo.get(LUN_GROUP_ID).get(index));
        storageListData.getLunGroupName().add(lunStorageInfo.get(LUN_GROUP_NAME).get(index));
        storageListData.getLunId().add(lunStorageInfo.get(LUN_ID).get(index));
        storageListData.getLunName().add(lunStorageInfo.get(LUN_NAME).get(index));
        storageListData.getLunCapacity().add(lunStorageInfo.get(CAPACITY).get(index));
        storageListData.getLunHostId().add(lunStorageInfo.get(HOST_ID).get(index));
        storageListData.getLunHostGroupId().add(lunStorageInfo.get(HOSTGROUP_ID).get(index));
        storageListData.getLunStatus().add(lunStorageInfo.get(STATUS).get(index));
        storageListData.getLunWwn().add(lunStorageInfo.get(LUN_WWN).get(index));
        storageListData.getLunType().add(lunStorageInfo.get(LUN_TYPE).get(index));
        storageListData.getLunMappingViewId().add(lunStorageInfo.get(MAPPING_VIEW_ID).get(index));
        storageListData.getLunMappingViewName().add(mappingViewName);
        if (isHuaweiDevice) {
            storageListData.getHuaweiTakeoverLunWwn().add(lunStorageInfo.get(TAKEOVER_LUN_WWN).get(index));
            storageListData.getHuaweiRemoteReplication().add(lunStorageInfo.get(REMOTE_REPLICATION).get(index));
            storageListData.getHuaweiHyperMetro().add(lunStorageInfo.get(HYPER_METRO).get(index));
        }
    }

    private static boolean isHuaweiDevice(Map<String, List<String>> lunStorageInfo) {
        return lunStorageInfo.containsKey(TAKEOVER_LUN_WWN);
    }

    private static HPStorageListData dealHostInfoByScenario(Map<String, List<String>> hostStorageInfo, String keyId, String scenario, int nameIndex, boolean isHuaweiDevice) {
        List<String> scenarioIds = hostStorageInfo.get(scenario);
        HPStorageListData storageListData = new HPStorageListData();
        for (int index = 0; index < scenarioIds.size(); ++index) {
            if (!keyId.equalsIgnoreCase(scenarioIds.get(index))) continue;
            String mappingViewName = hostStorageInfo.get(MAPPING_VIEW_NAME).get(index);
            if (NA.equalsIgnoreCase(mappingViewName)) {
                mappingViewName = MAPPING_VIEW + String.format(Locale.ENGLISH, ID_FORMATTER, nameIndex);
            }
            HandleStorageXlsData.addHostData2ListData(storageListData, hostStorageInfo, index, mappingViewName, isHuaweiDevice);
        }
        return storageListData;
    }

    private static void addHostData2ListData(HPStorageListData listData, Map<String, List<String>> hostStorageInfo, int index, String mappingViewName, boolean isHuaweiDevice) {
        listData.getHostGroupId().add(hostStorageInfo.get(HOST_GROUP_ID).get(index));
        listData.getHostGroupName().add(hostStorageInfo.get(HOST_GROUP_NAME).get(index));
        listData.getHostId().add(hostStorageInfo.get(HOST_ID).get(index));
        listData.getHostName().add(hostStorageInfo.get(HOST_NAME).get(index));
        listData.getType().add(hostStorageInfo.get(HOST_TYPE).get(index));
        listData.getWwn().add(hostStorageInfo.get(INITIATOR_WWN).get(index));
        listData.getPort().add(hostStorageInfo.get(PORT).get(index));
        if (isHuaweiDevice) {
            listData.getAccessMode().add(hostStorageInfo.get(ACCESS_MODEL).get(index));
        }
        listData.getMappingViewId().add(hostStorageInfo.get(MAPPING_VIEW_ID).get(index));
        listData.getMappingViewName().add(mappingViewName);
    }

    private static Map<String, List<String>> getLunAfterStorageInfo(HPStorageListData hpStorageListData, boolean isHuaweiDevice) {
        HashMap<String, List<String>> lunAfterStorageInfo = new HashMap<String, List<String>>();
        lunAfterStorageInfo.put(LUN_GROUP_ID, hpStorageListData.getLunGroupId());
        lunAfterStorageInfo.put(LUN_GROUP_NAME, hpStorageListData.getLunGroupName());
        lunAfterStorageInfo.put(LUN_ID, hpStorageListData.getLunId());
        lunAfterStorageInfo.put(LUN_NAME, hpStorageListData.getLunName());
        lunAfterStorageInfo.put(CAPACITY, hpStorageListData.getLunCapacity());
        lunAfterStorageInfo.put(HOST_ID, hpStorageListData.getLunHostId());
        lunAfterStorageInfo.put(HOSTGROUP_ID, hpStorageListData.getLunHostGroupId());
        lunAfterStorageInfo.put(STATUS, hpStorageListData.getLunStatus());
        lunAfterStorageInfo.put(LUN_WWN, hpStorageListData.getLunWwn());
        lunAfterStorageInfo.put(LUN_TYPE, hpStorageListData.getLunType());
        lunAfterStorageInfo.put(MAPPING_VIEW_ID, hpStorageListData.getLunMappingViewId());
        lunAfterStorageInfo.put(MAPPING_VIEW_NAME, hpStorageListData.getLunMappingViewName());
        if (isHuaweiDevice) {
            lunAfterStorageInfo.put(TAKEOVER_LUN_WWN, hpStorageListData.getHuaweiTakeoverLunWwn());
            lunAfterStorageInfo.put(REMOTE_REPLICATION, hpStorageListData.getHuaweiRemoteReplication());
            lunAfterStorageInfo.put(HYPER_METRO, hpStorageListData.getHuaweiHyperMetro());
        }
        return lunAfterStorageInfo;
    }

    private static Map<String, List<String>> getHostAfterStorageInfo(HPStorageListData hpStorageListData, boolean isHuaweiDevice) {
        HashMap<String, List<String>> hostAfterStorageInfo = new HashMap<String, List<String>>();
        hostAfterStorageInfo.put(MAPPING_VIEW_ID, hpStorageListData.getMappingViewId());
        hostAfterStorageInfo.put(MAPPING_VIEW_NAME, hpStorageListData.getMappingViewName());
        hostAfterStorageInfo.put(HOST_GROUP_ID, hpStorageListData.getHostGroupId());
        hostAfterStorageInfo.put(HOST_GROUP_NAME, hpStorageListData.getHostGroupName());
        hostAfterStorageInfo.put(HOST_ID, hpStorageListData.getHostId());
        hostAfterStorageInfo.put(HOST_NAME, hpStorageListData.getHostName());
        hostAfterStorageInfo.put(HOST_TYPE, hpStorageListData.getType());
        hostAfterStorageInfo.put(INITIATOR_WWN, hpStorageListData.getWwn());
        hostAfterStorageInfo.put(PORT, hpStorageListData.getPort());
        if (isHuaweiDevice) {
            hostAfterStorageInfo.put(ACCESS_MODEL, hpStorageListData.getAccessMode());
        }
        return hostAfterStorageInfo;
    }

    private static boolean checkHasUsableId(List<String> allIdList) {
        for (String id : allIdList) {
            if (NA.equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    private HandleStorageXlsData() {
    }
}

