/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.service;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.huawei.ism.tool.framework.pubservice.entity.enums.NodeAddEnum;
import com.huawei.ism.tool.infograb.entity.AixHost;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.HostInfo;
import com.huawei.ism.tool.infograb.entity.HostOracle;
import com.huawei.ism.tool.infograb.entity.HostOs;
import com.huawei.ism.tool.infograb.entity.HostVG;
import com.huawei.ism.tool.infograb.entity.HostVolume;
import com.huawei.ism.tool.infograb.entity.HpuxHost;
import com.huawei.ism.tool.infograb.entity.LinuxHost;
import com.huawei.ism.tool.infograb.entity.LvmFsFstab;
import com.huawei.ism.tool.infograb.entity.OracleDisk;
import com.huawei.ism.tool.infograb.entity.OverView;
import com.huawei.ism.tool.infograb.entity.PowerHA;
import com.huawei.ism.tool.infograb.entity.PowerNode;
import com.huawei.ism.tool.infograb.entity.PowerVm;
import com.huawei.ism.tool.infograb.entity.ServiceGuard;
import com.huawei.ism.tool.infograb.entity.ServiceGuardNode;
import com.huawei.ism.tool.infograb.entity.SolarisHost;
import com.huawei.ism.tool.infograb.entity.SolarisLvm;
import com.huawei.ism.tool.infograb.entity.SolarisLvmDisk;
import com.huawei.ism.tool.infograb.entity.VMwareHost;
import com.huawei.ism.tool.infograb.entity.Vioc;
import com.huawei.ism.tool.infograb.entity.VirtualHost;
import com.huawei.ism.tool.infograb.entity.VmControllerDisk;
import com.huawei.ism.tool.infograb.entity.VmInfo;
import com.huawei.ism.tool.infograb.entity.VmMultiDisk;
import com.huawei.ism.tool.infograb.entity.VmMultipath;
import com.huawei.ism.tool.infograb.entity.offline.GpfsCluster;
import com.huawei.ism.tool.infograb.entity.offline.GpfsDisk;
import com.huawei.ism.tool.infograb.entity.offline.PvInfo;
import com.huawei.ism.tool.infograb.entity.offline.SolarisVcs;
import com.huawei.ism.tool.infograb.entity.offline.SolarisVxVm;
import com.huawei.ism.tool.infograb.entity.offline.VcsNode;
import com.huawei.ism.tool.infograb.entity.offline.VxVmDisk;
import com.huawei.ism.tool.infograb.entity.offline.VxVmDiskGroup;
import com.huawei.ism.tool.infograb.entity.offline.VxVmPlex;
import com.huawei.ism.tool.infograb.entity.offline.VxVmVolume;
import com.huawei.ism.tool.infograb.entity.offline.WindowsHost;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabFileFactory;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabUtil;
import com.huawei.ism.tool.infograb.parser.host.HostCommonParser;
import com.huawei.ism.tool.infograb.parser.host.WindowsParser;
import com.huawei.ism.tool.infograb.service.XlsHostWriter;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.json.JSONObject;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.bind.JAXBException;
import org.python.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostDataHandleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostDataHandleService.class);
    private static final Type LIST_STRING_TYPE = new TypeToken<List<String>>(){}.getType();
    private static final Gson GSON = new Gson();

    public static boolean summary2Xls(String saveSumDataXls, List<GrabDevNode2> currSelectedNodes) {
        try {
            LOGGER.info("begin creat migration Summary report");
            Map<String, List<List<String>>> reportDatas = HostDataHandleService.getStructureDatas(currSelectedNodes);
            return XlsHostWriter.saveXlsReport(new File(saveSumDataXls), reportDatas);
        }
        catch (Exception e) {
            LOGGER.error("Failed to export the xls file.", (Throwable)e);
            return false;
        }
    }

    public static boolean host2XML(List<ExecuteResult> currResultList, GrabDevNode2 dev, Map<String, Object> resultMap, String offlineTaskName) {
        Set<String> nameKeys = resultMap.keySet();
        HostInfo hostInfo = "Linux".equals(dev.getDeviceName()) ? new LinuxHost() : ("AIX".equals(dev.getDeviceName()) ? new AixHost() : ("HP-UX".equals(dev.getDeviceName()) ? new HpuxHost() : ("Solaris".equals(dev.getDeviceName()) ? new SolarisHost() : ("Windows".equals(dev.getDeviceName()) ? new WindowsHost() : new VMwareHost()))));
        HostDataHandleService.createHostInfo(hostInfo, resultMap, nameKeys, dev);
        String xmlFile = HostDataHandleService.getXmlFile(currResultList, dev, offlineTaskName);
        boolean flag = ToolUtils.write2XML(xmlFile, hostInfo);
        if (flag) {
            dev.setXmlFileName(xmlFile);
            return true;
        }
        return false;
    }

    private static String getXmlFile(List<ExecuteResult> currResultList, GrabDevNode2 dev, String offlineTaskName) {
        if (dev.getNodeAddType().equals((Object)NodeAddEnum.OFFLINE_IMPORT)) {
            return GrabFileFactory.getInstance().getOfflineXmlPath(currResultList, offlineTaskName);
        }
        return GrabFileFactory.getInstance().getXmlFile(currResultList).toString();
    }

    private static void createHostInfo(HostInfo hostInfo, Map<String, Object> resultMap, Set<String> nameKeys, GrabDevNode2 dev) {
        nameKeys.forEach(nameKey -> HostDataHandleService.createOneHostInfo(hostInfo, resultMap, dev, nameKey));
    }

    private static void createOneHostInfo(HostInfo hostInfo, Map<String, Object> resultMap, GrabDevNode2 dev, String nameKey) {
        HostDataHandleService.createBasicHostInfo(hostInfo, resultMap, dev, nameKey);
        if (HostDataHandleService.isTargetType(nameKey, "multipath_info")) {
            HostCommonParser.buildMultipath(hostInfo, resultMap, dev.getDeviceName());
        } else if (HostDataHandleService.isTargetType(nameKey, "oracle_info")) {
            HostDataHandleService.setHostOracle(hostInfo, resultMap, dev.getDeviceName());
        } else if (HostDataHandleService.isTargetType(nameKey, "power_ha_info")) {
            HostDataHandleService.setPowerHA(hostInfo, resultMap);
        } else if (HostDataHandleService.isTargetType(nameKey, "power_vm_info")) {
            HostDataHandleService.setPowerVM(hostInfo, resultMap);
        } else if (HostDataHandleService.isTargetType(nameKey, "serviceguard_info")) {
            HostDataHandleService.setServiceGuard(hostInfo, resultMap);
        } else if (HostDataHandleService.isTargetType(nameKey, "vm_multipath_info")) {
            HostDataHandleService.setVmMultipath(hostInfo, resultMap);
        } else if (HostDataHandleService.isTargetType(nameKey, "vm_info")) {
            HostDataHandleService.setVmInfo(hostInfo, resultMap);
        } else if (HostDataHandleService.isTargetType(nameKey, "solaris_lvm_info")) {
            HostDataHandleService.setSolarisLVMInfo(hostInfo, resultMap);
        }
        if ("Windows".equals(dev.getDeviceName()) && hostInfo instanceof WindowsHost) {
            WindowsParser.buildWindowsHostInfo((WindowsHost)hostInfo, resultMap, nameKey);
        }
    }

    private static void createBasicHostInfo(HostInfo hostInfo, Map<String, Object> resultMap, GrabDevNode2 dev, String nameKey) {
        if ("os_info".equals(nameKey)) {
            HostDataHandleService.setOsInfo(hostInfo, resultMap);
        } else if ("overview_info".equals(nameKey)) {
            HostDataHandleService.setOverview(hostInfo, resultMap);
        } else if ("solaris_vxvm_info".equals(nameKey)) {
            HostDataHandleService.setSolarisVxVmInfo(hostInfo, resultMap);
        } else if ("solaris_vcs_info".equals(nameKey)) {
            HostDataHandleService.setSolarisVcsInfo(hostInfo, resultMap);
        } else if ("lvm_info".equals(nameKey)) {
            HostDataHandleService.setHostVolume(hostInfo, resultMap, dev.getDeviceName());
        } else if ("gpfs_info".equals(nameKey)) {
            HostDataHandleService.setGpfsInfo(hostInfo, resultMap);
        }
    }

    private static boolean isTargetType(String nameKey, String hostMigraDataMultipath) {
        return hostMigraDataMultipath.equals(nameKey);
    }

    private static Map<String, List<List<String>>> getStructureDatas(List<GrabDevNode2> currSelectedNodes) {
        LOGGER.info("get structured data");
        HashMap<String, List<List<String>>> reportData = new HashMap<String, List<List<String>>>();
        ArrayList<HostInfo> linuxHosts = new ArrayList<HostInfo>(currSelectedNodes.size());
        ArrayList<HostInfo> aixHosts = new ArrayList<HostInfo>(currSelectedNodes.size());
        ArrayList<HostInfo> hpHosts = new ArrayList<HostInfo>(currSelectedNodes.size());
        ArrayList<HostInfo> solarisHosts = new ArrayList<HostInfo>(currSelectedNodes.size());
        ArrayList<HostInfo> vmwareHosts = new ArrayList<HostInfo>(currSelectedNodes.size());
        ArrayList<HostInfo> windowsHosts = new ArrayList<HostInfo>(currSelectedNodes.size());
        ArrayList<HostInfo> allHosts = new ArrayList<HostInfo>(currSelectedNodes.size());
        for (GrabDevNode2 currSelectedNode : currSelectedNodes) {
            try {
                HostInfo hostInfo;
                if ("Linux".equals(currSelectedNode.getDeviceName())) {
                    hostInfo = ToolUtils.read2Obj(currSelectedNode.getXmlFileName(), new LinuxHost());
                    linuxHosts.add(hostInfo);
                } else if ("AIX".equals(currSelectedNode.getDeviceName())) {
                    hostInfo = ToolUtils.read2Obj(currSelectedNode.getXmlFileName(), new AixHost());
                    aixHosts.add(hostInfo);
                } else if ("HP-UX".equals(currSelectedNode.getDeviceName())) {
                    hostInfo = ToolUtils.read2Obj(currSelectedNode.getXmlFileName(), new HpuxHost());
                    hpHosts.add(hostInfo);
                } else if ("Solaris".equals(currSelectedNode.getDeviceName())) {
                    hostInfo = ToolUtils.read2Obj(currSelectedNode.getXmlFileName(), new SolarisHost());
                    solarisHosts.add(hostInfo);
                } else if ("Windows".equals(currSelectedNode.getDeviceName())) {
                    hostInfo = ToolUtils.read2Obj(currSelectedNode.getXmlFileName(), new WindowsHost());
                    windowsHosts.add(hostInfo);
                } else {
                    hostInfo = ToolUtils.read2Obj(currSelectedNode.getXmlFileName(), new VMwareHost());
                    vmwareHosts.add(hostInfo);
                }
                allHosts.add(hostInfo);
            }
            catch (JAXBException e) {
                LOGGER.error("creat object from xml fail:", (Throwable)e);
            }
        }
        if (!allHosts.isEmpty()) {
            reportData.put("Overview", HostCommonParser.getOverviewData(allHosts));
        }
        HostDataHandleService.buildLinuxStructureDatas(linuxHosts, reportData);
        HostDataHandleService.buildAixStructureDatas(aixHosts, reportData);
        HostDataHandleService.buildHpStructureDatas(hpHosts, reportData);
        HostDataHandleService.buildSolarisStructureDatas(solarisHosts, reportData);
        HostDataHandleService.buildVMwareStructureDatas(vmwareHosts, reportData);
        WindowsParser.buildWindowsStructureDatas(windowsHosts, reportData);
        return reportData;
    }

    private static void buildLinuxStructureDatas(List<HostInfo> linuxHosts, Map<String, List<List<String>>> reportData) {
        if (!linuxHosts.isEmpty()) {
            reportData.put("Linux_OS", HostCommonParser.getOsData(linuxHosts));
            reportData.put("Linux_Multipath", HostCommonParser.getMultiData(linuxHosts, "Linux"));
            reportData.put("Linux_LVM", HostDataHandleService.getLvmData(linuxHosts, "Linux"));
            reportData.put("Linux_OracleRAC", HostDataHandleService.getOracleData(linuxHosts, "Linux"));
            reportData.put("Linux_GPFS", HostDataHandleService.getGpfsData(linuxHosts));
        }
    }

    private static void buildAixStructureDatas(List<HostInfo> aixHosts, Map<String, List<List<String>>> reportData) {
        if (!aixHosts.isEmpty()) {
            reportData.put("AIX_OS", HostCommonParser.getOsData(aixHosts));
            reportData.put("AIX_Multipath", HostCommonParser.getMultiData(aixHosts, "AIX"));
            reportData.put("AIX_LVM", HostDataHandleService.getLvmData(aixHosts, "AIX"));
            reportData.put("AIX_OracleRAC", HostDataHandleService.getOracleData(aixHosts, "AIX"));
            reportData.put("AIX_PowerHA", HostDataHandleService.getPowerHAData(aixHosts));
            reportData.put("AIX_PowerVM", HostDataHandleService.getPowerVMData(aixHosts));
            reportData.put("AIX_GPFS", HostDataHandleService.getGpfsData(aixHosts));
        }
    }

    private static void buildHpStructureDatas(List<HostInfo> hpHosts, Map<String, List<List<String>>> reportData) {
        if (!hpHosts.isEmpty()) {
            reportData.put("HPUX_OS", HostCommonParser.getOsData(hpHosts));
            reportData.put("HPUX_Multipath", HostCommonParser.getMultiData(hpHosts, "HP-UX"));
            reportData.put("HPUX_LVM", HostDataHandleService.getLvmData(hpHosts, "HP-UX"));
            reportData.put("HPUX_OracleRAC", HostDataHandleService.getOracleData(hpHosts, "HP-UX"));
            reportData.put("HPUX_ServiceGuard", HostDataHandleService.getServiceGuardData(hpHosts));
        }
    }

    private static void buildSolarisStructureDatas(List<HostInfo> solarisHosts, Map<String, List<List<String>>> reportData) {
        if (!solarisHosts.isEmpty()) {
            reportData.put("Solaris_OS", HostCommonParser.getSolarisOsData(solarisHosts));
            reportData.put("Solaris_Multipath", HostCommonParser.getMultiData(solarisHosts, "Solaris"));
            reportData.put("Solaris_LVM", HostDataHandleService.getSolarisLvmData(solarisHosts));
            reportData.put("Solaris_OracleRAC", HostDataHandleService.getOracleData(solarisHosts, "Solaris"));
            reportData.put("Solaris_VCS", HostDataHandleService.getSolarisVcsData(solarisHosts));
            reportData.put("Solaris_VxVM", HostDataHandleService.getSolarisVxVmData(solarisHosts));
        }
    }

    private static void buildVMwareStructureDatas(List<HostInfo> vmwareHosts, Map<String, List<List<String>>> reportData) {
        if (!vmwareHosts.isEmpty()) {
            reportData.put("ESXi_OS", HostCommonParser.getOsData(vmwareHosts));
            reportData.put("ESXi_Multipath", HostDataHandleService.getVMwareMultiData(vmwareHosts));
            reportData.put("ESXi_VMinfo", HostDataHandleService.getVMwareVMinfoData(vmwareHosts));
        }
    }

    private static List<List<String>> getSolarisVxVmData(List<HostInfo> solarisHosts) {
        ArrayList<List<String>> vxVmData = new ArrayList<List<String>>();
        vxVmData.add(Arrays.asList("IP/ID", "DG Name", "Disk Name", "Device Name", "Volume Name", "Plex Name", "Subdisk", "Mount Point", "Volume Size"));
        solarisHosts.stream().filter(host -> host instanceof SolarisHost).map(host -> (SolarisHost)host).map(HostDataHandleService::getOneSolarisHostContents).flatMap(Collection::stream).forEach(vxVmData::add);
        return vxVmData;
    }

    private static List<List<String>> getOneSolarisHostContents(SolarisHost host) {
        SolarisVxVm solarisVxVm = host.getSolarisVxVm();
        List<VxVmDiskGroup> vxVmDiskGroups = solarisVxVm.getVxVmDiskGroups();
        String ip = solarisVxVm.getIp();
        return vxVmDiskGroups.stream().map(vxVmDiskGroup -> HostDataHandleService.getOneGroupContent(vxVmDiskGroup, ip)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<List<String>> getOneGroupContent(VxVmDiskGroup vxVmDiskGroup, String ip) {
        List<VxVmDisk> vxVmDisks = vxVmDiskGroup.getVxVmDisks();
        List<VxVmVolume> vxVmVolumes = vxVmDiskGroup.getVxVmVolumes();
        List<List<String>> allDiskContent = HostDataHandleService.getAllDiskContent(vxVmDisks);
        List<List<String>> allVolumeContent = HostDataHandleService.getAllVolumeContent(vxVmVolumes);
        int maxIndex = Math.max(allDiskContent.size(), allVolumeContent.size());
        List<String> oneRow = Arrays.asList(ip, vxVmDiskGroup.getDiskGroupName());
        return IntStream.range(0, maxIndex).mapToObj(index -> HostDataHandleService.getOneRowContent(index, allDiskContent, allVolumeContent, oneRow)).collect(Collectors.toList());
    }

    private static List<String> getOneRowContent(int index, List<List<String>> allDiskContent, List<List<String>> allVolumeContent, List<String> rowStart) {
        ArrayList oneRow = Lists.newArrayList();
        oneRow.addAll(rowStart);
        if (index < allDiskContent.size()) {
            oneRow.addAll((Collection)allDiskContent.get(index));
        } else {
            oneRow.addAll(Arrays.asList("", ""));
        }
        if (index < allVolumeContent.size()) {
            oneRow.addAll((Collection)allVolumeContent.get(index));
        } else {
            oneRow.addAll(Arrays.asList("", "", "", "", ""));
        }
        return oneRow;
    }

    private static List<List<String>> getAllDiskContent(List<VxVmDisk> vxVmDisks) {
        return vxVmDisks.stream().map(vxVmDisk -> Arrays.asList(vxVmDisk.getDiskName(), vxVmDisk.getDeviceName())).collect(Collectors.toList());
    }

    private static List<List<String>> getAllVolumeContent(List<VxVmVolume> vxVmVolumes) {
        return vxVmVolumes.stream().map(HostDataHandleService::getPlex2VolumeList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<List<String>> getPlex2VolumeList(VxVmVolume vxVmVolume) {
        List<List<String>> sub2PlexList = vxVmVolume.getVxVmPlexes().stream().map(HostDataHandleService::getSubDisk2PlexList).flatMap(Collection::stream).map(arrList -> HostDataHandleService.getOnePlex2VolumeList(vxVmVolume, arrList)).collect(Collectors.toList());
        if (sub2PlexList.isEmpty()) {
            return Collections.singletonList(Arrays.asList(vxVmVolume.getVolumeName(), "", "", vxVmVolume.getMountPoint(), vxVmVolume.getTotalSize()));
        }
        return sub2PlexList;
    }

    private static List<String> getOnePlex2VolumeList(VxVmVolume vxVmVolume, List<String> arrList) {
        ArrayList initList = Lists.newArrayList((Object[])new String[]{vxVmVolume.getVolumeName()});
        initList.addAll(arrList);
        initList.addAll(Arrays.asList(vxVmVolume.getMountPoint(), vxVmVolume.getTotalSize()));
        return initList;
    }

    private static List<List<String>> getSubDisk2PlexList(VxVmPlex vxVmPlex) {
        if (vxVmPlex.getSubDisks().isEmpty()) {
            return Collections.singletonList(Arrays.asList(vxVmPlex.getPlexName(), ""));
        }
        return vxVmPlex.getSubDisks().stream().map(subDisk -> Arrays.asList(vxVmPlex.getPlexName(), subDisk)).collect(Collectors.toList());
    }

    private static List<List<String>> getSolarisVcsData(List<HostInfo> solarisHosts) {
        ArrayList<List<String>> vcsData = new ArrayList<List<String>>();
        vcsData.add(Arrays.asList("IP/ID", "Cluster Member", "Node Stauts", "Cluster Version", "Cluster Vote", "Cluster MultiPath", "Fencing Mode", "Cluster Group", "Group State", "DG Name"));
        List allHostVcsData = solarisHosts.stream().map(HostDataHandleService::getOneHostVcsData).flatMap(Collection::stream).collect(Collectors.toList());
        vcsData.addAll(allHostVcsData);
        return vcsData;
    }

    private static List<List<String>> getOneHostVcsData(HostInfo host) {
        SolarisVcs solarisVcs = ((SolarisHost)host).getSolarisVcs();
        List<VcsNode> vcsNodes = solarisVcs.getVcsNodes();
        return vcsNodes.stream().map(vcsNode -> HostDataHandleService.getOneRowData(solarisVcs, vcsNode)).collect(Collectors.toList());
    }

    private static List<String> getOneRowData(SolarisVcs solarisVcs, VcsNode vcsNode) {
        ArrayList<String> oneRowContent = new ArrayList<String>();
        oneRowContent.add(solarisVcs.getIp());
        oneRowContent.add(vcsNode.getNodeName());
        oneRowContent.add(vcsNode.getNodeStatus());
        oneRowContent.add(solarisVcs.getClusterVersion());
        oneRowContent.add(solarisVcs.getClusterVote());
        oneRowContent.add(solarisVcs.getClusterMultiPath());
        oneRowContent.add(solarisVcs.getFencingMode());
        oneRowContent.add(vcsNode.getNodeGroup());
        oneRowContent.add(vcsNode.getGroupState());
        oneRowContent.add(vcsNode.getDgName());
        solarisVcs.setFencingMode("");
        solarisVcs.setClusterVersion("");
        solarisVcs.setClusterVote("");
        solarisVcs.setClusterMultiPath("");
        return oneRowContent;
    }

    private static List<List<String>> getSolarisLvmData(List<HostInfo> solarisHosts) {
        ArrayList<List<String>> lvmData = new ArrayList<List<String>>();
        lvmData.add(Arrays.asList("IP/ID", "LVM Type", "Pool Name", "Volume Name", "Disk Name ", "Filesystem", "FS Total Size(GiB)", "FS Used Size(GiB)", "FS Mount Point"));
        for (HostInfo host : solarisHosts) {
            SolarisLvm solarisLvm = ((SolarisHost)host).getSolarisLvm();
            List<SolarisLvmDisk> solarisLvmDisks = solarisLvm.getSolarisLvmDisks();
            for (SolarisLvmDisk solarisLvmDisk : solarisLvmDisks) {
                ArrayList<String> content = new ArrayList<String>();
                content.add(solarisLvm.getIp());
                content.add(solarisLvmDisk.getLvmType());
                content.add(solarisLvmDisk.getPoolName());
                content.add(solarisLvmDisk.getVolumeName());
                content.add(solarisLvmDisk.getDiskName());
                content.add(solarisLvmDisk.getFilesystem());
                content.add(solarisLvmDisk.getTotalSize());
                content.add(solarisLvmDisk.getUsedSize());
                content.add(solarisLvmDisk.getMountPoint());
                lvmData.add(content);
            }
        }
        return lvmData;
    }

    private static List<List<String>> getLvmData(List<HostInfo> hosts, String hostType) {
        ArrayList<List<String>> lvmData = new ArrayList<List<String>>();
        lvmData.add(HostDataHandleService.getLvmDataHead(hostType));
        hosts.stream().map(hostInfo -> HostDataHandleService.getOneHostVgData(hostInfo, hostType)).forEach(lvmData::addAll);
        return lvmData;
    }

    private static List<List<String>> getOneHostVgData(HostInfo hostInfo, String hostType) {
        HostVolume hostVolume = hostInfo.getHostVolume();
        List<HostVG> hostVGS = hostVolume.getHostVGS();
        return hostVGS.stream().map(hostVG -> HostDataHandleService.getOneVgData(hostVolume, hostVG, hostType)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<List<String>> getOneVgData(HostVolume hostVolume, HostVG hostVG, String hostType) {
        List<PvInfo> pvs = hostVG.getPvs();
        List<List<String>> lvmData = HostDataHandleService.generateContent(hostVolume, hostVG, pvs, hostType);
        pvs.stream().map(pvInfo -> HostDataHandleService.getOnePvData(pvInfo, hostType, hostVolume, hostVG)).forEach(lvmData::add);
        return lvmData;
    }

    private static List<String> getOnePvData(PvInfo pvTmp, String hostType, HostVolume hostVolume, HostVG hostVG) {
        ArrayList<String> content = new ArrayList<String>();
        if (hostType.equals("Linux")) {
            content.addAll(Arrays.asList(hostVolume.getIp(), hostVG.getVgName(), hostVG.getVgSize(), "", ""));
            content.add(pvTmp.getPvName());
            content.add(pvTmp.getPvSize());
            content.addAll(Arrays.asList("", "", "", "", "", "", "", "", hostVolume.getLvmConf(), ""));
        } else if (hostType.equals("AIX") || hostType.equals("HP-UX")) {
            content.addAll(HostDataHandleService.getAixHpUxOnePvDataBegin(hostType, hostVolume.getIp(), hostVG));
            content.add(pvTmp.getPvName());
            if (hostType.equals("AIX")) {
                content.add(pvTmp.getPvId());
            }
            content.add(pvTmp.getPvSize());
            content.addAll(Arrays.asList("", "", "", ""));
        }
        return content;
    }

    private static List<String> getAixHpUxOnePvDataBegin(String type, String ip, HostVG hostVG) {
        if (type.equals("HP-UX")) {
            return Arrays.asList(ip, hostVG.getVgName(), hostVG.getVgSize(), hostVG.getVgState(), "", "", "");
        }
        return Arrays.asList(ip, hostVG.getVgName(), hostVG.getVgSize(), hostVG.getVgState(), hostVG.getVgMajorNumber(), "", "", "");
    }

    private static List<String> getLvmDataHead(String hostType) {
        if (hostType.equals("Linux")) {
            return Arrays.asList("IP/ID", "VG Name", "VG Size", "LV Name", "LV Size", "PV Name", "PV Size", "Filesystem", "FS Total Size", "FS Used Size", "FS Type", "FS Mount Point", "FStab Filesystem", "FStab Mount Point", "FStab FS Type", "LVM Filter", "Discard");
        }
        if (hostType.equals("AIX")) {
            return Arrays.asList("IP/ID", "VG Name", "VG Size", "VG State", "VG Major Number", "LV Name", "LV Size", "LV State", "PV Name", "PVID", "PV Size", "Filesystem", "FS Total Size", "FS Used Size", "FS Mount Point");
        }
        return Arrays.asList("IP/ID", "VG Name", "VG Size", "VG State", "LV Name", "LV Size", "LV State", "PV Name", "PV Size", "Filesystem", "FS Total Size", "FS Used Size", "FS Mount Point");
    }

    private static List<List<String>> generateContent(HostVolume hostVolume, HostVG hostVG, List<PvInfo> pvs, String hostType) {
        return hostVG.getLvmFsFstabs().stream().map(lvmFsFstab -> HostDataHandleService.getOneLvmData(hostVolume, hostVG, hostType, lvmFsFstab, pvs)).collect(Collectors.toList());
    }

    private static List<String> getOneLvmData(HostVolume hostVolume, HostVG hostVG, String hostType, LvmFsFstab lvmFsFstab, List<PvInfo> pvs) {
        ArrayList<String> content = new ArrayList<String>(Arrays.asList(hostVolume.getIp(), hostVG.getVgName(), hostVG.getVgSize()));
        if (hostType.equals("Linux")) {
            content.add(lvmFsFstab.getLvName());
            content.add(lvmFsFstab.getLvSize());
            HostDataHandleService.getPvsData(pvs, content, hostType);
            content.add(lvmFsFstab.getFsFileSystem());
            content.add(lvmFsFstab.getFsTotalSize());
            content.add(lvmFsFstab.getFsUsedSize());
            content.add(lvmFsFstab.getFsType());
            content.add(lvmFsFstab.getFsMountPoint());
            content.add(lvmFsFstab.getFstabFileSystem());
            content.add(lvmFsFstab.getFstabMountPoint());
            content.add(lvmFsFstab.getFstabType());
            content.add(hostVolume.getLvmConf());
            content.add(lvmFsFstab.getDiscard());
        } else if (hostType.equals("AIX") || hostType.equals("HP-UX")) {
            content.add(hostVG.getVgState());
            if (hostType.equals("AIX")) {
                content.add(hostVG.getVgMajorNumber());
            }
            content.add(lvmFsFstab.getLvName());
            content.add(lvmFsFstab.getLvSize());
            content.add(lvmFsFstab.getLvState());
            HostDataHandleService.getPvsData(pvs, content, hostType);
            content.add(lvmFsFstab.getFsFileSystem());
            content.add(lvmFsFstab.getFsTotalSize());
            content.add(lvmFsFstab.getFsUsedSize());
            content.add(lvmFsFstab.getFsMountPoint());
        }
        return content;
    }

    private static void getPvsData(List<PvInfo> pvs, List<String> content, String hostType) {
        if (!pvs.isEmpty()) {
            PvInfo pv = pvs.get(0);
            content.add(pv.getPvName());
            if ("AIX".equals(hostType)) {
                content.add(pv.getPvId());
            }
            content.add(pv.getPvSize());
            pvs.remove(0);
        } else {
            content.add("");
            if ("AIX".equals(hostType)) {
                content.add("");
            }
            content.add("");
        }
    }

    private static List<List<String>> getOracleData(List<HostInfo> hosts, String hostType) {
        ArrayList<List<String>> oracleData = new ArrayList<List<String>>();
        oracleData.add(HostDataHandleService.getOracleHeader(hostType));
        for (HostInfo host : hosts) {
            host.getHostOracle().getOracleDisks().forEach(oracleDisk -> oracleData.add(HostDataHandleService.getOneDiskOracleData(hostType, host.getHostOracle(), oracleDisk)));
        }
        return oracleData;
    }

    private static List<String> getOneDiskOracleData(String hostType, HostOracle hostOracle, OracleDisk oracleDisk) {
        ArrayList<String> content = new ArrayList<String>();
        content.add(hostOracle.getIp());
        content.add(hostOracle.getVersion());
        content.add(oracleDisk.getDiskName());
        content.add(oracleDisk.getDiskPath());
        content.add(oracleDisk.getDiskState());
        content.add(oracleDisk.getDiskTotalSize());
        content.add(oracleDisk.getDiskFreeSize());
        content.add(hostOracle.getDiskStringValue());
        HostDataHandleService.addContentForLinux(hostType, hostOracle, oracleDisk, content);
        HostDataHandleService.addContentForAix(hostType, oracleDisk, content);
        HostDataHandleService.addContentForSolaris(hostType, oracleDisk, content);
        HostDataHandleService.addContentForHpUx(hostType, oracleDisk, content);
        return content;
    }

    private static void addContentForLinux(String hostType, HostOracle hostOracle, OracleDisk oracleDisk, List<String> content) {
        if ("Linux".equals(hostType)) {
            content.add(hostOracle.getDiskRule());
            content.add(oracleDisk.getLunWwn());
            content.add(oracleDisk.getUser());
            content.add(oracleDisk.getGroup());
            content.add(hostOracle.getAsmScanorder());
            content.add(hostOracle.getAsmScanexclude());
            content.add(oracleDisk.getDiskSectorSize());
        }
    }

    private static void addContentForAix(String hostType, OracleDisk oracleDisk, List<String> content) {
        if ("AIX".equals(hostType)) {
            content.add(oracleDisk.getAixDiskName());
            content.add(oracleDisk.getPermission());
            content.add(oracleDisk.getUser());
            content.add(oracleDisk.getGroup());
            content.add(oracleDisk.getMajor());
            content.add(oracleDisk.getMinor());
            content.add(oracleDisk.getDiskSectorSize());
        }
    }

    private static void addContentForSolaris(String hostType, OracleDisk oracleDisk, List<String> content) {
        if ("Solaris".equals(hostType)) {
            content.add(oracleDisk.getLunWwn());
            content.add(oracleDisk.getUser());
            content.add(oracleDisk.getGroup());
            content.add(oracleDisk.getDiskSectorSize());
        }
    }

    private static void addContentForHpUx(String hostType, OracleDisk oracleDisk, List<String> content) {
        if ("HP-UX".equals(hostType)) {
            content.add(oracleDisk.getDiskSectorSize());
        }
    }

    private static List<String> getOracleHeader(String hostType) {
        switch (hostType) {
            case "Linux": {
                return Arrays.asList("IP/ID", "Oracle Version", "ASMdisk Name", "ASMdisk Path", "ASMdisk State", "ASMdisk Total Size(MB)", "ASMdisk Free Size(MB)", "ASM Diskstring Value", "Disk Rule", "Lun WWN", "User", "Group", "Oracleasm Scanorder", "Oracleasm Scanexclude", "Sector Size");
            }
            case "AIX": {
                return Arrays.asList("IP/ID", "Oracle Version", "ASMdisk Name", "ASMdisk Path", "ASMdisk State", "ASMdisk Total Size(MB)", "ASMdisk Free Size(MB)", "ASM Diskstring Value", "Disk Name", "Permissions", "User", "Group", "Major", "Minor", "Sector Size");
            }
            case "Solaris": {
                return Arrays.asList("IP/ID", "Oracle Version", "ASMdisk Name", "ASMdisk Path", "ASMdisk State", "ASMdisk Total Size(MB)", "ASMdisk Free Size(MB)", "ASM Diskstring Value", "Lun WWN", "User", "Group", "Sector Size");
            }
        }
        return Arrays.asList("IP/ID", "Oracle Version", "ASMdisk Name", "ASMdisk Path", "ASMdisk State", "ASMdisk Total Size(MB)", "ASMdisk Free Size(MB)", "ASM Diskstring Value", "Sector Size");
    }

    private static List<List<String>> getPowerHAData(List<HostInfo> aixHosts) {
        ArrayList<List<String>> powerHaData = new ArrayList<List<String>>();
        powerHaData.add(Arrays.asList("IP/ID", "Cluster Name", "Cluster Version", "Repository Disk", "Heartbeat Disk", "Node Name", "Resource Group", "VG Name"));
        for (HostInfo host : aixHosts) {
            PowerHA powerHA = ((AixHost)host).getPowerHA();
            List<PowerNode> powerNodes = powerHA.getPowerNodes();
            for (PowerNode powerNode : powerNodes) {
                ArrayList<String> content = new ArrayList<String>();
                content.add(powerHA.getIp());
                content.add(powerHA.getClusterName());
                content.add(powerHA.getClusterVersion());
                content.add(powerHA.getRepositoryDisk());
                content.add(powerHA.getHeartbeatDisk());
                content.add(powerNode.getNodeName());
                content.add(powerNode.getNodeGroup());
                content.add(powerNode.getNodeVg());
                powerHaData.add(content);
            }
        }
        return powerHaData;
    }

    private static List<List<String>> getPowerVMData(List<HostInfo> aixHosts) {
        ArrayList<List<String>> powerVmData = new ArrayList<List<String>>();
        powerVmData.add(Arrays.asList("IP/ID", "VIOS Version", "VIOC ID", "Virtual SCSI SA", "Virtual SCSI VTD", "Virtual SCSI BD", "Virtual FC SA", "Virtual FC Status", "Virtual FC Name"));
        for (HostInfo host : aixHosts) {
            PowerVm powerVm = ((AixHost)host).getPowerVm();
            List<Vioc> viocs = powerVm.getViocs();
            for (Vioc vioc : viocs) {
                ArrayList<String> content = new ArrayList<String>();
                content.add(powerVm.getIp());
                content.add(powerVm.getVersion());
                content.add(vioc.getViocId());
                content.add(vioc.getScsiSa());
                content.add(vioc.getScsiVtd());
                content.add(vioc.getScsiBackDevice());
                content.add(vioc.getFcSa());
                content.add(vioc.getFcStatus());
                content.add(vioc.getFcName());
                powerVmData.add(content);
            }
        }
        return powerVmData;
    }

    private static List<List<String>> getServiceGuardData(List<HostInfo> hpHosts) {
        ArrayList<List<String>> sdData = new ArrayList<List<String>>();
        sdData.add(Arrays.asList("IP/ID", "Cluster Name", "Cluster Version", "Cluster Status", "Cluster Node", "Lock Volume Group", "Lock Physical Disk", "Lock Status", "Package Node", "Package Name", "Package State", "Package Status"));
        for (HostInfo host : hpHosts) {
            ServiceGuard serviceGuard = ((HpuxHost)host).getServiceGuard();
            List<ServiceGuardNode> nodes = serviceGuard.getNodes();
            for (ServiceGuardNode sgNode : nodes) {
                ArrayList<String> content = new ArrayList<String>();
                content.add(serviceGuard.getIp());
                content.add(serviceGuard.getClusterName());
                content.add(serviceGuard.getClusterVersion());
                content.add(serviceGuard.getClusterStatus());
                content.add(sgNode.getNodeName());
                content.add(sgNode.getLockVolumeGroup());
                content.add(sgNode.getLockPhysicalDisk());
                content.add(sgNode.getLockStatus());
                content.add(sgNode.getPackageNode());
                content.add(sgNode.getPackageName());
                content.add(sgNode.getPackageState());
                content.add(sgNode.getPackageStatus());
                sdData.add(content);
            }
        }
        return sdData;
    }

    private static List<List<String>> getGpfsData(List<HostInfo> hosts) {
        ArrayList<List<String>> gpfsData = new ArrayList<List<String>>();
        gpfsData.add(Arrays.asList("IP/ID", "Cluster Name", "Cluster Version", "Cluster RepositoryType", "Cluster TiebreakerDisks", "Cluster DiskName", "Multipath DiskName", "Cluster FileSystem", "Cluster NSDServers", "Node Name", "Node State", "Cluster Designation"));
        hosts.stream().map(HostDataHandleService::getOneHostGpfsData).flatMap(Collection::stream).forEach(gpfsData::add);
        return gpfsData;
    }

    private static List<List<String>> getOneHostGpfsData(HostInfo host) {
        GpfsCluster gpfsCluster;
        if (host instanceof LinuxHost) {
            gpfsCluster = ((LinuxHost)host).getGpfsCluster();
        } else if (host instanceof AixHost) {
            gpfsCluster = ((AixHost)host).getGpfsCluster();
        } else {
            return Collections.singletonList(Arrays.asList("", "", "", "", "", "", "", "", "", "", "", ""));
        }
        List<String> startContent = Arrays.asList(gpfsCluster.getIp(), gpfsCluster.getClusterName(), gpfsCluster.getClusterVersion(), gpfsCluster.getClusterRepositoryType(), gpfsCluster.getClusterTiebreakerDisks());
        return gpfsCluster.getGpfsDisks().stream().map(gpfsDisk -> HostDataHandleService.getOneRowGpfsData(startContent, gpfsDisk)).collect(Collectors.toList());
    }

    private static List<String> getOneRowGpfsData(List<String> startContent, GpfsDisk gpfsDisk) {
        ArrayList<String> oneRowContent = new ArrayList<String>(startContent);
        oneRowContent.add(gpfsDisk.getClusterDiskName());
        oneRowContent.add(gpfsDisk.getMultipathDiskName());
        oneRowContent.add(gpfsDisk.getClusterFileSystem());
        oneRowContent.add(gpfsDisk.getNsdServers());
        oneRowContent.add(gpfsDisk.getNodeName());
        oneRowContent.add(gpfsDisk.getNodeState());
        oneRowContent.add(gpfsDisk.getClusterDesignation());
        return oneRowContent;
    }

    private static List<String> getRDMLunList(List<HostInfo> vmwareHosts) {
        return vmwareHosts.stream().flatMap(HostDataHandleService::getVmDisks).filter(HostDataHandleService::isRdmDisk).map(VmMultiDisk::getLunWwn).collect(Collectors.toList());
    }

    private static Stream<VmMultiDisk> getVmDisks(HostInfo vMwareHost) {
        return ((VMwareHost)vMwareHost).getVmMultipaths().stream().flatMap(vmMultipath -> vmMultipath.getVmMultiDisks().stream());
    }

    private static boolean isRdmDisk(VmMultiDisk vmMultiDisk) {
        return "RDM".equals(vmMultiDisk.getDiskUseType());
    }

    private static List<List<String>> getVMwareMultiData(List<HostInfo> vmwareHosts) {
        ArrayList<List<String>> multiData = new ArrayList<List<String>>();
        multiData.add(Arrays.asList("IP/ID", "Multipath Type", "Multipath Version", "Datastore Name", "Type", "Compatibility Mode", "Lun Size(GiB)", "Lun WWN", "VAAI Status", "VAAI Plugin Name", "Storage Array Type", "Path Policy", "Boot Device", "Vendor", "Product", "Reservation Key", "Host LUN ID"));
        List<String> rdmList = HostDataHandleService.getRDMLunList(vmwareHosts);
        for (HostInfo host : vmwareHosts) {
            List<VmMultipath> vmMultipaths = ((VMwareHost)host).getVmMultipaths();
            for (VmMultipath vmMultipath : vmMultipaths) {
                String ip = vmMultipath.getIp();
                String type = vmMultipath.getType();
                String version = vmMultipath.getVersion();
                List<VmMultiDisk> vmMultiDisks = vmMultipath.getVmMultiDisks();
                for (VmMultiDisk vmMultiDisk : vmMultiDisks) {
                    ArrayList<String> content = new ArrayList<String>();
                    content.add(ip);
                    content.add(type);
                    content.add(version);
                    content.add(vmMultiDisk.getDatastoreName());
                    if (rdmList.contains(vmMultiDisk.getLunWwn())) {
                        content.add("RDM");
                    } else {
                        content.add(vmMultiDisk.getDiskUseType());
                    }
                    content.add(vmMultiDisk.getCompatibilityMode());
                    content.add(vmMultiDisk.getLunSize());
                    content.add(vmMultiDisk.getLunWwn());
                    content.add(vmMultiDisk.getVaaiStatus());
                    content.add(vmMultiDisk.getVaaiPluginName());
                    content.add(vmMultiDisk.getStorageArrayType());
                    content.add(vmMultiDisk.getPathPolicy());
                    content.add(vmMultiDisk.getBootDevice());
                    content.add(vmMultiDisk.getVendor());
                    content.add(vmMultiDisk.getProduct());
                    content.add(vmMultiDisk.getReservationKey());
                    content.add(vmMultiDisk.getHostLunId());
                    multiData.add(content);
                }
            }
        }
        return multiData;
    }

    private static List<List<String>> getVMwareVMinfoData(List<HostInfo> vmwareHosts) {
        ArrayList<List<String>> vminfoData = new ArrayList<List<String>>();
        vminfoData.add(Arrays.asList("IP/ID", "VM Name", "Power State", "Os Type ", "VM Filepath", "Disk Label", "Disk Size(GiB)", "Disk Path", "Raw", "SCSI Controller Label", "SCSI Controller Type", "Shared Bus", "Unit Number", "Compatibility Mode", "Raw Lun ID"));
        for (HostInfo host : vmwareHosts) {
            VmInfo vmInfo = ((VMwareHost)host).getVmInfo();
            List<VirtualHost> virtualHosts = vmInfo.getVirtualHosts();
            for (VirtualHost virtualHost : virtualHosts) {
                List<VmControllerDisk> vmControllerDisks = virtualHost.getVmControllerDisks();
                for (VmControllerDisk vmControllerDisk : vmControllerDisks) {
                    ArrayList<String> content = new ArrayList<String>();
                    content.add(vmInfo.getIp());
                    content.add(virtualHost.getVmName());
                    content.add(virtualHost.getVmState());
                    content.add(virtualHost.getVmOsType());
                    content.add(virtualHost.getVmFile());
                    content.add(vmControllerDisk.getDiskLabel());
                    content.add(vmControllerDisk.getDiskSize());
                    content.add(vmControllerDisk.getDiskPath());
                    content.add(vmControllerDisk.getRaw());
                    content.add(vmControllerDisk.getControllerLable());
                    content.add(vmControllerDisk.getControllerType());
                    content.add(vmControllerDisk.getControllerShareBus());
                    content.add(vmControllerDisk.getUnitNumber());
                    content.add(vmControllerDisk.getCompatitbilityMode());
                    content.add(vmControllerDisk.getRawLunId());
                    vminfoData.add(content);
                }
            }
        }
        return vminfoData;
    }

    private static void setGpfsInfo(HostInfo hostInfo, Map<String, Object> result) {
        GpfsCluster gpfsCluster = new GpfsCluster();
        JsonObject resultMap = new JSONObject(result.get("gpfs_info").toString()).getMembers();
        gpfsCluster.setIp(HostDataHandleService.safeGetString(resultMap, "host_ip"));
        gpfsCluster.setClusterName(HostDataHandleService.safeGetString(resultMap, "cluster_name"));
        gpfsCluster.setClusterVersion(HostDataHandleService.safeGetString(resultMap, "cluster_version"));
        gpfsCluster.setClusterTiebreakerDisks(HostDataHandleService.safeGetString(resultMap, "cluster_tiebreaker"));
        gpfsCluster.setClusterRepositoryType(HostDataHandleService.safeGetString(resultMap, "cluster_repository"));
        JsonArray nodeDisks = HostDataHandleService.safeGetArray(resultMap, "node_disks");
        if (nodeDisks.size() > 0) {
            gpfsCluster.setGpfsDisks(HostDataHandleService.getGpfsDisks(nodeDisks));
        }
        if (hostInfo instanceof LinuxHost) {
            ((LinuxHost)hostInfo).setGpfsCluster(gpfsCluster);
        }
        if (hostInfo instanceof AixHost) {
            ((AixHost)hostInfo).setGpfsCluster(gpfsCluster);
        }
    }

    private static List<GpfsDisk> getGpfsDisks(JsonArray nodeDisks) {
        return IntStream.range(0, nodeDisks.size()).mapToObj(arg_0 -> ((JsonArray)nodeDisks).get(arg_0)).map(HostDataHandleService::getGpfsDisk).collect(Collectors.toList());
    }

    private static GpfsDisk getGpfsDisk(JsonElement jsonElement) {
        GpfsDisk gpfsDisk = new GpfsDisk();
        JsonObject diskGroupJson = jsonElement.getAsJsonObject();
        gpfsDisk.setNodeName(HostDataHandleService.safeGetString(diskGroupJson, "node_name"));
        gpfsDisk.setNodeState(HostDataHandleService.safeGetString(diskGroupJson, "node_state"));
        gpfsDisk.setClusterDesignation(HostDataHandleService.safeGetString(diskGroupJson, "node_designation"));
        gpfsDisk.setClusterDiskName(HostDataHandleService.safeGetString(diskGroupJson, "disk_name"));
        gpfsDisk.setMultipathDiskName(HostDataHandleService.safeGetString(diskGroupJson, "multi_disk_name"));
        gpfsDisk.setClusterFileSystem(HostDataHandleService.safeGetString(diskGroupJson, "file_system"));
        gpfsDisk.setNsdServers(HostDataHandleService.safeGetString(diskGroupJson, "nsd"));
        return gpfsDisk;
    }

    private static void setSolarisVxVmInfo(HostInfo hostInfo, Map<String, Object> result) {
        SolarisVxVm solarisVxVm = new SolarisVxVm();
        JsonObject resultMap = new JSONObject(result.get("solaris_vxvm_info").toString()).getMembers();
        solarisVxVm.setIp(HostDataHandleService.safeGetString(resultMap, "host_ip"));
        solarisVxVm.setVxVmDiskGroups(HostDataHandleService.getVxvmDiskGroups(HostDataHandleService.safeGetArray(resultMap, "dg_list")));
        ((SolarisHost)hostInfo).setSolarisVxVm(solarisVxVm);
    }

    private static List<VxVmDiskGroup> getVxvmDiskGroups(JsonArray diskGroups) {
        ArrayList<VxVmDiskGroup> vxVmDiskGroups = new ArrayList<VxVmDiskGroup>();
        for (JsonElement diskGroup : diskGroups) {
            VxVmDiskGroup vxVmDiskGroup = new VxVmDiskGroup();
            JsonObject diskGroupJson = diskGroup.getAsJsonObject();
            vxVmDiskGroup.setDiskGroupName(HostDataHandleService.safeGetString(diskGroupJson, "dg_name"));
            vxVmDiskGroup.setVxVmVolumes(HostDataHandleService.getVxVmVolumes(HostDataHandleService.safeGetArray(diskGroupJson, "vls")));
            vxVmDiskGroup.setVxVmDisks(HostDataHandleService.getVxVmDisks(HostDataHandleService.safeGetArray(diskGroupJson, "disks")));
            vxVmDiskGroups.add(vxVmDiskGroup);
        }
        return vxVmDiskGroups;
    }

    private static List<VxVmDisk> getVxVmDisks(JsonArray vxVmDisksArr) {
        ArrayList<VxVmDisk> vxVmDisks = new ArrayList<VxVmDisk>();
        for (JsonElement disk : vxVmDisksArr) {
            VxVmDisk vxVmDisk = new VxVmDisk();
            JsonObject diskJson = disk.getAsJsonObject();
            vxVmDisk.setDiskName(HostDataHandleService.safeGetString(diskJson, "disk_name"));
            vxVmDisk.setDeviceName(HostDataHandleService.safeGetString(diskJson, "device_name"));
            vxVmDisks.add(vxVmDisk);
        }
        return vxVmDisks;
    }

    private static List<VxVmVolume> getVxVmVolumes(JsonArray vxVmVolumeArr) {
        ArrayList<VxVmVolume> vxVmVolumes = new ArrayList<VxVmVolume>();
        for (JsonElement volume : vxVmVolumeArr) {
            VxVmVolume vxVmVolume = new VxVmVolume();
            JsonObject volumeJson = volume.getAsJsonObject();
            vxVmVolume.setVolumeName(HostDataHandleService.safeGetString(volumeJson, "volume_name"));
            vxVmVolume.setMountPoint(HostDataHandleService.safeGetString(volumeJson, "mount_point"));
            vxVmVolume.setTotalSize(HostDataHandleService.safeGetString(volumeJson, "volume_size"));
            vxVmVolume.setVxVmPlexes(HostDataHandleService.getVxVmPlexes(HostDataHandleService.safeGetArray(volumeJson, "pls")));
            vxVmVolumes.add(vxVmVolume);
        }
        return vxVmVolumes;
    }

    private static List<VxVmPlex> getVxVmPlexes(JsonArray vxVmPlexeArr) {
        ArrayList<VxVmPlex> vxVmPlexes = new ArrayList<VxVmPlex>();
        for (JsonElement plexe : vxVmPlexeArr) {
            VxVmPlex vxVmPlex = new VxVmPlex();
            JsonObject plexeJson = plexe.getAsJsonObject();
            vxVmPlex.setPlexName(HostDataHandleService.safeGetString(plexeJson, "pl_name"));
            vxVmPlex.setSubDisks((List)GSON.fromJson((JsonElement)HostDataHandleService.safeGetArray(plexeJson, "sds"), LIST_STRING_TYPE));
            vxVmPlexes.add(vxVmPlex);
        }
        return vxVmPlexes;
    }

    private static void setSolarisVcsInfo(HostInfo hostInfo, Map<String, Object> result) {
        SolarisVcs solarisVcs = new SolarisVcs();
        JsonObject resultMap = new JSONObject(result.get("solaris_vcs_info").toString()).getMembers();
        solarisVcs.setIp(HostDataHandleService.safeGetString(resultMap, "host_ip"));
        solarisVcs.setClusterVersion(HostDataHandleService.safeGetString(resultMap, "cluster_version"));
        solarisVcs.setClusterVote(HostDataHandleService.safeGetString(resultMap, "cluster_vote"));
        solarisVcs.setClusterMultiPath(HostDataHandleService.safeGetString(resultMap, "cluster_multipath"));
        solarisVcs.setFencingMode(HostDataHandleService.safeGetString(resultMap, "fencing_mode"));
        solarisVcs.setVcsNodes(HostDataHandleService.getSolarisVcsNodes(resultMap));
        ((SolarisHost)hostInfo).setSolarisVcs(solarisVcs);
    }

    private static List<VcsNode> getSolarisVcsNodes(JsonObject resultMap) {
        ArrayList<VcsNode> vcsNodes = new ArrayList<VcsNode>();
        JsonArray nodesName = HostDataHandleService.safeGetArray(resultMap, "cluster_member");
        JsonArray nodesStatus = HostDataHandleService.safeGetArray(resultMap, "node_status");
        JsonArray nodesGroup = HostDataHandleService.safeGetArray(resultMap, "cluster_group");
        JsonArray nodesGroupState = HostDataHandleService.safeGetArray(resultMap, "group_state");
        JsonArray nodesDgName = HostDataHandleService.safeGetArray(resultMap, "dg_name");
        for (int index = 0; index < nodesName.size(); ++index) {
            VcsNode vcsNode = new VcsNode();
            vcsNode.setNodeName(nodesName.get(index).getAsString());
            vcsNode.setNodeStatus(nodesStatus.get(index).getAsString());
            vcsNode.setNodeGroup(nodesGroup.get(index).getAsString());
            vcsNode.setGroupState(nodesGroupState.get(index).getAsString());
            vcsNode.setDgName(nodesDgName.get(index).getAsString());
            vcsNodes.add(vcsNode);
        }
        return vcsNodes;
    }

    private static void setSolarisLVMInfo(HostInfo hostInfo, Map<String, Object> resultMap) {
        SolarisLvm solarisLvm = new SolarisLvm();
        JsonObject lvmMap = new JSONObject(resultMap.get("solaris_lvm_info").toString()).getMembers();
        solarisLvm.setIp(HostDataHandleService.safeGetString(lvmMap, "host_ip"));
        JsonArray diskArr = HostDataHandleService.safeGetArray(lvmMap, "lvm_list");
        ArrayList<SolarisLvmDisk> solarisLvmDisks = new ArrayList<SolarisLvmDisk>();
        for (JsonElement disk : diskArr) {
            SolarisLvmDisk solarisLvmDisk = new SolarisLvmDisk();
            JsonObject diskMap = disk.getAsJsonObject();
            solarisLvmDisk.setLvmType(HostDataHandleService.safeGetString(diskMap, "lvm_type"));
            solarisLvmDisk.setPoolName(HostDataHandleService.safeGetString(diskMap, "pool_name"));
            solarisLvmDisk.setVolumeName(HostDataHandleService.safeGetString(diskMap, "volume_name"));
            solarisLvmDisk.setDiskName(HostDataHandleService.safeGetString(diskMap, "disk_name"));
            solarisLvmDisk.setFilesystem(HostDataHandleService.safeGetString(diskMap, "filesystem"));
            solarisLvmDisk.setTotalSize(HostDataHandleService.safeGetString(diskMap, "total_size"));
            solarisLvmDisk.setUsedSize(HostDataHandleService.safeGetString(diskMap, "used_size"));
            solarisLvmDisk.setMountPoint(HostDataHandleService.safeGetString(diskMap, "fs_mount_point"));
            solarisLvmDisks.add(solarisLvmDisk);
        }
        solarisLvm.setSolarisLvmDisks(solarisLvmDisks);
        ((SolarisHost)hostInfo).setSolarisLvm(solarisLvm);
    }

    private static void setHostVolume(HostInfo hostInfo, Map<String, Object> resultMap, String hostType) {
        HostVolume hostVolume = new HostVolume();
        JsonObject lvmMap = new JSONObject(resultMap.get("lvm_info").toString()).getMembers();
        hostVolume.setIp(HostDataHandleService.safeGetString(lvmMap, "host_ip"));
        if (hostType.equals("Linux")) {
            hostVolume.setLvmConf(HostDataHandleService.safeGetString(lvmMap, "lvm_conf"));
        }
        JsonArray vgInfos = HostDataHandleService.safeGetArray(lvmMap, "vg_info_list");
        ArrayList<HostVG> hostVGS = new ArrayList<HostVG>();
        for (JsonElement vgInfo : vgInfos) {
            JsonObject infoMap = vgInfo.getAsJsonObject();
            HostVG hostVG = new HostVG();
            ArrayList<LvmFsFstab> lvmFsFstabs = new ArrayList<LvmFsFstab>();
            hostVG.setVgName(HostDataHandleService.safeGetString(infoMap, "vg_name"));
            hostVG.setVgSize(HostDataHandleService.safeGetString(infoMap, "vg_size"));
            hostVG.setVgMajorNumber(HostDataHandleService.safeGetString(infoMap, "vg_major_number"));
            if (hostType.equals("AIX") || hostType.equals("HP-UX")) {
                hostVG.setVgState(HostDataHandleService.safeGetString(infoMap, "vg_state"));
            }
            hostVG.setPvs(HostDataHandleService.getPvs(HostDataHandleService.safeGetArray(infoMap, "pvs")));
            JsonArray lvms = HostDataHandleService.safeGetArray(infoMap, "lvs");
            for (JsonElement lvm : lvms) {
                infoMap = lvm.getAsJsonObject();
                lvmFsFstabs.add(HostDataHandleService.getLvmFsFstab(infoMap, hostType));
            }
            hostVG.setLvmFsFstabs(lvmFsFstabs);
            hostVGS.add(hostVG);
        }
        hostVolume.setHostVGS(hostVGS);
        hostInfo.setHostVolume(hostVolume);
    }

    private static List<PvInfo> getPvs(JsonArray pvs) {
        return IntStream.range(0, pvs.size()).mapToObj(index -> HostDataHandleService.getPvInfo(pvs.get(index))).collect(Collectors.toList());
    }

    private static PvInfo getPvInfo(JsonElement pvInfoJson) {
        JsonObject infoMap = pvInfoJson.getAsJsonObject();
        return new PvInfo(HostDataHandleService.safeGetString(infoMap, "pv_name"), HostDataHandleService.safeGetString(infoMap, "pv_size"), HostDataHandleService.safeGetString(infoMap, "pv_pvid"));
    }

    private static LvmFsFstab getLvmFsFstab(JsonObject infoMap, String hostType) {
        LvmFsFstab lvmFsFstab = new LvmFsFstab();
        lvmFsFstab.setLvName(HostDataHandleService.safeGetString(infoMap, "lv_name"));
        lvmFsFstab.setLvSize(HostDataHandleService.safeGetString(infoMap, "lv_size"));
        lvmFsFstab.setFsFileSystem(HostDataHandleService.safeGetString(infoMap, "filesystem"));
        lvmFsFstab.setFsTotalSize(HostDataHandleService.safeGetString(infoMap, "fs_total_size"));
        lvmFsFstab.setFsUsedSize(HostDataHandleService.safeGetString(infoMap, "fs_used_size"));
        lvmFsFstab.setFsMountPoint(HostDataHandleService.safeGetString(infoMap, "fs_mount_point"));
        lvmFsFstab.setDiscard(HostDataHandleService.safeGetString(infoMap, "discard"));
        if (hostType.equals("Linux")) {
            lvmFsFstab.setFsType(HostDataHandleService.safeGetString(infoMap, "fs_type"));
            lvmFsFstab.setFstabFileSystem(HostDataHandleService.safeGetString(infoMap, "fstab_filesystem"));
            lvmFsFstab.setFstabMountPoint(HostDataHandleService.safeGetString(infoMap, "fstab_mount_point"));
            lvmFsFstab.setFstabType(HostDataHandleService.safeGetString(infoMap, "fstab_fs_type"));
        } else if (hostType.equals("AIX") || hostType.equals("HP-UX")) {
            lvmFsFstab.setLvState(HostDataHandleService.safeGetString(infoMap, "lv_state"));
        }
        return lvmFsFstab;
    }

    private static void setOverview(HostInfo hostInfo, Map<String, Object> resultMap) {
        OverView overView = new OverView();
        JsonObject overviewMap = new JSONObject(resultMap.get("overview_info").toString()).getMembers();
        overView.setIp(HostDataHandleService.safeGetString(overviewMap, "host_ip"));
        overView.setHostName(HostDataHandleService.safeGetString(overviewMap, "host_name"));
        overView.setOsVersion(HostDataHandleService.safeGetString(overviewMap, "os_version"));
        overView.setHbaType(HostDataHandleService.safeGetString(overviewMap, "hba_type"));
        overView.setHbaWwn(HostDataHandleService.safeGetString(overviewMap, "hba_wwn_list"));
        overView.setMultiType(HostDataHandleService.safeGetString(overviewMap, "multi_type"));
        overView.setMultiVersion(HostDataHandleService.safeGetString(overviewMap, "multi_version"));
        overView.setClusterName(HostDataHandleService.safeGetString(overviewMap, "cluster_name"));
        overView.setClusterIps((List)GSON.fromJson((JsonElement)HostDataHandleService.safeGetArray(overviewMap, "cluster_ips"), LIST_STRING_TYPE));
        overView.setClusterVersion(HostDataHandleService.safeGetString(overviewMap, "cluster_version"));
        overView.setLvmType(HostDataHandleService.safeGetString(overviewMap, "lvm_type"));
        overView.setDbName(HostDataHandleService.safeGetString(overviewMap, "db_name"));
        overView.setDbVersion(HostDataHandleService.safeGetString(overviewMap, "db_version"));
        overView.setDiskUse(HostDataHandleService.safeGetString(overviewMap, "disk_use"));
        overView.setRealIp(HostDataHandleService.safeGetString(overviewMap, "real_ip"));
        overView.setInfoGrabVersion(GrabUtil.getToolVersion().trim());
        overView.setMultiPathStatus(HostDataHandleService.safeGetString(overviewMap, "multi_path_status"));
        overView.setHbaDetail(HostDataHandleService.safeGetString(overviewMap, "hba_detail"));
        hostInfo.setOverView(overView);
    }

    private static void setServiceGuard(HostInfo hostInfo, Map<String, Object> resultMap) {
        ServiceGuard serviceGuard = new ServiceGuard();
        JsonObject guardMap = new JSONObject(resultMap.get("serviceguard_info").toString()).getMembers();
        serviceGuard.setIp(HostDataHandleService.safeGetString(guardMap, "host_ip"));
        serviceGuard.setClusterName(HostDataHandleService.safeGetString(guardMap, "cluster_name"));
        serviceGuard.setClusterVersion(HostDataHandleService.safeGetString(guardMap, "cluster_version"));
        serviceGuard.setClusterStatus(HostDataHandleService.safeGetString(guardMap, "cluster_status"));
        JsonArray nodesArr = HostDataHandleService.safeGetArray(guardMap, "nodes");
        ArrayList<ServiceGuardNode> serviceGuardNodes = new ArrayList<ServiceGuardNode>();
        for (JsonElement oneNode : nodesArr) {
            JsonObject nodeMap = oneNode.getAsJsonObject();
            ServiceGuardNode serviceGuardNode = new ServiceGuardNode();
            serviceGuardNode.setNodeName(HostDataHandleService.safeGetString(nodeMap, "node_name"));
            serviceGuardNode.setLockVolumeGroup(HostDataHandleService.safeGetString(nodeMap, "lock_vg"));
            serviceGuardNode.setLockPhysicalDisk(HostDataHandleService.safeGetString(nodeMap, "lock_disk"));
            serviceGuardNode.setLockStatus(HostDataHandleService.safeGetString(nodeMap, "lock_status"));
            serviceGuardNode.setPackageName(HostDataHandleService.safeGetString(nodeMap, "package_name"));
            serviceGuardNode.setPackageNode(HostDataHandleService.safeGetString(nodeMap, "package_node"));
            serviceGuardNode.setPackageState(HostDataHandleService.safeGetString(nodeMap, "package_state"));
            serviceGuardNode.setPackageStatus(HostDataHandleService.safeGetString(nodeMap, "package_status"));
            serviceGuardNodes.add(serviceGuardNode);
        }
        serviceGuard.setNodes(serviceGuardNodes);
        ((HpuxHost)hostInfo).setServiceGuard(serviceGuard);
    }

    private static void setPowerVM(HostInfo hostInfo, Map<String, Object> resultMap) {
        PowerVm powerVm = new PowerVm();
        JsonObject powerVmMap = new JSONObject(resultMap.get("power_vm_info").toString()).getMembers();
        powerVm.setIp(HostDataHandleService.safeGetString(powerVmMap, "host_ip"));
        powerVm.setVersion(HostDataHandleService.safeGetString(powerVmMap, "vm_version"));
        JsonArray viocArr = HostDataHandleService.safeGetArray(powerVmMap, "vioc_list");
        ArrayList<Vioc> viocs = new ArrayList<Vioc>();
        for (JsonElement oneVioc : viocArr) {
            JsonObject viocMap = oneVioc.getAsJsonObject();
            Vioc vioc = new Vioc();
            vioc.setViocId(HostDataHandleService.safeGetString(viocMap, "vioc_id"));
            vioc.setScsiSa(HostDataHandleService.safeGetString(viocMap, "scsi_sa"));
            vioc.setScsiVtd(HostDataHandleService.safeGetString(viocMap, "scsi_vtd"));
            vioc.setScsiBackDevice(HostDataHandleService.safeGetString(viocMap, "scsi_bd"));
            vioc.setFcSa(HostDataHandleService.safeGetString(viocMap, "fc_sa"));
            vioc.setFcStatus(HostDataHandleService.safeGetString(viocMap, "fc_status"));
            vioc.setFcName(HostDataHandleService.safeGetString(viocMap, "fc_name"));
            viocs.add(vioc);
        }
        powerVm.setViocs(viocs);
        ((AixHost)hostInfo).setPowerVm(powerVm);
    }

    private static void setPowerHA(HostInfo hostInfo, Map<String, Object> resultMap) {
        PowerHA powerHA = new PowerHA();
        JsonObject powerHaMap = new JSONObject(resultMap.get("power_ha_info").toString()).getMembers();
        powerHA.setIp(HostDataHandleService.safeGetString(powerHaMap, "host_ip"));
        powerHA.setClusterName(HostDataHandleService.safeGetString(powerHaMap, "cluster_name"));
        powerHA.setClusterVersion(HostDataHandleService.safeGetString(powerHaMap, "cluster_version"));
        powerHA.setRepositoryDisk(HostDataHandleService.safeGetString(powerHaMap, "repository_disk"));
        powerHA.setHeartbeatDisk(HostDataHandleService.safeGetString(powerHaMap, "heartbeat_disk"));
        JsonArray nodesArr = HostDataHandleService.safeGetArray(powerHaMap, "nodes");
        ArrayList<PowerNode> powerNodes = new ArrayList<PowerNode>();
        for (JsonElement oneNode : nodesArr) {
            JsonObject nodeMap = oneNode.getAsJsonObject();
            PowerNode powerNode = new PowerNode();
            powerNode.setNodeName(HostDataHandleService.safeGetString(nodeMap, "node_name"));
            powerNode.setNodeGroup(HostDataHandleService.safeGetString(nodeMap, "node_group"));
            powerNode.setNodeVg(HostDataHandleService.safeGetString(nodeMap, "node_vg"));
            powerNodes.add(powerNode);
        }
        powerHA.setPowerNodes(powerNodes);
        ((AixHost)hostInfo).setPowerHA(powerHA);
    }

    private static void setHostOracle(HostInfo hostInfo, Map<String, Object> resultMap, String hostType) {
        HostOracle hostOracle = new HostOracle();
        JsonObject oracleMap = new JSONObject(resultMap.get("oracle_info").toString()).getMembers();
        hostOracle.setIp(HostDataHandleService.safeGetString(oracleMap, "host_ip"));
        hostOracle.setVersion(HostDataHandleService.safeGetString(oracleMap, "oracle_version"));
        if (hostType.equals("Linux")) {
            hostOracle.setAsmScanorder(HostDataHandleService.safeGetString(oracleMap, "oracleasm_scanorder"));
            hostOracle.setAsmScanexclude(HostDataHandleService.safeGetString(oracleMap, "oracleasm_scanexclude"));
            hostOracle.setDiskRule(HostDataHandleService.safeGetString(oracleMap, "disk_rule"));
        }
        hostOracle.setDiskStringValue(HostDataHandleService.safeGetString(oracleMap, "asm_diskstring_value"));
        JsonArray disks = HostDataHandleService.safeGetArray(oracleMap, "disk_list");
        ArrayList<OracleDisk> oracleDisks = new ArrayList<OracleDisk>();
        for (JsonElement jsonElement : disks) {
            JsonObject diskMap = jsonElement.getAsJsonObject();
            OracleDisk oracleDisk = new OracleDisk();
            oracleDisk.setDiskName(HostDataHandleService.safeGetString(diskMap, "asmdisk_name"));
            oracleDisk.setDiskPath(HostDataHandleService.safeGetString(diskMap, "asmdisk_path"));
            oracleDisk.setDiskState(HostDataHandleService.safeGetString(diskMap, "asmdisk_state"));
            oracleDisk.setDiskTotalSize(HostDataHandleService.safeGetString(diskMap, "asmdisk_total_size"));
            oracleDisk.setDiskFreeSize(HostDataHandleService.safeGetString(diskMap, "asmdisk_free_size"));
            oracleDisk.setDiskSectorSize(HostDataHandleService.safeGetString(diskMap, "asmdisk_sector_size"));
            oracleDisk.setUser(HostDataHandleService.safeGetString(diskMap, "user"));
            oracleDisk.setGroup(HostDataHandleService.safeGetString(diskMap, "group"));
            if ("Linux".equals(hostType) || "Solaris".equals(hostType)) {
                oracleDisk.setLunWwn(HostDataHandleService.safeGetString(diskMap, "lun_wwn"));
            } else if (hostType.equals("AIX")) {
                oracleDisk.setAixDiskName(HostDataHandleService.safeGetString(diskMap, "disk_name"));
                oracleDisk.setPermission(HostDataHandleService.safeGetString(diskMap, "permission"));
                oracleDisk.setMajor(HostDataHandleService.safeGetString(diskMap, "major"));
                oracleDisk.setMinor(HostDataHandleService.safeGetString(diskMap, "minor"));
            }
            oracleDisks.add(oracleDisk);
        }
        hostOracle.setOracleDisks(oracleDisks);
        hostInfo.setHostOracle(hostOracle);
    }

    private static void setVmInfo(HostInfo hostInfo, Map<String, Object> resultMap) {
        VmInfo vmInfo = new VmInfo();
        JsonObject vmMap = new JSONObject(resultMap.get("vm_info").toString()).getMembers();
        String ip = HostDataHandleService.safeGetString(vmMap, "host_ip");
        vmInfo.setIp(ip);
        JsonArray virtualHostArr = HostDataHandleService.safeGetArray(vmMap, "vm_list");
        ArrayList<VirtualHost> vMwareHosts = new ArrayList<VirtualHost>();
        for (JsonElement jsonElement : virtualHostArr) {
            JsonObject oneVirtualHost = jsonElement.getAsJsonObject();
            VirtualHost virtualHost = new VirtualHost();
            ArrayList<VmControllerDisk> vmControllerDisks = new ArrayList<VmControllerDisk>();
            virtualHost.setVmId(HostDataHandleService.safeGetString(oneVirtualHost, "vm_id"));
            virtualHost.setVmState(HostDataHandleService.safeGetString(oneVirtualHost, "vm_state"));
            virtualHost.setVmName(HostDataHandleService.safeGetString(oneVirtualHost, "vm_name"));
            virtualHost.setVmFile(HostDataHandleService.safeGetString(oneVirtualHost, "vm_file"));
            virtualHost.setVmOsType(HostDataHandleService.safeGetString(oneVirtualHost, "vm_os_type"));
            JsonArray controllerDiskArr = HostDataHandleService.safeGetArray(oneVirtualHost, "controller_disk_list");
            for (JsonElement cdElement : controllerDiskArr) {
                JsonObject oneControllerDisk = cdElement.getAsJsonObject();
                VmControllerDisk vmControllerDisk = new VmControllerDisk();
                vmControllerDisk.setDiskId(HostDataHandleService.safeGetString(oneControllerDisk, "disk_id"));
                vmControllerDisk.setDiskLabel(HostDataHandleService.safeGetString(oneControllerDisk, "disk_label"));
                vmControllerDisk.setDiskSize(HostDataHandleService.safeGetString(oneControllerDisk, "disk_size"));
                vmControllerDisk.setDiskPath(HostDataHandleService.safeGetString(oneControllerDisk, "disk_path"));
                vmControllerDisk.setUnitNumber(HostDataHandleService.safeGetString(oneControllerDisk, "unit_number"));
                vmControllerDisk.setRaw(HostDataHandleService.safeGetString(oneControllerDisk, "raw"));
                vmControllerDisk.setCompatitbilityMode(HostDataHandleService.safeGetString(oneControllerDisk, "compatibility_mode"));
                vmControllerDisk.setRawLunId(HostDataHandleService.safeGetString(oneControllerDisk, "raw_lun_id"));
                vmControllerDisk.setControllerId(HostDataHandleService.safeGetString(oneControllerDisk, "controller_id"));
                vmControllerDisk.setControllerLable(HostDataHandleService.safeGetString(oneControllerDisk, "controller_lable"));
                vmControllerDisk.setControllerType(HostDataHandleService.safeGetString(oneControllerDisk, "controller_type"));
                vmControllerDisk.setControllerShareBus(HostDataHandleService.safeGetString(oneControllerDisk, "controller_share_bus"));
                vmControllerDisks.add(vmControllerDisk);
            }
            virtualHost.setVmControllerDisks(vmControllerDisks);
            vMwareHosts.add(virtualHost);
        }
        vmInfo.setVirtualHosts(vMwareHosts);
        ((VMwareHost)hostInfo).setVmInfo(vmInfo);
    }

    private static void setVmMultipath(HostInfo hostInfo, Map<String, Object> resultMap) {
        JsonObject multiMap = new JSONObject(resultMap.get("vm_multipath_info").toString()).getMembers();
        String ip = HostDataHandleService.safeGetString(multiMap, "host_ip");
        JsonArray multipathArr = HostDataHandleService.safeGetArray(multiMap, "multipaths");
        ((VMwareHost)hostInfo).setVmMultipaths(HostDataHandleService.getVmwareMultipaths(ip, multipathArr));
    }

    private static List<VmMultipath> getVmwareMultipaths(String ip, JsonArray multipathArr) {
        return IntStream.range(0, multipathArr.size()).mapToObj(index -> HostDataHandleService.getOneVmwareMultipath(ip, multipathArr.get(index))).collect(Collectors.toList());
    }

    private static VmMultipath getOneVmwareMultipath(String ip, JsonElement jsonElement) {
        JsonObject oneMulti = jsonElement.getAsJsonObject();
        VmMultipath vmMultipath = new VmMultipath();
        vmMultipath.setIp(ip);
        vmMultipath.setType(HostDataHandleService.safeGetString(oneMulti, "multipath_type"));
        vmMultipath.setVersion(HostDataHandleService.safeGetString(oneMulti, "version"));
        JsonArray diskArr = HostDataHandleService.safeGetArray(oneMulti, "disk_list");
        vmMultipath.setVmMultiDisks(HostDataHandleService.getVmwareMultiDisks(diskArr));
        return vmMultipath;
    }

    private static List<VmMultiDisk> getVmwareMultiDisks(JsonArray diskArr) {
        return IntStream.range(0, diskArr.size()).mapToObj(index -> HostDataHandleService.getOneVmwareMultiDisk(diskArr.get(index))).collect(Collectors.toList());
    }

    private static VmMultiDisk getOneVmwareMultiDisk(JsonElement jsonElement) {
        VmMultiDisk vmMultiDisk = new VmMultiDisk();
        JsonObject oneDisk = jsonElement.getAsJsonObject();
        vmMultiDisk.setDatastoreName(HostDataHandleService.safeGetString(oneDisk, "datastore_name"));
        vmMultiDisk.setDiskUseType(HostDataHandleService.safeGetString(oneDisk, "datastore_type"));
        vmMultiDisk.setCompatibilityMode(HostDataHandleService.safeGetString(oneDisk, "compatibility_mode"));
        vmMultiDisk.setLunSize(HostDataHandleService.safeGetString(oneDisk, "lun_size"));
        vmMultiDisk.setLunWwn(HostDataHandleService.safeGetString(oneDisk, "lun_wwn"));
        vmMultiDisk.setHostLunId(HostDataHandleService.safeGetString(oneDisk, "host_lun_id"));
        vmMultiDisk.setVaaiStatus(HostDataHandleService.safeGetString(oneDisk, "vaai_status"));
        vmMultiDisk.setVaaiPluginName(HostDataHandleService.safeGetString(oneDisk, "vaai_plugin_name"));
        vmMultiDisk.setStorageArrayType(HostDataHandleService.safeGetString(oneDisk, "storage_array_type"));
        vmMultiDisk.setPathPolicy(HostDataHandleService.safeGetString(oneDisk, "path_policy"));
        vmMultiDisk.setBootDevice(HostDataHandleService.safeGetString(oneDisk, "boot_device"));
        vmMultiDisk.setVendor(HostDataHandleService.safeGetString(oneDisk, "vendor"));
        vmMultiDisk.setProduct(HostDataHandleService.safeGetString(oneDisk, "product"));
        vmMultiDisk.setReservationKey(HostDataHandleService.safeGetString(oneDisk, "reservation_key"));
        return vmMultiDisk;
    }

    private static void setOsInfo(HostInfo hostInfo, Map<String, Object> resultMap) {
        HostOs hostOs = new HostOs();
        JsonObject osMap = new JSONObject(resultMap.get("os_info").toString()).getMembers();
        hostOs.setIp(HostDataHandleService.safeGetString(osMap, "host_ip"));
        hostOs.setType(HostDataHandleService.safeGetString(osMap, "os_type"));
        hostOs.setVersion(HostDataHandleService.safeGetString(osMap, "os_version"));
        hostOs.setIsSanBoot(HostDataHandleService.safeGetString(osMap, "is_san_boot"));
        hostInfo.setHostOs(hostOs);
    }

    private static String safeGetString(JsonObject jsonObject, String key) {
        if (jsonObject.has(key)) {
            return jsonObject.get(key).getAsString();
        }
        return "";
    }

    private static JsonArray safeGetArray(JsonObject jsonObject, String key) {
        if (jsonObject.has(key)) {
            return jsonObject.get(key).getAsJsonArray();
        }
        return new JsonArray();
    }

    private HostDataHandleService() {
    }
}

