/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.service;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.pubservice.common.IConnectionManage;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infograb.context.CollectStatusEnum;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.context.ItemResultEnum;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.Item;
import com.huawei.ism.tool.infograb.grab.GrabFlowAdapter;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabFileFactory;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.InfoGrabDirPropertiesUtil;
import com.huawei.ism.tool.infograb.periodgrab.ui.PeriodGrabTaskDetailContainer;
import com.huawei.ism.tool.infograb.service.GifAssistant;
import com.huawei.ism.tool.infograb.ui.RealTimeTaskDetailContainer;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public final class InfoGrabService {
    private static final InfoGrabService INSTANCE = new InfoGrabService();
    private GrabContext context = GrabContext.getInstance();
    private GifAssistant gifAssistant = GifAssistant.getInstance();
    private ReentrantLock lock = new ReentrantLock();

    private InfoGrabService() {
    }

    public static InfoGrabService getInstance() {
        return INSTANCE;
    }

    public Boolean isDevNodeCollecting(GrabDevNode2 devNode) {
        return this.findNodeStatus(devNode);
    }

    public boolean isAllDevNodeStoppped() {
        ConcurrentHashMap<GrabDevNode2, Boolean> currStatusMap = this.context.getNodeStatusMap();
        for (Map.Entry<GrabDevNode2, Boolean> entry : currStatusMap.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isSelectedNodesStopped(List<GrabDevNode2> devNodesList) {
        for (GrabDevNode2 devNode : devNodesList) {
            if (!this.isDevNodeCollecting(devNode).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isSelectedNodesDone(List<GrabDevNode2> devNodesList) {
        for (GrabDevNode2 devNode : devNodesList) {
            if (devNode.isCollectDone()) continue;
            return false;
        }
        return true;
    }

    public void copyItemDcnToAnother(GrabDevNode2 fromNode, GrabDevNode2 toNode) {
        ItDeviceType toItType;
        ItDeviceType fromItType = fromNode.getItDeviceType();
        if (fromItType.equals((Object)(toItType = toNode.getItDeviceType()))) {
            this.copyItemDecision(fromNode, toNode);
        }
    }

    private void copyItemDecision(GrabDevNode2 fromNode, GrabDevNode2 toNode) {
        GrabFlowAdapter currAdapter = GrabFlowAdapter.getInstance();
        List<Item> fromItems = currAdapter.getNodeGrabFlowMap().get((Object)fromNode);
        LinkedList<Item> toItems = new LinkedList<Item>();
        for (Item item : fromItems) {
            Item newItem = new Item();
            newItem.copyeItem(item);
            toItems.add(newItem);
        }
        currAdapter.getNodeGrabFlowMap().put(toNode, toItems);
        List<String> fromCategory = currAdapter.getNodeSelectedCategoryMap().get((Object)fromNode);
        LinkedList<String> toCategory = new LinkedList<String>();
        Iterator<String> iterator = fromCategory.iterator();
        while (iterator.hasNext()) {
            String category;
            String newCategory = category = iterator.next();
            toCategory.add(newCategory);
        }
        currAdapter.getNodeSelectedCategoryMap().put(toNode, toCategory);
    }

    public void changeNodeStatus(GrabDevNode2 devNode, Boolean flag) {
        this.context.getNodeStatusMap().put(devNode, flag);
    }

    public Boolean findNodeStatus(GrabDevNode2 devNode) {
        Boolean flag = this.context.getNodeStatusMap().get((Object)devNode);
        if (flag == null) {
            return Boolean.FALSE;
        }
        return flag;
    }

    public void setNodesRunning(List<GrabDevNode2> nodeList) {
        for (GrabDevNode2 node : nodeList) {
            this.context.getNodeStatusMap().put(node, Boolean.TRUE);
        }
    }

    public void setNodesStopped(GrabDevNode2 node) {
        this.context.getNodeStatusMap().put(node, Boolean.FALSE);
    }

    public List<GrabDevNode2> getAllDevNode() {
        List<DevNode> devs = EntityUtils.toNewDevList(DefaultNodeProviderImpl.getInstance().getNodeList());
        ArrayList<GrabDevNode2> grabDevs = new ArrayList<GrabDevNode2>();
        for (DevNode singleNode : devs) {
            grabDevs.add(ToolUtils.toGrabNewNode(singleNode));
        }
        return grabDevs;
    }

    public void startGifLoading() {
        this.gifAssistant.start();
    }

    public void stopGifLoading() {
        this.gifAssistant.stopGifLoading();
    }

    public boolean checkSameType(GrabDevNode2 baseNode, GrabDevNode2 compNode) {
        if (!baseNode.getItDeviceType().equals((Object)compNode.getItDeviceType())) {
            return false;
        }
        if (baseNode.getDevTypeLevel2() != null && compNode.getDevTypeLevel2() != null) {
            return baseNode.getDevTypeLevel2().equals((Object)compNode.getDevTypeLevel2());
        }
        return baseNode.getDevTypeLevel2() == null && compNode.getDevTypeLevel2() == null;
    }

    public IConnectionManage getCurrConnManager() {
        return this.context.getCurrInfoGrabFrame().getConnMng();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillOneResultByNode(GrabDevNode2 devNode, ExecuteResult currResult) {
        this.lock.lock();
        try {
            ConcurrentHashMap<GrabDevNode2, List<ExecuteResult>> executeResultMap = this.context.getExecuteResultMap();
            List resultList = (List)executeResultMap.get((Object)devNode);
            if (resultList == null) {
                LinkedList<ExecuteResult> newResultList = new LinkedList<ExecuteResult>();
                newResultList.add(currResult);
                executeResultMap.put(devNode, newResultList);
            } else {
                if (resultList.contains(currResult)) {
                    resultList.remove(currResult);
                }
                resultList.add(currResult);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillFailedReasonByNode(GrabDevNode2 devNode, String reason) {
        this.lock.lock();
        try {
            ConcurrentHashMap<GrabDevNode2, String> executeFailedReasonMap = this.context.getExecuteFailedReasonMap();
            executeFailedReasonMap.put(devNode, reason);
        }
        finally {
            this.lock.unlock();
        }
    }

    public ExecuteResult createFailedResult(GrabDevNode2 devNode) {
        ExecuteResult currExecuteResult = new ExecuteResult();
        currExecuteResult.setDevNode(devNode);
        currExecuteResult.setItemResultEnum(ItemResultEnum.FAILD);
        currExecuteResult.setNowStatus(CollectStatusEnum.COLLECT_FAILED);
        currExecuteResult.setProgress(-100);
        currExecuteResult.setCheckResult(ResourceUtil.getString((String)"infograb.failed"));
        return currExecuteResult;
    }

    public ExecuteResult createStartingResult(GrabDevNode2 devNode) {
        ExecuteResult currExecuteResult = new ExecuteResult();
        currExecuteResult.setDevNode(devNode);
        currExecuteResult.setNowStatus(CollectStatusEnum.WAIT_TOGO);
        currExecuteResult.setProgress(0);
        currExecuteResult.setCheckResult(ResourceUtil.getString((String)"infograb.readytogo"));
        return currExecuteResult;
    }

    public boolean preCheckResultFolder() {
        return GrabFileFactory.getInstance().preCheckResultFolder();
    }

    public boolean checkDiskCapactity(long capacty) {
        return GrabFileFactory.getInstance().checkDiskCapactity(capacty);
    }

    public String getSelectDevNodeReportDir() {
        if (GrabContext.getInstance().getCurrentTask() == null) {
            return "";
        }
        String fileNameHead = GrabContext.getInstance().getCurrentTask().getTask().getTaskDirName();
        String fileName = "";
        File[] files = new File(InfoGrabDirPropertiesUtil.getProperty()).listFiles();
        if (files == null) {
            return "";
        }
        for (File file : files) {
            if (file.getName().startsWith(fileNameHead)) {
                if (!file.isDirectory()) continue;
                fileName = file.getName();
                continue;
            }
            if (fileName.equals("")) continue;
            return fileName;
        }
        return fileName;
    }

    public void refreshStopStatus(GrabDevNode2 dev) {
        ((RealTimeTaskDetailContainer)GrabContext.getInstance().getCurrentTask().getTaskDetailContainer()).refreshStopStatus(dev);
    }

    public void refreshPeriodStopStatus(GrabDevNode2 dev) {
        ((PeriodGrabTaskDetailContainer)GrabContext.getInstance().getCurrentTask().getTaskDetailContainer()).refreshStopStatus(dev);
    }
}

