/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.service;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.enums.NodeAddEnum;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.grab.OfflineGrabService;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabFileFactory;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.InfoGrabDirPropertiesUtil;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.infograb.service.HostDataHandleService;
import com.huawei.ism.tool.infograb.utils.OfflineImportUtils;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.infograb.utils.migration.AnonymizeUtils;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.threadpool.ThreadPoolHelper;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import org.python.google.common.base.Strings;
import org.python.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfflineService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfflineService.class);
    private static final long SIZE_100MB = 0x6400000L;
    private static final long SIZE_5MB = 0x500000L;
    private JDialog moreFunctionDialog;
    private String taskName = "OfflineTask_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
    private ExecutorService grabExcutor = new ThreadPoolExecutor(20, 256, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private List<GrabDevNode2> devNodes;
    private JProgressBar progressBar;
    private ProgressDialog progressDialog;
    private final int MAX_GRAB_PROGRESS = 95;

    public OfflineService(JDialog moreFunctionDialog) {
        this.moreFunctionDialog = moreFunctionDialog;
    }

    public void doOffline() {
        List<File> offlineFiles = this.getOfflineFile();
        if (offlineFiles.isEmpty()) {
            OperationEnum.OFFLINE_CHOOSE_FILES.failLog("");
            return;
        }
        OperationEnum.OFFLINE_CHOOSE_FILES.successLog("");
        this.createDevNodes(offlineFiles);
        this.offlineGrab();
        this.startGrabProgress();
        this.checkGrabResult();
    }

    private void startGrabProgress() {
        this.initUi();
        Timer proGressTimer = this.getCheckProgressTimer();
        this.initProGressListener(proGressTimer);
        this.progressDialog.setVisible(true);
    }

    private void initProGressListener(Timer proGressTimer) {
        this.progressBar.addChangeListener(changeEvent -> {
            if (this.progressBar.getValue() == 100) {
                proGressTimer.cancel();
                this.progressDialog.dispose();
            }
        });
    }

    private Timer getCheckProgressTimer() {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                OfflineService.this.progressBar.setValue(OfflineService.this.getCurrentValue());
                if (OfflineService.this.devNodes.size() == OfflineService.this.getFinishNodes(OfflineService.this.devNodes)) {
                    OfflineService.this.summary2Xls(OfflineService.this.devNodes);
                    OfflineService.this.progressBar.setValue(100);
                }
            }
        }, 0L, 2000L);
        return timer;
    }

    private void initUi() {
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressDialog = new ProgressDialog((Window)this.moreFunctionDialog, ResourceUtil.getString((String)"infograb.morefunction.offline.parse"), 220, this.progressBar);
        this.progressBar.setValue(0);
    }

    private int getCurrentValue() {
        int presentProgress = this.progressBar.getValue();
        int finishNodesCount = this.getFinishNodes(this.devNodes);
        if (presentProgress >= 95 || presentProgress >= (finishNodesCount + 1) * 95 / this.devNodes.size()) {
            return presentProgress;
        }
        if (presentProgress < finishNodesCount * 95 / this.devNodes.size()) {
            return finishNodesCount * 95 / this.devNodes.size();
        }
        return ++presentProgress;
    }

    private int getFinishNodes(List<GrabDevNode2> devNodes) {
        return (int)devNodes.stream().filter(this::finishNode).count();
    }

    private boolean finishNode(GrabDevNode2 node) {
        return !Strings.isNullOrEmpty((String)node.getErrorDecs()) || node.isCollectDone();
    }

    private void summary2Xls(List<GrabDevNode2> devNodes) {
        List<GrabDevNode2> successNodes = devNodes.stream().filter(this::checkNode).collect(Collectors.toList());
        if (successNodes.size() > 0) {
            LOGGER.info("begin to summary host info to Xls.");
            String offlineXlsPath = GrabFileFactory.getInstance().getOfflineXlsPath(this.taskName);
            HostDataHandleService.summary2Xls(offlineXlsPath, successNodes);
            AnonymizeUtils.anonymizeData(successNodes, offlineXlsPath);
        }
    }

    public List<File> getOfflineFile() {
        List<String> supportTypes = Arrays.asList("data", "tgz", "tar.gz");
        String title = ResourceUtil.getString((String)"devicemanager.layout.device.offlineImport.fileChoose");
        List<File> importFiles = this.getFilesFromFileChooser(title, "offline_import_file", supportTypes);
        if (null == importFiles) {
            return Collections.emptyList();
        }
        List<File> finalFiles = this.checkFileSize(importFiles);
        if (!this.checkHdsUnzipCapacity(finalFiles)) {
            DialogUtils.showInfoDialog((JDialog)this.moreFunctionDialog, (String)ResourceUtil.getString((String)"devicemanager.layout.device.offlineImport.capacityWarn"));
            return Collections.emptyList();
        }
        if (!this.checkReportCapacity(finalFiles)) {
            DialogUtils.showInfoDialog((JDialog)this.moreFunctionDialog, (String)ResourceUtil.getString((String)"infograb.offline.reportcapactityfail"));
            return Collections.emptyList();
        }
        return finalFiles;
    }

    private List<File> checkFileSize(List<File> importFiles) {
        List invalidFileNames = importFiles.stream().filter(this::invalidFileSize).map(File::getName).collect(Collectors.toList());
        List<File> finalFiles = importFiles.stream().filter(file -> !this.invalidFileSize((File)file)).collect(Collectors.toList());
        if (!invalidFileNames.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this.moreFunctionDialog, (String)ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.offlineImport.bigFileWarn", (Object[])new Object[]{invalidFileNames}));
        }
        return finalFiles;
    }

    private boolean invalidFileSize(File file) {
        return file.length() == 0L || file.length() > 0x6400000L;
    }

    private boolean checkHdsUnzipCapacity(List<File> importFiles) {
        String dirName = importFiles.get(0).getParent();
        String diskPath = dirName.split(":")[0] + ":" + File.separator;
        long unzipSize = importFiles.stream().filter(this::isHdsDataFile).collect(Collectors.summingLong(File::length));
        return new File(diskPath).getFreeSpace() > unzipSize * 50L;
    }

    private boolean checkReportCapacity(List<File> importFiles) {
        String reportDir = InfoGrabDirPropertiesUtil.getProperty() + File.separator;
        return new File(reportDir).getFreeSpace() > (long)importFiles.size() * 0x500000L;
    }

    private boolean isHdsDataFile(File file) {
        return file.getName().toUpperCase(Locale.ENGLISH).endsWith(".TGZ");
    }

    private List<File> getFilesFromFileChooser(String title, String defaultPathId, List<String> fileTypes) {
        LinkedHashMap<String, String[]> multiFileTypeMap = new LinkedHashMap<String, String[]>();
        String[] fileTypeArr = (String[])fileTypes.toArray();
        String typeKey = fileTypes.stream().collect(Collectors.joining(";*.", "*.", ""));
        multiFileTypeMap.put(typeKey, fileTypeArr);
        return ToolFileChooser.selectFiles((Window)this.moreFunctionDialog, title, defaultPathId, 0, true, multiFileTypeMap);
    }

    private void createDevNodes(List<File> fileNames) {
        LOGGER.info("begin to create devNodes.");
        this.devNodes = fileNames.stream().map(this::generateDevnode).collect(Collectors.toList());
        LOGGER.info("begin to parse basic info.");
        this.parseBasicInfo(this.devNodes);
        this.checkRepeatDevNode(this.devNodes);
    }

    private void checkRepeatDevNode(List<GrabDevNode2> devNodes) {
        devNodes.stream().filter(this::noError).collect(Collectors.groupingBy(this::getIpSn)).entrySet().stream().filter(nodeGroup -> ((List)nodeGroup.getValue()).size() > 1).forEach(this::setErrorDesc4RepeatNode);
    }

    private String getIpSn(GrabDevNode2 node) {
        return node.getIp() + node.getDeviceSerialNumber();
    }

    private void setErrorDesc4RepeatNode(Map.Entry<String, List<GrabDevNode2>> devNodeGroup) {
        devNodeGroup.getValue().stream().skip(1L).forEach(devNode -> devNode.setErrorDecs(ResourceUtil.getStringWithParams((String)"infograb.morefunction.offline.deviceduplicate", (Object[])new Object[]{devNode.getIp(), devNode.getDeviceSerialNumber()})));
    }

    private GrabDevNode2 generateDevnode(File fileName) {
        GrabDevNode2 devNode = new GrabDevNode2();
        devNode.setNodeAddType(NodeAddEnum.OFFLINE_IMPORT);
        devNode.setDevInfoPkgPath(fileName.toString());
        String deviceName = this.parseDeviceName(devNode);
        if ("HDS".equalsIgnoreCase(deviceName) || "NetApp".equalsIgnoreCase(deviceName)) {
            return this.fullInfoNode(devNode, ItDeviceType.Storage, deviceName);
        }
        if (OfflineImportUtils.getSupportOfflineHostTypes().contains(deviceName)) {
            return this.fullInfoNode(devNode, ItDeviceType.Host, deviceName);
        }
        devNode.setErrorDecs(ResourceUtil.getString((String)"infograb.morefunction.offline.notsupport"));
        return devNode;
    }

    private GrabDevNode2 fullInfoNode(GrabDevNode2 devNode, ItDeviceType storage, String deviceName) {
        devNode.setItDeviceType(storage);
        devNode.setDeviceName(deviceName);
        devNode.setDevTypeLevel2(DeviceType.valueOf((String)deviceName));
        return devNode;
    }

    private void parseBasicInfo(List<GrabDevNode2> devNodes) {
        List<Callable<Boolean>> parseInfoBasicCalls = this.getParseInfoBasicCalls(devNodes);
        String custMizeMsg = ResourceUtil.getString((String)"infograb.morefunction.offline.verifyfile");
        this.excute(parseInfoBasicCalls, custMizeMsg);
    }

    private List<Callable<Boolean>> getParseInfoBasicCalls(List<GrabDevNode2> devNodes) {
        return devNodes.stream().filter(this::noError).map(this::getParseInfoBasicCall).collect(Collectors.toList());
    }

    private Callable<Boolean> getParseInfoBasicCall(GrabDevNode2 node) {
        return () -> new OfflineGrabService(node, this.taskName).parseBasicInfo();
    }

    private boolean noError(GrabDevNode2 node) {
        return Strings.isNullOrEmpty((String)node.getErrorDecs());
    }

    private boolean checkNode(GrabDevNode2 node) {
        return Strings.isNullOrEmpty((String)node.getErrorDecs()) && !Strings.isNullOrEmpty((String)node.getXmlFileName());
    }

    private void offlineGrab() {
        LOGGER.info("begin to grab node info.");
        this.getGrabCalls().forEach(grab -> this.grabExcutor.submit(grab));
    }

    private List<Callable<Boolean>> getGrabCalls() {
        return this.devNodes.stream().filter(this::noError).map(node -> this.getGrabCall((GrabDevNode2)((Object)node), this.taskName)).collect(Collectors.toList());
    }

    private Callable<Boolean> getGrabCall(GrabDevNode2 node, String taskName) {
        return () -> new OfflineGrabService(node, taskName).offlineGrab();
    }

    private void excute(List<Callable<Boolean>> calls, String custMizeMsg) {
        if (calls.size() < 1) {
            return;
        }
        JProgressBar parseProgressBar = new JProgressBar();
        parseProgressBar.setStringPainted(true);
        ThreadPoolHelper.executeWithCustomBar(this.moreFunctionDialog, parseProgressBar, custMizeMsg, calls);
    }

    private void checkGrabResult() {
        boolean allFail = this.showErrorMsg();
        if (allFail) {
            return;
        }
        this.openResultDir();
    }

    private void openResultDir() {
        WarningDialog wdialog = DialogUtils.showYesNoDialog((Window)this.moreFunctionDialog, (String)ResourceUtil.getString((String)"infograb.morefunction.offline.end"));
        if (0 == wdialog.getValue()) {
            String offlineTaskPath = GrabFileFactory.getInstance().getOfflineTaskPath(this.taskName).toString();
            ToolUtils.exeExportSelectFile(offlineTaskPath, false);
        }
    }

    private boolean showErrorMsg() {
        List failDataList = this.devNodes.stream().filter(devNode -> !Strings.isNullOrEmpty((String)devNode.getErrorDecs())).map(this::getFailData).collect(Collectors.toList());
        if (!failDataList.isEmpty()) {
            SubDialogUtils.showMultiInfoDialog((Window)this.moreFunctionDialog, (String)ResourceUtil.getString((String)"infograb.morefunction.offline.end.error"), (String[])new String[]{ResourceUtil.getString((String)"devicemanager.layout.device.offlineImport.errorTitle"), ResourceUtil.getString((String)"devicemanager.layout.device.offlineImport.errorReason")}, failDataList);
        }
        return failDataList.size() == this.devNodes.size();
    }

    private ArrayList<Object> getFailData(GrabDevNode2 devNode) {
        return Lists.newArrayList((Object[])new Object[]{this.getSourceFileName(devNode), devNode.getErrorDecs()});
    }

    private String getSourceFileName(GrabDevNode2 node) {
        String filePath = node.getDevInfoPkgPath();
        File file = new File(filePath);
        if (filePath.endsWith(".TGZ".toLowerCase(Locale.ENGLISH)) || filePath.endsWith("data".toLowerCase(Locale.ENGLISH)) || filePath.endsWith(".TAR.GZ".toLowerCase(Locale.ENGLISH))) {
            return file.getName();
        }
        File parentFile = file.getParentFile();
        return parentFile.getName() + ".TGZ".toLowerCase(Locale.ENGLISH);
    }

    private String parseDeviceName(GrabDevNode2 devNode) {
        String devInfoPkgPath = devNode.getDevInfoPkgPath();
        if (devInfoPkgPath.endsWith("data")) {
            return this.getHostDeviceName(devInfoPkgPath);
        }
        if (devInfoPkgPath.toUpperCase(Locale.ENGLISH).endsWith(".TAR.GZ")) {
            return "NetApp";
        }
        return "HDS";
    }

    private String getHostDeviceName(String devInfoPkgPath) {
        String nodeType;
        switch (nodeType = this.getNodeTypeFromFile(devInfoPkgPath).toLowerCase()) {
            case "linux": {
                return "Linux";
            }
            case "aix": {
                return "AIX";
            }
            case "hp-ux": {
                return "HP-UX";
            }
            case "solaris": {
                return "Solaris";
            }
            case "vmware": {
                return "VMware";
            }
            case "xenserver": {
                return "XenServer";
            }
            case "fusionsphere": {
                return "FusionSphere";
            }
            case "windows": {
                return "Windows";
            }
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getNodeTypeFromFile(String dataFilePath) {
        List<String> hostType = Arrays.asList("linux", "aix", "hp-ux", "solaris", "vmware");
        String windowsStartFlag = "StartCmd:wmic OS get Caption /value";
        try (FileReader fileReader = new FileReader(dataFilePath);
             BufferedReader reader = new BufferedReader(fileReader);){
            String tempLine;
            int lineIndex = 0;
            do {
                if ((tempLine = reader.readLine()) == null) return "";
                if (++lineIndex != 3 || !hostType.contains(tempLine.trim().toLowerCase(Locale.US))) continue;
                String string = tempLine.trim();
                return string;
            } while (!windowsStartFlag.equals(tempLine.trim()));
            String string = "windows";
            return string;
        }
        catch (IOException e) {
            LOGGER.error("fail to get host type!");
        }
        return "";
    }
}

