/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.service;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.service.XlsItem;
import com.huawei.ism.tool.infograb.service.XlsReader;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.slf4j.Logger;

public class XLSService {
    public static final String META_DATE_KEY_EN = ResourceUtil.getString((String)"infograb.excel.datafile.name", (Locale)Locale.ENGLISH);
    public static final String META_DATE_KEY_CN = ResourceUtil.getString((String)"infograb.excel.datafile.name", (Locale)Locale.CHINESE);
    public static final String META_TOOLVERSION_CN = ResourceUtil.getString((String)"infograb.excel.version.num", (Locale)Locale.CHINESE);
    public static final String META_TOOLVERSION_EN = ResourceUtil.getString((String)"infograb.excel.version.num", (Locale)Locale.ENGLISH);
    public static final int MAX_COUNT_A_CELL = Short.MAX_VALUE;
    private static final String NA = "na";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(XLSService.class);
    private static final String HOST_TEMPLATE_PATH = "/config/templatefile/Output_Model.xls";
    private static final Object XLS_SERVICE_LOCK = new Object();
    private static final int A_SEPERATE_INDEX = 1;
    private static Map<String, List<XlsItem>> xlsItems = new ConcurrentHashMap<String, List<XlsItem>>();
    private static XLSService instance = null;
    private static HSSFWorkbook writeWorkBook = new HSSFWorkbook();
    private static HSSFCellStyle titleStyle = XLSService.createCellStyle(writeWorkBook, "title");
    private static HSSFCellStyle style = XLSService.createCellStyle(writeWorkBook, "content");

    private XLSService() {
        this.initXlsItems();
    }

    private void initXlsItems() {
        try {
            if (xlsItems.isEmpty()) {
                xlsItems.putAll(this.getXlsGrabItems());
            }
        }
        catch (ToolException e) {
            LOGGER.error("ready template error.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XLSService getInstance() {
        Object object = XLS_SERVICE_LOCK;
        synchronized (object) {
            if (null == instance) {
                instance = new XLSService();
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<XlsItem> getXlsItems(String key) {
        Object object = XLS_SERVICE_LOCK;
        synchronized (object) {
            if (xlsItems.isEmpty()) {
                this.initXlsItems();
            }
            return xlsItems.get(key.toLowerCase(Locale.ENGLISH));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<XlsItem>> getXlsGrabItems() throws ToolException {
        InputStream inputStream = this.getXlsTemplateIs();
        POIFSFileSystem fs = null;
        HSSFWorkbook xlsTempWorkbook = null;
        try {
            fs = new POIFSFileSystem(inputStream);
            xlsTempWorkbook = new HSSFWorkbook(fs);
            HSSFSheet sheet = xlsTempWorkbook.getSheet("Model");
            if (!VerifyUtil.isEmpty((Object)sheet)) {
                Map<String, List<XlsItem>> map = this.readXlsTempItems(sheet);
                return map;
            }
        }
        catch (IOException e) {
            LOGGER.info("read model file error.");
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)inputStream);
            if (null != fs) {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    LOGGER.error("Close xls stream error.");
                }
            }
            if (null != xlsTempWorkbook) {
                try {
                    xlsTempWorkbook.close();
                }
                catch (IOException e) {
                    LOGGER.error("Close xls stream error.");
                }
            }
        }
        return null;
    }

    private Map<String, List<XlsItem>> readXlsTempItems(HSSFSheet modelSheet) {
        ConcurrentHashMap<String, List<XlsItem>> xlsItemsMap = new ConcurrentHashMap<String, List<XlsItem>>();
        int rowBegin = modelSheet.getFirstRowNum();
        int rowEnd = modelSheet.getLastRowNum();
        for (int i = rowBegin; i <= rowEnd && i < Integer.MAX_VALUE; i += 4) {
            HSSFCell typeCell = modelSheet.getRow(i).getCell(0);
            String modelDevType = typeCell.getStringCellValue();
            if ("".equalsIgnoreCase(modelDevType)) continue;
            LinkedList<XlsItem> itemList = new LinkedList<XlsItem>();
            HSSFRow keyRow = modelSheet.getRow(i);
            HSSFRow startLabelRow = modelSheet.getRow(i + 1);
            HSSFRow zhNameRow = modelSheet.getRow(i + 2);
            HSSFRow enNameRow = modelSheet.getRow(i + 3);
            short cellBegin = keyRow.getFirstCellNum();
            short cellEnd = keyRow.getLastCellNum();
            for (int k = cellBegin + 1; k < cellEnd; ++k) {
                itemList.add(new XlsItem(keyRow.getCell(k).getStringCellValue(), startLabelRow.getCell(k).getStringCellValue(), zhNameRow.getCell(k).getStringCellValue(), enNameRow.getCell(k).getStringCellValue()));
            }
            itemList.add(new XlsItem(NA, NA, META_DATE_KEY_CN, META_DATE_KEY_EN));
            itemList.add(new XlsItem("InfoGrabVersion", NA, META_TOOLVERSION_CN, META_TOOLVERSION_EN));
            xlsItemsMap.put(modelDevType, itemList);
        }
        LOGGER.info("init excel item complete.");
        return xlsItemsMap;
    }

    private InputStream getXlsTemplateIs() throws ToolException {
        InputStream inputStream = XLSService.class.getResourceAsStream(HOST_TEMPLATE_PATH);
        if (null == inputStream) {
            throw new ToolException("can't find the model excel file.");
        }
        return inputStream;
    }

    public boolean updateOneCellValue(String xlsFile, String headerEn, String HeaderZHCN, String value) {
        try {
            int updateIdx;
            List<String> header = XlsReader.getInstance().getXlsRow(xlsFile, 0);
            int idexOfMtDateEN = header.indexOf(META_DATE_KEY_EN);
            int idexOfMtDateCN = header.indexOf(META_DATE_KEY_CN);
            int n = updateIdx = idexOfMtDateEN > 0 ? idexOfMtDateEN : idexOfMtDateCN;
            if (updateIdx < 0) {
                return false;
            }
            XLSService.getInstance().updateOneCellValue(new File(xlsFile), updateIdx, value);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("update excel error.", (Throwable)e);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean updateOneCellValue(File xlsFile, int index, String value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveXlsReport(File saveFile, Map<String, String> xlsReportData, List<XlsItem> items, GrabDevNode2 dev) throws ToolException {
        String savePath = ToolUtils.getCanonicalFilePath(saveFile);
        if (null == (saveFile = ToolUtils.getCanonicalFile(savePath)) || saveFile.isDirectory()) {
            throw new ToolException("The savefile is a directory, not file.");
        }
        if (!saveFile.getParentFile().exists() && saveFile.getParentFile().mkdirs()) {
            throw new ToolException("create directory failed.");
        }
        LOGGER.info("begin to write data to excel.");
        OutputStream outputStream = null;
        HSSFWorkbook hSSFWorkbook = writeWorkBook;
        synchronized (hSSFWorkbook) {
            HashMap<String, String> overlengthInfo = new HashMap<String, String>();
            HSSFSheet sheet = writeWorkBook.getSheet("data");
            if (null == sheet) {
                sheet = writeWorkBook.createSheet("data");
            }
            this.saveColItem2Sheet(writeWorkBook, sheet, xlsReportData, items, overlengthInfo, dev);
            this.saveOverlengthInfo2Sheet(writeWorkBook, overlengthInfo, dev);
            try {
                outputStream = this.getXlsFos(saveFile);
                writeWorkBook.write(outputStream);
                writeWorkBook.removeSheetAt(0);
            }
            catch (IOException e) {
                LOGGER.error("close writebook error.");
            }
            finally {
                StreamUtils.closeResource((Flushable)outputStream, (Closeable)outputStream);
            }
        }
    }

    private OutputStream getXlsFos(File savePath) throws ToolException {
        FileOutputStream outputStream = null;
        try {
            File parentFile = savePath.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                throw new ToolException("create parrent directory failed.");
            }
            if (savePath.exists()) {
                ConnUtils.sleep(1000);
                if (!ToolUtils.deleteFile(savePath.getCanonicalPath())) {
                    LOGGER.error("delete file error:{}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)savePath.getCanonicalPath()));
                }
            }
            if (!savePath.createNewFile()) {
                throw new ToolException("can not create new file.");
            }
            outputStream = new FileOutputStream(FilePathUtils.checkFile((File)savePath));
        }
        catch (IOException e) {
            throw new ToolException("create output stream failed.", (Throwable)e);
        }
        return outputStream;
    }

    private void saveOverlengthInfo2Sheet(HSSFWorkbook wb, Map<String, String> overlengthInfo, GrabDevNode2 dev) {
        if (overlengthInfo.isEmpty()) {
            return;
        }
        LOGGER.info("there are some overlength information .");
        HSSFSheet overlengthInfoSheet = wb.getSheet("overlengthInfo");
        if (null == overlengthInfoSheet) {
            overlengthInfoSheet = wb.createSheet("overlengthInfo");
        }
        Set<Map.Entry<String, String>> overlengthInfos = overlengthInfo.entrySet();
        int rowIndex = 0;
        ArrayList longList = new ArrayList();
        for (Map.Entry<String, String> singleInfo : overlengthInfos) {
            LinkedList<String> list = new LinkedList<String>();
            int colIndex = 0;
            HSSFRow contentRow = overlengthInfoSheet.createRow(rowIndex++);
            String key = singleInfo.getKey();
            String value = singleInfo.getValue();
            ArrayList<String> infoList = new ArrayList<String>();
            this.fillInfo2List(value, infoList, 1);
            HSSFCell cell = contentRow.createCell(colIndex++);
            cell.setCellValue(key);
            list.add(key);
            cell = null;
            for (String cellValue : infoList) {
                cell = contentRow.createCell(colIndex++);
                cell.setCellValue(cellValue);
                list.add(cellValue);
                cell = null;
            }
            longList.add(list);
        }
        GrabContext.getInstance().getOverlengthData().put(dev.getDeviceSerialNumber(), longList);
    }

    private void fillInfo2List(String singleInfo, List<String> infoList, int aSeperateIndex) {
        if (aSeperateIndex * Short.MAX_VALUE < singleInfo.length()) {
            infoList.add(singleInfo.substring((aSeperateIndex - 1) * Short.MAX_VALUE, aSeperateIndex++ * Short.MAX_VALUE));
            this.fillInfo2List(singleInfo, infoList, aSeperateIndex);
        } else {
            infoList.add(singleInfo.substring((aSeperateIndex - 1) * Short.MAX_VALUE, singleInfo.length()));
        }
    }

    private void saveColItem2Sheet(HSSFWorkbook wb, HSSFSheet sheet, Map<String, String> xlsReportData, List<XlsItem> items, Map<String, String> overlengthInfo, GrabDevNode2 dev) throws ToolException {
        LinkedList<String> titleList = new LinkedList<String>();
        LinkedList<String> dataList = new LinkedList<String>();
        int colIndex = 0;
        try {
            HSSFRow titleRow = sheet.createRow(0);
            HSSFRow contentRow = sheet.createRow(1);
            HSSFPalette titlePalette = wb.getCustomPalette();
            titlePalette.setColorAtIndex(HSSFColor.HSSFColorPredefined.DARK_BLUE.getIndex(), (byte)Integer.parseInt("137"), (byte)Integer.parseInt("212"), (byte)Integer.parseInt("46"));
            titleList.add("IP");
            dataList.add(dev.getIp());
            for (XlsItem item : items) {
                String content;
                HSSFCell titleCell = titleRow.createCell(colIndex);
                HSSFCell contentCell = contentRow.createCell(colIndex);
                titleCell.setCellStyle(titleStyle);
                contentCell.setCellStyle(style);
                String title = Locale.ENGLISH.equals(GrabContext.getInstance().getLocale()) ? item.getEnName() : item.getZhName();
                String string = content = StringUtils.isNULLStr(xlsReportData.get(item.getKey())) ? "" : xlsReportData.get(item.getKey());
                if (Short.MAX_VALUE < content.length()) {
                    String key = System.currentTimeMillis() + "-" + content.length();
                    overlengthInfo.put(key, content);
                    content = ResourceUtil.getStringWithParams((String)"infograb.xls.report.one.cell.string.overflow", (Object[])new Object[]{"1001", item.getStartLabel(), key});
                }
                titleList.add(title);
                if (title.equals(ResourceUtil.getString((String)"infograb.excel.datafile.name"))) {
                    content = "datafile";
                }
                dataList.add(content);
                titleCell.setCellValue(title);
                contentCell.setCellValue(content);
                ++colIndex;
                titleCell = null;
                contentCell = null;
            }
            this.saveExcelData(titleList, dataList, dev);
        }
        catch (NumberFormatException e) {
            LOGGER.error("add cell to sheet error");
            throw new ToolException("write data to sheet error.", (Throwable)e);
        }
    }

    private void saveExcelData(LinkedList<String> titleList, LinkedList<String> dataList, GrabDevNode2 dev) {
        switch (this.judgeType(dev)) {
            case "Database": {
                Map<String, LinkedList<String>> dbList = GrabContext.getInstance().getDbData();
                if (dbList.isEmpty()) {
                    dbList.put("title", titleList);
                }
                dbList.put(dev.getXlsFileName(), dataList);
                break;
            }
            case "Host": {
                Map<String, LinkedList<String>> hostList = GrabContext.getInstance().getHostData();
                if (hostList.isEmpty()) {
                    hostList.put("title", titleList);
                }
                hostList.put(dev.getXlsFileName(), dataList);
                break;
            }
            case "Switch": {
                Map<String, LinkedList<String>> switchList = GrabContext.getInstance().getSwitchData();
                if (switchList.isEmpty()) {
                    switchList.put("title", titleList);
                }
                switchList.put(dev.getXlsFileName(), dataList);
                break;
            }
        }
    }

    private String judgeType(GrabDevNode2 dev) {
        return dev.getItDeviceType().getName();
    }

    private static HSSFCellStyle createCellStyle(HSSFWorkbook wb, String type) {
        HSSFFont font = wb.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        if (type.equalsIgnoreCase("title")) {
            cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.BRIGHT_GREEN.getIndex());
        } else {
            cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        }
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setBottomBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setFont(font);
        return cellStyle;
    }
}

