/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.service;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.service.XlsClusterItem;
import com.huawei.ism.tool.infograb.service.XlsItem;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.infograb.utils.migration.MigrationUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;

public class XLSStorageService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(XLSStorageService.class);
    private static final String HOST_TEMPLATE_PATH = "/config/templatefile/Storage_Model.xls";
    private static final Object XLS_STORAGE_LOCK = new Object();
    private static HSSFWorkbook writeWorkBook = new HSSFWorkbook();
    private static XLSStorageService instance = null;
    private List<XlsClusterItem> xlsMigItemList = new LinkedList<XlsClusterItem>();
    private int countNum = 0;
    private int increaseNum = 0;
    private int rowNum = 0;

    private XLSStorageService() {
    }

    private void initXlsItems(String deviceType) {
        try {
            this.xlsMigItemList = this.getXlsGrabItems(deviceType);
        }
        catch (ToolException e) {
            LOGGER.error("ready migrate template error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XLSStorageService getInstance() {
        Object object = XLS_STORAGE_LOCK;
        synchronized (object) {
            if (null == instance) {
                instance = new XLSStorageService();
            }
            if (null == writeWorkBook) {
                writeWorkBook = new HSSFWorkbook();
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<XlsClusterItem> getMigratXlsItems(String key) {
        Object object = XLS_STORAGE_LOCK;
        synchronized (object) {
            this.initXlsItems(key);
            return this.xlsMigItemList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<XlsClusterItem> getXlsGrabItems(String deviceType) throws ToolException {
        HSSFWorkbook xlsTempWorkbook;
        POIFSFileSystem storageFs;
        InputStream inputStream;
        block7: {
            List<XlsClusterItem> list;
            block6: {
                inputStream = null;
                storageFs = null;
                xlsTempWorkbook = null;
                try {
                    inputStream = this.getXlsTemplateIs();
                    storageFs = new POIFSFileSystem(inputStream);
                    xlsTempWorkbook = new HSSFWorkbook(storageFs);
                    HSSFSheet sotrageSheet = xlsTempWorkbook.getSheet(deviceType);
                    if (!VerifyUtil.isEmpty((Object)sotrageSheet)) {
                        list = this.readMigrateXlsTempItems(sotrageSheet);
                        StreamUtils.closeResource(null, (Closeable)xlsTempWorkbook);
                        break block6;
                    }
                    StreamUtils.closeResource(null, (Closeable)xlsTempWorkbook);
                    break block7;
                }
                catch (IOException e) {
                    LOGGER.info("read storage migrate model file error");
                    return null;
                }
            }
            StreamUtils.closeResource(null, (Closeable)storageFs);
            StreamUtils.closeResource(null, (Closeable)inputStream);
            return list;
        }
        StreamUtils.closeResource(null, (Closeable)storageFs);
        StreamUtils.closeResource(null, (Closeable)inputStream);
        return null;
        finally {
            StreamUtils.closeResource(null, xlsTempWorkbook);
            StreamUtils.closeResource(null, (Closeable)storageFs);
            StreamUtils.closeResource(null, (Closeable)inputStream);
        }
    }

    private List<XlsClusterItem> readMigrateXlsTempItems(HSSFSheet modelSheet) {
        LinkedList<XlsClusterItem> xlsItemsList = new LinkedList<XlsClusterItem>();
        int rowBegin = modelSheet.getFirstRowNum();
        int rowEnd = modelSheet.getLastRowNum();
        int storageBegin = rowBegin;
        while (storageBegin <= rowEnd) {
            while (null == modelSheet.getRow(storageBegin).getCell(0)) {
                ++storageBegin;
            }
            HSSFCell featureName = modelSheet.getRow(storageBegin).getCell(3);
            HSSFCell titleChName = modelSheet.getRow(storageBegin).getCell(1);
            HSSFCell titleEnName = modelSheet.getRow(storageBegin).getCell(2);
            HSSFCell pythonFileName = modelSheet.getRow(storageBegin).getCell(4);
            HSSFCell typeName = modelSheet.getRow(storageBegin).getCell(0);
            if (featureName.getStringCellValue().contains("vertical")) {
                XlsClusterItem xlsMigrate = new XlsClusterItem();
                LinkedList<XlsItem> itemList = new LinkedList<XlsItem>();
                int stringNum = featureName.getStringCellValue().length();
                int columNum = Integer.parseInt(featureName.getStringCellValue().substring(stringNum - 1));
                int beginflag = storageBegin++;
                while (storageBegin < beginflag + columNum + 1) {
                    HSSFRow keyRow = modelSheet.getRow(storageBegin);
                    String sotrageKey = keyRow.getCell(0).getStringCellValue().toLowerCase(LanguageManager.getInstance().getCurrentLanguage());
                    String storageStartLabel = keyRow.getCell(1).getStringCellValue().toLowerCase(LanguageManager.getInstance().getCurrentLanguage());
                    String chName = keyRow.getCell(2).getStringCellValue();
                    String enName = keyRow.getCell(3).getStringCellValue();
                    itemList.add(new XlsItem(sotrageKey, storageStartLabel, chName, enName));
                    ++storageBegin;
                }
                xlsMigrate.setMigrateItemKey(typeName.getStringCellValue().toLowerCase(LanguageManager.getInstance().getCurrentLanguage()));
                xlsMigrate.setEnName(titleEnName.getStringCellValue());
                xlsMigrate.setChName(titleChName.getStringCellValue());
                xlsMigrate.setMigrateXlsDirect("vertical");
                xlsMigrate.setSinglePyItems(itemList);
                xlsMigrate.setPythonFileName(pythonFileName.getStringCellValue());
                xlsItemsList.add(xlsMigrate);
            }
            if (storageBegin > rowEnd) break;
            storageBegin = this.getStorageBegin(modelSheet, xlsItemsList, storageBegin);
        }
        return xlsItemsList;
    }

    private int getStorageBegin(HSSFSheet modelSheet, List<XlsClusterItem> xlsItemsList, int storageBegin) {
        HSSFCell featureName = modelSheet.getRow(storageBegin).getCell(3);
        HSSFCell titleChName = modelSheet.getRow(storageBegin).getCell(1);
        HSSFCell titleEnName = modelSheet.getRow(storageBegin).getCell(2);
        HSSFCell pythonFileName = modelSheet.getRow(storageBegin).getCell(4);
        HSSFCell typeName = modelSheet.getRow(storageBegin).getCell(0);
        if (featureName.getStringCellValue().contains("horizontal")) {
            LinkedList<XlsItem> itemList = new LinkedList<XlsItem>();
            XlsClusterItem storageXls = new XlsClusterItem();
            HSSFRow storageKeyRow = modelSheet.getRow(++storageBegin);
            HSSFRow storageStartLabel = modelSheet.getRow(++storageBegin);
            HSSFRow storageChName = modelSheet.getRow(++storageBegin);
            HSSFRow storageEnName = modelSheet.getRow(++storageBegin);
            int cellBegin = storageKeyRow.getFirstCellNum();
            short cellEnd = storageKeyRow.getLastCellNum();
            for (int i = cellBegin; i < cellEnd; ++i) {
                itemList.add(new XlsItem(storageKeyRow.getCell(i).getStringCellValue().toLowerCase(LanguageManager.getInstance().getCurrentLanguage()), storageStartLabel.getCell(i).getStringCellValue().toLowerCase(LanguageManager.getInstance().getCurrentLanguage()), storageChName.getCell(i).getStringCellValue(), storageEnName.getCell(i).getStringCellValue()));
            }
            storageXls.setMigrateItemKey(typeName.getStringCellValue().toLowerCase(LanguageManager.getInstance().getCurrentLanguage()));
            storageXls.setEnName(titleEnName.getStringCellValue());
            storageXls.setChName(titleChName.getStringCellValue());
            storageXls.setMigrateXlsDirect("horizontal");
            storageXls.setSinglePyItems(itemList);
            storageXls.setPythonFileName(pythonFileName.getStringCellValue());
            xlsItemsList.add(storageXls);
            ++storageBegin;
        }
        return storageBegin;
    }

    private InputStream getXlsTemplateIs() throws ToolException {
        InputStream inputStream = XLSStorageService.class.getResourceAsStream(HOST_TEMPLATE_PATH);
        if (null == inputStream) {
            throw new ToolException("can't find the storage model excel file.");
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveXlsReport(File storageFile, Map<String, Map<String, List<String>>> xlsReportData, List<XlsClusterItem> xmiList) throws ToolException {
        String storagePath = ToolUtils.getCanonicalFilePath(storageFile);
        if (null == (storageFile = ToolUtils.getCanonicalFile(storagePath)) || storageFile.isDirectory()) {
            throw new ToolException("The storage migrate savefile is a directory, not file.");
        }
        if (!storageFile.getParentFile().exists() && storageFile.getParentFile().mkdirs()) {
            throw new ToolException("create storage migrate directory failed.");
        }
        OutputStream storageOutputStream = null;
        HSSFWorkbook hSSFWorkbook = writeWorkBook;
        synchronized (hSSFWorkbook) {
            block11: {
                LOGGER.info("writeWorkBook in");
                HSSFSheet sheet = writeWorkBook.getSheet("Storage");
                if (null == sheet) {
                    sheet = writeWorkBook.createSheet("Storage");
                }
                try {
                    this.saveColItem2Sheet(writeWorkBook, sheet, xlsReportData, xmiList);
                    storageOutputStream = this.getXlsFos(storageFile);
                    writeWorkBook.write(storageOutputStream);
                    writeWorkBook.removeSheetAt(0);
                    StreamUtils.closeResource((Flushable)storageOutputStream, (Closeable)storageOutputStream);
                }
                catch (IOException e) {
                    LOGGER.error("close storage cluster writebook error.");
                    break block11;
                }
                finally {
                    StreamUtils.closeResource(storageOutputStream, storageOutputStream);
                    StreamUtils.closeResource(null, (Closeable)writeWorkBook);
                    writeWorkBook = null;
                }
                StreamUtils.closeResource(null, (Closeable)writeWorkBook);
                writeWorkBook = null;
            }
        }
        StreamUtils.closeResource((Flushable)storageOutputStream, (Closeable)storageOutputStream);
    }

    private OutputStream getXlsFos(File saveClusterPath) throws ToolException {
        FileOutputStream outputStream = null;
        try {
            File storageFile = saveClusterPath.getParentFile();
            if (!storageFile.exists() && !storageFile.mkdirs()) {
                throw new ToolException("create cluster parent directory failed.");
            }
            if (saveClusterPath.exists() && !saveClusterPath.delete()) {
                throw new ToolException("the storage file already exists!");
            }
            if (!saveClusterPath.createNewFile()) {
                throw new ToolException("can not create new storage file.");
            }
            outputStream = new FileOutputStream(FilePathUtils.checkFile((File)saveClusterPath));
        }
        catch (IOException e) {
            throw new ToolException("create storage output stream failed.", (Throwable)e);
        }
        return outputStream;
    }

    private void saveColItem2Sheet(HSSFWorkbook wb, HSSFSheet sheet, Map<String, Map<String, List<String>>> xlsReportData, List<XlsClusterItem> xmiList) throws ToolException {
        LOGGER.info("Storage saveColItem2Sheet in");
        HSSFCellStyle titleStyle = this.createCellStyle(wb, "title");
        HSSFCellStyle contentStyle = this.createCellStyle(wb, "content");
        int checkFlag = 0;
        this.countNum = 0;
        this.rowNum = 0;
        for (XlsClusterItem storageXmi : xmiList) {
            this.rowNum = this.storageXlsReportTitle(sheet, this.rowNum, storageXmi);
            this.rowNum = this.handleStorageVertical(sheet, xlsReportData, titleStyle, contentStyle, this.rowNum, storageXmi);
            this.increaseNum = 0;
            if ((checkFlag = this.handleStorageHorizontal(sheet, xlsReportData, titleStyle, contentStyle, checkFlag, storageXmi)) % 2 != 0 || checkFlag == 0) continue;
            this.mergeCells(sheet);
            ++this.rowNum;
            this.countNum = 0;
        }
        this.columnWidthModify(sheet);
    }

    void mergeCells(HSSFSheet sheet) {
        if (this.countNum <= 0) {
            return;
        }
        sheet.addMergedRegion(new CellRangeAddress(this.rowNum - this.countNum, this.rowNum, 0, 0));
        sheet.addMergedRegion(new CellRangeAddress(this.rowNum - this.countNum, this.rowNum, 1, 1));
    }

    private int handleStorageHorizontal(HSSFSheet sheet, Map<String, Map<String, List<String>>> xlsReportData, HSSFCellStyle titleStyle, HSSFCellStyle contentStyle, int checkFlag, XlsClusterItem storageXmi) {
        if (storageXmi.getMigrateXlsDirect().equals("horizontal")) {
            ++checkFlag;
            int flagRowNum = this.rowNum;
            int contentRowNum = flagRowNum + 1;
            int column = 0;
            HSSFRow currentRow = sheet.createRow(flagRowNum);
            boolean createRowFlag = false;
            for (XlsItem item : storageXmi.getSinglePyItems()) {
                HSSFCell cellTitle = currentRow.createCell(column);
                cellTitle.setCellStyle(titleStyle);
                String title = Locale.ENGLISH.equals(GrabContext.getInstance().getLocale()) ? item.getEnName() : item.getZhName();
                cellTitle.setCellValue(title);
                this.increaseNum = 0;
                for (int i = 0; i < xlsReportData.get(storageXmi.getMigrateItemKey()).get(item.getKey()).size(); ++i) {
                    if (!createRowFlag) {
                        this.countNum = this.createNewRow(sheet, xlsReportData, this.countNum, storageXmi, contentRowNum, item);
                        createRowFlag = true;
                    }
                    HSSFRow contentRow = sheet.getRow(contentRowNum + i);
                    HSSFCell cellContent = contentRow.createCell(column);
                    cellContent.setCellStyle(contentStyle);
                    String content = XLSStorageService.isNULLStr(xlsReportData.get(storageXmi.getMigrateItemKey()).get(item.getKey()).get(i)) ? "" : xlsReportData.get(storageXmi.getMigrateItemKey()).get(item.getKey()).get(i);
                    cellContent.setCellValue(content);
                    ++this.increaseNum;
                }
                ++column;
            }
            this.rowNum += this.increaseNum;
        }
        return checkFlag;
    }

    private int storageXlsReportTitle(HSSFSheet sheet, int rowNumTemp, XlsClusterItem storageXmi) {
        if (rowNumTemp != 0) {
            ++rowNumTemp;
        }
        if (storageXmi.getMigrateItemKey().equals("report_title")) {
            HSSFRow titleRow = sheet.createRow(rowNumTemp);
            HSSFCell blockTitleCell = titleRow.createCell(0);
            blockTitleCell.setCellValue(Locale.ENGLISH.equals(GrabContext.getInstance().getLocale()) ? storageXmi.getEnName() : storageXmi.getChName());
            ++rowNumTemp;
        }
        return rowNumTemp;
    }

    private int createNewRow(HSSFSheet sheet, Map<String, Map<String, List<String>>> xlsReportData, int countNumTemp, XlsClusterItem storageXmi, int contentRowNum, XlsItem item) {
        for (int j = 0; j < xlsReportData.get(storageXmi.getMigrateItemKey()).get(item.getKey()).size(); ++j) {
            sheet.createRow(contentRowNum + j);
            if (j != 0) continue;
            countNumTemp += xlsReportData.get(storageXmi.getMigrateItemKey()).get(item.getKey()).size();
        }
        return countNumTemp;
    }

    private void columnWidthModify(HSSFSheet sheet) {
        for (int i = 0; i < 13; ++i) {
            sheet.setColumnWidth(i, 5120);
            if (i != 10 && i != 12) continue;
            sheet.setColumnWidth(i, 8704);
        }
    }

    private int handleStorageVertical(HSSFSheet sheet, Map<String, Map<String, List<String>>> xlsReportData, HSSFCellStyle titleStyle, HSSFCellStyle contentStyle, int rowNumVertical, XlsClusterItem storageXmi) {
        if (storageXmi.getMigrateXlsDirect().equals("vertical")) {
            for (XlsItem item : storageXmi.getSinglePyItems()) {
                HSSFRow currentRow = sheet.createRow(rowNumVertical);
                HSSFCell cellTitle = currentRow.createCell(0);
                HSSFCell cellContent = currentRow.createCell(1);
                cellTitle.setCellStyle(titleStyle);
                cellContent.setCellStyle(contentStyle);
                String title = Locale.ENGLISH.equals(GrabContext.getInstance().getLocale()) ? item.getEnName() : item.getZhName();
                cellTitle.setCellValue(title);
                String contentData = xlsReportData.get(storageXmi.getMigrateItemKey()).get(item.getKey()).get(0);
                String content = XLSStorageService.isNULLStr(contentData) ? "" : contentData;
                cellContent.setCellValue(content);
                ++rowNumVertical;
            }
            HSSFRow rowTitle = sheet.createRow(++rowNumVertical);
            HSSFCell titleCell = rowTitle.createCell(0);
            titleCell.setCellValue("Mapping View Info");
        }
        return rowNumVertical;
    }

    private HSSFCellStyle createCellStyle(HSSFWorkbook wb, String type) {
        HSSFFont font = wb.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        HSSFCellStyle style = wb.createCellStyle();
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setAlignment(HorizontalAlignment.LEFT);
        if (type.equalsIgnoreCase("title")) {
            HSSFPalette storagePalette = wb.getCustomPalette();
            storagePalette.setColorAtIndex(HSSFColor.HSSFColorPredefined.SKY_BLUE.getIndex(), (byte)-107, (byte)-80, (byte)-41);
            style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.SKY_BLUE.getIndex());
        } else {
            HSSFPalette storagePalette = wb.getCustomPalette();
            storagePalette.setColorAtIndex(HSSFColor.HSSFColorPredefined.BLUE_GREY.getIndex(), (byte)-36, (byte)-26, (byte)-15);
            style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.BLUE_GREY.getIndex());
        }
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBottomBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setFont(font);
        MigrationUtils.setStyleAsText(wb, style);
        return style;
    }

    public static boolean isNULLStr(String str) {
        return null == str || "".equals(str.trim());
    }

    void setCountNum(int countNum) {
        this.countNum = countNum;
    }

    void setRowNum(int rowNum) {
        this.rowNum = rowNum;
    }
}

