/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.service;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.infograb.utils.migration.Configurations;
import com.huawei.ism.tool.infograb.utils.migration.MigrationUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.excel.POIUtils;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;

public class XlsHostWriter {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(XlsHostWriter.class);
    private static final Object XLS_WRITER_LOCK = new Object();
    private static HSSFCellStyle titleStyle = null;
    private static HSSFCellStyle contentStyle = null;
    private static HSSFCellStyle doubleContentStyle = null;

    /*
     * Exception decompiling
     */
    public static boolean saveXlsReport(File saveFile, Map<String, List<List<String>>> reportDatas) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void createXlsData(List<String> sheetNames, Map<String, List<List<String>>> reportDatas, HSSFWorkbook writeWorkBook) {
        sheetNames.stream().filter(reportDatas::containsKey).forEach(sheetName -> XlsHostWriter.saveColItem2Sheet(writeWorkBook, (Sheet)writeWorkBook.createSheet(sheetName), (List)reportDatas.get(sheetName), true));
    }

    private static List<String> getSheetNames() {
        return Arrays.asList("Overview", "Linux_OS", "AIX_OS", "HPUX_OS", "Solaris_OS", "ESXi_OS", "Windows_OS", "Linux_Multipath", "AIX_Multipath", "HPUX_Multipath", "Solaris_Multipath", "ESXi_Multipath", "Windows_Multipath", "Linux_LVM", "AIX_LVM", "HPUX_LVM", "Solaris_LVM", "Solaris_VCS", "Solaris_VxVM", "ESXi_VMinfo", "Linux_OracleRAC", "AIX_OracleRAC", "HPUX_OracleRAC", "Solaris_OracleRAC", "AIX_PowerHA", "AIX_PowerVM", "HPUX_ServiceGuard", "Windows_Cluster", "Linux_GPFS", "AIX_GPFS", "Windows_Hyper-V");
    }

    public static void saveColItem2Sheet(HSSFWorkbook workbook, Sheet sheet, List<List<String>> xlsReportData, boolean createTitle) {
        boolean creatTitleTemp = createTitle;
        Map<String, Integer> item2Width = XlsHostWriter.getItem2Width();
        int rowIndex = 0;
        XlsHostWriter.initFontAndStyle(workbook);
        if (sheet.getSheetName().contains("Linux_LVM")) {
            contentStyle.setWrapText(false);
        } else {
            contentStyle.setWrapText(true);
        }
        List<String> doubleItem = Arrays.asList("Lun Size(GiB)", "ASMdisk Total Size(MB)", "ASMdisk Free Size(MB)", "Disk Size(GiB)", "FS Total Size(GiB)", "FS Used Size(GiB)");
        ArrayList<Integer> doubleIndex = new ArrayList<Integer>();
        for (List<String> oneSheetData : xlsReportData) {
            int index;
            int colIndex = 0;
            if (creatTitleTemp) {
                index = 0;
                for (String item : oneSheetData) {
                    if (doubleItem.contains(item)) {
                        doubleIndex.add(index);
                    }
                    XlsHostWriter.setXlsAutoFilter(oneSheetData.size(), sheet);
                    sheet.setColumnWidth(colIndex, XlsHostWriter.getStandNum(item2Width.getOrDefault(item, 15)));
                    POIUtils.setCellValue(sheet, rowIndex, colIndex, item, titleStyle);
                    ++colIndex;
                    ++index;
                }
                creatTitleTemp = false;
            } else {
                index = 0;
                for (String item : oneSheetData) {
                    if (doubleIndex.contains(index)) {
                        XlsHostWriter.setCellValue(sheet, rowIndex, colIndex, item, true);
                    } else {
                        XlsHostWriter.setCellValue(sheet, rowIndex, colIndex, item, false);
                    }
                    ++colIndex;
                    ++index;
                }
            }
            ++rowIndex;
        }
    }

    private static void setCellValue(Sheet sheet, int rowIndex, int colIndex, String item, boolean floatFlag) {
        Cell cell;
        Row rowLine = sheet.getRow(rowIndex);
        if (null == rowLine) {
            rowLine = sheet.createRow(rowIndex);
        }
        if (null == (cell = rowLine.getCell(colIndex))) {
            cell = rowLine.createCell(colIndex);
        }
        if (floatFlag && StringUtils.isDigit(item)) {
            BigDecimal bd = new BigDecimal(item);
            Double result = bd.setScale(2, 4).doubleValue();
            cell.setCellValue(result.doubleValue());
            if (null != doubleContentStyle) {
                cell.setCellStyle((CellStyle)doubleContentStyle);
            }
        } else {
            cell.setCellValue(item);
            if (null != contentStyle) {
                cell.setCellStyle((CellStyle)contentStyle);
            }
        }
    }

    private static void setXlsAutoFilter(int lineNum, Sheet sheet) {
        String endLine = String.valueOf((char)(lineNum + 64));
        String rang = "A1:" + endLine + "1";
        CellRangeAddress rangeAddress = CellRangeAddress.valueOf((String)rang);
        sheet.setAutoFilter(rangeAddress);
    }

    private static boolean checkFile(File saveFile) throws IOException {
        File file = saveFile.getParentFile();
        if (!file.exists() && !file.mkdirs()) {
            LOGGER.error("mk dir failed.");
            return false;
        }
        if (!saveFile.exists() && !saveFile.createNewFile()) {
            LOGGER.error("cannot create new file.");
            return false;
        }
        return true;
    }

    private static void initFontAndStyle(HSSFWorkbook book) {
        titleStyle = XlsHostWriter.createTitleStyle(book);
        contentStyle = POIUtils.createContentStyle(book);
        MigrationUtils.setStyleAsText(book, contentStyle);
        doubleContentStyle = POIUtils.createContentStyle(book);
        doubleContentStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"0.00"));
    }

    public static HSSFCellStyle createTitleStyle(HSSFWorkbook workbook) {
        HSSFCellStyle style = workbook.createCellStyle();
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(false);
        HSSFFont font = workbook.createFont();
        font.setFontName("Times New Roman");
        font.setFontHeightInPoints((short)11);
        font.setBold(true);
        font.setItalic(false);
        style.setFont((Font)font);
        return style;
    }

    private static Map<String, Integer> getItem2Width() {
        return Configurations.SUMMARY_HEADER_WIDTH_CONFIGURATIONS.getConfig().getWidthData();
    }

    private static int getStandNum(int num) {
        return (int)(((double)num + 0.72) * 256.0);
    }
}

