/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.service;

import com.huawei.ism.tool.infograb.utils.migration.MigrationUtils;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.excel.POIUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsNetAppWriter {
    private static final Logger log = LoggerFactory.getLogger(XlsNetAppWriter.class);
    private final File saveFile;
    private final Map<String, List<List<String>>> reportData;
    private final String deviceMode;
    private HSSFCellStyle titleStyle;
    private HSSFCellStyle levelTwoTitleStyle;
    private HSSFCellStyle contentStyle;

    public XlsNetAppWriter(File saveFile, Map<String, List<List<String>>> reportData, String deviceMode) {
        this.saveFile = saveFile;
        this.reportData = reportData;
        this.deviceMode = deviceMode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveXlsReport() {
        log.info("begin to generate xls.");
        List<String> sheetNames = this.getSheetNames();
        try (OutputStream outputStream = Files.newOutputStream(this.saveFile.toPath(), new OpenOption[0]);){
            HSSFWorkbook writeWorkBook = new HSSFWorkbook();
            this.initFontAndStyle(writeWorkBook);
            sheetNames.forEach(sheetName -> this.saveSheetData((String)sheetName, writeWorkBook));
            writeWorkBook.write(outputStream);
            log.info("success to generate xls.");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.error("write xls error.", (Throwable)e);
            return false;
        }
    }

    private List<String> getSheetNames() {
        if ("C-MODE".equals(this.deviceMode)) {
            return this.getCModeSheetNames();
        }
        if ("7-MODE".equals(this.deviceMode)) {
            return this.get7ModeSheetNames();
        }
        if ("OceanStor_V3/V5".equals(this.deviceMode)) {
            return this.getV3V5SheetNames();
        }
        if ("Isilon".equals(this.deviceMode)) {
            return XlsNetAppWriter.getIsilonSheetNames();
        }
        if ("OceanStor_9000".equals(this.deviceMode)) {
            return this.get9000SheetNames();
        }
        return Collections.emptyList();
    }

    @NotNull
    private List<String> getV3V5SheetNames() {
        return Arrays.asList("Overview", "Vstore", "Logical_Port", "Filesystem", "Worm", "Dtree", "Quota", "NFS_Share", "CIFS_Share", "CIFS_Share_Permission", "CIFS_Share_Ip_Control", "CIFS_Share_File_Extension", "CIFS_Homedir_Rule", "Group", "User", "User_Mapping", "NFS_Server", "CIFS_Server", "CIFS_Server_Sid_Mapping", "Deduplicated_Compressed", "Domains", "Snapshot", "Hyper_Metro", "Remote_Replication");
    }

    @NotNull
    private List<String> get9000SheetNames() {
        return Arrays.asList("Overview", "InfoEqualizer", "Logical_Port", "Quota", "Quota_Template", "NFS_Share", "CIFS_Share", "Homedir", "NFS_Server", "CIFS_Server", "Group", "User", "User_Mapping", "User_Mapping_Config", "Domains", "Worm", "Snapshot", "Remote_Replication", "General_Config", "Node", "Copy_Chunk");
    }

    static List<String> getIsilonSheetNames() {
        return Arrays.asList("Overview", "StoragePools", "Zones", "NIC", "Quota", "NIC_Pool", "Worm", "NFS_Share", "CIFS_Share", "CIFS_Share_Permission", "Group", "User", "NFS_Server", "CIFS_Server", "Deduplicated_Compressed", "Domain_ADS", "Domain_LDAP", "Domain_NIS", "Snapshot");
    }

    @NotNull
    private List<String> get7ModeSheetNames() {
        return Arrays.asList("Overview", "Aggregate", "Volume_Qtree", "CIFS_Share", "User_Group", "SMB_Version", "Export_Policy", "Deduplicated_Compressed", "Homedir_Path", "NFS_Version", "Vserver_Domain", "Name_Mapping");
    }

    @NotNull
    private List<String> getCModeSheetNames() {
        return Arrays.asList("Overview", "Aggregate", "Volume_Qtree", "CIFS_Share", "CIFS_User", "CIFS_Group", "CIFS_Server", "CIFS_User_Group_Privileges", "Export_Policy", "Deduplicated_Compressed", "Junction", "Homedir_Path", "Quota_Policy", "NFS_Version", "NFS_User_Group", "Vserver_Domain", "Vserver_Domain_Ldap", "Vserver_Domain_Nis", "Name_Mapping", "Snap_Policy", "Network_Port");
    }

    private void saveSheetData(String sheetName, HSSFWorkbook writeWorkBook) {
        Map<String, String> headerWidth = this.getHeaderWidth();
        if (this.reportData.containsKey(sheetName)) {
            this.saveColItem2Sheet((Sheet)writeWorkBook.createSheet(sheetName), this.reportData.get(sheetName), headerWidth, sheetName);
        }
    }

    private void saveColItem2Sheet(Sheet sheet, List<List<String>> xlsReportData, Map<String, String> item2Width, String sheetName) {
        if ("SMB_Version".equals(sheetName)) {
            this.writeSmbContent(sheet, item2Width, xlsReportData);
            return;
        }
        if ("OceanStor_V3/V5".equals(this.deviceMode) && "Domains".equals(sheetName)) {
            this.writeLevelTwoTitle(xlsReportData.get(0), sheet);
            this.writeTitle(xlsReportData.get(1), sheet, item2Width, false, 1);
            this.writeContent(xlsReportData, sheet, 2);
            this.mergeLevelTwoTitleCells(xlsReportData.get(0), sheet);
            return;
        }
        if ("C-MODE".equals(this.deviceMode) && "Vserver_Domain".equals(sheetName)) {
            this.writeLevelTwoTitle(xlsReportData.get(0), sheet);
            this.writeTitle(xlsReportData.get(1), sheet, item2Width, false, 1);
            this.writeContent(xlsReportData, sheet, 2);
            this.mergeLevelTwoTitleCells(xlsReportData.get(0), sheet);
            return;
        }
        this.writeTitle(xlsReportData.get(0), sheet, item2Width, true, 0);
        this.writeContent(xlsReportData, sheet, 1);
    }

    private void mergeLevelTwoTitleCells(List<String> titles, Sheet sheet) {
        if (CollectionUtil.isEmpty(titles)) {
            return;
        }
        String temp = titles.get(0);
        int startCol = 0;
        for (int i = 1; i < titles.size(); ++i) {
            if (!ObjectUtils.notEqual((Object)temp, (Object)titles.get(i))) continue;
            this.mergeCells(sheet, startCol, i);
            temp = titles.get(i);
            startCol = i;
        }
        this.mergeCells(sheet, startCol, titles.size());
    }

    private void mergeCells(Sheet sheet, int startCol, int endCol) {
        if (endCol - startCol >= 2) {
            POIUtils.mergeCells(sheet, startCol, 0, endCol - 1, 0);
        }
    }

    private void writeSmbContent(Sheet sheet, Map<String, String> item2Width, List<List<String>> xlsReportData) {
        this.writeTitle(xlsReportData.get(0), sheet, item2Width, false, 0);
        this.writeContent(xlsReportData.subList(0, 3), sheet, 1);
        this.writeTitle(xlsReportData.get(3), sheet, item2Width, false, 3);
        this.writeContent(xlsReportData, sheet, 4);
    }

    private void writeContent(List<List<String>> xlsReportData, Sheet sheet, int startRowIndex) {
        if (xlsReportData.isEmpty()) {
            return;
        }
        IntStream.range(startRowIndex, xlsReportData.size()).forEach(rowIndex -> this.writeRowContent(rowIndex, (List)xlsReportData.get(rowIndex), sheet));
    }

    private void writeRowContent(int rowIndex, List<String> oneRowContent, Sheet sheet) {
        IntStream.range(0, oneRowContent.size()).forEach(colIndex -> this.writeRowContentData(rowIndex, colIndex, oneRowContent, sheet));
    }

    private void writeRowContentData(int rowIndex, int colIndex, List<String> oneRowContent, Sheet sheet) {
        this.setCellValue(sheet, rowIndex, colIndex, oneRowContent.get(colIndex));
    }

    private void writeTitle(List<String> headers, Sheet sheet, Map<String, String> item2Width, boolean autoFilter, int rowNum) {
        IntStream.range(0, headers.size()).forEach(colIndex -> this.writeTitleData(colIndex, headers, sheet, item2Width, rowNum));
        if (autoFilter) {
            this.setXlsAutoFilter(headers.size(), sheet);
        }
    }

    private void writeTitleData(int colIndex, List<String> headers, Sheet sheet, Map<String, String> item2Width, int rowNum) {
        sheet.setColumnWidth(colIndex, Integer.parseInt(item2Width.getOrDefault(headers.get(colIndex), this.getStandNum(25))));
        POIUtils.setCellValue(sheet, rowNum, colIndex, headers.get(colIndex), this.titleStyle);
    }

    private void writeLevelTwoTitle(List<String> headers, Sheet sheet) {
        IntStream.range(0, headers.size()).forEach(colIndex -> this.writeLevelTwoTitleData(colIndex, headers, sheet));
    }

    private void writeLevelTwoTitleData(int colIndex, List<String> headers, Sheet sheet) {
        sheet.setColumnWidth(colIndex, Integer.parseInt(this.getStandNum(30)));
        POIUtils.setCellValue(sheet, 0, colIndex, headers.get(colIndex), this.levelTwoTitleStyle);
    }

    private void setCellValue(Sheet sheet, int rowIndex, int colIndex, String data) {
        Row rowLine = null != sheet.getRow(rowIndex) ? sheet.getRow(rowIndex) : sheet.createRow(rowIndex);
        Cell cell = null != rowLine.getCell(colIndex) ? rowLine.getCell(colIndex) : rowLine.createCell(colIndex);
        this.setValue(cell, data);
        cell.setCellStyle((CellStyle)this.contentStyle);
    }

    private void setValue(Cell cell, String newText) {
        if ("C-MODE".equals(this.deviceMode) && XlsNetAppWriter.isInteger(newText)) {
            cell.setCellValue((double)Integer.parseInt(newText));
        } else {
            cell.setCellValue(newText);
        }
    }

    private static boolean isInteger(String newText) {
        try {
            Integer.valueOf(newText);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void setXlsAutoFilter(int lineNum, Sheet sheet) {
        String endLine = this.excelColIndexToStr(lineNum);
        String rang = "A1:" + endLine + "1";
        CellRangeAddress rangeAddress = CellRangeAddress.valueOf((String)rang);
        sheet.setAutoFilter(rangeAddress);
    }

    private String excelColIndexToStr(int lineNum) {
        int columnIndex = lineNum;
        if (columnIndex <= 0) {
            return "";
        }
        StringBuilder columnStr = new StringBuilder();
        --columnIndex;
        do {
            if (columnStr.length() > 0) {
                --columnIndex;
            }
            columnStr.insert(0, (char)(columnIndex % 26 + 65));
        } while ((columnIndex = (columnIndex - columnIndex % 26) / 26) > 0);
        return columnStr.toString();
    }

    private void initFontAndStyle(HSSFWorkbook book) {
        HSSFCellStyle baseTitleStyle = this.createBaseTitleStyle(book);
        this.titleStyle = this.createTitleStyle(baseTitleStyle);
        this.levelTwoTitleStyle = this.createLevelTwoTitleStyle(baseTitleStyle);
        this.contentStyle = POIUtils.createContentStyle(book);
        MigrationUtils.setStyleAsText(book, this.contentStyle);
    }

    private HSSFCellStyle createBaseTitleStyle(HSSFWorkbook workbook) {
        HSSFCellStyle style = workbook.createCellStyle();
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(false);
        style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"@"));
        HSSFFont font = workbook.createFont();
        font.setFontName("Times New Roman");
        font.setFontHeightInPoints((short)11);
        font.setBold(true);
        font.setItalic(false);
        style.setFont((Font)font);
        return style;
    }

    private HSSFCellStyle createLevelTwoTitleStyle(HSSFCellStyle style) {
        style.setAlignment(HorizontalAlignment.CENTER);
        return style;
    }

    private HSSFCellStyle createTitleStyle(HSSFCellStyle style) {
        style.setAlignment(HorizontalAlignment.LEFT);
        return style;
    }

    private Map<String, String> getHeaderWidth() {
        HashMap<String, String> headersWidth = new HashMap<String, String>();
        List<String> width15Headers = Arrays.asList("Size", "Available", "Used%", "State", "#Vols", "Total Used", "Full Name", "Rule Index", "RO Rule", "Total-saved", "Used", "Language", "Position", "v3", "v4.0", "v4.1", "UDP", "TCP", "v4.0 ACL", "v4.1 ACL", "Group ID", "User Name", "User ID", "Full Name", "State", "NIS Domain", "ifree", "NIS Server", "Vscan Status", "Direction", "Hostname", "Style", "Oplocks", "Status", "iused", "%iused", "Quota State", "Type", "RW Rule");
        this.setColumnWidth(headersWidth, this.getStandNum(15), width15Headers);
        List<String> width23Headers = Arrays.asList("Domains", "DNS Name Servers", "CIFS Server Name", "CIFS Status Admin", "IP Address/Mask", "Pattern", "Anonymous User ID");
        this.setColumnWidth(headersWidth, this.getStandNum(23), width23Headers);
        List<String> width31Headers = Arrays.asList("Domain/Workgroup Name", "User Groups/Group Roles", "User Name ", "Current Connected DCs", "Connected AD LDAP Server", "Superuser Security Types");
        this.setColumnWidth(headersWidth, this.getStandNum(31), width31Headers);
        this.setColumnWidth(headersWidth, this.getStandNum(41), Collections.singletonList("DataCenter"));
        this.setColumnWidth(headersWidth, this.getStandNum(37), Collections.singletonList("Language "));
        this.setColumnWidth(headersWidth, this.getStandNum(44), Collections.singletonList("Info"));
        List<String> width33Headers = Arrays.asList("Total Storage Efficiency Ratio", "Negative Cache Entry Expiry", "NFSv3 RDMA RRoCE only", "Client-side Caching Policy", "Access Based Enumeration", "Negative Cache Entry Expiry", "Dedupe Cluster Physical Size", "Dedupe Cluster Used Size", "Dedupe Logical Size Deduplicated", "Dedupe Estimated Physical Saving");
        this.setColumnWidth(headersWidth, this.getStandNum(33), width33Headers);
        List<String> width53Headers = Arrays.asList("Automatically expand user names or domain names", "Automatically create home directories for users", "Access Based Enumeration Root Only", "Dedupe Estimated Size Deduplicated");
        this.setColumnWidth(headersWidth, this.getStandNum(53), width53Headers);
        return headersWidth;
    }

    private void setColumnWidth(Map<String, String> headersWidth, String columnNum, List<String> columns) {
        columns.forEach(column -> headersWidth.put((String)column, columnNum));
    }

    private String getStandNum(int num) {
        return String.valueOf(256 * num + 184);
    }
}

