/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.service;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.obase.utils.excel.POIUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;

public class XlsReader {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(XlsReader.class);
    private static final Object XLS_READER_LOCK = new Object();
    private static XlsReader instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XlsReader getInstance() {
        Object object = XLS_READER_LOCK;
        synchronized (object) {
            if (null == instance) {
                instance = new XlsReader();
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getAllXlsRow(File xlsFile, String sheetName, int startRow) {
        ArrayList<List<String>> allXlsRows = new ArrayList<List<String>>();
        HSSFWorkbook xlsTempWorkbook = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(xlsFile);
            xlsTempWorkbook = new HSSFWorkbook((InputStream)fis);
            Sheet sheet = this.getSheet(xlsTempWorkbook, sheetName);
            int rows = sheet.getLastRowNum() + 1;
            while (startRow < rows) {
                allXlsRows.add(this.readXlsTempItems(sheet, startRow));
                ++startRow;
            }
        }
        catch (IOException e) {
            LOGGER.error("create workbook error.");
        }
        catch (ToolException e) {
            LOGGER.error("The specfic sheet does not exist.");
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)fis);
        }
        return allXlsRows;
    }

    public void fillOverlengthInfo2List(List<LinkedList<String>> datas, String path) throws ToolException {
        String excelPath = ToolUtils.getCanonicalFilePath(path);
        InputStream inputStream = this.getXlsTemplateIs(excelPath);
        HSSFWorkbook xlsTempWorkbook = this.getXlsTempWorkbook(inputStream);
        Sheet sheet = this.getSheet(xlsTempWorkbook, "overlengthInfo");
        StreamUtils.closeStream(null, (InputStream)inputStream);
        LOGGER.info("read data complete.");
        int rowCount = sheet.getLastRowNum() + 1;
        for (int i = 0; i < rowCount; ++i) {
            datas.add(this.readXlsTempItems(sheet, i));
        }
    }

    public List<String> getXlsRow(String path, int row) throws ToolException {
        String excelPath = ToolUtils.getCanonicalFilePath(path);
        InputStream inputStream = this.getXlsTemplateIs(excelPath);
        HSSFWorkbook xlsTempWorkbook = this.getXlsTempWorkbook(inputStream);
        Sheet sheet = this.getSheet(xlsTempWorkbook, "data");
        try {
            inputStream.close();
        }
        catch (IOException e) {
            LOGGER.info("XlsReader getXlsRow err");
        }
        LOGGER.info("read data complete.");
        return this.readXlsTempItems(sheet, row);
    }

    private LinkedList<String> readXlsTempItems(Sheet modelSheet, int row) {
        LinkedList<String> xlsItems = new LinkedList<String>();
        int rows = modelSheet.getLastRowNum() + 1;
        if (row < rows || row > 0) {
            Row rowData = modelSheet.getRow(row);
            for (Cell cell : rowData) {
                xlsItems.add(POIUtils.getStringCellValue(cell));
            }
        }
        return xlsItems;
    }

    private HSSFWorkbook getXlsTempWorkbook(InputStream inputStream) throws ToolException {
        try {
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(inputStream);
            return hSSFWorkbook;
        }
        catch (IOException e) {
            LOGGER.error("create workbook error.");
            throw new ToolException("create workbook error.", (Throwable)e);
        }
        catch (Exception e) {
            throw new ToolException("create workbook error.", (Throwable)e);
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.info("inputStream close err");
                }
            }
        }
    }

    private InputStream getXlsTemplateIs(String path) throws ToolException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(FilePathUtils.checkFile((String)path));
        }
        catch (FileNotFoundException e) {
            LOGGER.error("can not find the excel file.");
        }
        if (null == inputStream) {
            throw new ToolException("can't find the excel file.");
        }
        return inputStream;
    }

    private Sheet getSheet(HSSFWorkbook writeWorkbook, String sheetTitle) throws ToolException {
        HSSFSheet sheet = writeWorkbook.getSheet(sheetTitle);
        if (null == sheet) {
            throw new ToolException("The specfic sheet does not exist.");
        }
        return sheet;
    }
}

