/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.service;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.excel.POIUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;

public class XlsWriter {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(XlsWriter.class);
    private static final Object XLS_WRITER_LOCK = new Object();
    private static XlsWriter instance = null;
    private static HSSFCellStyle titleStyle = null;
    private static HSSFCellStyle contentStyle = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XlsWriter getInstance() {
        Object object = XLS_WRITER_LOCK;
        synchronized (object) {
            if (null == instance) {
                instance = new XlsWriter();
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveXlsReport(File saveFile, Map<String, List<LinkedList<String>>> reportDatas) throws ToolException {
        Object object = XLS_WRITER_LOCK;
        synchronized (object) {
            if (saveFile.isDirectory()) {
                throw new ToolException("The savefile is a directory, not file.");
            }
            if (!saveFile.getParentFile().exists() && !saveFile.getParentFile().mkdirs()) {
                throw new ToolException("create directory failed.");
            }
            LOGGER.info("begin to write data to excel.");
            OutputStream outputStream = null;
            HSSFWorkbook writeWorkBook = null;
            try {
                outputStream = this.getXlsFos(saveFile);
                writeWorkBook = new HSSFWorkbook();
                this.initFontAndStyle(writeWorkBook);
                if (reportDatas.containsKey("HostReport")) {
                    this.saveColItem2Sheet(writeWorkBook, this.createSheet(writeWorkBook, "HostReport", 0), reportDatas.get("HostReport"), false);
                }
                if (reportDatas.containsKey("DatabaseReport")) {
                    this.saveColItem2Sheet(writeWorkBook, this.createSheet(writeWorkBook, "DatabaseReport", 0), reportDatas.get("DatabaseReport"), false);
                }
                if (reportDatas.containsKey("SwitchReport")) {
                    this.saveColItem2Sheet(writeWorkBook, this.createSheet(writeWorkBook, "SwitchReport", 0), reportDatas.get("SwitchReport"), false);
                }
                if (reportDatas.containsKey("overlengthInfo")) {
                    this.saveColItem2Sheet(writeWorkBook, this.createSheet(writeWorkBook, "overlengthInfo", 0), reportDatas.get("overlengthInfo"), true);
                }
                this.writeXls(writeWorkBook, outputStream);
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, writeWorkBook);
                StreamUtils.closeStream(outputStream, null);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)writeWorkBook);
            StreamUtils.closeStream(outputStream, null);
        }
    }

    public void saveColItem2Sheet(HSSFWorkbook workbook, Sheet sheet, List<LinkedList<String>> xlsReportData, boolean createTitle) throws ToolException {
        int rowIndex = 0;
        try {
            this.initFontAndStyle(workbook);
            for (LinkedList<String> linkedList : xlsReportData) {
                int colIndex = 0;
                if (!createTitle) {
                    for (String item : linkedList) {
                        sheet.setColumnWidth(colIndex, 3840);
                        POIUtils.setCellValue(sheet, rowIndex, colIndex, item, titleStyle);
                        ++colIndex;
                    }
                    createTitle = true;
                } else {
                    for (String item : linkedList) {
                        sheet.setColumnWidth(colIndex, 3840);
                        POIUtils.setCellValue(sheet, rowIndex, colIndex, item, contentStyle);
                        ++colIndex;
                    }
                }
                ++rowIndex;
            }
        }
        catch (Exception e) {
            LOGGER.error("add cell to sheet error");
            throw new ToolException("write data to sheet error.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateXlsRow(String path, List<String> dataList) {
        block7: {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            HSSFWorkbook workbook = null;
            try {
                fis = new FileInputStream(path);
                workbook = new HSSFWorkbook((InputStream)fis);
                this.initFontAndStyle(workbook);
                if (null != workbook) {
                    HSSFSheet sheet = workbook.getSheet("data");
                    if (null != sheet) {
                        this.sheetSetData(dataList, (Sheet)sheet, contentStyle);
                    }
                    fos = new FileOutputStream(path);
                    workbook.write((OutputStream)fos);
                }
                StreamUtils.closeResource(null, (Closeable)workbook);
            }
            catch (IOException e) {
                LOGGER.info("write data to excel error.");
                break block7;
            }
            finally {
                StreamUtils.closeResource(null, workbook);
                StreamUtils.closeStream(fos, fis);
            }
            StreamUtils.closeStream(fos, fis);
        }
    }

    private void sheetSetData(List<String> dataList, Sheet sheet, HSSFCellStyle style) {
        int colIndex = 0;
        for (String data : dataList) {
            sheet.setColumnWidth(colIndex, 3840);
            POIUtils.setCellValue(sheet, 1, colIndex, data, style);
            ++colIndex;
        }
    }

    private void writeXls(HSSFWorkbook writeWorkBook, OutputStream outputStream) {
        try {
            if (null != writeWorkBook) {
                writeWorkBook.write(outputStream);
            }
        }
        catch (IOException e) {
            LOGGER.error("Writable Workbook write error.");
        }
    }

    private Sheet createSheet(HSSFWorkbook writeWork, String sheetTitle, int index) {
        HSSFSheet writeableSheet = writeWork.createSheet(sheetTitle);
        return writeableSheet;
    }

    private OutputStream getXlsFos(File savefile) throws ToolException {
        String filePath = ToolUtils.getCanonicalFilePath(savefile);
        savefile = ToolUtils.getCanonicalFile(filePath);
        OutputStream out = null;
        try {
            out = this.checkFile(savefile);
        }
        catch (IOException e) {
            throw new ToolException("create outputstream failed.", (Throwable)e);
        }
        return out;
    }

    private OutputStream checkFile(File savefile) throws ToolException, IOException {
        File file = savefile.getParentFile();
        if (!file.exists() && !file.mkdirs()) {
            throw new ToolException("mk dir failed.");
        }
        if (savefile.exists() && !savefile.delete()) {
            throw new ToolException("savefile already exists.");
        }
        if (!savefile.createNewFile()) {
            throw new ToolException("cannot create new file.");
        }
        return new FileOutputStream(FilePathUtils.checkFile((File)savefile));
    }

    private void initFontAndStyle(HSSFWorkbook book) {
        titleStyle = POIUtils.createTitleStyle(book);
        contentStyle = POIUtils.createContentStyle(book);
        contentStyle.setWrapText(false);
    }
}

