/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.service.migration;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.infograb.context.CollectStatusEnum;
import com.huawei.ism.tool.infograb.context.ItemResultEnum;
import com.huawei.ism.tool.infograb.entity.CollectItem;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.exception.GenerateReportException;
import com.huawei.ism.tool.infograb.intf.worktaker.IGrabRefreshUI;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabFileFactory;
import com.huawei.ism.tool.infograb.parser.MigrationParse;
import com.huawei.ism.tool.infograb.service.InfoGrabService;
import com.huawei.ism.tool.infograb.service.XlsNetAppWriter;
import com.huawei.ism.tool.infograb.utils.DeviceModelChecker;
import com.huawei.ism.tool.infograb.utils.InfograbConstants;
import com.huawei.ism.tool.infograb.utils.migration.MigrationUtils;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.tool.pyengine.utils.PyJavaUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NasParseService {
    private static final Logger log = LoggerFactory.getLogger(NasParseService.class);
    private final String scriptDir;
    private final GrabDevNode2 node;
    private InfoGrabService grabService;
    private IGrabRefreshUI uiListener;
    private String txtFilePath = "";
    private String reportDir = "";

    public NasParseService(GrabDevNode2 devNode, InfoGrabService grabService, IGrabRefreshUI uiListener) {
        this(devNode);
        this.grabService = grabService;
        this.uiListener = uiListener;
    }

    public NasParseService(GrabDevNode2 devNode) {
        this.node = devNode;
        this.scriptDir = this.getScriptDirPath(devNode);
    }

    private String getScriptDirPath(GrabDevNode2 devNode) {
        return "script" + File.separator + "storages" + File.separator + devNode.getDeviceName() + File.separator;
    }

    public void doDataParse(List<ExecuteResult> currResultList) {
        this.txtFilePath = GrabFileFactory.getInstance().getTxtFile(currResultList).toString();
        this.reportDir = new File(this.txtFilePath).getParent();
        ExecuteResult currExecuteResult = currResultList.get(currResultList.size() - 1);
        currExecuteResult.setCurItemProgress(100);
        currExecuteResult.setExecuteEndTime();
        if (this.supportDataParse()) {
            this.grabService.fillOneResultByNode(this.node, currExecuteResult);
            this.uiListener.updateItemProgress(this.node);
            this.parse();
        } else {
            currExecuteResult.setProgress(100);
            currExecuteResult.setCurItemProgress(100);
            currExecuteResult.setNowStatus(CollectStatusEnum.COLLECT_SUCC);
            currExecuteResult.setCheckResult(ResourceUtil.getString((String)"infograb.complete"));
            this.node.setCollectDone(true);
            this.grabService.fillOneResultByNode(this.node, currExecuteResult);
            this.uiListener.updateItemProgress(this.node);
            this.handleItemStatus(currExecuteResult);
        }
    }

    private void parse() {
        ExecuteResult nasParseItem = new ExecuteResult();
        MigrationUtils.setNasParseItem(nasParseItem, this.node, this.grabService, this.uiListener);
        this.generateReport();
        this.setEndParse(nasParseItem);
    }

    public void generateReport() {
        try {
            Map<String, List<List<String>>> data = this.getReportData();
            File excelSavaFile = this.getExcelSavaFile();
            new XlsNetAppWriter(excelSavaFile, data, this.node.getDeviceModel()).saveXlsReport();
        }
        catch (Exception e) {
            log.error("fail to generate nas excel.", (Throwable)e);
        }
    }

    File getExcelSavaFile() {
        if (DeviceModelChecker.isHuaweiDevice(this.node.getDeviceModel())) {
            return FileUtils.getFile((String[])new String[]{this.reportDir, "Summary_" + System.currentTimeMillis() + ".xls"});
        }
        if (DeviceModelChecker.isNetAppDevice(this.node.getDeviceModel())) {
            return FileUtils.getFile((String[])new String[]{this.node.getDevInfoPkgPath(), "Summary_" + System.currentTimeMillis() + ".xls"});
        }
        if (DeviceModelChecker.isIsilonDevice(this.node.getDeviceModel())) {
            return FileUtils.getFile((String[])new String[]{this.reportDir, "Summary_" + System.currentTimeMillis() + ".xls"});
        }
        throw new GenerateReportException("unsupported device type for NAS: " + this.node.getDeviceModel());
    }

    private void setEndParse(ExecuteResult nasParseItem) {
        nasParseItem.setProgress(100);
        nasParseItem.setCureItemCollecting(false);
        nasParseItem.setItemResultEnum(ItemResultEnum.SUCCESS);
        nasParseItem.setNowStatus(CollectStatusEnum.COLLECT_SUCC);
        nasParseItem.setCheckResult(ResourceUtil.getString((String)"infograb.complete"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("err_msg", ResourceUtil.getString((String)"infograb.grabThread.collectsuccess"));
        nasParseItem.setResultMap(map);
        nasParseItem.setCurItemProgress(100);
        nasParseItem.setExecuteEndTime();
        this.node.setCollectDone(true);
        this.grabService.fillOneResultByNode(this.node, nasParseItem);
        this.uiListener.updateItemProgress(this.node);
        this.handleItemStatus(nasParseItem);
    }

    private boolean supportDataParse() {
        return DeviceModelChecker.isNetAppDevice(this.node.getDeviceModel()) || DeviceModelChecker.isHuaweiDevice(this.node.getDeviceModel()) || DeviceModelChecker.isIsilonDevice(this.node.getDeviceModel());
    }

    private void handleItemStatus(ExecuteResult currExecuteResult) {
        ArrayList<ExecuteResult> currExecuteResultList = new ArrayList<ExecuteResult>();
        currExecuteResultList.add(currExecuteResult);
        this.uiListener.refreshPregress(currExecuteResultList);
        this.uiListener.collectCallback(currExecuteResult.getDevNode());
        ConnUtils.sleep(30);
    }

    private Map<String, List<List<String>>> getReportData() {
        log.info("begin to parse data.");
        List<CollectItem> hostCollection = MigrationParse.getStorageCollections(this.node.getDeviceModel());
        HashMap<String, List<List<String>>> result = new HashMap<String, List<List<String>>>();
        hostCollection.forEach(item -> this.setOneParseResult(item.getItemName(), new File(this.scriptDir, item.getScriptName()), result));
        log.info("success to parse data.");
        return result;
    }

    private void setOneParseResult(String itemName, File file, Map<String, List<List<String>>> result) {
        List<List<String>> data = this.callMigScriptData(file, this.node);
        if (!data.isEmpty()) {
            result.put(itemName, data);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getInnerDataPath(GrabDevNode2 devNode) {
        String ipPathName = devNode.getIp().replace(".", "_");
        try (Stream<Path> dirList = Files.list(Paths.get(devNode.getDevInfoPkgPath(), devNode.getItDeviceType().getName()));){
            String string = dirList.filter(path -> path.toString().contains(ipPathName)).findFirst().map(Path::toAbsolutePath).map(Path::toString).orElse(devNode.getDevInfoPkgPath());
            return string;
        }
        catch (IOException e) {
            log.error("Cannot find dir {}", (Object)devNode.getItDeviceType().getName());
            return devNode.getDevInfoPkgPath();
        }
    }

    private List<List<String>> callMigScriptData(File scriptFile, GrabDevNode2 devNode) {
        log.info("execute script {}", (Object)scriptFile.getName());
        HashMap<String, Object> context = new HashMap<String, Object>();
        HashMap retMap = new HashMap();
        context.put("Logger", log);
        context.put("net_app_report_path", this.getInnerDataPath(devNode));
        context.put("map", retMap);
        context.put("ip", devNode.getIp());
        context.put("dev_type", devNode.getStorageDeviceType().getName());
        context.put("dev_vendor", devNode.getDeviceName());
        context.put("dev_model", devNode.getDeviceModel());
        context.put("path", this.txtFilePath);
        try {
            JythonExecuter jythonExecuter = new JythonExecuter(new File(InfograbConstants.SCRIPT_ROOT_PATH));
            jythonExecuter.compileScript(scriptFile);
            jythonExecuter.simpleInvokeFunction("execute", context);
            return this.convert2JavaList(retMap.get("data"));
        }
        catch (SignException e) {
            log.error("execute script error signException", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.error("execute {} script error fileNotFound Exception", (Object)scriptFile.getName());
        }
        catch (ToolException e) {
            log.error("python error", (Throwable)e);
        }
        catch (Exception e) {
            log.error("execute script error Tool Exception", (Throwable)e);
        }
        return Collections.emptyList();
    }

    private List<List<String>> convert2JavaList(Object pyList) {
        return PyJavaUtils.convertPyList2Jlist((Object)pyList).stream().map(this::convertPyList2JavaList).collect(Collectors.toList());
    }

    private List<String> convertPyList2JavaList(Object pyList) {
        return PyJavaUtils.convertPyList2Jlist((Object)pyList);
    }

    void setReportDir(String reportDir) {
        this.reportDir = reportDir;
    }
}

