/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.swing;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.devicemanager.entity.Launcher;
import com.huawei.ism.tool.devicemanager.service.DebugCheck;
import com.huawei.ism.tool.devicemanager.service.DeveloperModeCheck;
import com.huawei.ism.tool.devicemanager.service.PeerIPGainer;
import com.huawei.ism.tool.devicemanager.service.host.HostService;
import com.huawei.ism.tool.devicemanager.service.host.HostServiceFactory;
import com.huawei.ism.tool.devicemanager.utils.ModeTypeParse;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.entity.DevServicePkg;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.User;
import com.huawei.ism.tool.framework.pubservice.entity.enums.NodeAddEnum;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.infograb.connection.DbConnection;
import com.huawei.ism.tool.infograb.connection.DbConnectionManager;
import com.huawei.ism.tool.infograb.connection.FileConnectionGrab;
import com.huawei.ism.tool.infograb.connection.SshConnectionHelper;
import com.huawei.ism.tool.infograb.connection.StorageConnectionManager;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.DBCmdResultSet;
import com.huawei.ism.tool.infograb.entity.DatabaseType;
import com.huawei.ism.tool.infograb.entity.GrabDevNode1;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.swing.DeviceContext;
import com.huawei.ism.tool.infograb.swing.INodeTypeQuery;
import com.huawei.ism.tool.infograb.utils.DeviceModelChecker;
import com.huawei.ism.tool.infograb.utils.InfograbConstants;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.infograb.utils.migration.MigrationUtils;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.IGrabCliConnection;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.win.WmicConnection;
import com.huawei.ism.tool.obase.connection.win.WmicConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.PwdException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.CliResolverUtils;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNodeTypeQuery
implements INodeTypeQuery {
    private static final String PATH_NOT_FIND = "The system cannot find the path specified.";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultNodeTypeQuery.class);
    private static final String PRODUCT_SUPPORT_PAKAGE = "productSuportPkgPath";
    private static final String DEFAULT_PAKAGE_PATH = ApplicationContext.getInstance().getWorkPath() + File.separator + "packages" + File.separator + "toolkit";
    private static final String RPC_SERVICE_NOTOK = "ERROR";
    private final List<String> queryInfoCmds = new ArrayList<String>();
    private final List<com.huawei.ism.tool.obase.entity.DeviceType> supportDevTypes = new ArrayList<com.huawei.ism.tool.obase.entity.DeviceType>();

    public DefaultNodeTypeQuery(List<com.huawei.ism.tool.obase.entity.DeviceType> supportDevTypes, String ... queryInfoCmds) {
        if (null != supportDevTypes) {
            this.supportDevTypes.addAll(supportDevTypes);
        }
        if (null != queryInfoCmds) {
            this.queryInfoCmds.addAll(Arrays.asList(queryInfoCmds));
        }
    }

    public DefaultNodeTypeQuery(List<com.huawei.ism.tool.obase.entity.DeviceType> supportDevTypes, INodeSupport nodeSupport, String ... queryInfoCmds) {
        this(supportDevTypes, queryInfoCmds);
        LOGGER.info("INodeSupport null check is {}", (Object)(nodeSupport == null ? 1 : 0));
    }

    public IGrabCliConnection getDbOrHostConnection(DevNode devNode) throws ToolException {
        if (this.isDbDevice(devNode)) {
            return DbConnectionManager.getDbConnection(devNode);
        }
        if (this.isWindowsHost(devNode)) {
            WmicConnection conn = new WmicConnection(devNode.getIp(), devNode.getLoginUser());
            WmicConnectionManager.cacheWmicConnection(devNode, conn);
            return conn;
        }
        return DefaultNodeTypeQuery.getSshConnection(devNode);
    }

    private static IGrabCliConnection getSshConnection(DevNode devNode) throws ToolException {
        return (IGrabCliConnection)SshConnectionHelper.getSshConnection(devNode);
    }

    protected boolean isUseForward(GrabDevNode1 devNode) {
        return !devNode.isNotSshForward() || !devNode.isNotSocks5Proxy();
    }

    protected void checkHostReachAble(GrabDevNode1 devNode) throws ToolException {
        if (!this.isUseForward(devNode) && !NetUtil.isHostCanConnect(devNode.getIp(), devNode.getPort(), 10)) {
            throw new ToolException("ssh.connect.timed.out", new String[]{devNode.getIp()});
        }
    }

    protected void checkHostReachAble(DevNode devNode) throws ToolException {
        if (!this.isUseForward(devNode) && !NetUtil.isHostCanConnect(devNode.getIp(), devNode.getPort(), 5)) {
            throw new ToolException("ssh.connect.timed.out", new String[]{devNode.getIp()});
        }
    }

    protected boolean isUseForward(DevNode devNode) {
        return !devNode.isNotSshForward() || !devNode.isNotSocks5Proxy();
    }

    /*
     * Exception decompiling
     */
    @Override
    public TaskResult queryNodeInfo(GrabDevNode1 devNode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TaskResult checkToolException(TaskResult ret, ToolException e) {
        ToolLoggerFactory.getLogger(this.getClass()).error("DefaultNodeTypeQuery.queryNodeInfo() error unknow.");
        ret.setErrorLocaleDescription(e.getErrorLocaleDescription());
        ret.setResult(TaskResult.Result.FAILED);
        return ret;
    }

    private TaskResult checkPwdException(TaskResult ret, PwdException e) {
        ToolLoggerFactory.getLogger(this.getClass()).error("DefaultNodeTypeQuery.queryNodeInfo() pwd error.");
        ret.setErrorLocaleDescription(e.getErrorMsg());
        ret.setErrorId("devicemanager.layout.device.add.deviceadddialog.PWD_EXCEPTION");
        ret.setResult(TaskResult.Result.FAILED);
        return ret;
    }

    private boolean checkGrabDevice(GrabDevNode1 devNode, TaskResult ret, IGrabCliConnection con) throws ToolException {
        HostService hostService;
        if (!TaskResult.Result.SUCCESS.equals((Object)ret.getResult())) {
            return true;
        }
        if (!this.isDbDevice(devNode) && (devNode.isRootPwCheck() || devNode.isSwitchRoot())) {
            GrabDevNode2 devNodeTwo = new GrabDevNode2();
            User adminUser = devNode.getAdminUser();
            devNodeTwo.setDevTypeLevel2(DeviceType.valueOf((String)devNode.getDevTypeLevel2().toString()));
            devNodeTwo.setRootUser(adminUser);
            con.execSwitchRootCmd(devNodeTwo);
            String currentName = con.execCmd("whoami");
            if (SshConnection.isSwitchRoot(currentName)) {
                ret.setResult(TaskResult.Result.SUCCESS);
                GrabContext.getInstance().getAdminNameAndPassMap().put(devNode.getIp(), adminUser);
            } else {
                ret.setResult(TaskResult.Result.FAILED);
                if (SshConnection.checkWhoAmICommond(currentName)) {
                    ret.setErrorLocaleDescription(ResourceUtil.getString((String)"infograb.check.whoami.error"));
                } else {
                    ret.setErrorLocaleDescription(ResourceUtil.getString((String)"infograb.switchroot.passwd.error"));
                }
            }
        }
        if (null != (hostService = HostServiceFactory.createHostService((DevNode)devNode))) {
            Launcher launcher = hostService.queryWwn((ICliConnection)con, (DevNode)devNode);
            LOGGER.info("launcher :{} devKey:{}", (Object)launcher, (Object)devNode.getDevKey());
            GrabContext.getInstance().getLauncherMap().put(devNode.getDevKey(), launcher);
        }
        return false;
    }

    private void saveDevImportType(GrabDevNode1 devNode) {
        GrabContext context = GrabContext.getInstance();
        Map<String, String> devOffAndOnLine = context.getDevOffAndOnLineMap();
        NodeAddEnum type = devNode.getNodeAddType();
        switch (type) {
            case ONLINE: {
                devOffAndOnLine.put(devNode.getIp(), NodeAddEnum.ONLINE.toString());
                break;
            }
            case GRAB_PKG: {
                devOffAndOnLine.put(devNode.getIp(), NodeAddEnum.GRAB_PKG.toString());
                break;
            }
            case GRAB_FILE: {
                devOffAndOnLine.put(devNode.getIp(), NodeAddEnum.GRAB_FILE.toString());
                break;
            }
            case COLLECT_FILE: {
                devOffAndOnLine.put(devNode.getIp(), NodeAddEnum.COLLECT_FILE.toString());
                break;
            }
        }
    }

    private IGrabCliConnection createConnection(GrabDevNode1 devNode) throws ToolException {
        IGrabCliConnection con = null;
        if (devNode.isFileNode()) {
            con = new FileConnectionGrab(devNode);
            return con;
        }
        if (this.isDbDevice(devNode) || this.isWindowsHost(devNode) || this.isHostDevice(devNode)) {
            con = this.getDbOrHostConnection(devNode);
        } else if (this.isSwitchDevice(devNode)) {
            con = DefaultNodeTypeQuery.getSshConnection(devNode);
        } else if (this.isStorageDevice(devNode)) {
            con = this.setGrabConnForStorage(devNode);
        }
        return con;
    }

    private TaskResult checkDebugPwd(GrabDevNode1 devNode, TaskResult ret, IGrabCliConnection con) {
        if (!com.huawei.ism.tool.obase.entity.DeviceType.N8000.equals(devNode.getDeviceType()) && !ItDeviceType.Host.equals((Object)devNode.getItDeviceType())) {
            String debugPwd = devNode.getDeveloperPwd();
            if (!StringUtils.isNULLStr(debugPwd)) {
                ret = DeveloperModeCheck.checkDeveloperPwd((ICliConnection)con, (DevNode)devNode);
            }
            if (!StringUtils.isNULLStr(debugPwd) && !TaskResult.Result.SUCCESS.equals((Object)ret.getResult())) {
                ret = DebugCheck.checkDebugPwd((ICliConnection)con, (DevNode)devNode);
            }
            com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)debugPwd);
        }
        return ret;
    }

    private IGrabCliConnection setGrabConnForStorage(GrabDevNode1 devNode) throws ToolException {
        if ("VNX_SAN".equalsIgnoreCase(devNode.getDeviceModel())) {
            return StorageConnectionManager.getStorageConnection(devNode);
        }
        if (DeviceModelChecker.isGrabByRest(devNode.getDeviceModel())) {
            return StorageConnectionManager.getStorageRestConnection(devNode);
        }
        return DefaultNodeTypeQuery.getSshConnection(devNode);
    }

    private TaskResult queryDeviceShowInfo(GrabDevNode1 devNode, TaskResult ret, IGrabCliConnection con) throws ToolException {
        if (this.isHostDevice(devNode)) {
            if (this.isWindowsHost(devNode)) {
                return this.dealWindowsNodeInfo(devNode, con);
            }
            return this.dealNewNodeInfo(devNode, con);
        }
        if (this.isDbDevice(devNode)) {
            return this.dealDbNodeInfo(devNode, con);
        }
        if (this.isSwitchDevice(devNode)) {
            return this.dealSwitchNodeInfo(devNode, con);
        }
        if (this.isStorageDevice(devNode)) {
            if ("VNX_SAN".equalsIgnoreCase(devNode.getDeviceModel())) {
                return this.dealHeteroStorageNodeInfo(devNode);
            }
            return this.dealNewNodeInfo(devNode, con);
        }
        String cliResult = "";
        for (String cmd : this.queryInfoCmds) {
            cliResult = con.execCmdWithTimout(cmd, 30);
            if (this.isOtherPorductCLIResultInValid(cliResult) || this.isCLIResultInValid(cliResult) || !this.isContainXVEModel(cliResult)) continue;
            TaskResult deviceRet = this.dealNodeInfo(devNode, cliResult);
            if (!StringUtils.isNULLStr(devNode.getProductVersion())) {
                ret = deviceRet;
                cliResult = "";
                break;
            }
            if (TaskResult.Result.SUCCESS == deviceRet.getResult()) {
                ret = deviceRet;
                cliResult = "";
                break;
            }
            ret = deviceRet;
        }
        if (!TaskResult.Result.SUCCESS.equals((Object)ret.getResult()) && StringUtils.isNULLStr(devNode.getProductVersion())) {
            return this.dealNewNodeInfo(devNode, con);
        }
        return ret;
    }

    private Set<String> getNotSupportCmds() {
        HashSet<String> notSupportComds = new HashSet<String>();
        List<DevServicePkg> desServicePkgs = DeviceContext.getDevServicePkgs();
        for (DevServicePkg desServicePkg : desServicePkgs) {
            List notSupportComd = desServicePkg.getNotSupportComd();
            for (String string : notSupportComd) {
                if (StringUtils.isNULLStr(string)) continue;
                notSupportComds.add(string);
            }
        }
        return notSupportComds;
    }

    private boolean getendingJudges(String type) {
        if (null != type) {
            List<DevServicePkg> desServicePkgs = DeviceContext.getDevServicePkgs();
            for (DevServicePkg desServicePkg : desServicePkgs) {
                String devType = desServicePkg.getDevType();
                if (!type.equals(devType)) continue;
                return desServicePkg.isMutilCtr();
            }
        }
        return false;
    }

    private String findProperPathByNode(DevNode devNode, String path) {
        if (this.isStorage(devNode)) {
            return path + File.separator + "storage";
        }
        return path + File.separator + (this.isHostDevice(devNode) ? "host" : "switch");
    }

    private String generateProperFileName(DevNode devNode) {
        String fileName = devNode.getDevTypeLevel2().toString();
        if ("EMC".equalsIgnoreCase(fileName)) {
            fileName = fileName + "_" + devNode.getDeviceModel();
        }
        return fileName.toLowerCase(Locale.ENGLISH) + ".py";
    }

    private TaskResult dealNewNodeInfo(GrabDevNode1 devNode, IGrabCliConnection con) {
        JythonExecuter executer = new JythonExecuter(new File(InfograbConstants.SCRIPT_PACKAGE_PATH));
        TaskResult ret = new TaskResult();
        if (this.checkSudoNoPassWord(devNode, con, ret)) {
            return ret;
        }
        File[] files = new File(this.findProperPathByNode(devNode, this.getSupportPkgPath())).listFiles();
        if (this.fileIsNull(ret, files)) {
            return ret;
        }
        Map nodeInfos = null;
        List<Object> ipLists = null;
        for (File scriptFile : this.getRightScriptFile(files, devNode)) {
            try {
                executer.compileScript(new File(this.getQueryPath(scriptFile), this.generateProperFileName(devNode)));
                if (this.isHostDevice(devNode) || this.isStorage(devNode)) {
                    Map<String, Object> context = this.getContextMap(devNode, con);
                    nodeInfos = (Map)executer.simpleInvokeFunction("execute", context);
                    break;
                }
                nodeInfos = (Map)executer.simpleInvokeFunction("execute", new Object[]{con});
                if (!this.checkResult(nodeInfos)) continue;
                String type = (String)nodeInfos.get("type");
                scriptFile = new File(this.getQueryPath(scriptFile), "queryctrips.py");
                ipLists = this.invokePythonFunction(con, executer, scriptFile, type);
                break;
            }
            catch (SignException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("py file switch or host execute filed!", (Throwable)e);
                this.makeErrorTaskResult(devNode, ret);
                return ret;
            }
            catch (FileNotFoundException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("py file {} not found!", (Object)scriptFile.getName());
                this.makeErrorTaskResult(devNode, ret);
                return ret;
            }
            catch (ToolException e) {
                return this.getTaskResult(devNode, ret, e, "py file not found!");
            }
        }
        if (null != nodeInfos) {
            this.addDevNodeInfo(devNode, nodeInfos, ipLists, ret);
        }
        return ret;
    }

    private List<File> getRightScriptFile(File[] files, GrabDevNode1 devNode) {
        return Arrays.stream(files).filter(file -> this.isRightScriptFile(devNode, (File)file)).collect(Collectors.toList());
    }

    private boolean isRightScriptFile(GrabDevNode1 devNode, File scriptFile) {
        if (!scriptFile.isDirectory()) {
            return false;
        }
        String queryPath = this.getQueryPath(scriptFile);
        if (queryPath == null) {
            return false;
        }
        File scriptFileTmp = new File(queryPath, this.generateProperFileName(devNode));
        return scriptFileTmp.exists();
    }

    private TaskResult getTaskResult(GrabDevNode1 devNode, TaskResult ret, ToolException exception, String str) {
        ToolLoggerFactory.getLogger(this.getClass()).error(str, (Throwable)exception);
        this.makeErrorTaskResult(devNode, ret);
        return ret;
    }

    private Map<String, Object> getContextMap(GrabDevNode1 devNode, IGrabCliConnection con) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("SSH", con);
        context.put("dev", devNode);
        context.put("Logger", LOGGER);
        return context;
    }

    private boolean checkSudoNoPassWord(GrabDevNode1 devNode, IGrabCliConnection con, TaskResult ret) {
        if (devNode.isSudoGrab() && !this.checkSudoNoPasswd(con)) {
            ret.setResult(TaskResult.Result.FAILED);
            ret.setErrorLocaleDescription(ResourceUtil.getString((String)"infograb.layout.device.add.deviceadddialog.need.sudo.nopasswd"));
            return true;
        }
        return false;
    }

    private boolean fileIsNull(TaskResult ret, File[] files) {
        if (null == files) {
            ret.setResult(TaskResult.Result.FAILED);
            ret.setErrorLocaleDescription(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.lose.file"));
            return true;
        }
        return false;
    }

    private String getQueryPath(File scriptFile) {
        String queryPath = "";
        try {
            queryPath = scriptFile.getCanonicalPath() + File.separator + "discovery";
        }
        catch (IOException e1) {
            ToolLoggerFactory.getLogger(this.getClass()).error("get script file error.");
            return null;
        }
        return queryPath;
    }

    private boolean checkSudoNoPasswd(IGrabCliConnection con) {
        try {
            String cmdRet = con.execCmdNoLogTimout("echo * | sudo -S -l", 60);
            LOGGER.info("excute cmd to confirm (root) NOPASSWD: is done");
            if (cmdRet.toUpperCase(Locale.ENGLISH).contains("(ROOT) NOPASSWD:")) {
                return true;
            }
        }
        catch (ToolException e) {
            LOGGER.error("excute cmd fail.", (Throwable)e);
            return false;
        }
        return false;
    }

    private String getSupportPkgPath() {
        Object supportPkgPath = HibernateContainer.getInstance().get(PRODUCT_SUPPORT_PAKAGE);
        if (null == supportPkgPath) {
            return DEFAULT_PAKAGE_PATH;
        }
        return String.valueOf(supportPkgPath);
    }

    private List<Object> invokePythonFunction(IGrabCliConnection con, JythonExecuter executer, File file, String type) throws FileNotFoundException, ToolException {
        List<Object> ipLists = new ArrayList<Object>();
        if (file.exists() && this.getendingJudges(type)) {
            executer.compileScript(file);
            ipLists = executer.invokeFunction("execute", new Object[]{con});
        }
        return ipLists;
    }

    private TaskResult dealSwitchNodeInfo(GrabDevNode1 devNode, IGrabCliConnection con) {
        JythonExecuter executerSwitch = new JythonExecuter();
        String pathSwitch = this.getSupportPkgPath();
        TaskResult retSwitch = new TaskResult();
        Map nodeInfosSwitch = null;
        List<Object> ipListsSwitch = null;
        File[] filesSwitch = new File(pathSwitch = this.findProperPathByNode(devNode, pathSwitch)).listFiles();
        if (this.fileIsNull(retSwitch, filesSwitch)) {
            return retSwitch;
        }
        for (File file : filesSwitch) {
            String queryPath;
            if (!file.isDirectory() || (queryPath = this.getQueryPath(file)) == null || !(file = new File(queryPath, this.generateProperFileName(devNode))).exists()) continue;
            try {
                executerSwitch.compileScript(file);
                if (this.isSwitchDevice(devNode)) {
                    HashMap<String, Object> contextSwitch = new HashMap<String, Object>();
                    contextSwitch.put("SSH", con);
                    contextSwitch.put("dev", devNode);
                    nodeInfosSwitch = (Map)executerSwitch.simpleInvokeFunction("execute", contextSwitch);
                    break;
                }
                nodeInfosSwitch = (Map)executerSwitch.simpleInvokeFunction("execute", new Object[]{con});
                if (!this.checkResult(nodeInfosSwitch)) continue;
                String type = (String)nodeInfosSwitch.get("type");
                file = new File(queryPath, "queryctrips.py");
                ipListsSwitch = this.invokePythonFunction(con, executerSwitch, file, type);
                break;
            }
            catch (SignException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("py file switch or host execute filed!", (Throwable)e);
                this.makeErrorTaskResult(devNode, retSwitch);
                return retSwitch;
            }
            catch (FileNotFoundException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("py file {} not found!", (Object)file.getName());
                this.makeErrorTaskResult(devNode, retSwitch);
                return retSwitch;
            }
            catch (ToolException e) {
                return this.getTaskResult(devNode, retSwitch, e, "py file not found!");
            }
        }
        if (null != nodeInfosSwitch) {
            this.addDevNodeInfo(devNode, nodeInfosSwitch, ipListsSwitch, retSwitch);
        }
        return retSwitch;
    }

    private TaskResult dealHeteroStorageNodeInfo(GrabDevNode1 devNode) {
        LOGGER.info("begin query EMC Device's info.");
        TaskResult ret = new TaskResult();
        String serialNum = "";
        String modelType = "";
        Process process = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader reader = null;
        if (this.checkCloseRes(devNode, ret, serialNum, modelType, process, inputStreamReader, reader)) {
            return ret;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCloseRes(GrabDevNode1 devNode, TaskResult ret, String serialNum, String modelType, Process process, InputStreamReader inputStreamReader, BufferedReader reader) {
        try {
            String cmdNavi = "naviseccli -h " + devNode.getIp() + " getagent";
            String[] cmds = new String[]{"cmd.exe", "/C", cmdNavi};
            ProcessBuilder pb = new ProcessBuilder(cmds);
            pb = pb.redirectErrorStream(true);
            process = pb.start();
            inputStreamReader = new InputStreamReader(process.getInputStream(), "GBK");
            reader = new BufferedReader(inputStreamReader);
            String line = null;
            StringBuilder cmcRetSb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                cmcRetSb.append(line);
                cmcRetSb.append(System.lineSeparator());
                if (line.endsWith("(The default selection is [1]):")) break;
                if ("".equals((line = Normalizer.normalize(line, Normalizer.Form.NFKC)).trim())) continue;
                if (line.trim().contains("Serial No:")) {
                    serialNum = Normalizer.normalize(line.trim(), Normalizer.Form.NFKC);
                    continue;
                }
                if (!line.trim().contains("Model:")) continue;
                modelType = Normalizer.normalize(line.trim(), Normalizer.Form.NFKC);
            }
            if (this.checkDeviceType(devNode, ret, serialNum, modelType, cmcRetSb)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("emc connect storage array error", (Throwable)e);
            this.makeErrorTaskResult(devNode, ret);
            boolean bl = true;
            return bl;
        }
        finally {
            this.checkCloseResource(process, inputStreamReader, reader);
        }
        return false;
    }

    private void checkCloseResource(Process process, InputStreamReader inputStreamReader, BufferedReader reader) {
        StreamUtils.closeResource(null, (Closeable)reader);
        StreamUtils.closeResource(null, (Closeable)inputStreamReader);
        if (null != process) {
            process.destroy();
        }
    }

    private boolean checkDeviceType(GrabDevNode1 devNode, TaskResult ret, String serialNum, String modelType, StringBuilder cmcRetSb) {
        LOGGER.info("cmdNavi Ret = {}{}", (Object)System.lineSeparator(), (Object)cmcRetSb.toString());
        if ("".equals(serialNum) || "".equals(modelType)) {
            ToolLoggerFactory.getLogger(this.getClass()).error("Failed to excute naviCli cmd!");
            this.makeStorageErrorTaskResult(devNode, ret);
            return true;
        }
        String[] serialStrs = serialNum.split(" ");
        String[] modelStrs = modelType.split(" ");
        serialNum = serialStrs[serialStrs.length - 1].trim();
        modelType = modelStrs[modelStrs.length - 1].trim();
        devNode.setDeviceType(com.huawei.ism.tool.obase.entity.DeviceType.valueOf(modelType));
        devNode.setDeviceName(devNode.getDevTypeLevel2().toString());
        devNode.setDeviceSerialNumber(serialNum.toUpperCase(Locale.US));
        devNode.setProductVersion("");
        ret.setResult(TaskResult.Result.SUCCESS);
        ret.setErrorLocaleDescription("");
        ret.setResultObject(devNode);
        return false;
    }

    private TaskResult dealWindowsNodeInfo(GrabDevNode1 devNode, IGrabCliConnection con) {
        TaskResult ret = new TaskResult();
        try {
            String[] resultVerArray;
            String[] resultMacArray;
            String cmdIPAdd = "wmic NICCONFIG get ipaddress";
            String cmdMac = "wmic NICCONFIG get macaddress";
            String cmdVer = "wmic OS get name";
            String resultIPAdd = Normalizer.normalize(con.execCmd(cmdIPAdd), Normalizer.Form.NFKC);
            String resultMac = Normalizer.normalize(con.execCmd(cmdMac), Normalizer.Form.NFKC);
            this.fillIpMacOnManualGrab(devNode, resultIPAdd, resultMac);
            String resultVer = Normalizer.normalize(con.execCmd(cmdVer), Normalizer.Form.NFKC);
            LOGGER.info("resultIPAdd = {}{}", (Object)System.lineSeparator(), (Object)resultIPAdd);
            LOGGER.info("resultMac = {}{}", (Object)System.lineSeparator(), (Object)resultMac);
            LOGGER.info("resultVer = {}{}", (Object)System.lineSeparator(), (Object)resultVer);
            if (NodeAddEnum.ONLINE.equals((Object)devNode.getNodeAddType()) && con instanceof WmicConnection && !((WmicConnection)con).isLocalSupportWmic()) {
                String errorDes = ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.wmic.not.found");
                ret.setErrorLocaleDescription(errorDes);
                ret.setResult(TaskResult.Result.FAILED);
                LOGGER.info("Local Not Support.");
                return ret;
            }
            if (resultMac.contains("TOOLKIT_EXE_CMD_FAILED") || resultIPAdd.contains("TOOLKIT_EXE_CMD_FAILED") || resultVer.contains("TOOLKIT_EXE_CMD_FAILED") || resultVer.contains(RPC_SERVICE_NOTOK) || resultVer.contains(PATH_NOT_FIND) || resultVer.contains(RPC_SERVICE_NOTOK.toLowerCase(Locale.ENGLISH))) {
                ToolLoggerFactory.getLogger(this.getClass()).error("Failed to excute wmic cmd!");
                this.makeWindowsErrorTaskResult(devNode, ret);
                return ret;
            }
            String[] resultIPAddArray = resultIPAdd.split("\r\n");
            if (this.checkResultMac(devNode, con, ret, resultVer, resultIPAddArray, resultMacArray = resultMac.split("\r\n"), resultVerArray = resultVer.split("\r\n"))) {
                return ret;
            }
        }
        catch (ToolException e) {
            return this.getTaskResult(devNode, ret, e, "execute cmd error.");
        }
        return ret;
    }

    private boolean checkResultMac(GrabDevNode1 devNode, IGrabCliConnection con, TaskResult ret, String resultVer, String[] resultIPAddArray, String[] resultMacArray, String[] resultVerArray) throws ToolException {
        int i;
        int ipIndex = 0;
        for (i = 1; i < resultIPAddArray.length; ++i) {
            if (!resultIPAddArray[i].contains(devNode.getIp())) continue;
            ipIndex = i;
            break;
        }
        String resultMac = resultMacArray[ipIndex];
        resultMac = resultMac.trim().replace(":", "");
        for (i = 0; i < resultVerArray.length; ++i) {
            if (!resultVerArray[i].contains("Microsoft")) continue;
            resultVer = resultVerArray[i].split("\\|")[0].trim().replace("?", "");
            resultVer = "Windows" + resultVer.split("Windows")[1];
            resultVer = resultVer.replace("Serverr", "Server");
            break;
        }
        return this.checkPaexeConnection(devNode, con, ret, resultMac, resultVer);
    }

    private boolean checkPaexeConnection(GrabDevNode1 devNode, IGrabCliConnection con, TaskResult ret, String resultMac, String resultVer) throws ToolException {
        if (NodeAddEnum.ONLINE.equals((Object)devNode.getNodeAddType()) && con instanceof WmicConnection) {
            if (((WmicConnection)con).getPaexecConnection().isGrabLocalHost()) {
                LOGGER.info("The is local host.Does not involve PAE connection");
            } else if (!((WmicConnection)con).getPaexecConnection().getMappedWwmicConn().isCanRemoteExecCmd().booleanValue()) {
                String errorDes = ResourceUtil.getString((String)"infograb.collect.windows.connection.warning.adddvice.desc");
                ret.setErrorLocaleDescription(errorDes);
                ret.setResult(TaskResult.Result.FAILED);
                LOGGER.info("The windows pae connection is error.");
                return true;
            }
        }
        devNode.setDeviceType(com.huawei.ism.tool.obase.entity.DeviceType.valueOf(resultVer));
        devNode.setDeviceName("Windows");
        devNode.setDeviceNameAlias(this.getHostName(con));
        String macStr = org.apache.commons.lang3.StringUtils.remove((String)resultMac, (String)"-");
        if (StringUtils.isNULLStr(devNode.getDeviceSerialNumber())) {
            devNode.setDeviceSerialNumber(devNode.getIp().replace(".", "") + macStr);
        }
        devNode.setProductVersion("");
        ret.setResult(TaskResult.Result.SUCCESS);
        ret.setErrorLocaleDescription("");
        ret.setResultObject(devNode);
        return false;
    }

    private void fillIpMacOnManualGrab(GrabDevNode1 devNode, String cmdMac, String resultMac) {
        if (!StringUtils.isNULLStr(devNode.getIp())) {
            return;
        }
        StringBuilder ips = new StringBuilder();
        StringBuilder sn = new StringBuilder();
        Pattern pat = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
        Matcher mat = pat.matcher(cmdMac);
        for (String mac : resultMac.split(System.lineSeparator())) {
            if (StringUtils.isNULLStr(mac.trim()) || mac.split(":").length <= 5) continue;
            sn.append(mac.trim().replace(":", ""));
        }
        while (mat.find()) {
            String result = mat.group();
            if (StringUtils.isNULLStr(result)) continue;
            ips.append(result).append(',');
            break;
        }
        if (ips.length() > 0) {
            devNode.setIp(ips.substring(0, ips.length() - 1));
            devNode.setDeviceSerialNumber(sn.toString());
        }
    }

    public String getHostName(ICliConnection con) throws ToolException {
        String ret = con.execCmd("wmic os get csname");
        String[] retLines = ret.split(System.lineSeparator());
        int infoLastLineIndex = retLines.length - 1;
        if (infoLastLineIndex > 0) {
            --infoLastLineIndex;
        }
        for (int i = infoLastLineIndex; i >= 0; --i) {
            if (StringUtils.isNULLStr(retLines[i])) continue;
            return retLines[i].trim();
        }
        return "";
    }

    private TaskResult dealDbNodeInfo(GrabDevNode1 devNode, IGrabCliConnection con) {
        TaskResult ret = new TaskResult();
        try {
            StringBuilder ipSerialSb = new StringBuilder().append(Long.toHexString(Long.parseLong(org.apache.commons.lang3.StringUtils.remove((String)devNode.getIp(), (char)'.'))).toUpperCase(Locale.US));
            devNode.setDeviceType(this.createDevTypeSN(devNode, ipSerialSb, con));
            devNode.setDeviceName(devNode.getDevTypeLevel2().toString());
            devNode.setDeviceSerialNumber(ipSerialSb.toString());
            devNode.setProductVersion("");
            ret.setResult(TaskResult.Result.SUCCESS);
            ret.setErrorLocaleDescription("");
            ret.setResultObject(devNode);
            if (devNode.getDevTypeLevel2().toString().equals("Oracle") && TaskResult.Result.SUCCESS.equals((Object)ret.getResult()) && !devNode.isUseJdbc()) {
                boolean isHasPreUpgradeScene = ToolUtils.isHavePreUpgrabdeScene();
                con.execCmd("exit");
                if (!isHasPreUpgradeScene) {
                    return ret;
                }
                this.checkHostAsmInstanceAvailable(con, ret);
            }
        }
        catch (NumberFormatException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("create device type error.", (Throwable)e);
            this.makeErrorTaskResult(devNode, ret);
            return ret;
        }
        catch (ToolException e) {
            return this.getTaskResult(devNode, ret, e, "create device type error.");
        }
        catch (SQLException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("create device type error.");
            this.makeErrorTaskResult(devNode, ret);
            return ret;
        }
        return ret;
    }

    private void checkHostAsmInstanceAvailable(IGrabCliConnection con, TaskResult ret) {
        DbConnection dbconn = (DbConnection)con;
        String result = dbconn.getAsmInfo();
        if (!result.contains("asm_pmon")) {
            String errorDes = ResourceUtil.getString((String)"infograb.layout.device.add.deviceadddialog.oracle.noasm.tip");
            ret.setErrorLocaleDescription(errorDes);
            ret.setResult(TaskResult.Result.FAILED);
            return;
        }
        String systemVer = dbconn.getSystemInfo();
        String[] notSupport = new String[]{"VMkernel"};
        boolean isOracleNotSupportSshGrab = false;
        for (String string : notSupport) {
            if (!systemVer.contains(string)) continue;
            isOracleNotSupportSshGrab = true;
        }
        if (isOracleNotSupportSshGrab && (result = dbconn.getAsmInfo()).contains("asm_pmon")) {
            String dbName = result.substring(result.indexOf("asm_pmon") + 9);
            dbName = dbName.substring(0, dbName.indexOf("\r\n"));
            String errorDes = ResourceUtil.getStringWithParams((String)"infograb.layout.device.add.deviceadddialog.oracle.sshadd.notsupport.tip", (Object[])new Object[]{dbName});
            ret.setErrorLocaleDescription(errorDes);
            ret.setResult(TaskResult.Result.FAILED);
        }
    }

    private com.huawei.ism.tool.obase.entity.DeviceType createDevTypeSN(GrabDevNode1 devNode, StringBuilder sbStr, IGrabCliConnection con) throws SQLException, ToolException {
        com.huawei.ism.tool.obase.entity.DeviceType devType;
        block10: {
            block9: {
                devType = null;
                if (!DatabaseType.MYSQL.getName().equals(devNode.getDevTypeLevel2().toString())) break block9;
                sbStr.append("DBMS");
                ResultSet rs = (ResultSet)((DBCmdResultSet)con.execSql("select version()")).getSqlResult();
                if (null == rs) break block10;
                rs.next();
                String typeRet = rs.getString(1);
                LOGGER.info("jdbc command : select version() , result = {}{}", (Object)System.lineSeparator(), (Object)typeRet);
                devType = com.huawei.ism.tool.obase.entity.DeviceType.valueOf(typeRet.split("-")[0]);
                break block10;
            }
            if (DatabaseType.ORACLE.getName().equals(devNode.getDevTypeLevel2().toString())) {
                devType = this.checkDatabaseType(devNode, sbStr, con);
            } else if (devNode.getDevTypeLevel2().toString().equals(DatabaseType.DB2.getName())) {
                sbStr.append("DBD2");
                ResultSet rs = (ResultSet)((DBCmdResultSet)con.execSql("SELECT service_level FROM TABLE (sysproc.env_get_inst_info()) as INSTANCEINFO")).getSqlResult();
                if (rs == null) {
                    LOGGER.info(" exec sql Result is null.");
                    return null;
                }
                rs.next();
                String typeRet = rs.getString(1);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("jdbc command : SELECT service_level FROM TABLE (sysproc.env_get_inst_info()) as INSTANCEINFO , result = " + System.lineSeparator() + com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)typeRet));
                }
                devType = com.huawei.ism.tool.obase.entity.DeviceType.valueOf(typeRet.split(" ")[1]);
            } else if (DatabaseType.SQLSERVER.getName().equals(devNode.getDevTypeLevel2().toString())) {
                sbStr.append("DBSS");
                ResultSet rs = (ResultSet)((DBCmdResultSet)con.execSql("select @@version")).getSqlResult();
                if (rs == null) {
                    throw new ToolException("execSql select @@version failed. rs is null.");
                }
                rs.next();
                String typeRet = rs.getString(1);
                LOGGER.info("jdbc command : select @@version , result = {}{}", (Object)System.lineSeparator(), (Object)typeRet);
                String[] version = typeRet.split(" ");
                for (int i = 0; i < version.length; ++i) {
                    if (!version[i].trim().equals("-")) continue;
                    devType = com.huawei.ism.tool.obase.entity.DeviceType.valueOf(version[i + 1].trim());
                    break;
                }
            }
        }
        return devType;
    }

    private com.huawei.ism.tool.obase.entity.DeviceType checkDatabaseType(GrabDevNode1 devNode, StringBuilder sbStr, IGrabCliConnection con) throws ToolException, SQLException {
        com.huawei.ism.tool.obase.entity.DeviceType devType;
        sbStr.append("DBOC");
        if (devNode.isUseJdbc()) {
            ResultSet rs = (ResultSet)((DBCmdResultSet)con.execSql("select * from v$version")).getSqlResult();
            if (rs == null) {
                LOGGER.info(" exec sql Result is null.");
                return null;
            }
            rs.next();
            rs.next();
            String typeRet = rs.getString(1);
            LOGGER.info("jdbc command : select * from v$version , result = {}{}", (Object)System.lineSeparator(), (Object)typeRet);
            devType = com.huawei.ism.tool.obase.entity.DeviceType.valueOf(typeRet.split(" ")[2]);
        } else {
            String oracleSnRet = (String)((DBCmdResultSet)con.execSql("select * from v$version")).getSqlResult();
            LOGGER.info("ssh command : select * from v$version , result = {}{}", (Object)System.lineSeparator(), (Object)oracleSnRet);
            String[] typeString = oracleSnRet.split("\r\n");
            devType = this.judgeDevType(typeString);
            if (devType == null) {
                throw new ToolException("");
            }
        }
        return devType;
    }

    private com.huawei.ism.tool.obase.entity.DeviceType judgeDevType(String[] typeString) {
        com.huawei.ism.tool.obase.entity.DeviceType devType = null;
        for (String line : typeString) {
            if (!line.contains("PL/SQL Release")) continue;
            devType = com.huawei.ism.tool.obase.entity.DeviceType.valueOf(line.split(" ")[2]);
            break;
        }
        return devType;
    }

    private boolean checkResult(Map<String, String> nodeInfos) {
        if (null == nodeInfos || nodeInfos.isEmpty()) {
            return false;
        }
        String name = nodeInfos.get("name");
        String type = nodeInfos.get("type");
        String sn = nodeInfos.get("sn");
        String version = nodeInfos.get("version");
        return !this.checkDefaultstr(name) && !this.checkDefaultstr(type) && !this.checkDefaultstr(sn) && !this.checkDefaultstr(version);
    }

    private void addDevNodeInfo(GrabDevNode1 devNode, Map<String, String> nodeInfos, List<Object> ipLists, TaskResult ret) {
        String name = nodeInfos.get("name");
        String type = nodeInfos.get("type");
        String sn = nodeInfos.get("sn").toUpperCase(Locale.US);
        String version = nodeInfos.get("version");
        if (this.checkDefaultstr(name) || this.checkDefaultstr(type) || this.checkDefaultstr(sn) || "--".equals(version)) {
            this.makeErrorTaskResult(devNode, ret);
            return;
        }
        if (!MigrationUtils.isSanScenario() && !this.checkProductVersion(type, version)) {
            ret.setResult(TaskResult.Result.FAILED);
            ret.setErrorLocaleDescription(ResourceUtil.getString((String)"infograb.check.product.version.error"));
            return;
        }
        devNode.setDeviceName(name);
        devNode.setDeviceSerialNumber(sn);
        com.huawei.ism.tool.obase.entity.DeviceType devType = com.huawei.ism.tool.obase.entity.DeviceType.valueOf(type);
        devNode.setDeviceType(devType);
        devNode.setProductVersion(version);
        ret.setResult(TaskResult.Result.SUCCESS);
        ret.setErrorLocaleDescription("");
        ret.setResultObject(devNode);
        if (this.isHostDevice(devNode)) {
            this.refixHostResult(name, ret, devNode);
        }
        if (this.isSwitchDevice(devNode)) {
            this.refixSwitchResult(name, ret, devNode);
        }
        if (this.isStorageDevice(devNode)) {
            this.refixStorageResult(name, ret, devNode);
        }
        if (this.checkDevTypeUnknown(type) && ret.getResult().equals((Object)TaskResult.Result.SUCCESS)) {
            this.makeUnknownTaskResult(devNode, ret);
            return;
        }
        if (this.checkDevSNUnknown(sn) && ret.getResult().equals((Object)TaskResult.Result.SUCCESS)) {
            this.makeUnknownSNTaskResult(devNode, ret);
            return;
        }
        if (null != ipLists && !ipLists.isEmpty()) {
            for (Object ipObj : ipLists) {
                String ip = String.valueOf(ipObj);
                PeerIPGainer.addIPlist((String)ip, (DevNode)devNode);
                PeerIPGainer.addPeerIP((String)ip, (DevNode)devNode);
            }
        }
    }

    private void refixHostResult(String name, TaskResult ret, DevNode devNode) {
        if (!name.equalsIgnoreCase(devNode.getDevTypeLevel2().toString())) {
            ret.setResult(TaskResult.Result.FAILED);
            ret.setErrorLocaleDescription(ResourceUtil.getString((String)"toolbox.login.error.ostype"));
        }
    }

    private void refixSwitchResult(String name, TaskResult ret, DevNode devNode) {
        if (!name.equalsIgnoreCase(devNode.getDevTypeLevel2().toString())) {
            ret.setResult(TaskResult.Result.FAILED);
            ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)"build.connection.failed", (Object[])new Object[]{devNode.getIp()}));
        }
    }

    private void refixStorageResult(String name, TaskResult ret, DevNode devNode) {
        if (!name.equalsIgnoreCase(devNode.getDevTypeLevel2().toString())) {
            ret.setResult(TaskResult.Result.FAILED);
            ret.setErrorLocaleDescription(ResourceUtil.getString((String)"toolbox.login.error.ostype"));
        }
    }

    private boolean checkDefaultstr(String str) {
        return "--".equals(str) || "NA".equals(str);
    }

    private boolean checkDevTypeUnknown(String str) {
        return "unknown".equalsIgnoreCase(str);
    }

    private boolean checkDevSNUnknown(String str) {
        return "".equalsIgnoreCase(str);
    }

    private void makeErrorTaskResult(GrabDevNode1 devNode, TaskResult ret) {
        String errorKey = "Vplex".equalsIgnoreCase(devNode.getDeviceModel()) || "Unity".equalsIgnoreCase(devNode.getDeviceModel()) ? "devicemanager.layout.device.add.deviceadddialog.emc.deviceconnecterror" : "devicemanager.layout.device.add.deviceadddialog.deviceconnecterror";
        String errorDes = ResourceUtil.getStringWithParams((String)errorKey, (Object[])new Object[]{devNode.getIp()});
        ret.setErrorLocaleDescription(errorDes);
        ret.setResult(TaskResult.Result.FAILED);
    }

    private void makeUnknownTaskResult(GrabDevNode1 devNode, TaskResult ret) {
        String errorDes = ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.deviceunknownerror", (Object[])new Object[]{devNode.getIp()});
        ret.setErrorLocaleDescription(errorDes);
        ret.setResult(TaskResult.Result.FAILED);
    }

    private void makeUnknownSNTaskResult(GrabDevNode1 devNode, TaskResult ret) {
        String errorDes = ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.devicesnunknownerror", (Object[])new Object[]{devNode.getIp()});
        ret.setErrorLocaleDescription(errorDes);
        ret.setResult(TaskResult.Result.FAILED);
    }

    private void makeWindowsErrorTaskResult(GrabDevNode1 devNode, TaskResult ret) {
        String errorDes = ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.deviceconnecterror.win", (Object[])new Object[]{devNode.getIp()});
        ret.setErrorLocaleDescription(errorDes);
        ret.setResult(TaskResult.Result.FAILED);
    }

    private void makeStorageErrorTaskResult(GrabDevNode1 devNode, TaskResult ret) {
        String errorDes = ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.deviceconnecterror.storage", (Object[])new Object[]{devNode.getIp()});
        ret.setErrorLocaleDescription(errorDes);
        ret.setResult(TaskResult.Result.FAILED);
    }

    public boolean checkVersionByScript(GrabDevNode1 dev, String scriptPath) {
        HashMap<String, GrabDevNode1> paramMap = new HashMap<String, GrabDevNode1>();
        paramMap.put("dev", dev);
        try {
            JythonExecuter jythonExecuter = new JythonExecuter();
            File pyFile = new File(scriptPath);
            jythonExecuter.compileScript(pyFile);
            Object ret = jythonExecuter.simpleInvokeFunction("execute", paramMap);
            return (Boolean)ret;
        }
        catch (RuntimeException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("something error has happend in runtime.");
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("Check version error.");
        }
        return true;
    }

    private boolean isContainXVEModel(String cliResult) {
        return cliResult.contains("Device Model") || cliResult.contains("Device Type") || cliResult.contains("Product Model") || cliResult.contains("Product Version") || cliResult.contains("Model");
    }

    private boolean isCLIResultInValid(String cliResult) {
        return cliResult.contains("command not found") || cliResult.contains("not exist") || cliResult.contains("command name is invalid");
    }

    private boolean isOtherPorductCLIResultInValid(String cliResult) {
        Set<String> notSupportComds = this.getNotSupportCmds();
        if (notSupportComds.isEmpty()) {
            return false;
        }
        for (String string : notSupportComds) {
            if (!cliResult.contains(string)) continue;
            return true;
        }
        return false;
    }

    private TaskResult dealNodeInfo(DevNode devNode, String cliResult) {
        String deviceSerialNumber = CliResolverUtils.getSerialNumber(cliResult);
        String deviceName = CliResolverUtils.getInfoByNames(cliResult, "System Name", "Name");
        String productVersion = CliResolverUtils.getDeviceInfo(cliResult, "Product Version");
        String deviceMode = CliResolverUtils.getInfoByNames(cliResult, "Device Model", "Device Type", "Product Model", "Product Mode", "Model");
        deviceMode = ModeTypeParse.getModelType((String)deviceMode);
        devNode.setDeviceName(deviceName);
        devNode.setDeviceSerialNumber(deviceSerialNumber);
        if (deviceMode.contains("VIS") && productVersion.equals("")) {
            productVersion = "V100R001C02";
        }
        TaskResult ret = new TaskResult();
        if (!MigrationUtils.isSanScenario() && !this.checkProductVersion(deviceMode, productVersion)) {
            ret.setResult(TaskResult.Result.FAILED);
            ret.setErrorLocaleDescription(ResourceUtil.getString((String)"infograb.check.product.version.error"));
            return ret;
        }
        devNode.setProductVersion(productVersion);
        com.huawei.ism.tool.obase.entity.DeviceType type = com.huawei.ism.tool.obase.entity.DeviceType.valueOf(deviceMode);
        devNode.setDeviceType(type);
        ret.setResult(TaskResult.Result.SUCCESS);
        ret.setResultObject(devNode);
        return ret;
    }

    private boolean checkProductVersion(String deviceMode, String productVersion) {
        return !deviceMode.contains("OceanStor") || !productVersion.startsWith("6.");
    }

    private boolean isHostDevice(DevNode devNode) {
        return ItDeviceType.Host.equals((Object)devNode.getItDeviceType());
    }

    private boolean isSwitchDevice(DevNode devNode) {
        return ItDeviceType.Switch.equals((Object)devNode.getItDeviceType());
    }

    private boolean isStorageDevice(DevNode devNode) {
        return ItDeviceType.Storage.equals((Object)devNode.getItDeviceType());
    }

    private boolean isStorage(DevNode devNode) {
        return ItDeviceType.Storage.equals((Object)devNode.getItDeviceType());
    }

    private boolean isDbDevice(DevNode devNode) {
        return ItDeviceType.Database.equals((Object)devNode.getItDeviceType());
    }

    private boolean isWindowsHost(DevNode devNode) {
        return "Windows".equalsIgnoreCase(devNode.getDevTypeLevel2().toString());
    }
}

