/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.swing;

import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.tool.infograb.swing.DevNodeImportProgressDialog;
import com.huawei.ism.util.SwingUtil;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevNodeImportAsyncExcutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevNodeImportAsyncExcutor.class);
    private static DevNodeImportProgressDialog devNodeImportProgressDialog;

    public static List<?> execute(Window parent, Callable<?> ... tasks) {
        devNodeImportProgressDialog = new DevNodeImportProgressDialog(parent);
        return DevNodeImportAsyncExcutor.execute(devNodeImportProgressDialog, tasks);
    }

    private static List<?> execute(DevNodeImportProgressDialog pd, final Callable<?> ... tasks) {
        final DevNodeImportProgressDialog progressDlg = pd;
        ExecutorService executor = ThreadPoolManager.getInstance().getAsyncExcutor();
        Callable taskB = new Callable<List<?>>(){

            @Override
            public List<?> call() {
                ArrayList<Object> result = new ArrayList<Object>(0);
                for (Callable task : tasks) {
                    try {
                        result.add(task.call());
                    }
                    catch (RuntimeException e) {
                        result.add(e);
                    }
                    catch (Exception ex) {
                        result.add(ex);
                    }
                }
                if (null != progressDlg) {
                    DevNodeImportAsyncExcutor.disposeProgressDialog(progressDlg);
                }
                return result;
            }
        };
        Future<List<?>> future = executor.submit(taskB);
        if (null != progressDlg) {
            progressDlg.setVisible(true);
            progressDlg.toFront();
        }
        List<?> result = DevNodeImportAsyncExcutor.getResult(future);
        return result;
    }

    private static List<?> getResult(Future<List<?>> future) {
        List<Object> result = new ArrayList(0);
        try {
            result = future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error("devnodeimport error, InterruptedException.");
        }
        catch (ExecutionException e) {
            LOGGER.error("devnodeimport error, ExecutionException.");
        }
        return result;
    }

    private static void disposeProgressDialog(final DevNodeImportProgressDialog progressDlg) {
        SwingUtil.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                progressDlg.setVisible(false);
                progressDlg.dispose();
            }
        });
    }

    public static DevNodeImportProgressDialog getDevNodeImportProgressDialog() {
        return devNodeImportProgressDialog;
    }
}

