/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.swing;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.ui.swing.ImagePanel;
import com.huawei.ism.ui.swing.dialog.HeadlessDialog;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class DevNodeImportProgressDialog
extends HeadlessDialog {
    private static final long serialVersionUID = 1L;
    private int totalDevCount = 0;
    private int importedDevCount = 0;
    private JLabel lable;

    public DevNodeImportProgressDialog(Window parent) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_uiComponent_ProgressDialog");
        this.layoutUI();
        this.pack();
        this.setLocationRelativeTo(parent);
        this.toFront();
        this.setFocusableWindowState(true);
    }

    private void layoutUI() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JComponent iconLabel = null;
        if (!IsmPlafUtils.isBlueStyle()) {
            iconLabel = this.createArmorContentPane();
            iconLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        } else {
            Border border = BorderFactory.createRaisedBevelBorder();
            panel.setBorder(border);
            iconLabel = this.createIconPanel("progress.gif");
        }
        panel.add((Component)iconLabel, "North");
        JButton bu = new JButton("");
        bu.setSize(0, 0);
        bu.setPreferredSize(new Dimension(0, 0));
        panel.add((Component)bu, "South");
        this.add(panel);
    }

    private JLabel createIconPanel(String imgName) {
        ImageIcon process = ResourceManager.getImage((String)imgName);
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(process);
        process.setImageObserver(iconLabel);
        return iconLabel;
    }

    private JComponent createArmorContentPane() {
        ImagePanel leftImagePanel = new ImagePanel(ResourceManager.getImage((String)"loading-left.png"));
        ImagePanel rightImagePanel = new ImagePanel(ResourceManager.getImage((String)"loading-right.png"));
        ImagePanel middleImagePanel = new ImagePanel(ResourceManager.getImage((String)"loading-middle.png"), ImagePanel.ExtendOrient.HORIZONAL);
        leftImagePanel.setPreferredSize(new Dimension(20, 122));
        middleImagePanel.setPreferredSize(new Dimension(470, 122));
        rightImagePanel.setPreferredSize(new Dimension(20, 122));
        leftImagePanel.setOpaque(false);
        middleImagePanel.setOpaque(false);
        rightImagePanel.setOpaque(false);
        middleImagePanel.setLayout((LayoutManager)new BorderLayout());
        this.lable = this.createIconPanel("task_loading.gif");
        this.lable.setFont(IsmFontFactory.getPlaint13Font());
        this.lable.setForeground(Color.WHITE);
        this.lable.setText(ResourceManager.getString((String)"LOADING_TEXT"));
        Box lableBox = Box.createHorizontalBox();
        lableBox.add(Box.createHorizontalGlue());
        lableBox.add(this.lable);
        lableBox.add(Box.createHorizontalGlue());
        middleImagePanel.add((Component)lableBox);
        Box box = Box.createHorizontalBox();
        box.add((Component)leftImagePanel);
        box.add((Component)middleImagePanel);
        box.add((Component)rightImagePanel);
        return box;
    }

    public void dispose() {
        super.dispose();
    }

    public void refreshHandleTaskCount(int count) {
        this.importedDevCount = count;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ResourceUtil.getString((String)"TOTALDEV"));
        stringBuffer.append(this.totalDevCount);
        stringBuffer.append(";  ");
        stringBuffer.append(ResourceUtil.getString((String)"HANDLEDDEV"));
        stringBuffer.append(this.importedDevCount);
        this.lable.setText(stringBuffer.toString());
    }

    public void refreshQueryTaskCount(int count) {
        this.importedDevCount = count;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ResourceUtil.getString((String)"QUERYTOTALDEV"));
        stringBuffer.append(this.totalDevCount);
        stringBuffer.append(";  ");
        stringBuffer.append(ResourceUtil.getString((String)"QUERYHANDLEDDEV"));
        stringBuffer.append(this.importedDevCount);
        this.lable.setText(stringBuffer.toString());
    }

    public void handledDevCount() {
        this.refreshHandleTaskCount(++this.importedDevCount);
    }

    public void setInitDevCount(int totalCount, int importedCount) {
        this.totalDevCount = totalCount;
        this.importedDevCount = importedCount;
    }
}

