/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.swing;

import com.huawei.ism.tool.base.utils.Base64EncodeUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.service.SettingService;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceAddIpCheck;
import com.huawei.ism.tool.devicemanager.utils.AuthType;
import com.huawei.ism.tool.devicemanager.utils.LogUtils;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubui.entity.DeviceDialogType;
import com.huawei.ism.tool.framework.pubui.entity.DeviceManageSetting;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode1;
import com.huawei.ism.tool.infograb.entity.MigrationType;
import com.huawei.ism.tool.infograb.intf.worktaker.AddDeviceService;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.infograb.swing.AuthSettingDilaog;
import com.huawei.ism.tool.infograb.swing.DevNodeImportAsyncExcutor;
import com.huawei.ism.tool.infograb.swing.DeviceAddLayout;
import com.huawei.ism.tool.infograb.swing.DeviceManageService;
import com.huawei.ism.tool.infograb.swing.DeviceQueryErrorParser;
import com.huawei.ism.tool.infograb.swing.DeviceTypePaneLayout;
import com.huawei.ism.tool.infograb.swing.IDeviceManageService;
import com.huawei.ism.tool.infograb.swing.INodeTypeQuery;
import com.huawei.ism.tool.infograb.swing.InfoTips;
import com.huawei.ism.tool.infograb.swing.SelKeyAction;
import com.huawei.ism.tool.infograb.ui.action.BatchImportAction;
import com.huawei.ism.tool.infograb.ui.action.DownLoadAction;
import com.huawei.ism.tool.infograb.utils.DeviceModelChecker;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.infograb.utils.migration.MigrationUtils;
import com.huawei.ism.tool.infograb.utils.ssh.SshConnectionSecurityChecker;
import com.huawei.ism.tool.obase.connection.win.WmicConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.SettingType;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTask;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTaskExecutor;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.threadpool.ThreadPoolHelper;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ArrayUtils;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.util.SwingUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;

public class DeviceAddDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DeviceAddDialog.class);
    private static DeviceAddDialog deviceAddDia;
    private static int snDiff;
    private DeviceAddLayout layout = new DeviceAddLayout();
    private transient IDeviceManageService deviceManageService = null;
    private transient InfoTips tips;
    private Set<SettingType> supportTypes = new HashSet<SettingType>();
    private Window parent;
    private Map<String, String> failedDeviceMap = new HashMap<String, String>();
    private DeviceDialogType dialogType = DeviceDialogType.StorageOnly;
    private DeviceManageSetting deviceListSet;
    private boolean checkRootPw = true;
    private boolean checkRootPwFS = true;
    private File selectFile = null;
    private transient AddDeviceService addDeviceService;
    private BatchImportAction batchImportAction;
    private Color selectUploadFileColor = new Color(243, 243, 243);
    private ArrayList<JRadioButton> ipPanRadios = new ArrayList();
    private ArrayList<JRadioButton> proxyRadios = new ArrayList();

    public DeviceAddDialog(Window parent1, INodeTypeQuery nodeTypeQueryIntf, InfoTips tips) {
        this(parent1, nodeTypeQueryIntf, tips, SettingType.Socks5Proxy, SettingType.SshForward);
    }

    public DeviceAddDialog(Window parent1, INodeTypeQuery nodeTypeQueryIntf, InfoTips tips, SettingType ... supportTypes) {
        this(parent1, nodeTypeQueryIntf, tips, DeviceDialogType.StorageOnly, supportTypes);
    }

    public DeviceAddDialog(Window parent1, INodeTypeQuery nodeTypeQueryIntf, InfoTips tips, DeviceDialogType dlgType, SettingType ... supportTypes) {
        super(parent1);
        this.supportTypes.addAll(Arrays.asList(supportTypes));
        this.parent = parent1;
        this.tips = tips;
        this.deviceManageService = new DeviceManageService(nodeTypeQueryIntf);
        this.dialogType = dlgType;
        this.init();
        this.layout.getDevTypePane().setVisible(!DeviceDialogType.StorageOnly.equals((Object)this.dialogType));
    }

    public DeviceAddDialog(Window parent1, INodeTypeQuery nodeTypeQueryIntf, InfoTips tips, DeviceManageSetting manageSetting, AddDeviceService addDeviceService, SettingType ... supportTypes) {
        super(parent1);
        this.supportTypes.addAll(Arrays.asList(supportTypes));
        this.deviceManageService = new DeviceManageService(nodeTypeQueryIntf);
        this.tips = tips;
        this.dialogType = DeviceDialogType.All;
        this.parent = parent1;
        this.deviceListSet = manageSetting;
        this.addDeviceService = addDeviceService;
        this.batchImportAction = new BatchImportAction(this, addDeviceService, this.selectFile, true);
        this.init();
        if (MigrationUtils.isSanScenario()) {
            this.layout.fillDevTypePane(this.deviceListSet);
        }
    }

    public void setDeveloperSelected(boolean selected) {
        this.layout.getDeveloperCheck().setSelected(selected);
        this.layout.setDeveloperSelected(selected);
    }

    public void setForwardEnabled(boolean enabled) {
        this.layout.getSelectSshForward().setEnabled(enabled);
        if (!enabled) {
            this.supportTypes.remove((Object)SettingType.SshForward);
        } else {
            this.supportTypes.add(SettingType.SshForward);
        }
    }

    public void setSocks5Enabled(boolean enabled) {
        this.layout.getSelectSocks5().setEnabled(enabled);
        if (!enabled) {
            this.supportTypes.remove((Object)SettingType.Socks5Proxy);
        } else {
            this.supportTypes.add(SettingType.Socks5Proxy);
        }
    }

    public void setNoProxyEnabled(boolean enabled) {
        this.layout.getSelectNoProxy().setEnabled(enabled);
    }

    private void init() {
        boolean noProxy;
        this.layout.getDevTypePane().setParentDialog(this);
        this.layout.getDevTypePaneWin().setParentDialog(this);
        this.add(this.layout);
        if (ApplicationContext.getInstance().isEnglishEnv()) {
            this.setMinimumSize(new Dimension(460, 660));
        } else {
            this.setMinimumSize(new Dimension(400, 645));
        }
        this.initState();
        this.initSocks5Data();
        this.initSshData();
        this.initLisnter();
        this.initLisnter2();
        this.getRootPane().setDefaultButton(this.layout.getNextBtn());
        this.setModal(true);
        this.pack();
        this.setResizable(false);
        SwingUtil.putScreenCenter((Window)this);
        UiMethod.setCloseWhenEscKeyPressed(this);
        boolean bl = noProxy = !this.supportTypes.contains((Object)SettingType.Socks5Proxy) && !this.supportTypes.contains((Object)SettingType.SshForward);
        if (noProxy) {
            this.layout.getProxySelectPan().setVisible(false);
        }
        if (!MigrationUtils.isSanScenario()) {
            this.layout.getDbIpTipLabel().setVisible(false);
            this.layout.getAssignIpRangeRadio().setEnabled(false);
            this.layout.getBatchImportBtnRadio().setEnabled(false);
            this.layout.getProxySelectPan().setVisible(false);
            this.layout.getDevTypePane().refreshProxyView();
            this.layout.setDefaultDescAndPort();
            this.layout.setConnetionInfoVisibale();
        }
    }

    private void initLisnter() {
        this.addRadios();
        this.addLastBtListener();
        this.addNextBtListener();
        this.addAssipraListener();
        this.addAssipraraListener();
        this.addSshListener();
        this.addSocksListener();
        this.addJdbcListener();
        this.addSelectSshListener();
        this.addSelectJdbcListener();
        this.addRootUserListener();
        this.addBatchImportListener();
        this.addSelectFileListener();
        this.addImportFileListener();
        this.addDownLoadTemplateListener();
        this.addBatchImportRadioListener();
        this.addProxyRadiosListener();
        this.addSetLinkBtnListener();
    }

    private void addRadios() {
        this.ipPanRadios.add(this.layout.getAssignIpRadio());
        this.ipPanRadios.add(this.layout.getAssignIpRangeRadio());
        this.ipPanRadios.add(this.layout.getBatchImportBtnRadio());
        this.proxyRadios.add(this.layout.getSelectNoProxy());
        this.proxyRadios.add(this.layout.getSelectSshForward());
        this.proxyRadios.add(this.layout.getSelectSocks5());
    }

    private void addRootUserListener() {
        this.layout.getUsername().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (DeviceAddDialog.this.isMigraHostScene() && !DeviceAddDialog.this.isMigraHostFS()) {
                    if (DeviceAddDialog.this.layout.getUsername().getText().isEmpty() || "root".equalsIgnoreCase(DeviceAddDialog.this.layout.getUsername().getText())) {
                        DeviceAddDialog.this.setSudoComVisible(false);
                    } else {
                        DeviceAddDialog.this.setSudoComVisible(true);
                    }
                } else if (DeviceAddDialog.this.isMigraHostFS()) {
                    DeviceAddDialog.this.setSudoComVisible(true);
                }
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                DeviceAddDialog.this.rootUserFocusLost();
            }
        });
    }

    private void rootUserFocusLost() {
        if (this.layout.checkRootUser()) {
            if (this.layout.getUsername().getText().isEmpty() || "root".equalsIgnoreCase(this.layout.getUsername().getText())) {
                this.layout.setRootPwEnableForLastbtn(false, false);
                this.layout.getSudoCheck().setSelected(false);
                this.setSudoComVisible(false);
            } else if (this.layout.getDevTypePane().getItDevTypeEnum().equals((Object)ItDeviceType.Database)) {
                this.layout.setRootPwEnableForLastbtn(true, true);
            } else {
                this.layout.setRootPwEnableForLastbtn(true, this.checkRootPw);
                if (this.isMigraHostScene()) {
                    this.setSudoComVisible(true);
                }
            }
        } else if (this.isMigraHostScene() && !this.isMigraHostFS()) {
            if (this.layout.getUsername().getText().isEmpty() || "root".equalsIgnoreCase(this.layout.getUsername().getText())) {
                this.layout.getSudoCheck().setSelected(false);
                this.setSudoComVisible(false);
            } else {
                this.setSudoComVisible(true);
            }
        } else if (this.isMigraHostFS()) {
            this.setSudoComVisible(true);
        }
    }

    private void setSudoComVisible(boolean flag) {
        this.layout.getSudoCheck().setVisible(flag);
        this.layout.getSudoComment().setVisible(flag);
        this.layout.getSudoSeeHelpLink().setVisible(flag);
    }

    public void initState() {
        this.layout.setDomainNameVisible(false);
        if (!this.checkHasSwichRoot()) {
            this.layout.setRootPwVisible(false);
        }
        this.setSudoComVisible(this.isMigraHostScene());
        this.initState2();
        this.layout.setIsDebugPwVisible();
        this.layout.setDBNameEnable();
        this.layout.setPortEnable();
        this.layout.handleCertificateVisible();
        this.layout.setUserPwdForVnx(this);
        this.layout.updateSerialNumVisible();
        this.layout.updateRootAndCliUserVisible();
        this.layout.enableDomainName();
        boolean enable = this.supportTypes.contains((Object)SettingType.Socks5Proxy) || this.supportTypes.contains((Object)SettingType.SshForward);
        this.layout.getSelectNoProxy().setEnabled(enable);
        this.layout.getSelectSshForward().setEnabled(this.supportTypes.contains((Object)SettingType.SshForward));
        this.layout.getSelectSocks5().setEnabled(this.supportTypes.contains((Object)SettingType.Socks5Proxy));
        UiMethod.setBatchButtonMnemonic(this.layout.getNextBtn());
    }

    public void initState2() {
        if (this.layout.getTabState() == 1) {
            this.setTitle(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.title"));
            this.layout.getLastBtn().setVisible(false);
            this.layout.getNextBtn().setEnabled(true);
            this.layout.getNextBtn().setText(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.nextbtn"));
            if (this.layout.getTabState() != this.layout.getLastTabState()) {
                this.layout.changeStateView(1);
            }
            this.layout.getCfgJpane().setVisible(false);
            this.layout.getWindowsBasicJpane().setVisible(false);
            this.layout.getBasicJpane().setVisible(true);
        } else if (this.layout.getTabState() == 2) {
            this.setTitle(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.title1"));
            this.layout.getLastBtn().setVisible(true);
            this.layout.getNextBtn().setText(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.okbtn"));
            this.layout.getBasicJpane().setVisible(false);
            this.layout.getWindowsBasicJpane().setVisible(false);
            this.layout.getCfgJpane().setVisible(true);
            this.layout.getUsername().requestFocus();
            this.layout.setKeyInfoVisible();
        } else if (this.layout.getTabState() == 3) {
            this.setTitle(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.title"));
            this.layout.getLastBtn().setVisible(false);
            this.layout.getNextBtn().setEnabled(false);
            this.layout.getNextBtn().setText(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.nextbtn"));
            if (this.layout.getTabState() != this.layout.getLastTabState()) {
                this.layout.changeStateView(3);
            }
            this.layout.getBasicJpane().setVisible(false);
            this.layout.getCfgJpane().setVisible(false);
            this.layout.getWindowsBasicJpane().setVisible(true);
        }
    }

    private void setProxydisableforDB(ItDeviceType type) {
        boolean isDisable;
        if (type == null) {
            return;
        }
        String deviceTypeL2 = this.layout.getDevTypePane().getLevel2TypeString();
        boolean isNotDB = type.equals((Object)ItDeviceType.Database) || type.equals((Object)ItDeviceType.Switch) || type.equals((Object)ItDeviceType.Storage);
        boolean notSupportedHosts = deviceTypeL2.equalsIgnoreCase("windows") || deviceTypeL2.equalsIgnoreCase("fusionsphere") || deviceTypeL2.equalsIgnoreCase("xenserver");
        boolean bl = isDisable = isNotDB || notSupportedHosts;
        if (isDisable) {
            this.layout.getSelectNoProxy().setEnabled(false);
            this.layout.getSelectSocks5().setEnabled(false);
            this.layout.getSelectSshForward().setEnabled(false);
        }
    }

    private void addSelectJdbcListener() {
        this.layout.getSelectJdbcConnection().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DeviceAddDialog.this.layout.getSelectJdbcConnection().isSelected()) {
                    DeviceAddDialog.this.layout.getDbName().setEnabled(true);
                    DeviceAddDialog.this.layout.getDbLabel().setVisible(true);
                    DeviceAddDialog.this.layout.getDbName().setVisible(true);
                    boolean isHasPreUpgradeScene = ToolUtils.isHavePreUpgrabdeScene();
                    if (!isHasPreUpgradeScene) {
                        DeviceAddDialog.this.layout.getDbLabelImage().setToolTipText(ResourceUtil.getString((String)"oracle.database.instance.name"));
                    }
                    DeviceAddDialog.this.layout.getDbLabelImage().setVisible(true);
                    DeviceAddDialog.this.layout.getDbJdbcUserNameImage().setVisible(true);
                    DeviceAddDialog.this.layout.setRootPwEnableForLastbtn(false, false);
                } else {
                    DeviceAddDialog.this.layout.getDbName().setEnabled(false);
                }
            }
        });
    }

    private void addSelectSshListener() {
        this.layout.getSelectSshConnection().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DeviceAddDialog.this.layout.getSelectJdbcConnection().isSelected()) {
                    DeviceAddDialog.this.layout.getPort().setText(String.valueOf(22));
                    DeviceAddDialog.this.layout.getDbName().setText("");
                    DeviceAddDialog.this.layout.getDbLabel().setVisible(false);
                    DeviceAddDialog.this.layout.getDbName().setVisible(false);
                    DeviceAddDialog.this.layout.setDbConnJdbc(false);
                    DeviceAddDialog.this.layout.getDbLabelImage().setVisible(false);
                    DeviceAddDialog.this.layout.getDbJdbcUserNameImage().setVisible(false);
                    if (DeviceAddDialog.this.layout.getUsername().getText().isEmpty() || "root".equalsIgnoreCase(DeviceAddDialog.this.layout.getUsername().getText())) {
                        DeviceAddDialog.this.layout.setRootPwEnableForLastbtn(false, false);
                    } else {
                        DeviceAddDialog.this.layout.setRootPwEnableForLastbtn(true, true);
                    }
                }
            }
        });
    }

    private void addJdbcListener() {
        this.layout.getSelectJdbcConnection().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceAddDialog.this.layout.setDefaultDescAndPort();
                DeviceAddDialog.this.layout.setDbConnJdbc(true);
            }
        });
    }

    private void addSshListener() {
        final JRadioButton sshFor = this.layout.getSelectSshForward();
        sshFor.getModel().addActionListener(new ForwardAction());
        sshFor.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DeviceAddDialog.this.layout.getSshRouteList().setEnabled(sshFor.isSelected());
                DeviceAddDialog.this.layout.getSshCfgLink().setEnabled(sshFor.isSelected());
                DeviceAddDialog.this.buttonGroup(DeviceAddDialog.this.proxyRadios, sshFor);
            }
        });
    }

    private void addAssipraraListener() {
        final JRadioButton assiprara = this.layout.getAssignIpRangeRadio();
        assiprara.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UiMethod.setBatchComponentProperty("setEnabled", new Object[]{DeviceAddDialog.this.layout.getAssignIpRangeRadio().isSelected()}, DeviceAddDialog.this.layout.getAssignIpRangePan());
                DeviceAddDialog.this.buttonGroup(DeviceAddDialog.this.ipPanRadios, assiprara);
            }
        });
    }

    private void addAssipraListener() {
        final JRadioButton assipra = this.layout.getAssignIpRadio();
        assipra.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UiMethod.setBatchComponentProperty("setEnabled", new Object[]{DeviceAddDialog.this.layout.getAssignIpRadio().isSelected()}, DeviceAddDialog.this.layout.getAssignIpPan());
                DeviceAddDialog.this.buttonGroup(DeviceAddDialog.this.ipPanRadios, assipra);
            }
        });
    }

    private void addBatchImportListener() {
        final JRadioButton batchImportBtnRadio = this.layout.getBatchImportBtnRadio();
        batchImportBtnRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UiMethod.setBatchComponentProperty("setEnabled", new Object[]{DeviceAddDialog.this.layout.getBatchImportBtnRadio().isSelected()}, DeviceAddDialog.this.layout.getBatchImportPan());
                DeviceAddDialog.this.buttonGroup(DeviceAddDialog.this.ipPanRadios, batchImportBtnRadio);
            }
        });
    }

    private void buttonGroup(ArrayList<JRadioButton> list, JRadioButton button) {
        int count = 0;
        for (JRadioButton radio : list) {
            if (radio != button) {
                radio.setSelected(false);
            }
            if (radio.isSelected()) continue;
            ++count;
        }
        if (count == list.size()) {
            button.setSelected(true);
        }
    }

    private void addNextBtListener() {
        JButton nextbt = this.layout.getNextBtn();
        nextbt.addActionListener(this);
        JButton cancelbt = this.layout.getCancelBtn();
        cancelbt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceAddDialog.this.dispose();
            }
        });
    }

    private void addLastBtListener() {
        JButton lastbt = this.layout.getLastBtn();
        lastbt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceAddDialog.this.layout.setTabState(1);
                DeviceAddDialog.this.initState();
                ItDeviceType currItDeviceType = (ItDeviceType)DeviceAddDialog.this.layout.getDevTypePane().getItDevType().getSelectedItem();
                DeviceAddDialog.this.setProxydisableforDB(currItDeviceType);
            }
        });
    }

    private void addSocksListener() {
        JRadioButton socks = this.layout.getSelectSocks5();
        socks.getModel().addActionListener(new SelectSockes5Action());
        socks.addChangeListener(new SocksChangeListner(socks, this.layout));
    }

    private void addProxyRadiosListener() {
        final JRadioButton noProxy = this.layout.getSelectNoProxy();
        final JRadioButton socks = this.layout.getSelectSocks5();
        noProxy.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DeviceAddDialog.this.buttonGroup(DeviceAddDialog.this.proxyRadios, noProxy);
            }
        });
        socks.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DeviceAddDialog.this.buttonGroup(DeviceAddDialog.this.proxyRadios, socks);
            }
        });
    }

    private void initLisnter2() {
        this.addSocksHyperLinkListener();
        this.addSshHyperLinkListener();
        this.addDeveloperCheckListener();
        this.addSetHyperLinkListener();
        this.addSelBtnListener();
        this.addDomainNameCheckListener();
        this.addRootPwCheckListener();
        this.addSudoCheckListener();
        this.addItDevTypeListener();
        this.addSudoSeeHelpLinkListener();
    }

    private void addSudoSeeHelpLinkListener() {
        this.layout.getSudoSeeHelpLink().addClickListener(new ToolHyperLinkLabel.ClickAdapter(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String helpLink = ResourceUtil.getString((String)"devicemanager.layout.device.offlineImport.helpLink.host");
                if (!StringUtils.isNULLStr(helpLink) && !"--".equals(helpLink)) {
                    ToolUtils.openHelpFile(DeviceAddDialog.this, helpLink);
                }
            }
        });
    }

    private void addSelBtnListener() {
        JButton selbtn = this.layout.getKeySelBtn();
        selbtn.addActionListener(new SelKeyAction(this, this.layout.getKeyCombo()));
    }

    private void addSetHyperLinkListener() {
        ToolHyperLinkLabel setLink = this.layout.getSetlink();
        setLink.addClickListener(new ToolHyperLinkLabel.ClickListener(){

            @Override
            public void clickLink(MouseEvent e) {
                AuthSettingDilaog dialog = new AuthSettingDilaog(DeviceAddDialog.this);
                dialog.setVisible(true);
            }
        });
    }

    private void addSetLinkBtnListener() {
        JButton setLinkBtn = this.layout.getSetLinkBtn();
        setLinkBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuthSettingDilaog dialog = new AuthSettingDilaog(DeviceAddDialog.this);
                dialog.setVisible(true);
            }
        });
    }

    private void addDeveloperCheckListener() {
        JCheckBox developerCheck = this.layout.getDeveloperCheck();
        developerCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DeviceAddDialog.this.layout.setDeveloperSelected(DeviceAddDialog.this.layout.getDeveloperCheck().isSelected());
            }
        });
    }

    private void addDomainNameCheckListener() {
        JCheckBox domainNameCheck = this.layout.getDomainNameCheck();
        domainNameCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DeviceAddDialog.this.layout.setDomainNameEnabled(DeviceAddDialog.this.layout.getDomainNameCheck().isSelected());
            }
        });
    }

    private void addRootPwCheckListener() {
        final JCheckBox rootPwCheck = this.layout.getRootPwCheck();
        rootPwCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DeviceAddDialog.this.layout.setrootPwEnabled(DeviceAddDialog.this.layout.getRootPwCheck().isSelected());
                DeviceAddDialog.this.checkRootPw = DeviceAddDialog.this.layout.getRootPwCheck().isSelected();
                DeviceAddDialog.this.checkRootPwFS = DeviceAddDialog.this.layout.getRootPwCheck().isSelected();
                if (rootPwCheck.isSelected()) {
                    DeviceAddDialog.this.layout.getSudoCheck().setSelected(false);
                }
            }
        });
    }

    private void addSudoCheckListener() {
        this.layout.getSudoCheck().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (DeviceAddDialog.this.layout.getSudoCheck().isSelected()) {
                    DeviceAddDialog.this.layout.setRootPwEnableForLastbtn(true, false);
                    DeviceAddDialog.this.layout.getRootPwCheck().setSelected(false);
                    DeviceAddDialog.this.checkRootPw = false;
                }
            }
        });
    }

    private void addItDevTypeListener() {
        this.layout.getDevTypePane().getItDevType().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DeviceAddDialog.this.setDbIpLabelVisble();
                DeviceAddDialog.this.setBatchImportEnabled();
            }
        });
        this.layout.getDevTypePane().getl2Type().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DeviceAddDialog.this.setDbIpLabelVisble();
                DeviceAddDialog.this.setBatchImportEnabled();
            }
        });
    }

    private void setBatchImportEnabled() {
        boolean storageScenario = ItDeviceType.Storage.equals((Object)this.layout.getDevTypePane().getItDevTypeEnum());
        this.layout.getBatchImportBtnRadio().setEnabled(!storageScenario);
        if (storageScenario) {
            this.layout.getAssignIpRadio().setSelected(true);
        }
    }

    private void setDbIpLabelVisble() {
        this.layout.getDbIpTipLabel().setVisible(false);
        this.layout.getDbIpTipLabel().setToolTipText(ResourceUtil.getString((String)"infograb.db.ip.tips"));
        try {
            if (this.layout.getDevTypePane().getItDevTypeEnum().equals((Object)ItDeviceType.Database)) {
                this.layout.getDbIpTipLabel().setVisible(true);
            } else if ("windows".equalsIgnoreCase(this.layout.getDevTypePane().getLevel2TypeString())) {
                this.layout.getDbIpTipLabel().setToolTipText(ResourceUtil.getString((String)"infograb.collect.windows.connection.tips.desc"));
                this.layout.getDbIpTipLabel().setVisible(true);
            } else {
                this.layout.getDbIpTipLabel().setVisible(false);
            }
        }
        catch (NullPointerException e) {
            this.layout.getDbIpTipLabel().setVisible(false);
        }
    }

    private void addSshHyperLinkListener() {
        ToolHyperLinkLabel sshLink = this.layout.getSshCfgLink();
        sshLink.addClickListener(new ToolHyperLinkLabel.ClickListener(){
            private static final long serialVersionUID = 3195294537969274123L;

            @Override
            public void clickLink(MouseEvent e) {
                SettingService.showSettingDialog((Window)DeviceAddDialog.this, (SettingType)SettingType.SshForward);
                DeviceAddDialog.this.initSshData();
                DeviceAddDialog.this.initSocks5Data();
                if (0 == DeviceAddDialog.this.layout.getSshRouteList().getModel().getSize()) {
                    DialogUtils.showInfoDialog((JDialog)DeviceAddDialog.this, (String)ResourceUtil.getString((String)"device.adddialog.proxysetting.nomoreroute"));
                    DeviceAddDialog.this.layout.getSelectNoProxy().setSelected(true);
                }
            }
        });
    }

    private void addSocksHyperLinkListener() {
        ToolHyperLinkLabel sockLink = this.layout.getSocks5CfgLink();
        sockLink.addClickListener(new SockLinkListener());
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.layout.getTabState() == 2) {
            if (!this.isDBAreaValid()) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.databasenameerror"));
                return;
            }
            String userName = this.layout.getUsername().getText();
            String pwd = this.getPwdFromChars();
            String port = this.layout.getPort().getText();
            boolean hasNull = StringUtils.hasNULLStr(userName, pwd, port);
            String hostType = this.layout.getDevTypePane().getLevel2TypeString();
            String devType = this.layout.getDevTypePane().getItDevType().getSelectedItem().toString();
            this.checkStingUtils(userName, pwd, hasNull, hostType, devType);
            return;
        }
        if (this.checkIpInfo()) {
            return;
        }
        this.layout.checkeRootPw(this.checkRootPw);
        this.layout.enableRootPw(this.checkRootPwFS);
        if (this.layout.checkRootUser()) {
            boolean rootFlag;
            boolean bl = rootFlag = !this.layout.getUsername().getText().isEmpty() && !"root".equalsIgnoreCase(this.layout.getUsername().getText());
            if (rootFlag || this.isMigraHostFS()) {
                this.layout.setRootPwEnableForLastbtn(true, this.checkRootPw);
            }
        }
        this.layout.setTabState(2);
        this.initState();
    }

    boolean checkIpInfo() {
        if (this.layout.getAssignIpRadio().isSelected()) {
            if (!this.checkAssignIp()) {
                return true;
            }
        } else {
            String endIpAddress;
            String startIpAddress = this.layout.getStartIpAddress().getText();
            if (StringUtils.hasNULLStr(startIpAddress, endIpAddress = this.layout.getEndIpAddress().getText())) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.iprangeipblank"));
                return true;
            }
            if (!NetUtil.isValidIP(startIpAddress) || !NetUtil.isValidIP(endIpAddress)) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.ipaddresserror"));
                return true;
            }
            String result = DeviceAddIpCheck.getInstance().ipIpRangeInvalid(startIpAddress, endIpAddress);
            if (!StringUtils.isNULLStr(result)) {
                DialogUtils.showInfoDialog((JDialog)this, (String)result);
                return true;
            }
        }
        return false;
    }

    void checkStingUtils(String userName, String pwd, boolean hasNull, String hostType, String devType) {
        WarningDialog notRootWarningDialog;
        char[] pwdChars;
        String pass;
        if ((this.layout.getRootPwCheck().isSelected() && (this.layout.getDevTypePane().getItDevTypeEnum().equals((Object)ItDeviceType.Host) || this.layout.getDevTypePane().getItDevTypeEnum().equals((Object)ItDeviceType.Database)) || this.layout.getDevTypePane().getl3ModelString().equals("OceanStor_9000")) && StringUtils.hasNULLStr(pass = Base64EncodeUtils.encode((String)new String(pwdChars = this.layout.getRootPw().getPassword())))) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.switch.need.root.pwd.info"));
            return;
        }
        if (!(hasNull || "windows".equalsIgnoreCase(hostType) || "root".equalsIgnoreCase(userName) || !ResourceUtil.getString((String)"device.type.host.desc").equalsIgnoreCase(devType) || this.layout.getRootPwCheck().isSelected() || this.layout.getSudoCheck().isSelected() || 1 != (notRootWarningDialog = DialogUtils.showYesNoDialog((Window)this, (String)ResourceUtil.getString((String)"device.adddialog.adddevice.notroot.suggest"))).getValue() && -1 != notRootWarningDialog.getValue())) {
            com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)pwd);
            return;
        }
        this.processAdd();
        this.layout.getUsername().requestFocus();
        com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)pwd);
    }

    private String getPwdFromChars() {
        String pwd = null;
        char[] passChars = this.layout.getPassword().getPassword();
        if (null != passChars) {
            pwd = String.valueOf(passChars);
        }
        ArrayUtils.clearCharArray(passChars);
        return pwd;
    }

    private boolean checkAssignIp() {
        String ipAddress = this.layout.getIpAddress().getText();
        if (StringUtils.hasNULLStr(ipAddress)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.deviceinfoipblank"));
            return false;
        }
        if (!NetUtil.isValidIP(ipAddress)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.ipaddresserror"));
            return false;
        }
        return true;
    }

    private boolean isDBAreaValid() {
        Object currSelectType = this.layout.getDevTypePane().getItDevType().getSelectedItem();
        ItDeviceType currItDeviceType = (ItDeviceType)currSelectType;
        if (currItDeviceType.equals((Object)ItDeviceType.Database) && this.layout.getSelectJdbcConnection().isSelected()) {
            return !StringUtils.hasNULLStr(this.layout.getDbName().getText());
        }
        return true;
    }

    private void initSocks5Data() {
        this.layout.getSocks5List().removeAllItems();
        List proxys = SettingService.getProxies();
        for (Socks5Proxy proxy : proxys) {
            this.layout.getSocks5List().addItem(proxy);
        }
    }

    private void initSshData() {
        this.layout.getSshRouteList().removeAllItems();
        KeyOrderedHashMap sshList = SettingService.getSshForwards();
        List keys = sshList.keyList();
        for (String key : keys) {
            this.layout.getSshRouteList().addItem(key);
        }
    }

    private void processAdd() {
        if (this.layout.getAssignIpRadio().isSelected()) {
            this.asSyncGetNode();
        } else if (this.layout.getAssignIpRangeRadio().isSelected()) {
            this.addIpRange();
        }
    }

    private void addIpRange() {
        String startIpAddress = this.layout.getStartIpAddress().getText();
        String endIpAddress = this.layout.getEndIpAddress().getText();
        if (!this.checkUserInputInfo()) {
            return;
        }
        this.setVisible(false);
        this.fetchDevices(startIpAddress, endIpAddress);
    }

    private void fetchDevices(String startIpAddress, String endIpAddress) {
        List ips = DeviceAddIpCheck.getInstance().constructIpSegs(startIpAddress, endIpAddress);
        if (!GrabContext.getInstance().isUpgradeEval() && GrabContext.getInstance().getDevCount().get() + ips.size() > 1000) {
            DialogUtils.showInfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.task.device_sum_limit_info"));
            return;
        }
        List<GrabDevNode1> devNodes = this.getDevNodes(ips);
        if (DeviceModelChecker.isGrabBySsh(devNodes.get(0)) && !this.checkSshConnection(devNodes)) {
            return;
        }
        List calls = this.getGrabCalls(devNodes);
        JProgressBar progressBar = new JProgressBar();
        progressBar.setStringPainted(true);
        ThreadPoolHelper.concurrentExecuteWithProcessBar(this.parent, progressBar, calls);
        LinkedList failRet = new LinkedList();
        for (Map.Entry<String, String> entry : this.failedDeviceMap.entrySet()) {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(entry.getKey());
            tmp.add(entry.getValue());
            failRet.add(tmp);
        }
        if (!failRet.isEmpty() && !ApplicationContext.getInstance().isJunit()) {
            SubDialogUtils.showMultiInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.batcherror"), (String[])new String[]{ResourceUtil.getString((String)"devicemanager.layout.device.errormsg.ip"), ResourceUtil.getString((String)"devicemanager.layout.device.errormsg.reason")}, failRet);
        }
        if (failRet.size() != ips.size()) {
            ToolUtils.executeAddDevice2Complete(this.addDeviceService);
        }
    }

    private List<Callable<GrabDevNode1>> getGrabCalls(List<GrabDevNode1> devNodes) {
        return devNodes.stream().map(x$0 -> new FetchDevNodeCall((GrabDevNode1)x$0)).collect(Collectors.toList());
    }

    private List<GrabDevNode1> getDevNodes(List<String> ips) {
        return ips.stream().map(this::createDev).collect(Collectors.toList());
    }

    private GrabDevNode1 createDev(String ip) {
        GrabDevNode1 device = new GrabDevNode1();
        String username = this.layout.getUsername().getText();
        String password = this.getPwdFromChars();
        int port = StringUtils.str2Int(this.layout.getPort().getText());
        device.setIp(ip);
        User user = new User(username, password);
        if (this.layout.getRootPwCheck().isSelected() && this.checkHasSwichRoot()) {
            char[] pwdChars = this.layout.getRootPw().getPassword();
            String pass = Base64EncodeUtils.encode((String)new String(pwdChars));
            com.huawei.ism.tool.framework.pubservice.entity.User adminUser = new com.huawei.ism.tool.framework.pubservice.entity.User("root", pass);
            device.setAdminUser(adminUser);
            device.setRootUser(new User("root", pass));
            device.setRootPwCheck(true);
        }
        this.addUserFor9000(device);
        if (this.layout.getDomainNameCheck().isSelected()) {
            String domainName = this.layout.getDomainName().getText();
            LOGGER.error("***[{}]***", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)this.layout.getDomainName().getText()));
            user.setDomainName(domainName);
            user.setUserName(domainName + "\\" + user.getUserName());
        }
        device.setLoginUser(user);
        device.setPort(port);
        device.setPriKey(this.layout.getCurKey());
        device.setSudoGrab(this.layout.getSudoCheck().isSelected());
        device.setVerifyCertificate(this.layout.getSelectNeedCheckCertificate().isSelected());
        if (this.layout.getDeveloperCheck().isSelected()) {
            String devpwd = null;
            char[] devPassChars = this.layout.getDeveloperPwd().getPassword();
            if (null != devPassChars) {
                devpwd = String.valueOf(devPassChars);
            }
            ArrayUtils.clearCharArray(devPassChars);
            device.setDeveloperPwd(devpwd);
            com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)devpwd);
        }
        this.checkSocksProxy(device, password);
        return device;
    }

    private void addUserFor9000(GrabDevNode1 device) {
        if (this.layout.isStorageHuawei9000()) {
            char[] rootPwdChars = this.layout.getRootPw().getPassword();
            String pass = Base64EncodeUtils.encode((String)new String(rootPwdChars));
            device.setAdminUser(new com.huawei.ism.tool.framework.pubservice.entity.User("root", pass));
            device.setRootUser(new User("root", pass));
            device.setRootPwCheck(true);
            char[] clientPwdChars = this.layout.getClientPassword().getPassword();
            String clientUser = this.layout.getClientUsername().getText();
            String clientPass = Base64EncodeUtils.encode((String)new String(clientPwdChars));
            device.setClientUser(new User(clientUser, clientPass));
        }
    }

    private void checkSocksProxy(GrabDevNode1 device, String password) {
        Object item;
        if (this.layout.getSelectSshForward().isSelected()) {
            item = this.layout.getSshRouteList().getItemAt(this.layout.getSshRouteList().getSelectedIndex());
            List nodes = (List)SettingService.getSshForwards().get(item);
            device.setSshForwardList(nodes);
        }
        if (this.layout.getSelectSocks5().isSelected()) {
            item = this.layout.getSocks5List().getItemAt(this.layout.getSocks5List().getSelectedIndex());
            Socks5Proxy proxy = (Socks5Proxy)item;
            device.setSocks5Proxy(proxy);
        }
        device.setDbName(this.layout.getDbName().getText());
        device.setUseJdbc(this.layout.getDevTypePane().getItDevTypeEnum().equals((Object)ItDeviceType.Database) ? this.layout.getSelectJdbcConnection().isSelected() : false);
        if (!DeviceDialogType.StorageOnly.equals((Object)this.dialogType)) {
            ItDeviceType itDevTye = this.layout.getDevTypePane().getItDevTypeEnum();
            DeviceType dveType = DeviceType.valueOf(this.layout.getDevTypePane().getl2Type().getSelectedItem().toString());
            if (MigrationUtils.isSanScenario()) {
                device.setMigrType(MigrationType.SAN.getName());
            } else {
                device.setMigrType(MigrationType.NAS.getName());
            }
            device.setDeviceModel(this.layout.getDevTypePane().getl3ModelString());
            device.setDeviceSerialNumber(this.layout.getSerialNumber().getText());
            device.setDevTypeLevel2(dveType);
            device.setItDeviceType(itDevTye);
        }
        com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)password);
        WmicConnectionManager.releaseConn(device);
    }

    private boolean checkHasSwichRoot() {
        DeviceTypePaneLayout devTypePane = this.layout.getDevTypePane();
        String getl2TypeString = devTypePane.getLevel2TypeString();
        boolean isSshDbCon = devTypePane.getItDevTypeEnum().equals((Object)ItDeviceType.Database) && this.layout.getSelectSshConnection().isSelected();
        return this.layout.isStorageHuawei9000() || isSshDbCon || devTypePane.getItDevTypeEnum().equals((Object)ItDeviceType.Host) && !getl2TypeString.contains("Windows") && !getl2TypeString.contains("VMware");
    }

    private void add2FailList(String ip, String reason) {
        this.failedDeviceMap.put(ip, reason);
    }

    private void asSyncGetNode() {
        if (!this.checkUserInputInfo()) {
            return;
        }
        this.setVisible(false);
        GrabDevNode1 dev = this.createDev(this.layout.getIpAddress().getText());
        if (DeviceModelChecker.isGrabBySsh(dev) && !this.checkSshConnection(Collections.singletonList(dev))) {
            return;
        }
        ProgressDialog progressDialog = new ProgressDialog((Window)this, null, 470);
        ServiceTaskExecutor taskExecutor = new ServiceTaskExecutor(progressDialog, true);
        DeviceTypeQueryTask queryTypeTask = new DeviceTypeQueryTask(dev);
        TaskResult result = taskExecutor.execute(queryTypeTask);
        if (this.addDeviceFail(result = DeviceQueryErrorParser.parseErrorInfo(result))) {
            this.dispose();
            this.initState();
            DialogUtils.showInfoDialog((Window)this.parent, (String)result.getErrorLocaleDescription());
            OperationEnum.ADD_DEVICE.failLogWithResources(dev.getIp(), dev.getDeviceName());
            this.setVisible(true);
        }
        if (null != result && result.getResult() == TaskResult.Result.SNFAILSAME) {
            StringBuilder sameDevTips = new StringBuilder();
            GrabDevNode1 devNodeSame = (GrabDevNode1)result.getResultObject();
            String ipSnTips = ResourceUtil.getStringWithParams((String)result.getErrorLocaleDescription(), (Object[])new Object[]{devNodeSame.getIp(), devNodeSame.getDeviceSerialNumber()});
            sameDevTips.append(ipSnTips);
            sameDevTips.append(ResourceUtil.getString((String)"infograb.dev.same.tip"));
            WarningDialog warDialog = DialogUtils.createWarningDialog((JDialog)this, (String)sameDevTips.toString());
            if (0 == warDialog.getValue() && !devNodeSame.isSnFail()) {
                String oldSn = devNodeSame.getDeviceSerialNumber();
                String newSn = oldSn + "(" + String.valueOf(snDiff) + ")";
                devNodeSame.setDeviceSerialNumber(newSn);
                try {
                    DefaultNodeProviderImpl.getInstance().addNode((DevNode)devNodeSame);
                    OperationEnum.ADD_DEVICE.failLogWithResources(dev.getIp(), dev.getDeviceName());
                    ++snDiff;
                }
                catch (ToolException e) {
                    LOGGER.error("add device node error.");
                    OperationEnum.ADD_DEVICE.failLogWithResources(dev.getIp(), dev.getDeviceName());
                }
            }
        }
        ToolUtils.executeAddDevice2Complete(this.addDeviceService);
    }

    private boolean checkSshConnection(List<GrabDevNode1> nodes) {
        return new SshConnectionSecurityChecker(this, nodes).check();
    }

    private boolean addDeviceFail(TaskResult result) {
        return null != result && result.getResult() == TaskResult.Result.FAILED && !"CERT_UNTRUST".equals(result.getErrorLocaleDescription());
    }

    private TaskResult getDevice(GrabDevNode1 dev) {
        TaskResult result = null;
        result = "NetApp".equalsIgnoreCase(dev.getDevTypeLevel2().toString()) || "EMC".equalsIgnoreCase(dev.getDevTypeLevel2().toString()) && "VMAX".equalsIgnoreCase(dev.getDeviceModel()) ? this.deviceManageService.addDevice(dev) : this.deviceManageService.addDeviceBySsh(dev);
        LogUtils.addOperaLog((String)"operalog.name.adddevice", (DevNode)dev, (TaskResult)result);
        return result;
    }

    private boolean checkUserInputInfo() {
        String ipAddress = this.layout.getIpAddress().getText();
        String port = this.layout.getPort().getText();
        if (this.layout.isVnxDevice()) {
            return true;
        }
        if (!this.checkBasicInfo(port)) {
            return false;
        }
        GrabDevNode1 node = new GrabDevNode1();
        node.setIp(ipAddress);
        if (this.deviceManageService.isDevNodeExist(node)) {
            String msg = ResourceUtil.getStringWithParams((String)this.tips.getDuplicateTipsKey(), (Object[])new Object[]{ipAddress});
            DialogUtils.showInfoDialog((JDialog)this, (String)msg);
            return false;
        }
        return true;
    }

    private boolean checkBasicInfo(String port) {
        String domainName;
        boolean isNullStr;
        if (this.hasBlankInputs(port)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)this.getBlankMessageKey()));
            return false;
        }
        if (this.layout.keyInfoVisible() && ResourceUtil.getString((String)"device.adddialog.key.bank").equals(this.layout.getKeyCombo().getSelectedItem().toString())) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"device.adddialog.key.select.null"));
            return false;
        }
        if (this.layout.getDeveloperCheck().isSelected()) {
            String devPass = null;
            char[] devPassChars = this.layout.getDeveloperPwd().getPassword();
            if (null != devPassChars) {
                devPass = String.valueOf(devPassChars);
            }
            ArrayUtils.clearCharArray(devPassChars);
            boolean isNullStr2 = StringUtils.isNULLStr(devPass);
            if (isNullStr2) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.developer.inputnull"));
                com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)devPass);
                return false;
            }
            com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)devPass);
        }
        if (this.layout.getDomainNameCheck().isSelected() && (isNullStr = StringUtils.isNULLStr(domainName = String.valueOf(this.layout.getDomainName().getText())))) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.layout.device.add.deviceadddialog.domainname.inputnull"));
            return false;
        }
        if (StringUtils.str2Int(port) > 65535 || StringUtils.str2Int(port) <= 0) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.devicePortInfo"));
            return false;
        }
        return true;
    }

    private String getBlankMessageKey() {
        if (this.layout.getSerialNumber().isVisible()) {
            return "devicemanager.layout.device.add.deviceadddialog.deviceinfoblank3";
        }
        if (this.layout.isStorageHuawei9000()) {
            return "devicemanager.layout.device.add.deviceadddialog.deviceinfoblank.9000";
        }
        if (this.layout.getPassword().isEnabled()) {
            return "devicemanager.layout.device.add.deviceadddialog.deviceinfoblank";
        }
        return "devicemanager.layout.device.add.deviceadddialog.deviceinfoblank.key";
    }

    private String getClientPwdFromChars() {
        String pwd = null;
        char[] passChars = this.layout.getClientPassword().getPassword();
        if (passChars != null) {
            pwd = String.valueOf(passChars);
        }
        ArrayUtils.clearCharArray(passChars);
        return pwd;
    }

    private boolean hasBlankInputs(String port) {
        return StringUtils.hasNULLStr(this.layout.getUsername().getText(), port) || this.isPasswordBlank() || this.isSerialNumBlank() || this.isClientUsernameBlank() || this.isClientPasswordBlank();
    }

    private boolean isPasswordBlank() {
        String password = this.getPwdFromChars();
        boolean isPasswordBlank = this.layout.getPassword().isEnabled() && StringUtils.isNULLStr(password);
        com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)password);
        return isPasswordBlank;
    }

    private boolean isSerialNumBlank() {
        return this.layout.getSerialNumber().isVisible() && StringUtils.isNULLStr(this.layout.getSerialNumber().getText());
    }

    private boolean isClientUsernameBlank() {
        return this.layout.getClientUsername().isVisible() && StringUtils.isNULLStr(this.layout.getClientUsername().getText());
    }

    private boolean isClientPasswordBlank() {
        String clientPassword = this.getClientPwdFromChars();
        boolean isPasswordBlank = this.layout.getClientPassword().isVisible() && StringUtils.isNULLStr(clientPassword);
        com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)clientPassword);
        return isPasswordBlank;
    }

    public void setAuthType(AuthType selType) {
        this.layout.setAuthType(selType);
    }

    public AuthType getAuthType() {
        return this.layout.getAuthType();
    }

    public DeviceAddLayout getDeviceAddLayout() {
        return this.layout;
    }

    public static DeviceAddDialog getDeviceadddialog() {
        return deviceAddDia;
    }

    public static void setDeviceadddialog(DeviceAddDialog deviceadddialog) {
        deviceAddDia = deviceadddialog;
    }

    private File getFileFromFileChooser(String[] exts, String title) {
        HashMap<String, String> extParams = new HashMap<String, String>();
        StringBuilder extsDesc = new StringBuilder();
        for (String ext : exts) {
            extsDesc.append("*.").append(ext).append(";");
        }
        extParams.put("description", extsDesc.toString());
        extParams.put("PathId", "select_file_flag");
        extParams.put("title", title);
        File importFile = ToolFileChooser.selectFile((Window)this, exts, 0, true, extParams);
        return importFile;
    }

    private void addSelectFileListener() {
        this.layout.getSelectUploadFile().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!DeviceAddDialog.this.layout.getBatchImportBtnRadio().isSelected()) {
                    return;
                }
                String title = ResourceUtil.getString((String)"infograb.layout.device.import.title");
                File tempFile = DeviceAddDialog.this.getFileFromFileChooser(new String[]{"xls", "xlsx"}, title);
                if (tempFile == null) {
                    return;
                }
                DeviceAddDialog.this.selectFile = tempFile;
                try {
                    DeviceAddDialog.this.layout.getSelectUploadFile().setText(DeviceAddDialog.this.selectFile.getCanonicalPath());
                    DeviceAddDialog.this.layout.getSelectUploadFile().setToolTipText(DeviceAddDialog.this.selectFile.getCanonicalPath());
                }
                catch (IOException ex) {
                    LOGGER.info("Get select upload file fail..", (Object)e);
                }
                DeviceAddDialog.this.batchImportAction.setSelect2ImportFile(DeviceAddDialog.this.selectFile);
            }
        });
    }

    private void addImportFileListener() {
        this.layout.getImportButton().addActionListener((ActionListener)((Object)this.batchImportAction));
    }

    private void addDownLoadTemplateListener() {
        DownLoadAction downLoadAction = new DownLoadAction(this, "device");
        this.layout.getDownloadLabel().addMouseListener(new DownLoadActionAdapter(downLoadAction));
    }

    private void addBatchImportRadioListener() {
        this.layout.getBatchImportBtnRadio().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DeviceAddDialog.this.layout.getBatchImportBtnRadio().isSelected()) {
                    DeviceAddDialog.this.batchImportChange(Color.white, false);
                    DeviceAddDialog.this.setProxyChange(false);
                } else {
                    DeviceAddDialog.this.batchImportChange(DeviceAddDialog.this.selectUploadFileColor, true);
                    DeviceAddDialog.this.setProxyChange(DeviceTypePaneLayout.isEnable());
                }
            }
        });
    }

    private void batchImportChange(Color color, boolean enabled) {
        this.layout.getSelectUploadFile().setBackground(color);
        this.layout.getNextBtn().setVisible(enabled);
    }

    public void setProxyChange(boolean enabled) {
        this.layout.getSelectNoProxy().setEnabled(enabled);
        this.layout.getSelectSocks5().setEnabled(enabled);
        this.layout.getSelectSshForward().setEnabled(enabled);
        this.layout.getSetLinkBtn().setEnabled(enabled);
        this.setAuthType(enabled ? this.getAuthType() : AuthType.PWD);
    }

    private boolean isMigraHostScene() {
        DeviceTypePaneLayout devTypePane = this.layout.getDevTypePane();
        List<String> supportHost = Arrays.asList("Linux", "AIX", "HP-UX", "Solaris", "FusionSphere", "XenServer");
        String hostType = devTypePane.getLevel2TypeString();
        return ToolUtils.isHaveMigraScene() && supportHost.contains(hostType);
    }

    private boolean isMigraHostFS() {
        DeviceTypePaneLayout devTypePane = this.layout.getDevTypePane();
        String hostType = devTypePane.getLevel2TypeString();
        return ToolUtils.isHaveMigraScene() && "FusionSphere".equals(hostType);
    }

    static {
        snDiff = 0;
    }

    public class DownLoadActionAdapter
    extends MouseAdapter {
        private DownLoadAction downLoadAction;

        public DownLoadActionAdapter(DownLoadAction downLoadAction) {
            this.downLoadAction = downLoadAction;
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (!DeviceAddDialog.this.layout.getBatchImportBtnRadio().isSelected()) {
                return;
            }
            this.downLoadAction.clickLink(event);
        }
    }

    private class DeviceTypeQueryTask
    extends ServiceTask {
        private GrabDevNode1 dev;

        public DeviceTypeQueryTask(GrabDevNode1 dev) {
            this.dev = dev;
        }

        @Override
        protected TaskResult doTask() {
            return DeviceAddDialog.this.getDevice(this.dev);
        }
    }

    private class FetchDevNodeCall
    implements Callable<GrabDevNode1> {
        private GrabDevNode1 device;

        public FetchDevNodeCall(GrabDevNode1 info) {
            this.device = info;
        }

        private void queryDev() throws com.huawei.ism.tool.framework.platform.exception.ToolException {
            TaskResult result = null;
            result = "NetApp".equalsIgnoreCase(this.device.getDevTypeLevel2().toString()) || "EMC".equalsIgnoreCase(this.device.getDevTypeLevel2().toString()) && "VMAX".equalsIgnoreCase(this.device.getDeviceModel()) ? DeviceAddDialog.this.deviceManageService.addDevice(this.device) : DeviceAddDialog.this.deviceManageService.addDeviceBySsh(this.device);
            result = DeviceQueryErrorParser.parseErrorInfo(result);
            LogUtils.addOperaLog((String)"operalog.name.adddevices", (DevNode)this.device, (TaskResult)result);
            if (result.getResult() == TaskResult.Result.FAILED) {
                DeviceAddDialog.this.add2FailList(this.device.getIp(), result.getErrorLocaleDescription());
                LOGGER.error("Call not query device info.");
            }
        }

        @Override
        public GrabDevNode1 call() {
            try {
                this.queryDev();
                DevNodeImportAsyncExcutor.getDevNodeImportProgressDialog().handledDevCount();
            }
            catch (com.huawei.ism.tool.framework.platform.exception.ToolException e) {
                LOGGER.error("Query device info error.");
            }
            return null;
        }
    }

    private class SelectSockes5Action
    implements ActionListener {
        private SelectSockes5Action() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String msg;
            WarningDialog wrDlg;
            if (0 == DeviceAddDialog.this.layout.getSocks5List().getModel().getSize() && 0 == (wrDlg = DialogUtils.showYesNoDialog((Window)DeviceAddDialog.this, (String)(msg = ResourceUtil.getString((String)"device.adddialog.proxysetting.nosocks5.config")))).getValue()) {
                SettingService.showSettingDialog((Window)DeviceAddDialog.this, (SettingType)SettingType.Socks5Proxy);
                DeviceAddDialog.this.initSocks5Data();
                DeviceAddDialog.this.initSshData();
            }
            if (0 == DeviceAddDialog.this.layout.getSocks5List().getModel().getSize()) {
                DeviceAddDialog.this.layout.getSelectNoProxy().setSelected(true);
            }
        }
    }

    private class ForwardAction
    implements ActionListener {
        private ForwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            String msg;
            WarningDialog wrDlg;
            if (0 == DeviceAddDialog.this.layout.getSshRouteList().getModel().getSize() && 0 == (wrDlg = DialogUtils.showYesNoDialog((Window)DeviceAddDialog.this, (String)(msg = ResourceUtil.getString((String)"device.adddialog.proxysetting.nomoreroute.config")))).getValue()) {
                SettingService.showSettingDialog((Window)DeviceAddDialog.this, (SettingType)SettingType.SshForward);
                DeviceAddDialog.this.initSshData();
                DeviceAddDialog.this.initSocks5Data();
            }
            if (0 == DeviceAddDialog.this.layout.getSshRouteList().getModel().getSize()) {
                DeviceAddDialog.this.layout.getSelectNoProxy().setSelected(true);
            }
        }
    }

    private static final class SocksChangeListner
    implements ChangeListener {
        private final JRadioButton socks;
        private DeviceAddLayout layout;

        private SocksChangeListner(JRadioButton socks, DeviceAddLayout layout) {
            this.socks = socks;
            this.layout = layout;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.layout.getSocks5List().setEnabled(this.socks.isSelected());
            this.layout.getSocks5CfgLink().setEnabled(this.socks.isSelected());
        }
    }

    private final class SockLinkListener
    implements ToolHyperLinkLabel.ClickListener {
        private static final long serialVersionUID = -7793742090785827906L;

        private SockLinkListener() {
        }

        @Override
        public void clickLink(MouseEvent e) {
            SettingService.showSettingDialog((Window)DeviceAddDialog.this, (SettingType)SettingType.Socks5Proxy);
            DeviceAddDialog.this.initSshData();
            DeviceAddDialog.this.initSocks5Data();
            if (0 == DeviceAddDialog.this.layout.getSocks5List().getModel().getSize()) {
                DialogUtils.showInfoDialog((JDialog)DeviceAddDialog.this, (String)ResourceUtil.getString((String)"device.adddialog.proxysetting.nosocks5"));
                DeviceAddDialog.this.layout.getSelectNoProxy().setSelected(true);
            }
        }
    }
}

