/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.swing;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.utils.CertCheckCfmUtils;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode1;
import com.huawei.ism.tool.infograb.exception.IdcGrabException;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.infograb.swing.AbstractDeviceService;
import com.huawei.ism.tool.infograb.swing.INodeTypeQuery;
import com.huawei.ism.tool.infograb.utils.CertCheckUtil;
import com.huawei.ism.tool.infograb.utils.DeviceModelChecker;
import com.huawei.ism.tool.infograb.utils.InfoGrabDeviceTypeUtil;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.infograb.utils.migration.SmartIdcUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.json.JSONObject;
import com.huawei.migration.common.util.json.JsonUtil;
import java.awt.Window;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class DeviceAddService
extends AbstractDeviceService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DeviceAddService.class);
    public static final String DUPLICATED = "has been added.";

    public DeviceAddService(INodeTypeQuery nodeTypeQueryIntf) {
        super(nodeTypeQueryIntf);
    }

    public DeviceAddService() {
    }

    public TaskResult addDevice(GrabDevNode1 devNode) {
        INodeTypeQuery nodeTypeQuery = this.getNodeTypeQueryObject();
        TaskResult result = nodeTypeQuery.queryNodeInfo(devNode);
        return this.parseResult(result, devNode);
    }

    private TaskResult parseResult(TaskResult result, GrabDevNode1 devNode) {
        if (result.getResult() == TaskResult.Result.FAILED) {
            return this.parseFailResult(result, devNode);
        }
        if (result.getResult() == TaskResult.Result.SUCCESS) {
            return this.parseSuccessResult(result, devNode);
        }
        result.setResult(TaskResult.Result.FAILED);
        result.setErrorLocaleDescription("devicemanager.layout.device.errormsg.can.not.query.dev.type");
        return result;
    }

    private void checkDevCert(TaskResult result, GrabDevNode1 devNode) {
        if (this.certCheckPass(devNode)) {
            OperationEnum.CERTIFICATE_CHECK.successLogWithResources(devNode.getIp(), devNode.getDeviceName());
            return;
        }
        WarningDialog wd = DialogUtils.showYesNoDialog((Window)GrabContext.getInstance().getDeviceAddDialog(), (String)ResourceUtil.getStringWithParams((String)"certifcate.check.invalid", (Object[])new Object[]{devNode.getIp()}));
        try {
            if (wd.getValue() != 0) {
                result.setErrorLocaleDescription("CERT_UNTRUST");
                result.setResult(TaskResult.Result.FAILED);
                OperationEnum.CERTIFICATE_CHECK.failLogWithResources(devNode.getIp(), devNode.getDeviceName());
                return;
            }
            CertCheckCfmUtils.setCertConfirmProp((String)devNode.getDeviceSerialNumber(), (String)String.valueOf(true));
            devNode.setVerifyCertificate(false);
            LOGGER.info("Choose to add untrusted dev:{}", (Object)devNode.getUid());
            OperationEnum.CERTIFICATE_CHECK.successLogWithResources(devNode.getIp(), devNode.getDeviceName());
        }
        catch (Exception e) {
            LOGGER.error("Add dev error!", (Throwable)e);
            OperationEnum.CERTIFICATE_CHECK.failLogWithResources(devNode.getIp(), devNode.getDeviceName());
        }
    }

    private boolean certCheckPass(GrabDevNode1 devNode) {
        if (CertCheckCfmUtils.isTCfmrusteDev((String)devNode.getDeviceSerialNumber())) {
            return true;
        }
        int certCheckResult = CertCheckUtil.checkDevCert(devNode);
        if (certCheckResult != 0 && certCheckResult != -1) {
            LOGGER.error("Cert check failed.");
            return false;
        }
        LOGGER.info("Cert check pass.");
        return true;
    }

    private TaskResult parseSuccessResult(TaskResult result, GrabDevNode1 devNode) {
        if (DeviceModelChecker.isGrabByRest(devNode.getDeviceModel())) {
            this.checkDevCert(result, devNode);
        }
        if (this.hasExists(devNode)) {
            result.setErrorLocaleDescription("devicemanager.layout.device.add.deviceadddialog.deviceduplicate");
            if (!devNode.isSnFail()) {
                result.setResult(TaskResult.Result.SNFAILSAME);
            } else {
                result.setResult(TaskResult.Result.FAILED);
            }
            return result;
        }
        this.addDeviceToPanel(result, devNode);
        return result;
    }

    private void addDeviceToPanel(TaskResult result, GrabDevNode1 dev) {
        if (result.getResult() == TaskResult.Result.SUCCESS) {
            try {
                DefaultNodeProviderImpl.getInstance().addNode((DevNode)dev);
                OperationEnum.ADD_DEVICE.successLogWithResources(dev.getIp(), dev.getDeviceName());
            }
            catch (ToolException e) {
                LOGGER.error("Add device node error.", (Throwable)e);
                OperationEnum.ADD_DEVICE.failLogWithResources(dev.getIp(), dev.getDeviceName());
            }
        }
    }

    private TaskResult parseFailResult(TaskResult result, GrabDevNode1 devNode) {
        result.setResultObject(devNode);
        if (ToolUtils.isFunsionSphere(devNode) && devNode.getLoginUser().getUserName().equalsIgnoreCase("root")) {
            result.setErrorLocaleDescription(ResourceUtil.getString((String)"devicemanager.layout.device.import.fail.fusionsphere.root"));
        } else if (StringUtils.isNULLStr(result.getErrorLocaleDescription())) {
            result.setErrorLocaleDescription("devicemanager.layout.device.add.deviceadddialog.deviceconnecterror");
        } else {
            LOGGER.error("add device node failed and error description is null.");
        }
        return result;
    }

    private boolean hasExists(GrabDevNode1 devNode) {
        return DefaultNodeProviderImpl.getInstance().getNodeList().contains(devNode);
    }

    public TaskResult addGrabDevice(GrabDevNode1 devNode) {
        if (this.checkCommonAddDevice(devNode)) {
            return this.addDevice(devNode);
        }
        devNode.setItDeviceType(ItDeviceType.Storage);
        devNode.setDeviceType(DeviceType.valueOf(devNode.getDeviceModel()));
        devNode.setDeviceName(devNode.getDevTypeLevel2().toString());
        TaskResult result = this.addDeviceBySmartIdc(devNode);
        if (TaskResult.Result.SUCCESS == result.getResult()) {
            this.checkSmartIdcCert(result);
        }
        if (result.getResult() == TaskResult.Result.FAILED) {
            if (StringUtils.isNULLStr(result.getErrorLocaleDescription())) {
                result.setErrorLocaleDescription("devicemanager.layout.device.add.deviceadddialog.deviceconnecterror.common");
            }
            LOGGER.error("add device node failed.");
            return result;
        }
        if (result.getResult() == TaskResult.Result.SUCCESS) {
            if (this.hasExists(devNode)) {
                result.setErrorLocaleDescription("devicemanager.layout.device.add.deviceadddialog.deviceduplicate");
                result.setResult(TaskResult.Result.FAILED);
                return result;
            }
            this.addDeviceToPanel(result, devNode);
            return result;
        }
        result.setResult(TaskResult.Result.FAILED);
        result.setErrorLocaleDescription("devicemanager.layout.device.errormsg.can.not.query.dev.type");
        return result;
    }

    private void checkSmartIdcCert(TaskResult result) {
        LOGGER.info("Begin to check IDC cert.");
        GrabDevNode1 certNode = new GrabDevNode1();
        certNode.setIp("127.0.0.1");
        certNode.setPort(7850);
        certNode.setDeviceSerialNumber("127.0.0.1");
        this.checkDevCert(result, certNode);
    }

    private boolean checkCommonAddDevice(GrabDevNode1 devNode) {
        return !DeviceModelChecker.isGrabBySmartIdc(devNode);
    }

    private TaskResult addDeviceBySmartIdc(GrabDevNode1 devNode) {
        Map<String, Object> params = this.getParams(devNode);
        TaskResult result = new TaskResult();
        result.setResultObject(devNode);
        try {
            JSONObject jsonObject = SmartIdcUtil.INSTANCE.postAddDevice(params);
            JSONObject reasonObject = JsonUtil.safeGetJsonObject((JSONObject)jsonObject, (String)"pre_check_status_info");
            if (!JsonUtil.safeGetString((JSONObject)jsonObject, (String)"pre_check_status").equals("pass")) {
                result.setResult(TaskResult.Result.FAILED);
                LOGGER.info("Add device failed by SmartIDC: {}", (Object)this.getErrorMessage(reasonObject));
                result.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.smartidc", (Object[])new Object[]{devNode.getIp()}));
                OperationEnum.ADD_DEVICE_IDC.failLog(devNode.getIp());
            } else {
                result.setResult(TaskResult.Result.SUCCESS);
                result.setErrorLocaleDescription("devicemanager.layout.device.import.success");
                String serialNumber = JsonUtil.safeGetString((JSONObject)JsonUtil.safeGetJsonObject((JSONObject)jsonObject, (String)"additional_info"), (String)"serial_number");
                devNode.setDeviceSerialNumber(serialNumber);
                devNode.setUuid(JsonUtil.safeGetString((JSONObject)jsonObject, (String)"uid"));
                OperationEnum.ADD_DEVICE_IDC.successLog(devNode.getIp());
            }
        }
        catch (IdcGrabException e) {
            LOGGER.error("SmartIDC_Grab error.", (Throwable)e);
            result.setResult(TaskResult.Result.FAILED);
            result.setErrorLocaleDescription(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.smartidc.init"));
            OperationEnum.ADD_DEVICE_IDC.failLog(devNode.getIp());
        }
        catch (Exception e) {
            LOGGER.error("failed to add device.", (Throwable)e);
            result.setResult(TaskResult.Result.FAILED);
            result.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.smartidc", (Object[])new Object[]{devNode.getIp()}));
            OperationEnum.ADD_DEVICE_IDC.failLog(devNode.getIp());
        }
        return result;
    }

    private String getErrorMessage(JSONObject reason) {
        return JsonUtil.safeGetString((JSONObject)reason, (String)"message") + ". " + JsonUtil.safeGetString((JSONObject)reason, (String)"suggestion");
    }

    private Map<String, Object> getParams(GrabDevNode1 devNode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("log_dir", SmartIdcUtil.INSTANCE.getLogDir(devNode.getMigrType(), devNode.getDeviceName(), devNode.getDeviceModel(), devNode.getIp()));
        params.put("type", "Storage");
        params.put("vendor", devNode.getDeviceName());
        params.put("model", devNode.getDeviceModel());
        params.put("username", devNode.getLoginUser().getUserName());
        params.put("password", devNode.getLoginUser().getPassword());
        params.put("collect_type", "Configuration");
        params.put("port", devNode.getPort());
        params.put("ips", Collections.singletonList(devNode.getIp()));
        params.put("duration", 3);
        params.put("durationText", "Current");
        params.put("data_center", "Migration");
        params.put("add", true);
        params.put("service_name", "Migration");
        params.put("session_id", AESEncrypt.decrypt((String)SmartIdcUtil.INSTANCE.getEncryptedSessionId()));
        if (InfoGrabDeviceTypeUtil.isEmcVmaxDevice(devNode.getDeviceName(), devNode.getDeviceModel())) {
            params.put("symmetrixId", devNode.getDeviceSerialNumber());
        }
        return Collections.singletonMap("devices", Collections.singletonList(params));
    }
}

