/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.swing;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.infograb.entity.GrabDevNode1;
import com.huawei.ism.tool.infograb.swing.AbstractDeviceService;
import com.huawei.ism.tool.infograb.swing.DeviceAddService;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.util.NetUtil;
import java.util.List;
import org.slf4j.Logger;

public class DeviceImportService
extends AbstractDeviceService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DeviceImportService.class);
    private DeviceAddService deviceAddService = new DeviceAddService();
    private int ipIsOk = 0;

    public TaskResult importDevice(GrabDevNode1 devNode) {
        if (!this.checkDeviceIsInvalid(devNode)) {
            LOGGER.error("parse error");
            return null;
        }
        TaskResult addDeviceResult = this.deviceAddService.addDevice(devNode);
        if (addDeviceResult.getResult() == TaskResult.Result.SUCCESS) {
            addDeviceResult.setErrorLocaleDescription("devicemanager.layout.device.import.success");
        }
        if (this.handleMutiduplicate(devNode)) {
            return addDeviceResult;
        }
        if (addDeviceResult.getErrorLocaleDescription().equals("devicemanager.layout.device.add.deviceadddialog.deviceduplicate")) {
            return this.modifyDevNode(addDeviceResult);
        }
        return addDeviceResult;
    }

    public TaskResult importDeviceSetFail(DevNode devNode) {
        TaskResult addDeviceResult = new TaskResult(TaskResult.Result.FAILED);
        if (!this.checkDeviceIsInvalid(devNode)) {
            LOGGER.error("parse error");
            return null;
        }
        addDeviceResult.setResult(TaskResult.Result.FAILED);
        String errorStr = ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.notsurpotthisscene");
        addDeviceResult.setErrorLocaleDescription(errorStr);
        return addDeviceResult;
    }

    public TaskResult importDeviceSetNoProxy(DevNode devNode) {
        TaskResult addDeviceResult = new TaskResult(TaskResult.Result.FAILED);
        if (!this.checkDeviceIsInvalid(devNode)) {
            LOGGER.error("parse error");
            return null;
        }
        addDeviceResult.setResult(TaskResult.Result.FAILED);
        String errorStr = ResourceUtil.getString((String)"devnodes_import_error_no_proxy");
        addDeviceResult.setErrorLocaleDescription(errorStr);
        return addDeviceResult;
    }

    private boolean handleMutiduplicate(DevNode devNode) {
        List devNodes = DefaultNodeProviderImpl.getInstance().getNodeList();
        List<String> devIpList = devNode.getIpList();
        for (String string : devIpList) {
            for (DevNode dev : devNodes) {
                if (!string.equals(dev.getIp())) continue;
                return true;
            }
        }
        return false;
    }

    private TaskResult modifyDevNode(TaskResult result) {
        GrabDevNode1 node = (GrabDevNode1)result.getResultObject();
        try {
            DefaultNodeProviderImpl.getInstance().modifyDevice((DevNode)node);
            result.setErrorLocaleDescription(String.valueOf("devicemanager.layout.device.import.modify"));
            result.setResult(TaskResult.Result.SUCCESS);
            return result;
        }
        catch (ToolException e) {
            LOGGER.error("Modify device error.");
            return result;
        }
    }

    private boolean checkDeviceIsInvalid(DevNode devNode) {
        String ip = devNode.getIp();
        if (ip == null || ip.length() == 0) {
            this.setIpIsOk(1);
            return false;
        }
        if (!NetUtil.isValidIP((String)ip)) {
            this.setIpIsOk(2);
            return false;
        }
        boolean passwdOk = !StringUtils.isNULLStr(devNode.getLoginUser().getPassword());
        boolean usernameOK = !StringUtils.isNULLStr(devNode.getLoginUser().getUserName());
        return passwdOk && usernameOK;
    }

    public void setIpIsOk(int ipIsOk) {
        this.ipIsOk = ipIsOk;
    }

    public int getIpIsOk() {
        return this.ipIsOk;
    }
}

