/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.swing;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.infograb.entity.GrabDevNode1;
import com.huawei.ism.tool.infograb.swing.DeviceAddService;
import com.huawei.ism.tool.infograb.swing.DeviceImportService;
import com.huawei.ism.tool.infograb.swing.DeviceModifyService;
import com.huawei.ism.tool.infograb.swing.DeviceQueryErrorParser;
import com.huawei.ism.tool.infograb.swing.IDeviceManageService;
import com.huawei.ism.tool.infograb.swing.INodeTypeQuery;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.StringUtils;

public class DeviceManageService
implements IDeviceManageService {
    private DeviceAddService deviceAddService = null;
    private DeviceModifyService deviceModifyService = new DeviceModifyService();
    private DeviceImportService deviceImportService = new DeviceImportService();

    public DeviceManageService(INodeTypeQuery nodeTypeQueryIntf) {
        this.deviceAddService = new DeviceAddService(nodeTypeQueryIntf);
    }

    public DeviceManageService() {
        this.deviceAddService = new DeviceAddService();
    }

    @Override
    public TaskResult addDeviceBySsh(GrabDevNode1 devNode) {
        return this.deviceAddService.addDevice(devNode);
    }

    @Override
    public TaskResult addDevice(GrabDevNode1 devNode) {
        String newMsg;
        String errMsg;
        TaskResult taskResult = this.deviceAddService.addGrabDevice(devNode);
        if (devNode.isFileNode() && !StringUtils.isNULLStr(errMsg = (taskResult = DeviceQueryErrorParser.parseErrorInfo(taskResult)).getErrorLocaleDescription()) && !StringUtils.isNULLStr(newMsg = ResourceUtil.getString((String)errMsg)) && !"--".equals(newMsg)) {
            taskResult.setErrorLocaleDescription(newMsg);
        }
        return taskResult;
    }

    @Override
    public void deleteDevice(GrabDevNode1 devNode) {
    }

    @Override
    public TaskResult modifyDevice(GrabDevNode1 devNode) {
        return this.deviceModifyService.modifyDevice(devNode);
    }

    @Override
    public TaskResult importDevice(GrabDevNode1 devNode) {
        return this.deviceImportService.importDevice(devNode);
    }

    @Override
    public TaskResult importDeviceSetFail(GrabDevNode1 devNode) {
        return this.deviceImportService.importDeviceSetFail(devNode);
    }

    @Override
    public TaskResult importDeviceSetNoProxy(GrabDevNode1 devNode) {
        return this.deviceImportService.importDeviceSetNoProxy(devNode);
    }

    @Override
    public boolean isDevNodeExist(GrabDevNode1 devNode) {
        return DefaultNodeProviderImpl.getInstance().getNodeList().contains(devNode);
    }

    public DeviceImportService getDeviceImportService() {
        return this.deviceImportService;
    }
}

