/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.swing;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.service.task.DevResultDisplayer;
import com.huawei.ism.tool.devicemanager.service.task.DeviceModifyObserver;
import com.huawei.ism.tool.devicemanager.service.task.IDeviceOperaObserver;
import com.huawei.ism.tool.devicemanager.ui.dialog.ApplyDialog;
import com.huawei.ism.tool.infograb.entity.GrabDevNode1;
import com.huawei.ism.tool.infograb.swing.DeviceContext;
import com.huawei.ism.tool.infograb.swing.ModifyTask;
import com.huawei.ism.tool.infograb.swing.SelKeyAction;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTaskExecutor;
import com.huawei.ism.tool.obase.ui.dialogs.ProgressNumDialog;
import com.huawei.ism.tool.obase.utils.ArrayUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;

public class DeviceModifyDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -311135654180093464L;
    private Window window = null;
    private GrabDevNode1 device;
    private List<GrabDevNode1> deviceNodes = null;
    private IsmTextField username;
    private JLabel deviceType;
    private JLabel deviceName;
    private JLabel deviceSerialNumber;
    private JPasswordField password;
    private IsmTextField portField;
    private JPasswordField keypwd;
    private JComboBox<String> keyCom;
    private JButton selBtn;
    private JLabel ipAddress;
    private JButton confirm;
    private JButton cancel;
    private JButton help;
    private JButton applyTo;
    private List<DevNode> nodeLists = null;
    private List<GrabDevNode1> selectDevNode = new ArrayList<GrabDevNode1>();
    private JPasswordField developerPwd;
    private JCheckBox developerCheck;
    private JLabel developerLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.developer"));
    private JCheckBox domainNameCheck = new JCheckBox(ResourceUtil.getString((String)"infograb.layout.device.add.deviceadddialog.need.domainname"));
    private JLabel domainNameLabel = new JLabel(ResourceUtil.getString((String)"infograb.layout.device.add.deviceadddialog.domainname"));
    private IsmTextField domainName = IsmTextField.getNameTextField((String)".*", (String)"", (int)60, (int)0);
    private JCheckBox sudoCheck = new JCheckBox(ResourceUtil.getString((String)"infograb.layout.device.add.deviceadddialog.need.sudo"));

    public DeviceModifyDialog(Window panel, GrabDevNode1 device) {
        super(panel);
        this.window = panel;
        this.device = device;
        this.init();
        this.setComponentsName();
    }

    public DeviceModifyDialog(Window panel, GrabDevNode1 device, List<GrabDevNode1> devNodes) {
        super(panel);
        this.window = panel;
        this.device = device;
        this.deviceNodes = devNodes;
        this.init();
        this.setComponentsName();
    }

    private void setComponentsName() {
        this.username.setName("_TextField_username");
        this.password.setName("_PasswordField_password");
        this.portField.setName("_TextField_portField");
        this.confirm.setName("_Button_confirm");
        this.cancel.setName("_Button_cancel");
        this.applyTo.setName("_Button_applyTo");
    }

    private void init() {
        this.nodeLists = DefaultNodeProviderImpl.getInstance().getNodeList();
        this.setMinimumSize(new Dimension(320, 300));
        this.initComponent();
        this.initUi();
        this.initListener();
        this.setResizable(false);
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
        UiMethod.setBatchButtonMnemonic(this.confirm);
        UiMethod.setCloseWhenEscKeyPressed(this);
        this.setModal(true);
        this.setComponentsName();
    }

    private void initComponent() {
        this.username = UiMethod.getUsernameFiled();
        this.username.setText(this.device.getLoginUser().getUserName());
        this.password = UiMethod.getPasswordFiled();
        this.password.setText(this.device.getLoginUser().getPassword());
        this.portField = UiMethod.getSshPortFiled();
        this.portField.setText(String.valueOf(this.device.getPort()));
        this.deviceName = new JLabel(this.device.getDeviceName());
        this.deviceType = new JLabel(this.device.getDeviceType().toString());
        this.deviceSerialNumber = new JLabel(this.device.getDeviceSerialNumber());
        this.ipAddress = new JLabel(this.device.getIp());
        this.sudoCheck.setVisible(this.isMigraHostScene(this.device) && !"root".equals(this.device.getLoginUser().getUserName()));
        this.sudoCheck.setSelected(this.device.isSudoGrab());
        this.confirm = new JButton(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.okbutton"));
        this.cancel = new JButton(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.cancelbtn"));
        this.help = new JButton(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.helpbtn"));
        this.applyTo = UiMethod.createButton(ResourceUtil.getString((String)"devicemanager.layout.device.applyto"), 'A');
        this.developerPwd = UiMethod.getPasswordFiled();
        this.setDebugEnabled(false);
        this.developerCheck = new JCheckBox(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.developer.check"));
        if (!StringUtils.isNULLStr(this.device.getDeveloperPwd())) {
            this.developerPwd.setText(this.device.getDeveloperPwd());
            this.setDeveloperSelected(true);
        }
        this.keyCom = new JComboBox();
        this.keypwd = UiMethod.getPasswordFiled();
        this.selBtn = UiMethod.createButton(ResourceUtil.getString((String)"device.adddialog.key.select"), 'B');
        if (null != this.device.getPriKey()) {
            DeviceContext.getInstance().saveKeyName(this.device.getPriKey().getKeyName(), this.device.getPriKey().getKeyPath());
            for (String s : DeviceContext.getInstance().getKeyNames().keySet()) {
                this.keyCom.addItem(s);
            }
            this.keyCom.setSelectedItem(this.device.getPriKey().getKeyName());
            this.keypwd.setText(this.device.getPriKey().getKeyPwd());
        }
        UiMethod.setComponentSize(new Dimension(150, 21), new Component[]{this.username, this.password, this.portField, this.domainName, this.deviceName, this.deviceType, this.deviceSerialNumber, this.ipAddress, this.developerPwd, this.keyCom, this.keypwd});
        this.getRootPane().setDefaultButton(this.confirm);
        UiMethod.setBatchButtonMnemonic(this.applyTo, this.confirm, this.cancel, this.help);
    }

    private void initListener() {
        this.confirm.addActionListener(this);
        this.cancel.addActionListener(this);
        this.help.addActionListener(this);
        this.applyTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                ApplyDialog applyDialog = new ApplyDialog((JDialog)DeviceModifyDialog.this);
                applyDialog.initData(DeviceModifyDialog.this.getNodes());
                applyDialog.setVisible(true);
                if (!applyDialog.isCancelClose()) {
                    DeviceModifyDialog.this.selectDevNode = ToolUtils.obaseToNewNode1List(applyDialog.getSelectRow());
                }
                DeviceModifyDialog.this.selectDevNode.add(DeviceModifyDialog.this.device);
            }
        });
        this.developerCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DeviceModifyDialog.this.setDebugEnabled(DeviceModifyDialog.this.developerCheck.isSelected());
            }
        });
        this.selBtn.addActionListener(new SelKeyAction(this, this.keyCom));
        this.domainNameCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceModifyDialog.this.domainNameLabel.setEnabled(DeviceModifyDialog.this.domainNameCheck.isSelected());
                DeviceModifyDialog.this.domainName.setEnabled(DeviceModifyDialog.this.domainNameCheck.isSelected());
            }
        });
        this.username.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (DeviceModifyDialog.this.isMigraHostScene(DeviceModifyDialog.this.device)) {
                    if (DeviceModifyDialog.this.username.getText().isEmpty() || "root".equalsIgnoreCase(DeviceModifyDialog.this.username.getText())) {
                        DeviceModifyDialog.this.sudoCheck.setSelected(false);
                        DeviceModifyDialog.this.sudoCheck.setVisible(false);
                    } else {
                        DeviceModifyDialog.this.sudoCheck.setVisible(true);
                    }
                }
            }
        });
    }

    private List<DevNode> getNodes() {
        ArrayList<DevNode> nodes = new ArrayList<DevNode>();
        ArrayList<GrabDevNode1> deivces = new ArrayList<GrabDevNode1>();
        if (null != this.deviceNodes) {
            deivces.addAll(this.deviceNodes);
        } else {
            deivces.addAll(DefaultNodeProviderImpl.getInstance().getNodeList());
        }
        for (DevNode devNode : deivces) {
            if (devNode.equals(this.device) || !devNode.getDevTypeLevel2().equals(this.device.getDevTypeLevel2())) continue;
            nodes.add(devNode);
        }
        return nodes;
    }

    private void initUi() {
        this.setTitle(ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.title"));
        this.setLayout(new BorderLayout());
        this.add(UiMethod.buildFrameSpace(UCD.buildVerticalBox(null, (Component[])new Component[]{this.createCom(), UCD.buildHBoxRight((Component[])new Component[]{this.confirm, this.applyTo, this.cancel})}), 12));
    }

    private JComponent createCom() {
        JLabel deviceTypeLable = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.label.devicetype"));
        JLabel deviceNameLable = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.label.devicename"));
        JLabel ipAddressLable = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.label.ipaddress"));
        JLabel serialLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.label.serial"));
        JLabel usernameLable = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.label.username"));
        JLabel passwordLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.devicemodifydialog.label.password"));
        JLabel portLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.sshPort"));
        JLabel keyLabel = UiMethod.createColonLabel(ResourceUtil.getString((String)"device.adddialog.key.field"));
        JLabel keyPwdLabel = UiMethod.createColonLabel(ResourceUtil.getString((String)"device.adddialog.key.pwd"));
        UiMethod.setComponentSameMaxWidthSize(deviceTypeLable, deviceNameLable, ipAddressLable, serialLabel, usernameLable, passwordLabel, this.developerLabel, keyLabel, keyPwdLabel, portLabel, this.domainNameLabel);
        Box devtypecom = UCD.buildHBoxLeft((Component[])new Component[]{deviceTypeLable, this.deviceType});
        Box devnamecom = UCD.buildHBoxLeft((Component[])new Component[]{deviceNameLable, this.deviceName});
        Box ipcom = UCD.buildHBoxLeft((Component[])new Component[]{ipAddressLable, this.ipAddress});
        Box sncom = UCD.buildHBoxLeft((Component[])new Component[]{serialLabel, this.deviceSerialNumber});
        Box namecom = UCD.buildHBoxLeft((Component[])new Component[]{usernameLable, this.username});
        Box pwdcom = UCD.buildHBoxLeft((Component[])new Component[]{passwordLabel, this.password});
        Box portcom = UCD.buildHBoxLeft((Component[])new Component[]{portLabel, this.portField});
        Box sudoCom = UCD.buildHBoxLeft((Component[])new Component[]{this.sudoCheck});
        Box debugchekc = UCD.buildHBoxLeft((Component[])new Component[]{this.developerCheck});
        Box debugcom = UCD.buildHBoxLeft((Component[])new Component[]{this.developerLabel, this.developerPwd});
        Box domainNameCheckCom = UCD.buildHBoxLeft((Component[])new Component[]{this.domainNameCheck});
        Box domainNameCom = UCD.buildHBoxLeft((Component[])new Component[]{this.domainNameLabel, this.domainName});
        Box keycom = UCD.buildHBoxLeft((Component[])new Component[]{keyLabel, this.keyCom, this.selBtn});
        Box keypwdcom = UCD.buildHBoxLeft((Component[])new Component[]{keyPwdLabel, this.keypwd});
        if (this.checkDevTypeLevel(devtypecom, portcom, sudoCom, domainNameCheckCom, domainNameCom)) {
            return UCD.buildVerticalBox(null, (Component[])new Component[]{devtypecom, devnamecom, ipcom, sncom, namecom, pwdcom, portcom, domainNameCheckCom, domainNameCom, debugchekc, debugcom, keycom, keypwdcom, Box.createVerticalStrut(12)});
        }
        return UCD.buildVerticalBox(null, (Component[])new Component[]{devtypecom, devnamecom, ipcom, sncom, namecom, pwdcom, portcom, sudoCom, domainNameCheckCom, domainNameCom, debugchekc, debugcom, Box.createVerticalStrut(12)});
    }

    private boolean checkDevTypeLevel(JComponent devtypecom, JComponent portcom, JComponent sudoCom, JComponent domainNameCheckCom, JComponent domainNameCom) {
        if (this.device.getDevTypeLevel2().toString().equalsIgnoreCase("windows")) {
            portcom.setVisible(false);
            this.domainNameLabel.setEnabled(false);
            this.domainName.setEnabled(false);
        } else {
            domainNameCheckCom.setVisible(false);
            domainNameCom.setVisible(false);
        }
        if (!this.isMigraHostScene(this.device)) {
            sudoCom.setVisible(false);
        }
        return null != this.device.getPriKey();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (null != event) {
            Object source = event.getSource();
            if (source == this.confirm) {
                this.updateDevice();
            } else if (source == this.cancel) {
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    private void updateDevice() {
        String uname = this.username.getText();
        String pwd = this.getPass(this.password.getPassword());
        int port = StringUtils.str2Int(this.portField.getText());
        User user = new User(uname, pwd, port);
        if (this.device.getDevTypeLevel2().toString().equals("Oracle") && !this.device.isUseJdbc() && !uname.equals("root")) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.devicesoracleunrooterror"));
            com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)pwd);
            return;
        }
        if (!this.device.getDevTypeLevel2().toString().equalsIgnoreCase("windows")) {
            if (StringUtils.hasNULLStr(uname, pwd, this.portField.getText())) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.deviceinfoblank"));
                com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)pwd);
                return;
            }
            if (port > 65535 || port <= 0) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.devicePortInfo"));
                com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)pwd);
                return;
            }
        }
        if (StringUtils.hasNULLStr(uname, pwd)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.deviceinfoblank2"));
            com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)pwd);
            return;
        }
        if (this.domainNameCheck.isSelected()) {
            String domainNameText = this.domainName.getText();
            if (StringUtils.isNULLStr(domainNameText)) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.layout.device.add.deviceadddialog.domainname.inputnull"));
                return;
            }
            user.setDomainName(domainNameText);
            user.setUserName(domainNameText + "\\" + user.getUserName());
        }
        this.saveProcessDialog(pwd, user);
    }

    private void saveProcessDialog(String pwd, User user) {
        ProgressNumDialog progressDialog = null;
        progressDialog = null != this.window ? new ProgressNumDialog(this.window) : new ProgressNumDialog((Window)this);
        ServiceTaskExecutor taskExecutor = new ServiceTaskExecutor(progressDialog);
        if (this.selectDevNode.isEmpty()) {
            this.selectDevNode.add(this.device);
        }
        PriKeyInfo info = null;
        if (null != this.device.getPriKey()) {
            info = new PriKeyInfo();
            String name = (String)this.keyCom.getSelectedItem();
            String priPassword = this.getPass(this.keypwd.getPassword());
            info.setKeyPwd(priPassword);
            info.setKeyName(name);
            info.setKeyPath(DeviceContext.getInstance().getKeyNames().get(name));
        }
        GrabDevNode1 updateinfo = new GrabDevNode1();
        updateinfo.setLoginUser(user);
        String devPassword = this.getPass(this.developerPwd.getPassword());
        updateinfo.setDeveloperPwd(devPassword);
        updateinfo.setPriKey(info);
        updateinfo.setSudoGrab(this.sudoCheck.isSelected());
        ModifyTask task = new ModifyTask(progressDialog, this.selectDevNode, updateinfo, false);
        DevResultDisplayer displayer = new DevResultDisplayer();
        task.setDeviceModifyObserver((IDeviceOperaObserver)new DeviceModifyObserver(displayer));
        this.setVisible(false);
        taskExecutor.execute(task);
        displayer.showResult((Window)this);
        com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)pwd);
    }

    private String getPass(char[] passChars) {
        String devPwd = null;
        if (null != passChars) {
            devPwd = String.valueOf(passChars);
        }
        ArrayUtils.clearCharArray(passChars);
        return devPwd;
    }

    public void setDeveloperSelected(boolean selected) {
        this.developerCheck.setSelected(selected);
        this.setDebugEnabled(selected);
    }

    public List<DevNode> getNodeLists() {
        return this.nodeLists;
    }

    public void setNodeLists(List<DevNode> nodeLists) {
        this.nodeLists = nodeLists;
    }

    private void setDebugEnabled(boolean isEnabled) {
        this.developerPwd.setEnabled(isEnabled);
        this.developerLabel.setEnabled(isEnabled);
    }

    public void setHideDebugPwdType(Boolean pwdVisible) {
        this.developerCheck.setVisible(pwdVisible);
        this.developerLabel.setVisible(pwdVisible);
        this.developerPwd.setVisible(pwdVisible);
    }

    private boolean isMigraHostScene(GrabDevNode1 device) {
        String hostType = device.getDevTypeLevel2().toString();
        List<String> supportHost = Arrays.asList("Linux", "AIX", "HP-UX", "Solaris", "FusionSphere", "XenServer");
        return ToolUtils.isHaveMigraScene() && supportHost.contains(hostType);
    }
}

