/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.swing;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;

public final class DeviceQueryErrorParser {
    private static final String CONNECTFAIL = "build.connection.failed";
    private static final String CONNECTERRPR = "ssh.connect.unknow.error";
    private static final String CONNECTDBFAIL = "build.connection.failed.db";
    private static final String CONNECTTIMEOUT = "ssh.connect.timed.out";
    private static final String CONNECT_NO_DRIVER = "build.connection.error.no.driver";
    private static final String CONNECT_WRONG_CLI = "cli.wrong.function.called";
    private static final String CONNECT_INSPECT_LOGIN = "inspect.ssh.user.already.login";
    private static final String CONNECT_CMD_ERROR = "cmd.execute.error";
    private static final String CONNECT_FORWARD_ERR = "sshforward.initforward.err";
    private static final String CONNECT_AUTH_FAIL_ID = "ssh.connect.auth.fail";
    private static final String CONNECT_UNKNOW_ERROR = "ssh.connect.unknow.error";
    private static final String CONNECT_KEY_NOFOUNT = "ssh.connect.key.nofound";
    private static final String CONNECT_AUTH_NOSUPPTOR_KEY = "ssh.connect.auth.nosupport.key";
    private static final String CONNECT_AUTH_NOSUPPTOR_PWD = "ssh.connect.auth.nosupport.pwd";
    private static final String CONNECT_NO_DB2_DRIVER = "build.connection.error.no.db2";
    private static final String CONNECT_NO_MYSQL_DRIVER = "build.connection.error.no.mysql";
    private static final String CONNECT_NO_SQLSERVER_DRIVER = "build.connection.error.no.sqlserver";
    private static final String CONNECT_NO_ORACLE_DRIVER = "build.connection.error.no.oracle";
    private static final String[] DESC_KEY_LIST_NO_PARAMS = new String[]{"devicemanager.layout.device.import.success", "devicemanager.layout.device.add.deviceadddialog.developer.error", "devicemanager.layout.device.add.deviceadddialog.developer.notfound", "build.connection.error.no.driver", "cli.wrong.function.called", "inspect.ssh.user.already.login", "cmd.execute.error", "sshforward.initforward.err", "build.connection.error.no.db2", "build.connection.error.no.mysql", "build.connection.error.no.sqlserver", "build.connection.error.no.oracle"};
    private static final String[] DESC_KEY_LIST_WITH_IP_PARAMS = new String[]{"build.connection.failed", "ssh.connect.unknow.error", "build.connection.failed.db", "ssh.connect.timed.out", "ssh.connect.auth.fail", "ssh.connect.unknow.error", "ssh.connect.key.nofound", "ssh.connect.auth.nosupport.key", "ssh.connect.auth.nosupport.pwd", "devicemanager.layout.device.add.deviceadddialog.deviceconnecterror.common"};

    private DeviceQueryErrorParser() {
    }

    public static TaskResult parseErrorInfo(TaskResult ret) {
        if (ret == null) {
            return null;
        }
        DevNode devNode = (DevNode)ret.getResultObject();
        if (ret.getErrorLocaleDescription().equals("") && ret.getResult() == TaskResult.Result.FAILED) {
            ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.deviceconnecterror", (Object[])new Object[]{devNode.getIp()}));
            ret.setErrorId("devicemanager.layout.device.add.deviceadddialog.deviceconnecterror");
            return ret;
        }
        if (ret.getErrorLocaleDescription().equals("devicemanager.layout.device.add.deviceadddialog.deviceautherror")) {
            ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.deviceautherror", (Object[])new Object[]{devNode.getIp()}));
            ret.setErrorId("devicemanager.layout.device.add.deviceadddialog.deviceautherror");
            return ret;
        }
        if (ret.getErrorLocaleDescription().equals("devicemanager.layout.device.add.deviceadddialog.deviceduplicate")) {
            ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.deviceduplicate", (Object[])new Object[]{devNode.getIp(), devNode.getDeviceSerialNumber()}));
            ret.setErrorId("devicemanager.layout.device.add.deviceadddialog.deviceduplicate");
            return ret;
        }
        if (ret.getErrorLocaleDescription().equals("devicemanager.layout.device.add.deviceadddialog.deviceconnecterror")) {
            ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.deviceconnecterror", (Object[])new Object[]{devNode.getIp()}));
            ret.setErrorId("devicemanager.layout.device.add.deviceadddialog.deviceconnecterror");
            return ret;
        }
        if (ret.getErrorLocaleDescription().equals("devicemanager.layout.device.errormsg.can.not.query.dev.type")) {
            ret.setErrorLocaleDescription(ResourceUtil.getString((String)"devicemanager.layout.device.errormsg.can.not.query.dev.type"));
            ret.setErrorId("devicemanager.layout.device.errormsg.can.not.query.dev.type");
            return ret;
        }
        if (ret.getErrorLocaleDescription().equals("devicemanager.layout.device.import.modify")) {
            ret.setErrorLocaleDescription(ResourceUtil.getString((String)"devicemanager.layout.device.import.modify"));
            ret.setErrorId("devicemanager.layout.device.errormsg.can.not.query.dev.type");
            return ret;
        }
        if (ret.getErrorLocaleDescription().equals("devicemanager.layout.device.import.nomodify")) {
            ret.setErrorLocaleDescription(ResourceUtil.getString((String)"devicemanager.layout.device.import.nomodify"));
            ret.setErrorId("devicemanager.layout.device.import.nomodify");
            return ret;
        }
        if (ret.getErrorLocaleDescription().equals("devicemanager.layout.device.modifydialog.deviceconnecterror")) {
            ret.setErrorLocaleDescription(ResourceUtil.getString((String)"devicemanager.layout.device.modifydialog.deviceconnecterror"));
            ret.setErrorId("devicemanager.layout.device.modifydialog.deviceconnecterror");
            return ret;
        }
        DeviceQueryErrorParser.handleError(ret);
        return ret;
    }

    private static void handleError(TaskResult ret) {
        for (String desckey : DESC_KEY_LIST_NO_PARAMS) {
            if (!ret.getErrorLocaleDescription().equals(desckey)) continue;
            if (GrabContext.getInstance().isUpgradeEval() && CONNECT_NO_ORACLE_DRIVER.equals(ret.getErrorLocaleDescription())) {
                desckey = "build.connection.error.no.oracle.upgradeEval";
            }
            ret.setErrorLocaleDescription(ResourceUtil.getString((String)desckey));
            return;
        }
        for (String desckey : DESC_KEY_LIST_WITH_IP_PARAMS) {
            if (!ret.getErrorLocaleDescription().equals(desckey)) continue;
            if (GrabContext.getInstance().isUpgradeEval() && CONNECTTIMEOUT.equals(ret.getErrorLocaleDescription())) {
                desckey = "ssh.connect.timed.out.upgradeeval";
            }
            DevNode devNode = (DevNode)ret.getResultObject();
            ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)desckey, (Object[])new Object[]{devNode.getIp()}));
            return;
        }
    }
}

