/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.swing;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.utils.AuthType;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infograb.entity.DatabaseType;
import com.huawei.ism.tool.infograb.swing.DeviceAddDialog;
import com.huawei.ism.tool.infograb.swing.DeviceAddLayout;
import com.huawei.ism.tool.infograb.swing.DeviceType;
import com.huawei.ism.tool.infograb.swing.DeviceTypePanelConfig;
import com.huawei.ism.tool.infograb.utils.migration.MigrationUtils;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DeviceTypePaneLayout
extends JPanel {
    private static boolean isSshEnabled = false;
    private static final long serialVersionUID = 410327757028784211L;
    private final JComboBox<ItDeviceType> itDevType = new JComboBox();
    private final JComboBox<DeviceType> l2Type = new JComboBox();
    private final JComboBox<String> l3Model = new JComboBox();
    private final Dimension l2typeDimension = new Dimension(100, 20);
    private List<ItDeviceType> itDeviceList;
    private Map<ItDeviceType, List<String>> l2TypeContent;
    private Map<DeviceType, List<String>> l3ModelContent;
    private DeviceAddDialog parentDialog = null;

    public DeviceTypePaneLayout() {
        this.initComponent();
        this.initUI();
        this.bindListener();
    }

    private void bindListener() {
        this.itDevType.addItemListener(event -> {
            this.refreshL2View();
            this.refreshProxyView();
        });
        this.l2Type.addItemListener(event -> {
            if (ItDeviceType.Storage.equals(this.itDevType.getSelectedItem())) {
                this.refreshL3View();
            }
            this.refreshProxyView();
            if (this.l2Type.getSelectedItem() != null) {
                this.parentDialog.getDeviceAddLayout().setDefaultDescAndPort();
                this.parentDialog.getDeviceAddLayout().setConnetionInfoVisibale();
            }
        });
    }

    private void refreshL2View() {
        ItDeviceType type = (ItDeviceType)this.itDevType.getSelectedItem();
        this.l2Type.removeAllItems();
        List<String> l2Types = this.l2TypeContent.get(type);
        if (l2Types == null) {
            this.l2Type.setVisible(false);
        } else {
            for (String l2TypeStr : l2Types) {
                this.l2Type.addItem(DeviceType.valueOf(l2TypeStr));
            }
            this.l2Type.setVisible(true);
        }
        this.l3Model.setVisible(ItDeviceType.Storage.equals((Object)type));
    }

    private void refreshL3View() {
        ItDeviceType type = (ItDeviceType)this.itDevType.getSelectedItem();
        DeviceType type2 = (DeviceType)this.l2Type.getSelectedItem();
        List<String> models = this.l3ModelContent.get(type2);
        boolean l3Visible = ItDeviceType.Storage.equals((Object)type) && Objects.nonNull(models);
        this.l3Model.setVisible(l3Visible);
        this.l3Model.removeAllItems();
        if (l3Visible) {
            for (String model : models) {
                this.l3Model.addItem(model);
            }
        }
    }

    public void refreshProxyView() {
        ItDeviceType type = (ItDeviceType)this.itDevType.getSelectedItem();
        DeviceType level2Type = (DeviceType)this.l2Type.getSelectedItem();
        if (type == null) {
            return;
        }
        DeviceAddLayout layout = this.parentDialog.getDeviceAddLayout();
        boolean proxyIsEnabled = new DeviceTypePanelConfig().getProxyIsEnabled(type, level2Type);
        layout.getSelectNoProxy().setEnabled(proxyIsEnabled);
        layout.getSelectSocks5().setEnabled(proxyIsEnabled);
        layout.getSelectSshForward().setEnabled(proxyIsEnabled);
        this.setEnable(proxyIsEnabled);
        if (layout.getBatchImportBtnRadio().isSelected()) {
            layout.getSelectNoProxy().setEnabled(false);
            layout.getSelectSocks5().setEnabled(false);
            layout.getSelectSshForward().setEnabled(false);
            layout.getSetLinkBtn().setEnabled(false);
        } else {
            layout.getSelectNoProxy().setEnabled(proxyIsEnabled);
            layout.getSelectSocks5().setEnabled(proxyIsEnabled);
            layout.getSelectSshForward().setEnabled(proxyIsEnabled);
            layout.getSetLinkBtn().setEnabled(proxyIsEnabled);
        }
        if (!layout.getSetLinkBtn().isEnabled()) {
            this.parentDialog.setAuthType(AuthType.PWD);
        }
    }

    private void initComponent() {
        if (this.itDeviceList == null || this.itDeviceList.isEmpty()) {
            this.initTypeComponents();
        }
        this.itDevType.removeAllItems();
        for (ItDeviceType itType : this.itDeviceList) {
            this.itDevType.addItem(itType);
        }
        this.l2Type.setPreferredSize(this.l2typeDimension);
        this.l2Type.setVisible(this.l2TypeContent.get(this.itDevType.getSelectedItem()) != null);
        this.l3Model.setPreferredSize(new Dimension(115, 20));
        this.l3Model.setVisible(Objects.equals(ItDeviceType.Storage, this.itDevType.getSelectedItem()) && !MigrationUtils.isSanScenario());
    }

    private void initTypeComponents() {
        this.itDeviceList = new LinkedList<ItDeviceType>();
        this.l2TypeContent = new HashMap<ItDeviceType, List<String>>();
        this.l3ModelContent = new HashMap<DeviceType, List<String>>();
        if (!MigrationUtils.isSanScenario()) {
            this.itDeviceList.add(ItDeviceType.Storage);
            this.l2TypeContent.put(ItDeviceType.Storage, Arrays.asList("NetApp", "EMC", "Huawei"));
            this.l3ModelContent.put(DeviceType.valueOf("EMC"), Collections.singletonList("Isilon"));
            this.l3ModelContent.put(DeviceType.valueOf("NetApp"), Arrays.asList("C-MODE", "7-MODE"));
            this.l3ModelContent.put(DeviceType.valueOf("Huawei"), Arrays.asList("OceanStor_V3/V5", "OceanStor_9000"));
        } else {
            this.itDeviceList.add(ItDeviceType.Host);
            this.itDeviceList.add(ItDeviceType.Database);
            this.itDeviceList.add(ItDeviceType.Switch);
            this.itDeviceList.add(ItDeviceType.Storage);
            this.l2TypeContent.put(ItDeviceType.Host, this.getSupportSanHosts());
            this.l2TypeContent.put(ItDeviceType.Database, this.getSupportSanDatabases());
            this.l2TypeContent.put(ItDeviceType.Switch, this.getSupportSanSwithes());
            this.l2TypeContent.put(ItDeviceType.Storage, this.getSupportSanStorages());
            this.l3ModelContent.put(DeviceType.valueOf("EMC"), Arrays.asList("VNX_SAN", "VMAX", "Vplex", "Unity"));
            this.l3ModelContent.put(DeviceType.valueOf("HP"), Collections.singletonList("3PAR"));
            this.l3ModelContent.put(DeviceType.valueOf("IBM"), Collections.singletonList("SVC/V Series"));
            this.l3ModelContent.put(DeviceType.valueOf("NetApp"), Collections.singletonList("FAS"));
            this.l3ModelContent.put(DeviceType.valueOf("Fujistu"), Collections.singletonList("S3"));
        }
    }

    private List<String> getSupportSanStorages() {
        return Arrays.asList("EMC", "HP", "IBM", "Huawei", "NetApp", "PureStorage", "Fujistu");
    }

    private List<String> getSupportSanSwithes() {
        return Arrays.asList("Brocade", "Cisco");
    }

    private List<String> getSupportSanDatabases() {
        return Arrays.asList("Oracle", "DB2", "MySQL", "SQLServer");
    }

    private List<String> getSupportSanHosts() {
        return Arrays.asList("Linux", "AIX", "HP-UX", "Solaris", "VMware");
    }

    private void initUI() {
        JLabel typeLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.deviceType"));
        JComponent box = UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(0), typeLabel, this.itDevType, this.l2Type, this.l3Model, Box.createHorizontalStrut(1)});
        ItDeviceType type = (ItDeviceType)this.itDevType.getSelectedItem();
        this.l2Type.removeAllItems();
        List<String> l2Types = this.l2TypeContent.get(type);
        if (Objects.nonNull(l2Types)) {
            for (String l2TypeStr : l2Types) {
                this.l2Type.addItem(DeviceType.valueOf(l2TypeStr));
            }
        }
        DeviceType type2 = (DeviceType)this.l2Type.getSelectedItem();
        this.l3Model.removeAllItems();
        List<String> l3models = this.l3ModelContent.get(type2);
        if (ItDeviceType.Storage.equals((Object)type) && Objects.nonNull(l3models)) {
            for (String model : l3models) {
                this.l3Model.addItem(model);
            }
        }
        this.setLayout(new BorderLayout());
        this.add((Component)box, "West");
    }

    public JComboBox<ItDeviceType> getItDevType() {
        return this.itDevType;
    }

    public ItDeviceType getItDevTypeEnum() {
        return (ItDeviceType)this.itDevType.getSelectedItem();
    }

    public DatabaseType getDeviceTypel2Enum() {
        return DatabaseType.valueOf(this.l2Type.getSelectedItem().toString().toUpperCase(Locale.ENGLISH));
    }

    public JComboBox<DeviceType> getl2Type() {
        return this.l2Type;
    }

    public String getLevel2TypeString() {
        Object selectedItem = this.l2Type.getSelectedItem();
        if (Objects.nonNull(selectedItem)) {
            return selectedItem.toString();
        }
        return "";
    }

    public JComboBox<String> getL3Model() {
        return this.l3Model;
    }

    public String getl3ModelString() {
        Object selectedItem = this.l3Model.getSelectedItem();
        if (this.l3Model.isVisible() && Objects.nonNull(selectedItem)) {
            return selectedItem.toString();
        }
        return "";
    }

    private void setItDeviceList(List<ItDeviceType> itDeviceList) {
        this.itDeviceList = itDeviceList;
    }

    private void setL2TypeContent(Map<ItDeviceType, List<String>> l2TypeContent) {
        this.l2TypeContent = l2TypeContent;
    }

    private void setL3ModelContent(Map<DeviceType, List<String>> l3ModelContent) {
        this.l3ModelContent = l3ModelContent;
    }

    public void setItDeviceTypel2(List<ItDeviceType> itDeviceTypeList, Map<ItDeviceType, List<String>> deviceTypel2Map) {
        this.setItDeviceList(itDeviceTypeList);
        this.setL2TypeContent(deviceTypel2Map);
        this.initComponent();
    }

    public DeviceAddDialog getParentDialog() {
        return this.parentDialog;
    }

    public void setParentDialog(DeviceAddDialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    public static boolean isEnable() {
        return isSshEnabled;
    }

    public void setEnable(boolean isEnable) {
        isSshEnabled = isEnable;
    }
}

