/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.swing;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.service.ShowSysConstans;
import com.huawei.ism.tool.devicemanager.ui.action.SettingAction;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IDeviceManage;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.common.AbstractPublicUI;
import com.huawei.ism.tool.framework.pubui.common.IPublicUI;
import com.huawei.ism.tool.framework.pubui.common.IToolBoxUI;
import com.huawei.ism.tool.framework.pubui.entity.DeviceDialogType;
import com.huawei.ism.tool.framework.pubui.entity.DeviceManageSetting;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode1;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.intf.worktaker.AddDeviceService;
import com.huawei.ism.tool.infograb.swing.DefaultNodeTypeQuery;
import com.huawei.ism.tool.infograb.swing.DeviceAddDialog;
import com.huawei.ism.tool.infograb.swing.DeviceModifyDialog;
import com.huawei.ism.tool.infograb.swing.IDeviceManageUI;
import com.huawei.ism.tool.infograb.swing.INodeTypeQuery;
import com.huawei.ism.tool.infograb.swing.InfoTips;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.SettingType;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;

public class IDeviceManageUIImpl
extends AbstractPublicUI
implements IDeviceManageUI {
    protected boolean init() {
        IToolBoxUI toolBoxUI = (IToolBoxUI)PublicUiManage.getInstance().getUi(IToolBoxUI.class);
        if (null != toolBoxUI) {
            toolBoxUI.registerSettingAction((AbstractAction)new SettingAction());
        }
        return true;
    }

    @Override
    public boolean showAddDeviceDialog(Window parent, List<String> devTypeList, boolean needDevPwd, boolean needForward, boolean needSocks5) {
        DefaultNodeTypeQuery nodeTypeQuery = new DefaultNodeTypeQuery(this.getDevTypeList(devTypeList), ShowSysConstans.getShowSysCmds());
        InfoTips tips = new InfoTips("devicemanager.layout.device.add.deviceadddialog.deviceduplicate");
        DeviceAddDialog dialog = new DeviceAddDialog(parent, nodeTypeQuery, tips);
        dialog.setForwardEnabled(needForward);
        dialog.setSocks5Enabled(needSocks5);
        if (!needForward && !needSocks5) {
            dialog.setNoProxyEnabled(false);
        }
        if (needDevPwd) {
            dialog.setDeveloperSelected(true);
        }
        if (ApplicationContext.getInstance().isJunit()) {
            return false;
        }
        dialog.setVisible(true);
        return true;
    }

    @Override
    public boolean showModifyDeviceDialog(Window parent, String key, List<GrabDevNode2> devNodes, boolean pwdVisible) {
        IDeviceManage devMng = (IDeviceManage)PublicServiceManage.getInstance().getService(IDeviceManage.class);
        DevNode devNode = this.getNodeBySN(key, devMng.getNodeList());
        GrabDevNode1 devNewNode1 = ToolUtils.obaseToNode1(devNode);
        if (null == devNode) {
            return false;
        }
        if (ItDeviceType.Storage.equals((Object)devNode.getItDeviceType())) {
            DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString((String)"infograb.storage.warninginfo"));
        } else {
            DeviceModifyDialog dialog = new DeviceModifyDialog(parent, devNewNode1, ToolUtils.obaseNodetoGrabDevNode1(devNodes));
            dialog.setHideDebugPwdType(pwdVisible);
            dialog.setVisible(true);
        }
        return true;
    }

    @Override
    public boolean showModifyDeviceDialog(Window parent, boolean needDevPwd, String key, List<GrabDevNode2> devNodes) {
        IDeviceManage devMng = (IDeviceManage)PublicServiceManage.getInstance().getService(IDeviceManage.class);
        DevNode devNode = this.getDevNodeByIp(key, devMng.getNodeList());
        GrabDevNode1 devNewNode1 = ToolUtils.obaseToNode1(devNode);
        if (null == devNode) {
            return false;
        }
        DeviceModifyDialog dialog = new DeviceModifyDialog(parent, devNewNode1, ToolUtils.obaseNodetoGrabDevNode1(devNodes));
        if (needDevPwd) {
            dialog.setDeveloperSelected(true);
        }
        dialog.setVisible(true);
        return true;
    }

    private DevNode getDevNodeByIp(String ip, List<com.huawei.ism.tool.framework.pubservice.entity.DevNode> list) {
        for (com.huawei.ism.tool.framework.pubservice.entity.DevNode devNode : list) {
            if (!devNode.getIp().equals(ip)) continue;
            return EntityUtils.toOldDev(devNode);
        }
        return null;
    }

    private DevNode getNodeBySN(String snNumber, List<com.huawei.ism.tool.framework.pubservice.entity.DevNode> list) {
        for (com.huawei.ism.tool.framework.pubservice.entity.DevNode devNode : list) {
            if (!devNode.getDeviceSerialNumber().equals(snNumber)) continue;
            return EntityUtils.toOldDev(devNode);
        }
        return null;
    }

    @Override
    public boolean showAddDeviceDialog(Window parent, List<String> devTypeList, boolean needDevPwd) {
        DefaultNodeTypeQuery nodeTypeQuery = new DefaultNodeTypeQuery(this.getDevTypeList(devTypeList), ShowSysConstans.getShowSysCmds());
        return this.showDialog(parent, nodeTypeQuery, needDevPwd);
    }

    @Override
    public boolean showAddDeviceDialog(Window parent, List<String> devTypeList, INodeSupport devSupport, boolean needDevPwd) {
        DefaultNodeTypeQuery nodeTypeQuery = new DefaultNodeTypeQuery(this.getDevTypeList(devTypeList), devSupport, ShowSysConstans.getShowSysCmds());
        return this.showDialog(parent, nodeTypeQuery, needDevPwd);
    }

    @Override
    public boolean showAddDeviceDialog(Window parent, List<String> devTypeList, INodeSupport devSupport, DeviceDialogType dlgType, DeviceManageSetting manageSetting, AddDeviceService addDeviceService) {
        return this.showAddDialogByType(parent, devTypeList, devSupport, dlgType, manageSetting, addDeviceService);
    }

    @Override
    public boolean showAddDeviceDialog(Window parent, List<String> devTypeList, INodeSupport devSupport, DeviceDialogType dlgType, DeviceManageSetting manageSetting) {
        return this.showAddDialogByType(parent, devTypeList, devSupport, dlgType, manageSetting, null);
    }

    @Override
    public boolean showAddDeviceDialog(Window parent, List<String> devTypeList, INodeSupport devSupport, DeviceManageSetting manageSetting) {
        return this.showAddDialogByType(parent, devTypeList, devSupport, DeviceDialogType.StorageOnly, manageSetting, null);
    }

    @Override
    public boolean showAddDialogByType(Window parent, List<String> devTypeList, INodeSupport devSupport, DeviceDialogType dlgType, DeviceManageSetting manageSetting, AddDeviceService addDeviceService) {
        DefaultNodeTypeQuery nodeTypeQuery = new DefaultNodeTypeQuery(this.getDevTypeList(devTypeList), devSupport, ShowSysConstans.getShowSysCmds());
        InfoTips tips = new InfoTips("devicemanager.layout.device.add.deviceadddialog.deviceduplicate");
        DeviceAddDialog dialog = null;
        if (DeviceDialogType.StorageOnly.equals((Object)dlgType)) {
            dialog = new DeviceAddDialog(parent, nodeTypeQuery, tips);
        } else {
            dialog = addDeviceService != null ? new DeviceAddDialog(parent, (INodeTypeQuery)nodeTypeQuery, tips, manageSetting, addDeviceService, SettingType.Socks5Proxy, SettingType.SshForward) : new DeviceAddDialog(parent, (INodeTypeQuery)nodeTypeQuery, tips, manageSetting, null, SettingType.Socks5Proxy, SettingType.SshForward);
            DeviceAddDialog.setDeviceadddialog(dialog);
        }
        if (manageSetting.isNeedDevPwd()) {
            dialog.setDeveloperSelected(true);
        }
        dialog.setForwardEnabled(manageSetting.isNeedForward());
        dialog.setSocks5Enabled(manageSetting.isNeedSocks5());
        if (!manageSetting.isNeedForward() && !manageSetting.isNeedSocks5()) {
            dialog.setNoProxyEnabled(false);
        }
        GrabContext.getInstance().setDeviceAddDialog(dialog);
        if (ApplicationContext.getInstance().isJunit()) {
            return false;
        }
        dialog.setVisible(true);
        return true;
    }

    private boolean showDialog(Window parent, DefaultNodeTypeQuery nodeTypeQuery, boolean needDevPwd) {
        InfoTips tips = new InfoTips("devicemanager.layout.device.add.deviceadddialog.deviceduplicate");
        DeviceAddDialog dialog = new DeviceAddDialog(parent, nodeTypeQuery, tips);
        if (needDevPwd) {
            dialog.setDeveloperSelected(true);
        }
        if (ApplicationContext.getInstance().isJunit()) {
            return false;
        }
        dialog.setVisible(true);
        return true;
    }

    private List<DeviceType> getDevTypeList(List<String> devTypeStrListS) {
        ArrayList<DeviceType> type = new ArrayList<DeviceType>();
        for (String deviceTypeStr : devTypeStrListS) {
            type.add(DeviceType.valueOf(deviceTypeStr));
        }
        return type;
    }

    public List<IPublicUI> getImplementedUIs() {
        ArrayList<IPublicUI> list = new ArrayList<IPublicUI>();
        list.add(this);
        return list;
    }

    protected AbstractContext getContext() {
        return null;
    }

    @Override
    public boolean showMultiInfoDialog(Window parent, Map<String, String> deviceMap, boolean newWindow) {
        if (null == deviceMap || deviceMap.isEmpty()) {
            return true;
        }
        ArrayList failRet = new ArrayList();
        for (Map.Entry<String, String> entry : deviceMap.entrySet()) {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(entry.getKey());
            tmp.add(entry.getValue());
            failRet.add(tmp);
        }
        return SubDialogUtils.showMultiInfoDialog((Window)parent, failRet, (boolean)newWindow);
    }
}

