/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.swing;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.devicemanager.service.task.IDeviceOperaObserver;
import com.huawei.ism.tool.devicemanager.utils.LogUtils;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode1;
import com.huawei.ism.tool.infograb.swing.DeviceManageService;
import com.huawei.ism.tool.infograb.swing.DeviceQueryErrorParser;
import com.huawei.ism.tool.infograb.swing.IDeviceManageService;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTask;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.ui.dialogs.ProgressNumDialog;
import java.util.List;

public class ModifyTask
extends ServiceTask {
    private IDeviceManageService deviceManageService = new DeviceManageService();
    private ProgressNumDialog progressDialog;
    private List<GrabDevNode1> devNodes;
    private User newUser;
    private String devPwd;
    private PriKeyInfo info;
    private boolean isSudoGrab;
    private IDeviceOperaObserver deviceModifyObserver = null;
    private boolean deviceStatus = false;

    public ModifyTask(ProgressNumDialog progressDialog, List<GrabDevNode1> devNodes, boolean devStatus) {
        this.progressDialog = progressDialog;
        this.devNodes = devNodes;
        this.deviceStatus = devStatus;
    }

    public ModifyTask(ProgressNumDialog progressDialog, List<GrabDevNode1> devNodes, GrabDevNode1 updateInfo, boolean devStatus) {
        this(progressDialog, devNodes, devStatus);
        this.newUser = updateInfo.getLoginUser();
        this.info = updateInfo.getPriKey();
        this.isSudoGrab = updateInfo.isSudoGrab();
        this.setDevPwd(updateInfo.getDeveloperPwd());
        this.deviceStatus = devStatus;
    }

    public String getDevPwd() {
        if (null == this.devPwd) {
            return null;
        }
        return AESEncrypt.decrypt((String)this.devPwd);
    }

    public void setDevPwd(String devPwd) {
        this.devPwd = AESEncrypt.encrypt((String)devPwd);
    }

    public void setDeviceModifyObserver(IDeviceOperaObserver observer) {
        this.deviceModifyObserver = observer;
    }

    @Override
    protected TaskResult doTask() {
        TaskResult ret = null;
        int count = 0;
        for (GrabDevNode1 devNode : this.devNodes) {
            String uName;
            GrabDevNode1 queryDev = this.constructQueryDev(devNode);
            ret = this.deviceManageService.modifyDevice(queryDev);
            count = this.refleshProgress(count);
            ret.setResultObject(queryDev);
            if (null == (ret = DeviceQueryErrorParser.parseErrorInfo(ret))) continue;
            if (TaskResult.Result.SUCCESS.equals((Object)ret.getResult()) && !"root".equalsIgnoreCase(uName = devNode.getLoginUser().getUserName())) {
                String ip = devNode.getIp();
                GrabContext.getInstance().getAdminNameAndPassMap().remove(ip);
            }
            this.deviceModifyObserver.observe(ret, devNode.getIp());
            if (this.deviceStatus) {
                LogUtils.addOperaLog((String)"operalog.name.upddevice", (DevNode)devNode, (TaskResult)ret);
                continue;
            }
            LogUtils.addOperaLog((String)"operalog.name.moddevice", (DevNode)devNode, (TaskResult)ret);
        }
        return ret;
    }

    private GrabDevNode1 constructQueryDev(GrabDevNode1 devNode) {
        GrabDevNode1 queryDev = new GrabDevNode1();
        if (this.newUser != null) {
            queryDev.setLoginUser(this.newUser);
            queryDev.setPort(this.newUser.getPort());
        } else {
            User user = new User(devNode.getLoginUser());
            queryDev.setLoginUser(user);
            queryDev.setPort(devNode.getPort());
        }
        this.copyOldToNewNode(queryDev, devNode);
        if (!devNode.isNotSocks5Proxy()) {
            queryDev.setSocks5Proxy(devNode.getSocks5Proxy());
        }
        if (!devNode.isNotSshForward()) {
            queryDev.setSshForwardList(devNode.getSshForwardList());
        }
        if (this.getDevPwd() != null) {
            queryDev.setDeveloperPwd(this.getDevPwd());
        } else {
            queryDev.setDeveloperPwd(devNode.getDeveloperPwd());
        }
        queryDev.setIp(devNode.getIp());
        if (null != this.info) {
            queryDev.setPriKey(this.info);
        } else {
            queryDev.setPriKey(devNode.getPriKey());
        }
        queryDev.setUseJdbc(devNode.isUseJdbc());
        queryDev.setSudoGrab(this.isSudoGrab);
        return queryDev;
    }

    private void copyOldToNewNode(GrabDevNode1 newDevNode, GrabDevNode1 oldNode) {
        if (oldNode.getItDeviceType() != null) {
            newDevNode.setItDeviceType(oldNode.getItDeviceType());
        }
        if (oldNode.getDevTypeLevel2() != null) {
            newDevNode.setDevTypeLevel2(oldNode.getDevTypeLevel2());
        }
        newDevNode.setDbName(oldNode.getDbName());
    }

    private int refleshProgress(int count) {
        int progress = ++count * 100 / this.devNodes.size();
        this.progressDialog.updateProgress(progress);
        return count;
    }

    public boolean isDeviceStatus() {
        return this.deviceStatus;
    }

    public void setDeviceStatus(boolean deviceStatus) {
        this.deviceStatus = deviceStatus;
    }
}

