/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.swing;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.infograb.swing.DeviceContext;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JComboBox;

public class SelKeyAction
implements ActionListener {
    private Window parent;
    private JComboBox<String> box;

    public SelKeyAction(Window parent, JComboBox<String> box) {
        this.parent = parent;
        this.box = box;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.selKeyFile();
    }

    private void selKeyFile() {
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put("title", ResourceUtil.getString((String)"device.adddialog.key.select"));
        extParams.put("PathId", "select_keyfile_id");
        extParams.put("description", " ");
        File keyfile = ToolFileChooser.selectFile(this.parent, new String[]{""}, 0, true, extParams);
        if (keyfile == null) {
            OperationEnum.PUBLIC_KEY_IMPORT.failLog("");
            return;
        }
        if (keyfile.length() > 10240L) {
            DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"device.adddialog.key.select.error"));
            OperationEnum.PUBLIC_KEY_IMPORT.failLog("");
            return;
        }
        String name = keyfile.getName();
        boolean overWrite = false;
        if (DeviceContext.getInstance().getKeyNames().containsKey(name)) {
            WarningDialog dia = DialogUtils.showYesNoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"device.adddialog.key.select.exist"));
            if (0 != dia.getValue()) {
                OperationEnum.PUBLIC_KEY_IMPORT.failLog("");
                return;
            }
            overWrite = true;
        }
        if (!overWrite) {
            this.box.addItem(name);
            this.box.setSelectedItem(name);
        } else {
            this.box.setSelectedItem(0);
        }
        String filePath = null;
        try {
            filePath = keyfile.getCanonicalPath();
            OperationEnum.PUBLIC_KEY_IMPORT.successLog("");
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(SelKeyAction.class).error("get canonical file path error.");
            OperationEnum.PUBLIC_KEY_IMPORT.failLog("");
            return;
        }
        DeviceContext.getInstance().saveKeyName(keyfile.getName(), filePath);
    }
}

