/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui;

import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.scene.utils.SceneDataExchange;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.entity.Launcher;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.ui.AddDevDialogResult;
import com.huawei.ism.tool.infograb.ui.StorUpAddDevDialog;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.obase.entity.DeviceInfo;
import com.huawei.ism.tool.obase.entity.HostInfo;
import com.huawei.ism.tool.obase.entity.InitiatorEnttiy;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTask;
import com.huawei.ism.tool.obase.utils.CliResolverUtils;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddDevServiceTask
extends ServiceTask {
    private static final String ONLINE = "online";
    private static final Logger LOGGER = LoggerFactory.getLogger(AddDevServiceTask.class);
    StorUpAddDevDialog storAddDialog = null;
    private List<TableRow> rows;

    public AddDevServiceTask(List<TableRow> rows) {
        this.rows = rows;
    }

    @Override
    protected AddDevDialogResult doTask() {
        this.storAddDialog = new StorUpAddDevDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), this.prepereNoAddHostTips(this.rows));
        AddDevDialogResult addResult = new AddDevDialogResult(this.storAddDialog);
        return addResult;
    }

    private List<HostInfo> prepereNoAddHostTips(List<TableRow> tableRows) {
        try {
            return this.getHostInfos(tableRows);
        }
        catch (Exception e) {
            LOGGER.error("exec match error", (Throwable)e);
            SceneDataExchange.getInstance().saveKV("storageInfoStatus", "unknown");
            return Collections.emptyList();
        }
    }

    private List<HostInfo> getHostInfos(List<TableRow> tableRows) {
        ArrayList<HostInfo> hostInfos = new ArrayList<HostInfo>();
        if (!SceneUtils.isScene()) {
            return hostInfos;
        }
        String needHandleSn = SceneDataExchange.getInstance().loadKV("needHandleSn");
        String[] needHandleSns = needHandleSn.split(",");
        List<DeviceInfo> deviceInfos = this.prepareDeviceInfos(needHandleSns);
        SceneDataExchange.getInstance().saveKV("devicesInfo", JSONObject.toJSONString(deviceInfos));
        this.calcIsHostAdded(tableRows, deviceInfos);
        for (DeviceInfo devInfo : deviceInfos) {
            devInfo.setDeviceIp(SceneDataExchange.getInstance().loadKV(devInfo.getDeviceSn()));
            this.handleOneDevInfo(hostInfos, devInfo);
        }
        LOGGER.info("Need to add host:{}", (Object)((Object)hostInfos).toString());
        return hostInfos;
    }

    private void handleOneDevInfo(List<HostInfo> hostInfos, DeviceInfo devInfo) {
        for (HostInfo hostInfo : devInfo.getHostInfo()) {
            hostInfo.setStorageIp(devInfo.getDeviceIp());
            hostInfo.setStorageSn(devInfo.getDeviceSn());
            if (hostInfo.getHostInit().isEmpty() && !StringUtils.isNULLStr((String)hostInfo.getHostName())) {
                hostInfos.add(hostInfo);
            }
            Map<String, InitiatorEnttiy> initMap = devInfo.getWwnInitMap();
            String hostId = hostInfo.getHostId();
            for (Map.Entry<String, InitiatorEnttiy> entry : initMap.entrySet()) {
                InitiatorEnttiy init = entry.getValue();
                if (hostId == null || !hostId.equalsIgnoreCase(init.getHostId()) || "--".equalsIgnoreCase(hostId)) continue;
                init.setHostId(hostId);
                hostInfo.getHostInit().add(init);
            }
        }
    }

    public List<DeviceInfo> prepareDeviceInfos(String[] needHandleSns) {
        ArrayList<DeviceInfo> deviceInfos = new ArrayList<DeviceInfo>();
        for (String sn : needHandleSns) {
            if (StringUtils.isNULLStr((String)sn)) {
                LOGGER.info("device sn is null:{}", (Object)sn);
                continue;
            }
            DeviceInfo info = new DeviceInfo();
            info.setDeviceSn(sn);
            String key = sn + "_FCInitiatorInfo";
            String cli = SceneDataExchange.getInstance().loadKV(key);
            this.checkCli(cli);
            List<InitiatorEnttiy> resList = CliResolverUtils.resloveAndMapCliRetToList(cli, InitiatorEnttiy.class);
            LOGGER.info("fc resList:{}", resList);
            info.setFcInitiator(resList);
            key = sn + "_ibInitiatorInfo";
            cli = SceneDataExchange.getInstance().loadKV(key);
            this.checkCli(cli);
            resList = CliResolverUtils.resloveAndMapCliRetToList(cli, InitiatorEnttiy.class);
            info.setIbInitiator(resList);
            LOGGER.info("ib resList:{}", resList);
            key = sn + "_iSCSIInitiatorInfo";
            cli = SceneDataExchange.getInstance().loadKV(key);
            this.checkCli(cli);
            resList = CliResolverUtils.resloveAndMapCliRetToList(cli, InitiatorEnttiy.class);
            info.setIscsiInitiator(resList);
            LOGGER.info("iscsi resList:{}", resList);
            key = sn + "_HostInfo";
            cli = SceneDataExchange.getInstance().loadKV(key);
            this.checkCli(cli);
            List<HostInfo> hInfos = CliResolverUtils.resloveAndMapCliRetToList(cli, HostInfo.class);
            info.setHostInfo(hInfos);
            LOGGER.info("host resList:{}", resList);
            info.setDeviceSn(sn);
            info.setDeviceIp(SceneDataExchange.getInstance().loadKV(sn));
            deviceInfos.add(info);
        }
        return deviceInfos;
    }

    public void checkCli(String cli) {
        if (cli == null) {
            throw new NullPointerException("storageInfo is not obtained");
        }
    }

    public void calcIsHostAdded(List<TableRow> tableRows, List<DeviceInfo> deviceInfos) {
        for (TableRow row : tableRows) {
            Launcher launcher;
            GrabDevNode2 dev = (GrabDevNode2)((Object)row.getUserObject());
            if (null == this.waitWinExecEnd(dev, launcher = GrabContext.getInstance().getLauncherMap().get(dev.getDevKey()))) continue;
            LOGGER.info("launcher info : devKey:{}", (Object)dev.getDevKey());
            ArrayList<InitiatorEnttiy> hostMappedInitList = new ArrayList<InitiatorEnttiy>();
            for (DeviceInfo devInfo : deviceInfos) {
                for (HostInfo host : devInfo.getHostInfo()) {
                    this.setRelation(launcher.getFcWwns(), devInfo, host, hostMappedInitList);
                    this.setRelation(launcher.getiSCSIWwns(), devInfo, host, hostMappedInitList);
                    this.setRelation(launcher.getIBWwns(), devInfo, host, hostMappedInitList);
                    this.setRelation(launcher.getNVMEWwns(), devInfo, host, hostMappedInitList);
                }
            }
            Map otherDataMap = launcher.getOtherDataMap();
            Object status = otherDataMap.get("queryWwnSuccess");
            if (!(status instanceof Boolean) || !((Boolean)status).booleanValue()) continue;
            SceneDataExchange.getInstance().saveKV(dev.getDevKey() + "_hostMappEdInit", JSONObject.toJSONString(hostMappedInitList));
        }
    }

    public void setRelation(List<String> wwns, DeviceInfo devInfo, HostInfo host, List<InitiatorEnttiy> hostMappedInitList) {
        if (wwns == null) {
            return;
        }
        for (String wwn : wwns) {
            InitiatorEnttiy init = devInfo.getWwnInitMap().get(wwn);
            init = init == null ? devInfo.getWwnInitMap().get(wwn.toLowerCase(Locale.US)) : init;
            if ((init = init == null ? devInfo.getWwnInitMap().get(wwn.toUpperCase(Locale.US)) : init) == null || host.getHostId() == null || host.getHostId().equalsIgnoreCase("--") || !host.getHostId().equals(init.getHostId())) continue;
            host.getHostInit().add(init);
            if (!ONLINE.equalsIgnoreCase(init.getRunningStatus())) continue;
            hostMappedInitList.add(init);
        }
    }

    public Launcher waitWinExecEnd(GrabDevNode2 dev, Launcher launcher) {
        if (ToolUtils.isWindowsHost(dev)) {
            try {
                Future future = (Future)launcher.getOtherDataMap().get("taskFuture");
                Launcher result = (Launcher)future.get(120L, TimeUnit.SECONDS);
                if (result != null) {
                    LOGGER.info("exec wwn over:{}", (Object)dev.getIp());
                }
                return result;
            }
            catch (Exception e) {
                LOGGER.error("exec error", (Throwable)e);
                return null;
            }
        }
        return launcher;
    }
}

