/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.OtherScenariosEntity;
import com.huawei.ism.tool.infograb.entity.RealTimeTask;
import com.huawei.ism.tool.infograb.entity.task.DataTurboCollectStrategy;
import com.huawei.ism.tool.infograb.grab.GrabEngine;
import com.huawei.ism.tool.infograb.grab.GrabThread;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.InfoGrabTaskNumProperties;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.infograb.periodgrab.context.PeriodGrabConfig;
import com.huawei.ism.tool.infograb.periodgrab.context.PeriodGrabContext;
import com.huawei.ism.tool.infograb.periodgrab.entity.PeriodGrabTask;
import com.huawei.ism.tool.infograb.periodgrab.ui.PeriodGrabTaskDetailContainer;
import com.huawei.ism.tool.infograb.periodgrab.ui.PeriodGrabTaskPanel;
import com.huawei.ism.tool.infograb.ui.CollectScenariosLayout;
import com.huawei.ism.tool.infograb.ui.DataTurboStrategyLayout;
import com.huawei.ism.tool.infograb.ui.InfoGrabMainFrameLayout;
import com.huawei.ism.tool.infograb.ui.RealTimeTaskDetailContainer;
import com.huawei.ism.tool.infograb.ui.RealTimeTaskPanel;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Normalizer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTaskDialog
extends JDialog
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(CreateTaskDialog.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final String AUTO_TASK_PREFIX = "CollectTask_";
    private static final long serialVersionUID = 630783356143383585L;
    private static final String REAL_TIME = ResourceUtil.getString((String)"infograb.task.realtime");
    private static final String TIMELY = ResourceUtil.getString((String)"infograb.task.timely");
    private static final String DAY = ResourceUtil.getString((String)"infograb.task.status.day");
    private static final String HOUR = ResourceUtil.getString((String)"infograb.task.status.hour");
    private static final String MINUTER = ResourceUtil.getString((String)"infograb.task.status.min");
    private static final String FREQ_MINUTER = ResourceUtil.getString((String)"infograb.task.status.freq_min_unit");
    private static int taskNameMax = 17;
    private InfoGrabMainFrameLayout layout = null;
    private JLabel taskTypeLabel = null;
    private JLabel taskNameLabel = null;
    private IsmTextField taskNameField = null;
    private JComboBox taskTypecomboBox = null;
    private JCheckBox categoryMigration = null;
    private JComboBox<OtherScenariosEntity> migrTypecomboBox = null;
    private JCheckBox categoryCampatibility = null;
    private JCheckBox categoryPreUpdate = null;
    private JCheckBox categoryOther = null;
    private JComboBox<OtherScenariosEntity> otherTaskTypecomboBox = null;
    private JButton confirmBtn = null;
    private JButton cancelBtn = null;
    private CollectScenariosLayout categoryAllBox = new CollectScenariosLayout();
    private DataTurboStrategyLayout dataTurboStrategyLayout = this.categoryAllBox.getDataTurboStrategyLayout();
    private Box changeAllBox;
    private Box allBtnBox;
    private JComponent changeBaseBox;
    private JComponent padComponent;
    private JLabel monitorTimeLabel;
    private JLabel monitorFrequency;
    private IsmTextField timeTextField;
    private JComboBox<String> timeUnitComoBox;
    private IsmTextField frequencyTextField;
    private JComboBox<String> freqUnitComboBox;
    private JComponent frequencyInput;
    private JComponent frequencyLayout;
    private JLabel cpuTHLabel;
    private JLabel memTHLabel;
    private JLabel iopsTHLabel;
    private JLabel bandwidthTHLabel;
    private IsmTextField cpuTHField;
    private IsmTextField memTHField;
    private IsmTextField iopsTHField;
    private IsmTextField bandwidthTHField;
    private JComboBox<String> cpuTHUnitComboBox;
    private JComboBox<String> memTHUnitComboBox;
    private JComboBox<String> iopsTHUnitComboBox;
    private JComboBox<String> bandwidthTHUnitComboBox;
    private String tempTaskName;
    private Integer tempNumber = InfoGrabTaskNumProperties.getProperty() + 1;
    private boolean isCheckTaskName = false;
    private static final String JSON_SCENE = "jsonScene";

    public CreateTaskDialog(Window parent, InfoGrabMainFrameLayout layout) {
        super(parent);
        this.layout = layout;
        this.setMinimumSize(new Dimension(450, 400));
        this.pack();
        this.setResizable(false);
        this.setTitle(ResourceUtil.getString((String)"infograb.create_task"));
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
        this.setModal(true);
        this.initUI();
        this.initLayout();
        this.initListener();
        this.changeLayoutByTaskType(REAL_TIME);
    }

    private void initListener() {
        this.taskTypecomboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (1 == event.getStateChange()) {
                    CreateTaskDialog.this.changeLayoutByTaskType(String.valueOf(CreateTaskDialog.this.taskTypecomboBox.getSelectedItem()));
                }
            }
        });
        this.setCategoryOther();
        this.otherTaskTypecomboBox.addItemListener(e -> this.setCollectStrategyBoxVisible());
        this.migrTypecomboBox.addItemListener(e -> this.changemigrTypeEnableBySence());
        JRadioButton allButton = this.categoryAllBox.getDataTurboStrategyLayout().getAllRadio();
        allButton.addActionListener(event -> this.setPeriodicLogCompVisible(false));
        JRadioButton selectTimeRadio = this.categoryAllBox.getDataTurboStrategyLayout().getSelectTimeRadio();
        selectTimeRadio.addActionListener(event -> this.setPeriodicLogCompVisible(true));
    }

    private void changemigrTypeEnableBySence() {
        String sceneInfo = "";
        if (SceneUtils.isScene()) {
            String sceneKey = JSON_SCENE;
            sceneInfo = System.getenv(sceneKey);
        }
        if (!sceneInfo.contains("\"mainScene\":\"Migration\"")) {
            if (Objects.equals(this.migrTypecomboBox.getSelectedItem().toString(), "NAS")) {
                this.categoryOther.setSelected(false);
                this.categoryOther.setEnabled(false);
                this.categoryPreUpdate.setSelected(false);
                this.categoryPreUpdate.setEnabled(false);
                this.categoryCampatibility.setSelected(false);
                this.categoryCampatibility.setEnabled(false);
                this.otherTaskTypecomboBox.setEnabled(false);
                this.categoryAllBox.updateOtherLabelTips(false);
            } else {
                this.categoryOther.setEnabled(true);
                this.categoryPreUpdate.setEnabled(true);
                this.categoryCampatibility.setEnabled(true);
            }
        }
    }

    private void setCollectStrategyBoxVisible() {
        if (Objects.equals(this.otherTaskTypecomboBox.getSelectedItem().toString(), ResourceUtil.getString((String)"infograb.item.category.DataTurbo.collect"))) {
            this.categoryAllBox.setCollectStrategeyboxVisible(true);
        } else {
            this.categoryAllBox.setCollectStrategeyboxVisible(false);
        }
    }

    private void setPeriodicLogCompVisible(boolean flag) {
        this.categoryAllBox.getDataTurboStrategyLayout().getPeriodicTimeComp().setVisible(flag);
    }

    private void setCategoryOther() {
        this.categoryOther.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (1 == event.getStateChange()) {
                    CreateTaskDialog.this.otherTaskTypecomboBox.setEnabled(true);
                    CreateTaskDialog.this.otherTaskTypecomboBox.setSelectedIndex(0);
                    CreateTaskDialog.this.categoryAllBox.updateOtherLabelTips(true);
                } else if (2 == event.getStateChange()) {
                    CreateTaskDialog.this.otherTaskTypecomboBox.setEnabled(false);
                    CreateTaskDialog.this.categoryAllBox.updateOtherLabelTips(false);
                }
            }
        });
        this.categoryMigration.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (1 == event.getStateChange()) {
                    if (Objects.equals(CreateTaskDialog.this.migrTypecomboBox.getSelectedItem().toString(), "NAS")) {
                        CreateTaskDialog.this.categoryOther.setSelected(false);
                        CreateTaskDialog.this.categoryOther.setEnabled(false);
                        CreateTaskDialog.this.categoryPreUpdate.setSelected(false);
                        CreateTaskDialog.this.categoryPreUpdate.setEnabled(false);
                        CreateTaskDialog.this.categoryCampatibility.setSelected(false);
                        CreateTaskDialog.this.categoryCampatibility.setEnabled(false);
                        CreateTaskDialog.this.otherTaskTypecomboBox.setEnabled(false);
                        CreateTaskDialog.this.categoryAllBox.updateOtherLabelTips(false);
                    }
                    CreateTaskDialog.this.migrTypecomboBox.setEnabled(true);
                } else if (2 == event.getStateChange()) {
                    CreateTaskDialog.this.categoryOther.setEnabled(true);
                    CreateTaskDialog.this.categoryPreUpdate.setEnabled(true);
                    CreateTaskDialog.this.categoryCampatibility.setEnabled(true);
                    CreateTaskDialog.this.migrTypecomboBox.setEnabled(false);
                }
            }
        });
    }

    private void changeLayoutByTaskType(String curSelectType) {
        if (REAL_TIME.equals(curSelectType)) {
            this.categoryAllBox.setVisible(true);
            this.changeAllBox.removeAll();
            this.changeAllBox.add(this.categoryAllBox);
            this.changeAllBox.add(this.padComponent);
            this.changeAllBox.add(this.allBtnBox);
            this.changeAllBox.repaint();
            this.checkTempTaskName(AUTO_TASK_PREFIX + this.tempNumber);
            this.setSize(new Dimension(450, 300));
            this.repaint();
        } else if (TIMELY.equals(curSelectType)) {
            this.categoryAllBox.setVisible(false);
            this.changeAllBox.removeAll();
            this.changeAllBox.add(this.frequencyLayout);
            this.changeAllBox.add(this.allBtnBox);
            this.changeAllBox.repaint();
            this.checkTempTaskName(AUTO_TASK_PREFIX + this.tempNumber);
            this.setSize(new Dimension(450, 450));
            this.repaint();
        }
    }

    private void checkTempTaskName(String taskName) {
        String temp = this.taskNameField.getText().trim();
        if (null != this.tempTaskName) {
            if (!this.tempTaskName.equals(temp)) {
                this.isCheckTaskName = true;
                return;
            }
            this.taskNameField.setText(taskName);
        } else {
            this.taskNameField.setText(taskName);
        }
        this.tempTaskName = this.taskNameField.getText().trim();
    }

    private void initUI() {
        this.categoryMigration = this.categoryAllBox.getCategoryMigration();
        this.migrTypecomboBox = this.categoryAllBox.getMigrTypecomboBox();
        this.categoryCampatibility = this.categoryAllBox.getCategoryCampatibility();
        this.categoryPreUpdate = this.categoryAllBox.getCategoryPreUpdate();
        this.categoryOther = this.categoryAllBox.getCategoryOther();
        this.otherTaskTypecomboBox = this.categoryAllBox.getOtherTaskTypecomboBox();
        this.taskNameLabel = new JLabel(ResourceUtil.getString((String)"infograb.task.name"));
        this.taskTypeLabel = new JLabel(ResourceUtil.getString((String)"infograb.task.type"));
        this.taskTypecomboBox = new JComboBox();
        this.taskTypecomboBox.addItem(ResourceUtil.getString((String)"infograb.task.realtime"));
        this.taskTypecomboBox.addItem(ResourceUtil.getString((String)"infograb.task.timely"));
        Dimension taskTypeComboBoxSize = new Dimension(212, 26);
        this.taskTypecomboBox.setPreferredSize(taskTypeComboBoxSize);
        this.taskTypecomboBox.setMinimumSize(taskTypeComboBoxSize);
        this.taskTypecomboBox.setMaximumSize(taskTypeComboBoxSize);
        this.taskTypecomboBox.setSize(taskTypeComboBoxSize);
        this.monitorTimeLabel = new JLabel(ResourceUtil.getString((String)"infograb.task.status.monitor_time"));
        this.monitorFrequency = new JLabel(ResourceUtil.getString((String)"infograb.task.status.monitor_frequency"));
        this.timeTextField = IsmTextField.getNameTextField((String)"\\d{0,2}", (String)"", (int)5, (int)2);
        this.timeUnitComoBox = new JComboBox();
        this.timeUnitComoBox.addItem(ResourceUtil.getString((String)"infograb.task.status.day"));
        this.timeUnitComoBox.addItem(ResourceUtil.getString((String)"infograb.task.status.hour"));
        this.timeUnitComoBox.addItem(ResourceUtil.getString((String)"infograb.task.status.min"));
        this.timeUnitComoBox.setPreferredSize(new Dimension(20, 21));
        this.frequencyTextField = IsmTextField.getNameTextField((String)"\\d{0,2}", (String)"", (int)5, (int)2);
        this.taskNameField = IsmTextField.getNameTextField((String)".*", (String)"", (int)(taskNameMax + 1), (int)18);
        this.freqUnitComboBox = new JComboBox();
        this.freqUnitComboBox.setPreferredSize(new Dimension(20, 21));
        this.freqUnitComboBox.addItem(ResourceUtil.getString((String)"infograb.task.status.freq_min_unit"));
        this.freqUnitComboBox.addItem(ResourceUtil.getString((String)"infograb.task.status.freq_second_unit"));
        this.setMemThunit();
    }

    private void setMemThunit() {
        this.cpuTHLabel = new JLabel(ResourceUtil.getString((String)"infograb.task.setting.cpu"));
        this.memTHLabel = new JLabel(ResourceUtil.getString((String)"infograb.task.setting.mem"));
        this.iopsTHLabel = new JLabel(ResourceUtil.getString((String)"infograb.task.setting.iops"));
        this.bandwidthTHLabel = new JLabel(ResourceUtil.getString((String)"infograb.task.setting.bandwidth"));
        this.cpuTHField = IsmTextField.getNameTextField((String)"\\d{0,2}", (String)"", (int)5, (int)3);
        this.cpuTHField.setText(PeriodGrabContext.getDefaultCpuTh() + "");
        this.memTHField = IsmTextField.getNameTextField((String)"\\d{0,2}", (String)"", (int)5, (int)3);
        this.memTHField.setText(PeriodGrabContext.getDefaultMemTh() + "");
        this.iopsTHField = IsmTextField.getNameTextField((String)"\\d{0,3}", (String)"", (int)5, (int)3);
        this.iopsTHField.setText(PeriodGrabContext.getDefaultIopsTh() + "");
        this.bandwidthTHField = IsmTextField.getNameTextField((String)"\\d{0,4}", (String)"", (int)5, (int)3);
        this.bandwidthTHField.setText(PeriodGrabContext.getDefaultBwTh() + "");
        this.cpuTHUnitComboBox = new JComboBox();
        this.cpuTHUnitComboBox.addItem("%     ");
        this.cpuTHUnitComboBox.setEnabled(false);
        this.memTHUnitComboBox = new JComboBox();
        this.memTHUnitComboBox.addItem("%     ");
        this.memTHUnitComboBox.setEnabled(false);
        this.iopsTHUnitComboBox = new JComboBox();
        this.iopsTHUnitComboBox.addItem("IOPS");
        this.iopsTHUnitComboBox.setEnabled(false);
        this.bandwidthTHUnitComboBox = new JComboBox();
        this.bandwidthTHUnitComboBox.addItem("Kbps");
        this.bandwidthTHUnitComboBox.addItem("Mbps");
        this.bandwidthTHUnitComboBox.setSelectedItem(PeriodGrabContext.getDefaultBwThUnit());
        this.confirmBtn = UiMethod.createButton(ResourceUtil.getString((String)"infograb.switch_root_confirm"), 'O');
        this.cancelBtn = UiMethod.createButton(ResourceUtil.getString((String)"infograb.switch_root_cancel"), 'C');
        this.confirmBtn.addActionListener(this);
        this.cancelBtn.addActionListener(this);
    }

    private void setCompsByScene() {
        if (!SceneUtils.isScene() || System.getenv(JSON_SCENE).contains("\"mainScene\":\"Troubleshooting\"")) {
            return;
        }
        String sceneInfo = System.getenv(JSON_SCENE);
        if (sceneInfo.contains("\"mainScene\":\"Migration\"")) {
            this.migrTypecomboBox.setEnabled(true);
            this.taskTypecomboBox.setEnabled(false);
            this.changeAllBox.setEnabled(false);
            this.categoryAllBox.setAllComponentsEnabled(false);
            this.categoryPreUpdate.setSelected(false);
            this.categoryMigration.setSelected(true);
            this.categoryCampatibility.setSelected(false);
            this.categoryOther.setSelected(false);
            return;
        }
        this.taskTypecomboBox.setEnabled(false);
        this.changeAllBox.setEnabled(false);
        this.categoryAllBox.setAllComponentsEnabled(false);
        this.categoryPreUpdate.setSelected(true);
        this.categoryMigration.setSelected(false);
        this.categoryCampatibility.setSelected(false);
        this.categoryOther.setSelected(false);
    }

    private void initLayout() {
        this.padComponent = UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createGlue(), Box.createGlue()});
        Box baseBox1 = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(12), this.taskNameLabel, this.taskNameField});
        Box baseBox2 = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(12), this.taskTypeLabel, this.taskTypecomboBox});
        this.changeBaseBox = UCD.buildVerticalBox(null, (Component[])new Component[]{baseBox1, baseBox2});
        JComponent allBtn = UCD.buildHorizotalBox(null, (Component[])new Component[]{this.confirmBtn, this.cancelBtn});
        this.allBtnBox = UCD.buildHBoxRight((Component[])new Component[]{allBtn});
        this.allBtnBox.setBorder(null);
        this.changeAllBox = UiMethod.createVerticalBox(this.categoryAllBox);
        Box timeComponent = UCD.buildHBoxLeft((Component[])new Component[]{this.monitorTimeLabel, this.timeTextField, this.timeUnitComoBox});
        Box frequencyComponent = UCD.buildHBoxLeft((Component[])new Component[]{this.monitorFrequency, this.frequencyTextField, this.freqUnitComboBox});
        this.frequencyInput = UCD.buildVerticalBox(null, (Component[])new Component[]{timeComponent, frequencyComponent});
        this.frequencyInput.setBorder(BorderFactory.createTitledBorder(ResourceUtil.getString((String)"infograb.item.category.period.setting")));
        Box cpuSetting = UCD.buildHBoxLeft((Component[])new Component[]{this.cpuTHLabel, this.cpuTHField, this.cpuTHUnitComboBox});
        Box memSetting = UCD.buildHBoxLeft((Component[])new Component[]{this.memTHLabel, this.memTHField, this.memTHUnitComboBox});
        Box iopsSetting = UCD.buildHBoxLeft((Component[])new Component[]{this.iopsTHLabel, this.iopsTHField, this.iopsTHUnitComboBox});
        Box bandwidthSetting = UCD.buildHBoxLeft((Component[])new Component[]{this.bandwidthTHLabel, this.bandwidthTHField, this.bandwidthTHUnitComboBox});
        JComponent settingComp = UCD.buildVerticalBox((Border)BorderFactory.createTitledBorder(ResourceUtil.getString((String)"infograb.task.setting.title")), (Component[])new Component[]{cpuSetting, memSetting, iopsSetting, bandwidthSetting});
        this.frequencyLayout = UCD.buildVerticalBox(null, (Component[])new Component[]{settingComp, this.frequencyInput, this.allBtnBox});
        Box contentArea = UiMethod.createVerticalBox(this.changeBaseBox, UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(12), this.changeAllBox, Box.createHorizontalStrut(12)}));
        this.add(contentArea);
        this.setCompsByScene();
    }

    private boolean checkTaskName(String taskName) {
        if (this.isBlankFileName(taskName)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.task.status.no_task_name"));
            return false;
        }
        if (!this.isCorrectFileName(taskName)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.task.status.invalid_task_name"));
            return false;
        }
        if (GrabContext.getInstance().getTaskNameSet().contains(taskName)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.task.status.same_task_name"));
            return false;
        }
        return true;
    }

    private boolean checkPeriodField() {
        if ("".equalsIgnoreCase(this.cpuTHField.getText().trim())) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.task.status.cputh.check"));
            return false;
        }
        if ("".equalsIgnoreCase(this.memTHField.getText().trim())) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.task.status.memth.check"));
            return false;
        }
        if ("".equalsIgnoreCase(this.iopsTHField.getText().trim())) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.task.status.iopsth.check"));
            return false;
        }
        if ("".equalsIgnoreCase(this.bandwidthTHField.getText().trim())) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.task.status.bandwidth.check"));
            return false;
        }
        return true;
    }

    public void createTask() {
        if (REAL_TIME.equals(this.taskTypecomboBox.getSelectedItem().toString())) {
            if (!this.isCheckTaskName) {
                InfoGrabTaskNumProperties.setProperty(this.tempNumber.toString());
            }
            this.realtimeConfirm();
        } else if (TIMELY.equals(this.taskTypecomboBox.getSelectedItem().toString())) {
            if (!this.isCheckTaskName) {
                InfoGrabTaskNumProperties.setProperty(this.tempNumber.toString());
            }
            this.timelyConfirm();
        }
    }

    public JCheckBox getCategoryPreUpdate() {
        return this.categoryPreUpdate;
    }

    public JCheckBox getCategoryMigration() {
        return this.categoryMigration;
    }

    public JComboBox<OtherScenariosEntity> getMigrTypecomboBox() {
        return this.migrTypecomboBox;
    }

    private boolean checkRealTimeOrPeriodInput() {
        if (REAL_TIME.equals(this.taskTypecomboBox.getSelectedItem().toString())) {
            boolean isOneSelected = this.categoryCampatibility.isSelected() || this.categoryMigration.isSelected() || this.categoryOther.isSelected();
            boolean isTwoSelected = this.categoryPreUpdate.isSelected();
            if (!isOneSelected && !isTwoSelected) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.task.status.not_select_category"));
                return false;
            }
        } else if (TIMELY.equals(this.taskTypecomboBox.getSelectedItem().toString())) {
            String timeText = this.timeTextField.getText().trim();
            String frequencyText = this.frequencyTextField.getText().trim();
            if (StringUtils.isNULLStr((String)timeText) || StringUtils.isNULLStr((String)frequencyText)) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.task.status.not_time_frequency"));
                return false;
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (null != event) {
            Object source = event.getSource();
            if (source == this.confirmBtn) {
                if (!this.checkTaskName(this.taskNameField.getText())) {
                    return;
                }
                if (!this.checkPeriodField()) {
                    return;
                }
                this.checkTempTaskName(AUTO_TASK_PREFIX + this.tempNumber);
                if (!this.checkRealTimeOrPeriodInput()) {
                    return;
                }
                if (!this.isDataTurboStartTimeValid()) {
                    return;
                }
                this.createTask();
            } else if (source == this.cancelBtn) {
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    private boolean isDataTurboStartTimeValid() {
        LocalDateTime end;
        LocalDateTime start;
        if (this.categoryOther.isSelected() && this.dataTurboStrategyLayout.getSelectTimeRadio().isSelected() && (start = LocalDateTime.parse(this.dataTurboStrategyLayout.getStartTimeChooseField().getText(), DATE_TIME_FORMATTER)).isAfter(end = LocalDateTime.parse(this.dataTurboStrategyLayout.getEndTimeChooseField().getText(), DATE_TIME_FORMATTER))) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.task.DataTurbo.start_time_invalid"));
            return false;
        }
        return true;
    }

    private boolean isCorrectFileName(String str) {
        String regex = "[\\w ]+";
        if (null != str) {
            if ((str = Normalizer.normalize(str, Normalizer.Form.NFKC)).contains("  ")) {
                return false;
            }
            return str.matches(regex);
        }
        return false;
    }

    private boolean isBlankFileName(String taskName) {
        if (null == taskName) {
            return false;
        }
        return "".equalsIgnoreCase(taskName.trim());
    }

    private void timelyConfirm() {
        PeriodGrabTask task = new PeriodGrabTask();
        task.setId(System.currentTimeMillis() + "");
        task.setTaskName(this.taskNameField.getText() + "");
        task.setTaskType(this.taskTypecomboBox.getSelectedItem() + "");
        PeriodGrabConfig monitorConfig = new PeriodGrabConfig();
        String timeText = this.timeTextField.getText().trim();
        String timeUnit = String.valueOf(this.timeUnitComoBox.getSelectedItem());
        StringBuilder timeAndUnit = new StringBuilder();
        timeAndUnit.append(timeText);
        timeAndUnit.append(':');
        timeAndUnit.append(timeUnit);
        monitorConfig.setMonitorTimeAndUnit(timeAndUnit.toString());
        String frequencyText = this.frequencyTextField.getText().trim();
        String freqUnit = String.valueOf(this.freqUnitComboBox.getSelectedItem());
        StringBuilder freqAndUnit = new StringBuilder();
        this.setMonitorConfig(monitorConfig, frequencyText, freqUnit, freqAndUnit);
        long monitorTime = 0L;
        if (DAY.equals(timeUnit)) {
            monitorTime = Long.valueOf(timeText) * 24L * 60L * 60L;
        } else if (HOUR.endsWith(timeUnit)) {
            monitorTime = Long.valueOf(timeText) * 60L * 60L;
        } else if (MINUTER.endsWith(timeUnit)) {
            monitorTime = Long.valueOf(timeText) * 60L;
        }
        long monitorFreq = 0L;
        if (FREQ_MINUTER.equals(freqUnit)) {
            monitorFreq = Long.valueOf(frequencyText) * 60L;
        } else if (this.rootPaneCheckingEnabled) {
            monitorFreq = Long.valueOf(frequencyText);
        }
        if (monitorTime == 0L || monitorFreq == 0L) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.task.status.tims.zero"));
            return;
        }
        long monitorCount = monitorTime / monitorFreq;
        if (monitorCount == 0L) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.task.status.monitor.input_erro"));
            return;
        }
        this.checkPeriodGrabTask(task, monitorConfig, monitorTime, monitorFreq);
    }

    private void setMonitorConfig(PeriodGrabConfig monitorConfig, String frequencyText, String freqUnit, StringBuilder freqAndUnit) {
        freqAndUnit.append(frequencyText);
        freqAndUnit.append(':');
        freqAndUnit.append(freqUnit);
        monitorConfig.setMonitorFreqAndUnit(freqAndUnit.toString());
        monitorConfig.setCpuThreshold(this.cpuTHField.getText().trim());
        monitorConfig.setMemThreshold(this.memTHField.getText().trim());
        monitorConfig.setIopsThreshold(this.iopsTHField.getText().trim());
        monitorConfig.setBandwidthThreshold(this.bandwidthTHField.getText().trim() + ":" + ((String)this.bandwidthTHUnitComboBox.getSelectedItem()).trim());
    }

    private void checkPeriodGrabTask(final PeriodGrabTask task, PeriodGrabConfig monitorConfig, long monitorTime, long monitorFreq) {
        GrabContext.getInstance().getTaskNameSet().add(this.taskNameField.getText());
        monitorConfig.setMonitorTime(monitorTime);
        monitorConfig.setMonitorFreq(monitorFreq);
        task.setMonitorConfig(monitorConfig);
        PeriodGrabTaskPanel itemPeriod = new PeriodGrabTaskPanel(task);
        PeriodGrabTaskDetailContainer taskContainer = new PeriodGrabTaskDetailContainer(itemPeriod);
        itemPeriod.setTaskDetailContainer(taskContainer);
        itemPeriod.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                PeriodGrabTaskPanel selectedPanel = (PeriodGrabTaskPanel)event.getSource();
                CreateTaskDialog.this.layout.setTaskSelectStatus();
                selectedPanel.getContentPan().setBorder(BorderFactory.createLineBorder(new Color(Integer.parseInt("990000", 16)), 1));
                GrabContext.getInstance().setCurrentTask(selectedPanel);
                Map<GrabDevNode2, GrabThread> currThreadMap = GrabEngine.getInstance().getCurrThreadMap();
                for (Map.Entry<GrabDevNode2, GrabThread> tempEntiy : currThreadMap.entrySet()) {
                    tempEntiy.getValue().getGrabService().startGifLoading();
                }
                CreateTaskDialog.this.layout.getSplitPane().setRightComponent(selectedPanel.getTaskDetailContainer());
                CreateTaskDialog.this.layout.repaint();
                log.info("selected periodgrab task {}", (Object)task.getTaskName());
            }
        });
        this.layout.setTaskSelectStatus();
        this.layout.getTaskPanel().add(itemPeriod);
        GrabContext.getInstance().getCollectTasks().add(itemPeriod);
        GrabContext.getInstance().setCurrentTask(itemPeriod);
        this.layout.getSplitPane().setRightComponent(itemPeriod.getTaskDetailContainer());
        this.layout.repaint();
        this.setVisible(false);
        log.info("create a timely task.");
        this.dispose();
    }

    private void realtimeConfirm() {
        GrabContext.getInstance().getTaskNameSet().add(this.taskNameField.getText());
        RealTimeTask task = new RealTimeTask();
        task.setId(System.currentTimeMillis() + "");
        task.setTaskName(this.taskNameField.getText());
        task.setTaskType(this.taskTypecomboBox.getSelectedItem() + "");
        task.setMigrType(String.valueOf(this.migrTypecomboBox.getSelectedItem()));
        ArrayList<String> selectCategory = new ArrayList<String>();
        if (this.categoryCampatibility.isSelected()) {
            selectCategory.add(this.categoryCampatibility.getText());
        }
        if (this.categoryMigration.isSelected()) {
            selectCategory.add(this.categoryMigration.getText());
        }
        if (this.categoryPreUpdate.isSelected()) {
            selectCategory.add(this.categoryPreUpdate.getText());
        }
        if (this.categoryOther.isSelected()) {
            String otherTaskType = String.valueOf(this.otherTaskTypecomboBox.getSelectedItem());
            if (log.isInfoEnabled()) {
                log.info("****[other task type is:{}]****", (Object)otherTaskType);
            }
            selectCategory.add(otherTaskType);
            task.setDataTurboCollectStrategy(this.getDataTurboCollectStrategy(otherTaskType));
        }
        task.setTaskCategory(selectCategory);
        this.setVisible(false);
        RealTimeTaskPanel item = new RealTimeTaskPanel(task);
        RealTimeTaskDetailContainer taskContainer = new RealTimeTaskDetailContainer(item);
        item.setTaskDetailContainer(taskContainer);
        item.addMouseListener(new ItemMouseAdapter(task));
        this.layout.setTaskSelectStatus();
        this.layout.getTaskPanel().add(item);
        GrabContext.getInstance().getCollectTasks().add(item);
        GrabContext.getInstance().setCurrentTask(item);
        this.layout.getSplitPane().setRightComponent(item.getTaskDetailContainer());
        this.layout.repaint();
        log.info("create a realtime Task ,taskName = {}  ,Application Scenario is : {}", (Object)StringUtils.getCleanMessage((String)this.taskNameField.getText()), (Object)((Object)selectCategory).toString());
        OperationEnum.ADD_TASK.successLog("");
        this.dispose();
    }

    private DataTurboCollectStrategy getDataTurboCollectStrategy(String otherTaskType) {
        DataTurboCollectStrategy dataTurboCollectStrategy = new DataTurboCollectStrategy();
        if (otherTaskType.equals(ResourceUtil.getString((String)"infograb.item.category.DataTurbo.collect"))) {
            dataTurboCollectStrategy.setModel(this.dataTurboStrategyLayout.getCollectModel());
            dataTurboCollectStrategy.setStartTime(this.dataTurboStrategyLayout.getStartTimeChooseField().getText());
            dataTurboCollectStrategy.setEndTime(this.dataTurboStrategyLayout.getEndTimeChooseField().getText());
            dataTurboCollectStrategy.setSplitVolumeSize(this.dataTurboStrategyLayout.getSplitVolumeSize());
        }
        return dataTurboCollectStrategy;
    }

    private void ultrapathConfirm() {
        GrabContext.getInstance().getTaskNameSet().add(this.taskNameField.getText());
        final RealTimeTask task = new RealTimeTask();
        task.setId(System.currentTimeMillis() + "");
        task.setTaskName(this.taskNameField.getText());
        task.setTaskType(this.taskTypecomboBox.getSelectedItem() + "");
        this.setVisible(false);
        RealTimeTaskPanel item = new RealTimeTaskPanel(task);
        RealTimeTaskDetailContainer taskContainer = new RealTimeTaskDetailContainer(item);
        item.setTaskDetailContainer(taskContainer);
        item.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                RealTimeTaskPanel selectedPanel = (RealTimeTaskPanel)event.getSource();
                CreateTaskDialog.this.layout.setTaskSelectStatus();
                selectedPanel.getContentPan().setBorder(BorderFactory.createLineBorder(new Color(Integer.parseInt("990000", 16)), 1));
                GrabContext.getInstance().setCurrentTask(selectedPanel);
                CreateTaskDialog.this.layout.getSplitPane().setRightComponent(selectedPanel.getTaskDetailContainer());
                CreateTaskDialog.this.layout.repaint();
                if (log.isInfoEnabled()) {
                    log.info("selected realtime task {}", (Object)task.getTaskName());
                }
            }
        });
        this.layout.setTaskSelectStatus();
        this.layout.getTaskPanel().add(item);
        GrabContext.getInstance().getCollectTasks().add(item);
        GrabContext.getInstance().setCurrentTask(item);
        this.layout.getSplitPane().setRightComponent(item.getTaskDetailContainer());
        this.layout.repaint();
        this.dispose();
    }

    private final class ItemMouseAdapter
    extends MouseAdapter {
        private final RealTimeTask task;

        public ItemMouseAdapter(RealTimeTask task) {
            this.task = task;
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            RealTimeTaskPanel selectedPanel = (RealTimeTaskPanel)event.getSource();
            CreateTaskDialog.this.layout.setTaskSelectStatus();
            selectedPanel.getContentPan().setBorder(BorderFactory.createLineBorder(new Color(Integer.parseInt("990000", 16)), 1));
            GrabContext.getInstance().setCurrentTask(selectedPanel);
            Map<GrabDevNode2, GrabThread> currThreadMap = GrabEngine.getInstance().getCurrThreadMap();
            for (Map.Entry<GrabDevNode2, GrabThread> tempEntiy : currThreadMap.entrySet()) {
                tempEntiy.getValue().getGrabService().startGifLoading();
            }
            CreateTaskDialog.this.layout.getSplitPane().setRightComponent(selectedPanel.getTaskDetailContainer());
            CreateTaskDialog.this.layout.repaint();
            if (log.isInfoEnabled()) {
                log.info("selected realtime task {}", (Object)this.task.getTaskName());
            }
        }
    }
}

