/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.ui.InfoGrabIsmTable;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.table.TableModel;

public class DevChooseDialog
extends JDialog {
    private static final long serialVersionUID = -2632698898249131092L;
    private static final Dimension SIZE = new Dimension(350, 400);
    private DefaultTableModel devTableModel = new DefaultTableModel(new String[]{ResourceUtil.getString((String)"infograb.devicetable.head.hostname"), ResourceUtil.getString((String)"infograb.devicetable.head.devicemodel"), ResourceUtil.getString((String)"infograb.devicetable.head.ip")}, new int[0]);
    private InfoGrabIsmTable devTable = new InfoGrabIsmTable((TableModel)this.devTableModel);
    private JButton ok = UiMethod.createButton(ResourceUtil.getString((String)"infograb.collectresult.sendmail.ok"), 'O');
    private JButton cancel = UiMethod.createButton(ResourceUtil.getString((String)"infograb.collectresult.sendmail.cancel"), 'C');
    private List<GrabDevNode2> selectDevNodes = new ArrayList<GrabDevNode2>();
    private TableScrollPane tableScrollPane = new TableScrollPane((IsmTable)this.devTable, false, false, true);

    public DevChooseDialog(JDialog parent) {
        super((Dialog)parent, true);
        this.setSize(SIZE);
        this.setTitle(ResourceUtil.getString((String)"infograb.collectresult.sendmail.applyto.title"));
        this.initUI();
        this.initListener();
        this.setButtonsName();
        SwingUtil.putParentCenter((Window)this, (Window)parent);
    }

    private void setButtonsName() {
        this.ok.setName("_Button_ok");
        this.cancel.setName("_Button_cancel");
    }

    public void initData(List<GrabDevNode2> devNodes) {
        if (devNodes == null) {
            return;
        }
        this.devTableModel.removeAll();
        this.devTable.removeAll();
        for (GrabDevNode2 devNode : devNodes) {
            DefaultTableRow row = new DefaultTableRow(3, (Object)devNode, (Object)devNode.getDeviceSerialNumber());
            int i = 0;
            row.setValueAt(i++, (Object)devNode.getDeviceName());
            row.setValueAt(i++, (Object)devNode.getDeviceType().toString());
            row.setValueAt(i++, (Object)devNode.getIp());
            this.devTableModel.addRow(new TableRow[]{row});
            if (!this.selectDevNodes.contains((Object)devNode)) continue;
            this.devTable.markTableRow(new TableRow[]{row});
        }
    }

    public List<GrabDevNode2> getSelectDevNode() {
        return this.selectDevNodes;
    }

    private void getSelectData() {
        this.selectDevNodes.clear();
        List rows = this.devTable.getMarkedRows();
        for (TableRow row : rows) {
            this.selectDevNodes.add((GrabDevNode2)((Object)row.getUserObject()));
        }
    }

    private void initListener() {
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevChooseDialog.this.setVisible(false);
            }
        });
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevChooseDialog.this.getSelectData();
                DevChooseDialog.this.setVisible(false);
            }
        });
    }

    private void initUI() {
        JComponent infoComp = UiMethod.buildFrameSpace(UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildLeftLabel(ResourceUtil.getString((String)"infograb.collectresult.sendmail.applyto.info"))}), 0);
        this.setLayout(new BorderLayout());
        JComponent view = UCD.buildVerticalBox(null, (Component[])new Component[]{infoComp, this.tableScrollPane, UCD.buildHBoxRight((Component[])new Component[]{this.ok, this.cancel})});
        this.add((Component)UiMethod.buildFrameSpace(view, 12), "Center");
    }
}

