/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabFileFactory;
import com.huawei.ism.tool.infograb.ui.InfoGrabIsmTable;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.table.TableModel;
import org.slf4j.Logger;

public class ErrorDetailInfoDialog
extends PublicDialog {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ErrorDetailInfoDialog.class);
    private static final long serialVersionUID = 8218275154634607967L;
    private static final String TAB = ":\t";
    private String[] detailInfoList;
    private final String[] tableHeaders = this.initColumnName();
    private DefaultTableModel detailTableModel;
    private InfoGrabIsmTable detailTable;

    public ErrorDetailInfoDialog(String info, JFrame parent) {
        super(parent, true);
        this.setModal(true);
        if (info != null) {
            this.detailInfoList = info.split(GrabFileFactory.ENTER);
        }
        this.setTitle(ResourceUtil.getString((String)"infograb.error.infograbdetail.title"));
        this.initUI();
        this.pack();
        this.initOkBtnListener();
        SwingUtil.putParentCenter((Window)this, (Window)parent);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
    }

    private String[] initColumnName() {
        return new String[]{ResourceUtil.getString((String)"infograb.detailArea.head.cmd"), ResourceUtil.getString((String)"infograb.detailArea.head.result"), ResourceUtil.getString((String)"infograb.devicetable.cell.details")};
    }

    private void initUI() {
        try {
            this.setHelpButtonVisiable(false);
            this.setCancelButtonVisible(false);
            this.detailTableModel = new DefaultTableModel(this.tableHeaders, new int[0]);
            this.detailTable = new InfoGrabIsmTable((TableModel)this.detailTableModel);
            this.setTableRowSize();
            this.fillDetailTable();
            TableScrollPane detailArea = new TableScrollPane((IsmTable)this.detailTable, true, true, false);
            detailArea.setPreferredSize(new Dimension(960, 280));
            detailArea.setMinimumSize(new Dimension(960, 280));
            this.getContentPanel().setLayout(new BorderLayout());
            this.getContentPanel().add((Component)UiMethod.buildFrameSpace((JComponent)detailArea, 12), "Center");
        }
        catch (Exception e) {
            LOGGER.error("Error happened in ErrorDetailInfoDialog", (Throwable)e);
        }
        this.setAppButtonVisible(false);
    }

    protected final void initOkBtnListener() {
        this.getOkBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorDetailInfoDialog.this.dispose();
            }
        });
    }

    public void fillDetailTable() {
        if (null == this.detailInfoList) {
            return;
        }
        int totalNumber = this.detailInfoList.length;
        for (int i = 0; i < totalNumber; ++i) {
            DefaultTableRow row = new DefaultTableRow(3, (Object)this.detailInfoList[i]);
            String[] detailInfoArray = this.detailInfoList[i].split(TAB);
            if (detailInfoArray.length > 1) {
                String[] errMsgs = this.detailInfoList[i].split(TAB);
                this.fillErrMsgs(errMsgs, (TableRow<String, String>)row);
            } else {
                row.setValueAt(0, (Object)this.detailInfoList[i]);
                if (ResourceUtil.getString((String)"infograb.python.errmsg.exeitemfailed").equals(this.detailInfoList[i])) {
                    row.setValueAt(1, (Object)ResourceUtil.getString((String)"infograb.dev.status.collectstopped"));
                } else {
                    row.setValueAt(1, (Object)ResourceUtil.getString((String)"infograb.detailArea.ready"));
                }
            }
            this.detailTableModel.addRow(new TableRow[]{row});
        }
    }

    private void setTableRowSize() {
        this.detailTable.getColumnModel().getColumn(0).setPreferredWidth(235);
        this.detailTable.getColumnModel().getColumn(1).setPreferredWidth(135);
        this.detailTable.getColumnModel().getColumn(2).setPreferredWidth(580);
    }

    private void fillErrMsgs(String[] errMsgs, TableRow<String, String> row) {
        for (int j = 0; j < 3; ++j) {
            String errMsg = errMsgs[j];
            if (errMsg.equals(ResourceUtil.getString((String)"infograb.dev.status.noecollect"))) {
                row.setValueAt(j, (Object)new StringBuilder("<html><font color=#F6B748>").append(errMsg).append("</font></html>"));
                continue;
            }
            if (errMsg.equals(ResourceUtil.getString((String)"infograb.python.errmsg.failed"))) {
                row.setValueAt(j, (Object)new StringBuilder("<html><font color=#CC1414>").append(errMsg).append("</font></html>"));
                continue;
            }
            row.setValueAt(j, (Object)errMsg);
        }
    }
}

