/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.ExtendedCommandEntity;
import com.huawei.ism.tool.infograb.entity.ExtendedCommandImportResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.GrabFlow;
import com.huawei.ism.tool.infograb.entity.Item;
import com.huawei.ism.tool.infograb.entity.Module;
import com.huawei.ism.tool.infograb.grab.GrabFlowAdapter;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.infograb.ui.ExtendedFunctionSetupPanel;
import com.huawei.ism.tool.infograb.ui.action.ImportExtendedCommandTask;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.util.SwingUtil;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class ExtendedFunctionSetupDialog
extends PublicDialog {
    private static final long serialVersionUID = -598763772556833388L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ExtendedFunctionSetupDialog.class);
    private static final int DIALOG_WIDTH = 715;
    private static final int DIALOG_HEIGTH = 545;
    private static final int DIALOG_LOCATION_MOVED_MARGIN = 10;
    private static final int IMPORT_PROGRESS_DIALOG_WIDTH = 250;
    private static final String WARNING_TIPS = ResourceUtil.getString((String)"extended.command.collect.dialog.confirm.tips");
    private static final String CONFIRM_CHECK_INFO = ResourceUtil.getString((String)"extended.command.collect.dialog.confirm.check.box");
    private static final String SAVEPATH_EXTENDED_CMD_ID = "download_extended_cmd_template_file";
    private static final String DEFAULT_EXTENDED_CMD_TEMPLATE_FILE_NAME = "Extended_Command_List.xls";
    private static final String TEMPLATE_FILE_PATH = "/config/templatefile/";
    private static final String OPENPATH_EXTENDED_ID = "open_extended_file_flag";
    private static final String SELECTED_SIGN_FILE_EXTS = "sign";
    private static final String SELECTED_SIGN_FILE_TITLE = ResourceUtil.getString((String)"extended.command.collect.dialog.import.desc.sign");
    private static final String SELECTED_CMD_FILE_EXTS = "xls";
    private static final String SELECTED_CMD_FILE_TITLE = ResourceUtil.getString((String)"extended.command.collect.dialog.import.desc.cmd");
    private static final String EXTENDED_COLLECTION_SCRIPT = "script/advanced/extendedCommand.py";
    private ExtendedFunctionSetupPanel layout = new ExtendedFunctionSetupPanel();
    private Window parent;
    private File signFile;
    private File cmdFile;
    private ExtendedCommandImportResult importResult;
    private boolean isCheckPass;

    public ExtendedFunctionSetupDialog(Window parent) {
        super(parent);
        this.parent = parent;
        this.init();
    }

    private void init() {
        this.initUI();
        this.initListener();
    }

    private void initListener() {
        this.addOkListener();
        this.addDownloadListener();
        this.addSelectSignListener();
        this.addDeleteSignListener();
        this.addSelectCmdListener();
        this.addDeleteCmdListener();
        this.addImportListener();
    }

    private void addImportListener() {
        this.layout.getImportButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtendedFunctionSetupDialog.this.doImportOperation();
            }
        });
    }

    private void addDeleteCmdListener() {
        this.layout.getSelectCmdPanel().getClearSelection().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ExtendedFunctionSetupDialog.this.layout.getSelectCmdPanel().removeAll();
                ExtendedFunctionSetupDialog.this.layout.getSelectCmdPanel().setToolTipText(ResourceUtil.getString((String)"extended.command.collect.dialog.import.tips.before"));
                ExtendedFunctionSetupDialog.this.layout.getSelectCmdPanel().updateUI();
                ExtendedFunctionSetupDialog.this.cmdFile = null;
            }
        });
    }

    private void addSelectCmdListener() {
        this.layout.getSelectCmdPanel().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                File tempFile = ExtendedFunctionSetupDialog.this.getFileFromFileChooser(ExtendedFunctionSetupDialog.SELECTED_CMD_FILE_EXTS, SELECTED_CMD_FILE_TITLE);
                if (null != tempFile) {
                    ExtendedFunctionSetupDialog.this.cmdFile = tempFile;
                    ExtendedFunctionSetupDialog.this.layout.getSelectCmdPanel().setSelectedFile2Panel(ExtendedFunctionSetupDialog.this.cmdFile.getName());
                }
            }
        });
    }

    private void addDeleteSignListener() {
        this.layout.getSelectSignPanel().getClearSelection().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ExtendedFunctionSetupDialog.this.layout.getSelectSignPanel().removeAll();
                ExtendedFunctionSetupDialog.this.layout.getSelectSignPanel().setToolTipText(ResourceUtil.getString((String)"extended.command.collect.dialog.import.tips.before"));
                ExtendedFunctionSetupDialog.this.layout.getSelectSignPanel().updateUI();
                ExtendedFunctionSetupDialog.this.signFile = null;
            }
        });
    }

    private void addSelectSignListener() {
        this.layout.getSelectSignPanel().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                File tempFile = ExtendedFunctionSetupDialog.this.getFileFromFileChooser(ExtendedFunctionSetupDialog.SELECTED_SIGN_FILE_EXTS, SELECTED_SIGN_FILE_TITLE);
                if (null != tempFile) {
                    ExtendedFunctionSetupDialog.this.signFile = tempFile;
                    ExtendedFunctionSetupDialog.this.layout.getSelectSignPanel().setSelectedFile2Panel(ExtendedFunctionSetupDialog.this.signFile.getName());
                }
            }
        });
    }

    private void addDownloadListener() {
        this.layout.getDownloadButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtendedFunctionSetupDialog.this.doDownloadOperation();
            }
        });
    }

    private void addOkListener() {
        this.getOkBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtendedFunctionSetupDialog.this.doConfirmOperation();
            }
        });
    }

    private File getFileFromFileChooser(String exts, String title) {
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put("description", "*." + exts);
        extParams.put("PathId", OPENPATH_EXTENDED_ID);
        extParams.put("title", title);
        File importFile = ToolFileChooser.selectFile((Window)this, new String[]{exts}, 0, true, extParams);
        return importFile;
    }

    private void doDownloadOperation() {
        String suffix;
        String title = ResourceUtil.getString((String)"extended.command.collect.dialog.download.title");
        String filePath = ToolFileChooser.getSaveFilePath(title, suffix = SELECTED_CMD_FILE_EXTS, this.parent, DEFAULT_EXTENDED_CMD_TEMPLATE_FILE_NAME, SAVEPATH_EXTENDED_CMD_ID);
        if (!StringUtils.isNULLStr((String)filePath)) {
            this.writeTemplateFile2Local(filePath);
            OperationEnum.EXTENDED_COMMAND_DOWNLOAD.successLog("");
            return;
        }
        OperationEnum.EXTENDED_COMMAND_DOWNLOAD.failLog("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeTemplateFile2Local(String filePath) {
        block10: {
            boolean bl;
            Locale locale = ApplicationContext.getInstance().getCurrentLanguage();
            String templateFileName = "";
            templateFileName = Locale.SIMPLIFIED_CHINESE.equals(locale) ? "Extended_zh.xls" : "Extended_en.xls";
            InputStream ins = ExtendedFunctionSetupDialog.class.getResourceAsStream(TEMPLATE_FILE_PATH + templateFileName);
            FileOutputStream outs = null;
            try {
                if (null == ins) {
                    DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"infograb.templatefile.not.found"));
                    LOGGER.info("Can not find Template file");
                    boolean bl2 = false;
                    return bl2;
                }
                if (!FileUtils.isDiskSpaceFull((String)filePath, (InputStream)ins)) {
                    DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"infograb.save.error"));
                    boolean bl3 = false;
                    StreamUtils.closeStream((OutputStream)outs, (InputStream)ins);
                    return bl3;
                }
                outs = new FileOutputStream(new File(filePath));
                byte[] b = new byte[1024];
                int size = 0;
                while ((size = ins.read(b, 0, 1024)) != -1) {
                    ((OutputStream)outs).write(b, 0, size);
                }
                bl = true;
                StreamUtils.closeStream((OutputStream)outs, (InputStream)ins);
            }
            catch (IOException e) {
                LOGGER.error("Save template file error.");
                DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"infograb.save.error"));
                break block10;
            }
            finally {
                StreamUtils.closeStream(outs, (InputStream)ins);
            }
            return bl;
        }
        return false;
    }

    private void doImportOperation() {
        Object result;
        this.isCheckPass = false;
        ImportExtendedCommandTask importExtendedCommandTask = new ImportExtendedCommandTask(this.signFile, this.cmdFile);
        List results = AsyncExcutor.execute((Window)this, (String)ResourceUtil.getString((String)"extended.command.collect.dialog.import.progress.dialog"), (int)250, (Callable[])new Callable[]{importExtendedCommandTask});
        if (!results.isEmpty() && (result = results.get(0)) instanceof ExtendedCommandImportResult) {
            this.importResult = (ExtendedCommandImportResult)result;
        }
        this.showImportResult();
    }

    private void showImportResult() {
        if (this.importResult.isSuccess()) {
            if (this.importResult.getExtendedCommands().isEmpty()) {
                DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getString((String)"extended.command.collect.dialog.import.failed.empty"));
            } else {
                DialogUtils.showSuccessDialog((JDialog)this, (String)ResourceUtil.getString((String)"extended.command.collect.dialog.import.success"));
                this.isCheckPass = true;
            }
        } else if (this.importResult.getCheckFailedCommands().isEmpty()) {
            DialogUtils.showErrorDialog((JDialog)this, (String)this.importResult.getFailedDesc());
        } else {
            String[] headers = new String[]{ResourceUtil.getString((String)"extended.command.collect.import.error.header.device.type"), ResourceUtil.getString((String)"extended.command.collect.import.error.header.command"), ResourceUtil.getString((String)"extended.command.collect.import.error.header.param.type"), ResourceUtil.getString((String)"extended.command.collect.import.error.header.param"), ResourceUtil.getString((String)"extended.command.collect.import.error.header.reason")};
            ArrayList datas = new ArrayList();
            for (ExtendedCommandEntity command : this.importResult.getCheckFailedCommands()) {
                ArrayList<String> detail = new ArrayList<String>();
                detail.add(command.getDevType());
                detail.add(command.getCommand());
                detail.add(command.getParamType());
                detail.add(command.getParamValue());
                detail.add(command.getFailedDesc());
                datas.add(detail);
            }
            DialogUtils.showMultiErrorDialog((Window)this, (String)this.importResult.getFailedDesc(), (String[])headers, datas);
        }
    }

    private void doConfirmOperation() {
        if (!this.isCheckPass) {
            LOGGER.info("nothing changed, just exit the extended command function.");
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"extended.command.collect.dialog.import.failed.ok"));
            return;
        }
        WarningDialog confirmDialog = DialogUtils.showWarnConfirmDialog((Window)this, (String)WARNING_TIPS, (String)CONFIRM_CHECK_INFO);
        int confirmResult = confirmDialog.getValue();
        if (0 == confirmResult) {
            this.makeItEffective();
            this.dispose();
        }
        confirmDialog.dispose();
    }

    private void makeItEffective() {
        String devType;
        Map<String, List<String>> allExtendedCommands = this.importResult.getExtendedCommands();
        HashMap<String, Item> allTypeExtendedItem = new HashMap<String, Item>();
        for (Map.Entry<String, List<String>> entry : allExtendedCommands.entrySet()) {
            Item collectionItem = new Item("extended_command_info", "extended_command_info", EXTENDED_COLLECTION_SCRIPT);
            collectionItem.setExtendedCommands(entry.getValue());
            ArrayList<String> itemCategory = new ArrayList<String>();
            itemCategory.add("allApplicationScenariosFlag");
            collectionItem.setCategory(itemCategory);
            devType = entry.getKey();
            Map<String, Module> flowMap = this.getKeyModuleSysType2FlowMap();
            Module currentModule = flowMap.get(devType);
            List<Item> allItems = currentModule.getItemList();
            if (!allItems.isEmpty()) {
                int processBar = allItems.get(0).getProcessBar();
                collectionItem.setProcessBar(processBar);
            }
            this.clearLastExtendedCommands(allItems);
            allItems.add(collectionItem);
            allTypeExtendedItem.put(devType, collectionItem);
        }
        Map<GrabDevNode2, List<Item>> selectedItems = GrabFlowAdapter.getInstance().getNodeGrabFlowMap();
        for (Map.Entry<GrabDevNode2, List<Item>> oneDevItem : selectedItems.entrySet()) {
            GrabDevNode2 dev = oneDevItem.getKey();
            devType = dev.getDevTypeLevel2().toString();
            if ("Oracle".equals(devType)) {
                devType = dev.isUseJdbc() ? "Oracle_SSH" : "Oracle_JDBC";
            }
            if (!allTypeExtendedItem.containsKey(devType)) continue;
            List<Item> allItems = oneDevItem.getValue();
            this.clearLastExtendedCommands(allItems);
            allItems.add((Item)allTypeExtendedItem.get(devType));
        }
    }

    private void clearLastExtendedCommands(List<Item> allItems) {
        ArrayList<Item> lastExtendedItems = new ArrayList<Item>();
        int itemSize = allItems.size();
        if (0 != itemSize) {
            for (Item item : allItems) {
                if (!"extended_command_info".equals(item.getId())) continue;
                lastExtendedItems.add(item);
            }
        }
        allItems.removeAll(lastExtendedItems);
    }

    private Map<String, Module> getKeyModuleSysType2FlowMap() {
        HashMap<String, Module> tempFlowMap = new HashMap<String, Module>();
        Map<ItDeviceType, GrabFlow> allFlowMap = GrabContext.getInstance().getSysType2FlowMap();
        for (GrabFlow grabFlow : allFlowMap.values()) {
            if (null == grabFlow) continue;
            for (Module module : grabFlow.getModuleList()) {
                String devType = module.getTitle();
                if (null == devType) {
                    LOGGER.info("the module is not complete");
                    continue;
                }
                tempFlowMap.put(devType, module);
            }
        }
        return tempFlowMap;
    }

    private void initUI() {
        this.setTitle(ResourceUtil.getString((String)"advanced.setup.function.extended.command.desc"));
        this.setSize(715, 545);
        this.add(this.layout);
        this.setResizable(false);
        Point point = this.parent.getLocation();
        this.setLocation((int)point.getX() + 10, (int)point.getY() + 10);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.toFront();
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
    }
}

