/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.infograb.ui.ImportFileLayoutPanel;
import com.huawei.ism.tool.obase.utils.UiMethod;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ExtendedFunctionSetupPanel
extends JPanel {
    private static final long serialVersionUID = -1785933092862818800L;
    private static final Rectangle DOWNLOAD_BOUNDS = new Rectangle(10, 10, 677, LanguageManager.getInstance().getCurrentLanguage().equals(Locale.ENGLISH) ? 105 : 97);
    private static final Rectangle IMPORT_BOUNDS = new Rectangle(10, 120, 677, LanguageManager.getInstance().getCurrentLanguage().equals(Locale.ENGLISH) ? 210 : 200);
    private static final Dimension TEXT_LABEL_SIZE = new Dimension(645, 33);
    private static final int FONT_SIZE = 13;
    private static final Color DESC_COLOR = new Color(0x666666);
    private static final Font DESC_FONT = new Font("\u5b8b\u4f53", 0, 13);
    private static final String PANEL_NAME_SIGN = "for_autoTest_penel_sign";
    private static final String PANEL_NAME_CMD = "for_autoTest_penel_cmd";
    private JButton downloadButton;
    private JButton importButton;
    private ImportFileLayoutPanel selectSignPanel;
    private ImportFileLayoutPanel selectCmdPanel;

    public ExtendedFunctionSetupPanel() {
        this.initComponent();
        this.initUI();
    }

    public JButton getDownloadButton() {
        return this.downloadButton;
    }

    public JButton getImportButton() {
        return this.importButton;
    }

    public ImportFileLayoutPanel getSelectSignPanel() {
        return this.selectSignPanel;
    }

    public ImportFileLayoutPanel getSelectCmdPanel() {
        return this.selectCmdPanel;
    }

    private void initComponent() {
        this.downloadButton = new JButton(ResourceUtil.getString((String)"extended.command.collect.dialog.download.button"));
        this.importButton = new JButton(ResourceUtil.getString((String)"extended.command.collect.dialog.import.button"));
        this.selectSignPanel = new ImportFileLayoutPanel(ResourceUtil.getString((String)"extended.command.collect.dialog.import.desc.sign"));
        this.selectSignPanel.setName(PANEL_NAME_SIGN);
        this.selectCmdPanel = new ImportFileLayoutPanel(ResourceUtil.getString((String)"extended.command.collect.dialog.import.desc.cmd"));
        this.selectCmdPanel.setName(PANEL_NAME_CMD);
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        JPanel contentArea = new JPanel();
        contentArea.setLayout(null);
        contentArea.setBackground(Color.WHITE);
        contentArea.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        contentArea.add(this.layoutDownloadPanel());
        contentArea.add(this.layoutImportPanel());
        this.add((Component)UiMethod.buildFrameSpace(contentArea, 8), "Center");
    }

    private JComponent layoutImportPanel() {
        Box importPanel = Box.createHorizontalBox();
        String title = ResourceUtil.getString((String)"extended.command.collect.dialog.import.title");
        importPanel.setBorder(BorderFactory.createTitledBorder(title));
        importPanel.setBounds(IMPORT_BOUNDS);
        importPanel.add(Box.createHorizontalStrut(10));
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(this.getDescLabel(ResourceUtil.getString((String)"extended.command.collect.dialog.import.desc")));
        vBox.add(Box.createVerticalStrut(12));
        vBox.add(this.getImportComponent(this.selectSignPanel));
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(this.getImportComponent(this.selectCmdPanel));
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(this.importButton);
        vBox.add(Box.createVerticalGlue());
        importPanel.add(vBox);
        return importPanel;
    }

    private JComponent getImportComponent(JPanel selectPanel) {
        JPanel hBox = new JPanel();
        hBox.setBackground(Color.WHITE);
        hBox.setLayout(null);
        selectPanel.setBackground(Color.WHITE);
        selectPanel.setBounds(0, 0, 401, 31);
        hBox.add(selectPanel);
        return hBox;
    }

    private JComponent layoutDownloadPanel() {
        Box vBox = Box.createVerticalBox();
        Box hBox = Box.createHorizontalBox();
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(this.getDescLabel(ResourceUtil.getString((String)"extended.command.collect.dialog.download.desc")));
        vBox.add(Box.createVerticalStrut(12));
        vBox.add(this.downloadButton);
        vBox.add(Box.createVerticalGlue());
        hBox.add(Box.createHorizontalStrut(10));
        hBox.add(vBox);
        String title = ResourceUtil.getString((String)"extended.command.collect.dialog.download.title");
        hBox.setBorder(BorderFactory.createTitledBorder(title));
        hBox.setBounds(DOWNLOAD_BOUNDS);
        return hBox;
    }

    private JLabel getDescLabel(String desc) {
        JLabel descLable = new JLabel(desc);
        descLable.setForeground(DESC_COLOR);
        descLable.setFont(DESC_FONT);
        if (LanguageManager.getInstance().getCurrentLanguage().equals(Locale.ENGLISH)) {
            descLable.setPreferredSize(TEXT_LABEL_SIZE);
        }
        return descLable;
    }
}

