/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImportFileLayoutPanel
extends JPanel {
    public static final int DEFAULT_PANEL_WEIGHT = 400;
    public static final int DEFAULT_PANEL_HEIGHT = 30;
    private static final long serialVersionUID = 1L;
    private static final Double LINE_RADIAN = 6.5;
    private static final int MARGIN_DESC = 10;
    private static final int MARGIN_LAST = 5;
    private static final Font LAST_FONT = new Font("\u5b8b\u4f53", 0, 15);
    private static final Font DESC_FONT = new Font("Arail", 0, 13);
    private static final Font DEFALUT_X_FONT = new Font("Berlin Sans FB Demi", 1, 15);
    private static final Color ENTER_X_COLOR = new Color(6402303);
    private static final Color DEFAULT_X_COLOR = new Color(0x999999);
    private static final Color DISPLAY_PANEL_BACKGROUND = new Color(15527921);
    private static final String DEFAULT_DESC = "Please choose a file";
    private static final String DEFAULT_SELECT_PANEL_TIPS = ResourceUtil.getString((String)"extended.command.collect.dialog.import.tips.before");
    private static final Dimension DISPLAY_LABEL_SIZE = new Dimension(310, 25);
    private static final Rectangle DISPLAY_PANEL_BOUNDS = new Rectangle(3, 3, 370, 25);
    private int height;
    private int weight;
    private String desc;
    private JLabel displaySelection;
    private JLabel clearSelection = new JLabel("X");
    private JPanel displayPanel;

    public ImportFileLayoutPanel() {
        this(DEFAULT_DESC, 400, 30);
    }

    public ImportFileLayoutPanel(String desc) {
        this(desc, 400, 30);
    }

    public ImportFileLayoutPanel(String desc, int weight, int height) {
        this.desc = desc;
        this.weight = weight;
        this.height = height;
        this.setCursor(new Cursor(12));
        this.setToolTipText(DEFAULT_SELECT_PANEL_TIPS);
        this.setLayout(null);
    }

    public void setSelectedFile2Panel(String fileName) {
        this.removeAll();
        this.init(fileName);
        this.updateUI();
    }

    private void init(String fileName) {
        this.initComponent(fileName);
        this.initUI();
        this.initListener();
    }

    @Override
    public void paintComponent(Graphics gra) {
        super.paintComponent(gra);
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, Color.LIGHT_GRAY, this.getWidth(), this.getHeight(), Color.GRAY, true);
        if (gra instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)gra;
            g2d.setPaint(paint);
            g2d.draw(new RoundRectangle2D.Double(0.0, 0.0, this.weight, this.height, LINE_RADIAN, LINE_RADIAN));
            g2d.setFont(DESC_FONT);
            g2d.drawString(this.desc, 10, this.height / 2 + DESC_FONT.getSize() / 2);
            g2d.setColor(Color.GRAY);
            g2d.setFont(LAST_FONT);
            g2d.drawString("\u2026", this.weight - 5 - LAST_FONT.getSize(), this.height / 2 + LAST_FONT.getSize() / 2);
        }
    }

    private void initUI() {
        this.setToolTipText(null);
        this.displaySelection.setPreferredSize(DISPLAY_LABEL_SIZE);
        this.displayPanel.setLayout(new BoxLayout(this.displayPanel, 0));
        this.displayPanel.setBounds(DISPLAY_PANEL_BOUNDS);
        this.displayPanel.setBackground(DISPLAY_PANEL_BACKGROUND);
        this.displayPanel.add(Box.createHorizontalStrut(12));
        this.displayPanel.add(this.displaySelection);
        this.displayPanel.add(Box.createHorizontalGlue());
        this.displayPanel.add(this.clearSelection);
        this.displayPanel.add(Box.createHorizontalStrut(12));
        this.add(this.displayPanel);
    }

    private void initComponent(String fileName) {
        this.displayPanel = new JPanel();
        this.displaySelection = new JLabel(fileName);
        this.clearSelection.setFont(DEFALUT_X_FONT);
        this.clearSelection.setForeground(DEFAULT_X_COLOR);
    }

    private void initListener() {
        this.clearSelection.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ImportFileLayoutPanel.this.clearSelection.setForeground(ENTER_X_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ImportFileLayoutPanel.this.clearSelection.setForeground(DEFAULT_X_COLOR);
            }
        });
    }

    public JLabel getClearSelection() {
        return this.clearSelection;
    }
}

