/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui;

import com.huawei.ism.tool.base.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IConnectionManage;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.infograb.parser.InfoGrabItemPaser;
import com.huawei.ism.tool.infograb.ui.CreateTaskDialog;
import com.huawei.ism.tool.infograb.ui.InfoGrabMainFrameLayout;
import com.huawei.ism.tool.infograb.ui.InfoGrabSetupDialog;
import com.huawei.ism.tool.infograb.ui.MoreFunctionDialog;
import com.huawei.ism.tool.infograb.ui.action.DelTaskAction;
import com.huawei.ism.tool.infograb.ui.action.DirSetupButtonAction;
import com.huawei.ism.tool.infograb.ui.action.DownLoadAction;
import com.huawei.ism.tool.infograb.ui.action.ExploreButtonAction;
import com.huawei.ism.tool.infograb.ui.action.GetOfflineCollectionFileAction;
import com.huawei.ism.tool.infograb.ui.action.GrabMainWindowListener;
import com.huawei.ism.tool.infograb.ui.action.OpenHelpFileListener;
import com.huawei.ism.tool.infograb.utils.SceneEnvironmentImpl;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.UiMethod;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.plaf.RootPaneUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoGrabMainFrame
extends JFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoGrabMainFrame.class);
    private static final long serialVersionUID = 8510278760988695267L;
    private static final double SIZE_PERCENT = 0.75;
    private static final Dimension DIALOG_SIZE = InfoGrabMainFrame.getMainUISize();
    private static IConnectionManage connMng = (IConnectionManage)PublicServiceManage.getInstance().getService(IConnectionManage.class);
    private InfoGrabMainFrameLayout layout = new InfoGrabMainFrameLayout();

    public InfoGrabMainFrame() {
        this.initUi();
        this.initListener();
        this.addSelfToContext();
        this.injectXMLFlowFile();
        if (SceneUtils.isScene()) {
            String sceneKey = "jsonScene";
            String sceneInfo = System.getenv(sceneKey);
            if (sceneInfo.contains("\"mainScene\":\"Migration\"") || sceneInfo.contains("\"mainScene\":\"Troubleshooting\"")) {
                return;
            }
            CreateTaskDialog ct = new CreateTaskDialog((Window)this, this.layout);
            ct.getCategoryPreUpdate().setSelected(true);
            ct.createTask();
        }
    }

    private static Dimension getMainUISize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return new Dimension((int)(screenSize.getWidth() * 0.75), (int)(screenSize.getHeight() * 0.75));
    }

    public IConnectionManage getConnMng() {
        return connMng;
    }

    private void injectXMLFlowFile() {
        Locale loc = ApplicationContext.getInstance().getCurrentLanguage();
        LOGGER.info("Locale lan is : {}", (Object)loc.toString());
        InfoGrabItemPaser.getInstance().createGrabFlowByXML();
    }

    private void initUi() {
        this.add(this.layout);
        this.setTitle(ResourceUtil.getString((String)"infograb.title"));
        this.setIconImage(ResourceUtil.getImage((String)"infograb.png").getImage());
        WizardRootPaneUI rootpanUi = new WizardRootPaneUI();
        rootpanUi.setShowHelp(false);
        rootpanUi.setShowMinimize(true);
        rootpanUi.setShowMaxsize(true);
        this.getRootPane().setUI((RootPaneUI)rootpanUi);
        this.setSize(DIALOG_SIZE);
        UiMethod.putScreenCenter(this);
        if (SceneEnvironmentImpl.getInstance().isScene() && !System.getenv("jsonScene").contains("\"mainScene\":\"Troubleshooting\"")) {
            String scenInfo = System.getenv("jsonScene");
            String string = scenInfo = scenInfo == null ? "" : scenInfo;
            if (scenInfo.contains("\"mainScene\":\"Migration\"")) {
                this.layout.getResultBtn().setEnabled(true);
            } else {
                this.layout.getResultBtn().setEnabled(false);
            }
        }
    }

    private void initListener() {
        this.addWindowListener(new GrabMainWindowListener());
        this.layout.getResultBtn().addActionListener(new DirSetupButtonAction(this));
        this.layout.getViewReportBtn().addActionListener(new ExploreButtonAction(this.layout));
        this.layout.getAddDeviceLabel().addClickListener(new DownLoadAction(this, "device"));
        this.layout.getGetCommandListLabel().addClickListener(new DownLoadAction(this, "commandlist"));
        this.layout.getgetWindowsCmdLabel().addClickListener(new GetOfflineCollectionFileAction(this));
        this.layout.getCreateTaskBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new CreateTaskDialog((Window)InfoGrabMainFrame.this, InfoGrabMainFrame.this.layout).setVisible(true);
            }
        });
        this.layout.getHelpLabel().addClickListener(new OpenHelpFileListener(this));
        this.layout.getAdvancedLabel().addClickListener(new ToolHyperLinkLabel.ClickListener(){
            private static final long serialVersionUID = -8950951130377514149L;

            @Override
            public void clickLink(MouseEvent me) {
                OperationEnum.ADVANCE_BTN.successLog("");
                new InfoGrabSetupDialog((Window)InfoGrabMainFrame.this).setVisible(true);
            }
        });
        this.layout.getDeleteTaskBtn().addActionListener(new DelTaskAction());
        this.layout.getMoreFuncBtn().addActionListener(event -> new MoreFunctionDialog((Window)this).setVisible(true));
    }

    private void addSelfToContext() {
        GrabContext.getInstance().setCurrInfoGrabDialog(this);
    }

    public InfoGrabMainFrameLayout getcurrLayout() {
        return this.layout;
    }

    public JLabel getBottomPanel() {
        return this.layout.getBottomPanel();
    }
}

