/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui;

import com.huawei.ism.tool.infograb.entity.OneFunctionPanelParam;
import com.huawei.ism.tool.obase.utils.UiMethod;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class InfoGrabSetupLayout
extends JPanel {
    private static final long serialVersionUID = -5338260892291874359L;
    private static final int DEFAULT_LAYOUT_ROW_COUNT = 3;
    private static final int COLUMN_COUNT_ONE_ROW = 3;
    private static final int MARGIN_IN_ONE_FUNCTIO = 3;
    private static final int MARGIN_SMALL = 15;
    private static final int MARGIN_BIG = 45;
    private static final int FONT_SIZE = 13;
    private static final Dimension PREFERRED_SIZE = new Dimension(185, 70);
    private static final Dimension RIGID_AREA_FILL_SPACE = new Dimension(190, 70);
    private List<JComponent> allFuncComponent = new ArrayList<JComponent>();

    public InfoGrabSetupLayout(List<OneFunctionPanelParam> allParams) {
        this.initData(allParams);
        this.initUI();
    }

    private void initData(List<OneFunctionPanelParam> allParams) {
        for (OneFunctionPanelParam param : allParams) {
            this.addNewPanel(param.getIcon(), param.getDesc(), param.getMouseAdapter());
        }
    }

    private void initUI() {
        Box contentPanel = Box.createVerticalBox();
        contentPanel.add(Box.createVerticalStrut(15));
        contentPanel.setBackground(Color.WHITE);
        int index = 0;
        int rowCount = 3;
        int trueRowCount = this.allFuncComponent.size() / 3;
        if (rowCount < trueRowCount + 1) {
            int n = rowCount = this.allFuncComponent.size() % 3 == 0 ? trueRowCount : trueRowCount + 1;
        }
        while (index < rowCount) {
            Box tempBox = Box.createHorizontalBox();
            tempBox.add(Box.createHorizontalStrut(15));
            tempBox.add(this.getLastRowComponent(3 * index));
            tempBox.add(Box.createHorizontalStrut(45));
            tempBox.add(this.getLastRowComponent(3 * index + 1));
            tempBox.add(Box.createHorizontalStrut(45));
            tempBox.add(this.getLastRowComponent(3 * index + 2));
            tempBox.add(Box.createHorizontalStrut(15));
            contentPanel.add(tempBox);
            contentPanel.add(Box.createVerticalStrut(45));
            ++index;
        }
        contentPanel.add(Box.createVerticalGlue());
        contentPanel.add(Box.createVerticalGlue());
        contentPanel.add(Box.createVerticalGlue());
        JScrollPane taskPane = new JScrollPane(contentPanel);
        this.setLayout(new BorderLayout());
        this.add(UiMethod.buildFrameSpace(taskPane, 8));
    }

    private Component getLastRowComponent(int index) {
        Component temp = Box.createRigidArea(index > 9 ? PREFERRED_SIZE : RIGID_AREA_FILL_SPACE);
        if (index < this.allFuncComponent.size()) {
            temp = this.allFuncComponent.get(index);
        }
        return temp;
    }

    private void addNewPanel(Icon icon, String desc, MouseListener mouseAdapter) {
        JLabel tempLabel = new JLabel(icon);
        tempLabel.setName("Function_Label_" + this.allFuncComponent.size());
        tempLabel.setText(desc);
        tempLabel.setFont(new Font(null, 0, 13));
        JPanel vBox = new JPanel();
        vBox.setLayout(new BoxLayout(vBox, 1));
        Box hBox = Box.createHorizontalBox();
        hBox.add(tempLabel);
        hBox.add(Box.createHorizontalGlue());
        vBox.add(Box.createVerticalStrut(3));
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(3));
        vBox.setPreferredSize(PREFERRED_SIZE);
        vBox.setBackground(Color.WHITE);
        vBox.setBorder(BorderFactory.createTitledBorder(""));
        vBox.setCursor(new Cursor(12));
        vBox.addMouseListener(mouseAdapter);
        this.allFuncComponent.add(vBox);
    }
}

