/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.HbaInfo;
import com.huawei.ism.tool.infograb.ui.InfoGrabIsmTable;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.table.TableModel;

public class IntegrateGrabCompleteDialog
extends PublicDialog {
    private static final long serialVersionUID = 8218275154634607967L;
    private static final Dimension SIZE = new Dimension(500, 400);
    private final String[] tableHeaders = new String[]{ResourceUtil.getString((String)"infograb.complete.information.head.item"), ResourceUtil.getString((String)"infograb.complete.information.head.info")};
    private final String[] hbaModelFailedArray = new String[]{"No such file or directory", "command not found", "No HBA card type info.", "", "No HBA info driver(firmware) version."};
    private DefaultTableModel completeInfoTableModel;
    private InfoGrabIsmTable completeInfoTable;
    private transient GrabDevNode2 currDevNode;
    private List<ExecuteResult> currResultList;
    private GrabContext context = GrabContext.getInstance();

    public IntegrateGrabCompleteDialog(GrabDevNode2 currDevNode) {
        this.currDevNode = currDevNode;
        this.currResultList = this.context.getExecuteResultMap().get((Object)currDevNode);
        this.setModal(true);
        this.setTitle(ResourceUtil.getString((String)"infoGrab.complete.information.title"));
        this.setSize(SIZE);
        this.initUI();
        this.initOkBtnListener();
        SwingUtil.putScreenCenter((Window)this);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
    }

    public static void showGrabCompleteDialog(GrabDevNode2 currDevNode) {
        IntegrateGrabCompleteDialog dialog = new IntegrateGrabCompleteDialog(currDevNode);
        dialog.setVisible(true);
    }

    private void initUI() {
        this.setAppButtonVisible(false);
        this.setHelpButtonVisiable(false);
        this.setCancelButtonVisible(false);
        this.completeInfoTableModel = new DefaultTableModel(this.tableHeaders, new int[0]);
        this.completeInfoTable = new InfoGrabIsmTable((TableModel)this.completeInfoTableModel);
        this.fillCompleteInfoTable();
        TableScrollPane completeInfoArea = new TableScrollPane((IsmTable)this.completeInfoTable, false, false, false);
        completeInfoArea.setMinimumSize(new Dimension(completeInfoArea.getPreferredSize().width, 80));
        this.getContentPanel().setLayout(new BorderLayout());
        this.getContentPanel().add((Component)UiMethod.buildFrameSpace((JComponent)completeInfoArea, 12), "Center");
    }

    protected final void initOkBtnListener() {
        this.getOkBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntegrateGrabCompleteDialog.this.dispose();
            }
        });
    }

    public void fillCompleteInfoTable() {
        if (this.currResultList.size() > 1) {
            Long expendTime = this.currResultList.get(this.currResultList.size() - 1).getExecuteEndTime().getTime() - this.currResultList.get(1).getExecuteStartTime().getTime();
            this.completeInfoTableModel.addRow(new TableRow[]{this.fillCompleteInfoRow(ResourceUtil.getString((String)"infograb.complete.information.item.ip"), this.currDevNode.getIp())});
            this.completeInfoTableModel.addRow(new TableRow[]{this.fillCompleteInfoRow(ResourceUtil.getString((String)"infograb.complete.information.item.devtype"), this.currDevNode.getItDeviceType().toString())});
            this.completeInfoTableModel.addRow(new TableRow[]{this.fillCompleteInfoRow(ResourceUtil.getString((String)"infograb.complete.information.item.starttime"), this.currResultList.get(1).getExecuteStartTimeString())});
            this.completeInfoTableModel.addRow(new TableRow[]{this.fillCompleteInfoRow(ResourceUtil.getString((String)"infograb.complete.information.item.expendtime"), Long.toString(expendTime % 1000L == 0L ? expendTime / 1000L : expendTime / 1000L + 1L))});
        }
        if (ItDeviceType.Host.equals((Object)this.currDevNode.getItDeviceType()) && !this.isWindowsDevNode(this.currDevNode)) {
            this.completeInfoTableModel.addRow(new TableRow[]{this.fillCompleteInfoRow(ResourceUtil.getString((String)"infograb.complete.information.item.containhba"), this.checkContainHba())});
        }
    }

    private boolean isWindowsDevNode(GrabDevNode2 dev) {
        if (null == dev) {
            return false;
        }
        if (null == dev.getDevTypeLevel2()) {
            return false;
        }
        return dev.getDevTypeLevel2().toString().trim().equalsIgnoreCase("windows");
    }

    private TableRow<String, String> fillCompleteInfoRow(String item, String info) {
        DefaultTableRow row = new DefaultTableRow(2, (Object)item);
        row.setValueAt(0, (Object)item);
        row.setValueAt(1, (Object)info);
        return row;
    }

    private String checkContainHba() {
        if (this.currDevNode.getItDeviceType().equals((Object)ItDeviceType.Host)) {
            ExecuteResult hbaExecuteResult = null;
            for (ExecuteResult executeResult : this.currResultList) {
                if (!executeResult.getDescription().contains("_hba_card_info")) continue;
                hbaExecuteResult = executeResult;
            }
            if (hbaExecuteResult == null) {
                return ResourceUtil.getString((String)"infograb.complete.information.item.containhba.notgrab");
            }
            HbaInfo hbaInfo = this.currDevNode.getHbaInfo();
            if (this.hasHbaCard(hbaInfo)) {
                return ResourceUtil.getString((String)"infograb.complete.information.item.containhba.yes");
            }
        }
        return ResourceUtil.getString((String)"infograb.complete.information.item.containhba.no");
    }

    private boolean hasHbaCard(HbaInfo hba) {
        ArrayList<String> hbas = new ArrayList<String>();
        hbas.add(hba.getHbaModel());
        hbas.add(hba.getHbaDriverVersion());
        hbas.add(hba.getFwVersion());
        for (String hbaMdf : hbas) {
            if ("".equals(hbaMdf.trim()) || hbaMdf.equals("NA") || this.isArrayContain(this.hbaModelFailedArray, hbaMdf)) continue;
            return true;
        }
        return false;
    }

    private boolean isArrayContain(String[] arrParm, String value) {
        if (null == value || "".equals(value.trim())) {
            return false;
        }
        for (String parm : arrParm) {
            if (!parm.contains(value.trim())) continue;
            return true;
        }
        return false;
    }
}

