/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.User;
import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.GrabFlow;
import com.huawei.ism.tool.infograb.entity.Item;
import com.huawei.ism.tool.infograb.entity.Module;
import com.huawei.ism.tool.infograb.entity.OtherScenariosEntity;
import com.huawei.ism.tool.infograb.grab.GrabFlowAdapter;
import com.huawei.ism.tool.infograb.service.InfoGrabService;
import com.huawei.ism.tool.infograb.swing.IDeviceManageUI;
import com.huawei.ism.tool.infograb.ui.DevChooseDialog;
import com.huawei.ism.tool.infograb.ui.GrabSetupLayout;
import com.huawei.ism.tool.infograb.ui.SwitchRootDialog;
import com.huawei.ism.tool.infograb.ui.support.DeviceSelectionListener;
import com.huawei.ism.tool.infograb.utils.OfflineImportUtils;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntegrateGrabSetupDialog
extends PublicDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegrateGrabSetupDialog.class);
    private GrabSetupLayout collectlayout = null;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private GrabDevNode2 deviceNode = null;
    private DevChooseDialog devChooseDialog = null;
    private List<GrabDevNode2> devNodes = null;
    private Map<GrabDevNode2, List<Item>> allCollectItems = new HashMap<GrabDevNode2, List<Item>>();
    private List<String> campatibilityItems = new ArrayList<String>();
    private List<String> dataMigrationItems = new ArrayList<String>();
    private List<String> miniComputerItems = new ArrayList<String>();
    private List<String> preUpdateExplorationItems = new ArrayList<String>();
    private List<String> hypermetroItems = new ArrayList<String>();
    private List<String> networkDiscoveryItems = new ArrayList<String>();
    private List<String> allAppScenarios = new ArrayList<String>();
    private Set<String> selectedItems = new HashSet<String>();
    private String integrateXML = "";

    private IntegrateGrabSetupDialog(Window parent, String xml) {
        super(parent, true);
        this.integrateXML = xml;
        this.collectlayout = new GrabSetupLayout(false);
        this.initUI();
        this.addListener();
    }

    public static void showCollectSetupDialog(Window parent, GrabDevNode2 deviceNode, String tempXML) {
        IntegrateGrabSetupDialog dialog = new IntegrateGrabSetupDialog(parent, tempXML);
        dialog.initData(deviceNode);
        dialog.setVisible(true);
    }

    private void initUI() {
        this.setTitle(ResourceUtil.getString((String)"infograb.devicesetup.title"));
        JPanel comPanel = this.getContentPanel();
        comPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab(ResourceUtil.getString((String)"infograb.devicesetup.basesetuptitle"), this.collectlayout);
        comPanel.add((Component)this.tabbedPane, "Center");
        this.setAppButtonVisible(true);
        this.setHelpButtonVisiable(false);
        JButton appB = this.getAppBtn();
        appB.setName("_Button_appB");
        appB.setText(ResourceUtil.getString((String)"infograb.button.apply"));
        appB.setMnemonic('A');
        this.validate();
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
        this.setResizable(false);
        this.setModal(true);
    }

    private boolean initData(GrabDevNode2 devNode) {
        this.deviceNode = devNode;
        this.collectlayout.getLoginInfoModifyComponent().setVisible(!OfflineImportUtils.isOfflineHost(this.deviceNode));
        this.getAppBtn().setVisible(OfflineImportUtils.isOfflineHost(this.deviceNode) ? false : this.getAppBtn().isVisible());
        this.initSelectItems();
        this.initCollectItemTree(this.deviceNode);
        this.initCollectConfInfoToUI();
        return true;
    }

    private void initSelectItems() {
        GrabFlowAdapter flowAdapter = GrabFlowAdapter.getInstance();
        Map<GrabDevNode2, List<Item>> currGrabFlowMap = flowAdapter.getNodeGrabFlowMap();
        ArrayList selectItems = new ArrayList();
        if (currGrabFlowMap.containsKey((Object)this.deviceNode)) {
            selectItems.addAll(currGrabFlowMap.get((Object)this.deviceNode));
        }
        this.allCollectItems.put(this.deviceNode, selectItems);
    }

    private void initCollectConfInfoToUI() {
        List<Item> currSelectedItems = this.findSelectItem();
        this.initCollectConfInfoItem(currSelectedItems);
        this.initSelectCategory();
    }

    private void initSelectCategory() {
        List<String> selectedCategory = GrabFlowAdapter.getInstance().getNodeSelectedCategoryMap().get((Object)this.deviceNode);
        if (selectedCategory == null) {
            this.collectlayout.getCategoryCampatibility().setSelected(true);
            this.collectlayout.getCategoryMigration().setSelected(true);
            this.collectlayout.getCategoryMiniComputer().setSelected(true);
            this.collectlayout.getCategoryPreUpdate().setSelected(true);
            this.collectlayout.getCategoryOther().setSelected(true);
            this.collectlayout.getOtherTaskTypecomboBox().setEnabled(true);
        } else {
            if (selectedCategory.contains(this.collectlayout.getCategoryCampatibility().getText())) {
                this.collectlayout.getCategoryCampatibility().setSelected(true);
            }
            if (selectedCategory.contains(this.collectlayout.getCategoryMigration().getText())) {
                this.collectlayout.getCategoryMigration().setSelected(true);
            }
            if (selectedCategory.contains(this.collectlayout.getCategoryMiniComputer().getText())) {
                this.collectlayout.getCategoryMiniComputer().setSelected(true);
            }
            if (selectedCategory.contains(this.collectlayout.getCategoryPreUpdate().getText())) {
                this.collectlayout.getCategoryPreUpdate().setSelected(true);
            }
            if (selectedCategory.contains(((OtherScenariosEntity)this.collectlayout.getOtherTaskTypecomboBox().getSelectedItem()).getTitle())) {
                this.collectlayout.getCategoryOther().setSelected(true);
            }
        }
    }

    private List<Item> findSelectItem() {
        LinkedList<Item> selectItems = new LinkedList<Item>();
        List<Item> allItems = GrabFlowAdapter.getInstance().getNodeGrabFlowMap().get((Object)this.deviceNode);
        if (allItems == null) {
            List<Module> currModuleList = GrabContext.getInstance().getSysType2FlowMap().get(this.deviceNode.getItDeviceType()).getModuleList();
            for (Module module : currModuleList) {
                String moduleName = module.getTitle();
                if (moduleName.equalsIgnoreCase("oracle_jdbc") && moduleName.contains(this.deviceNode.getDevTypeLevel2().toString()) && this.deviceNode.isUseJdbc()) {
                    allItems = module.getItemList();
                    break;
                }
                if (moduleName.equalsIgnoreCase("oracle_ssh") && moduleName.contains(this.deviceNode.getDevTypeLevel2().toString()) && !this.deviceNode.isUseJdbc()) {
                    allItems = module.getItemList();
                }
                if (!module.getTitle().equalsIgnoreCase(this.deviceNode.getDevTypeLevel2().toString())) continue;
                allItems = module.getItemList();
            }
        }
        if (null != allItems) {
            for (Item item : allItems) {
                if (!item.isDefaultChoose()) continue;
                selectItems.add(item);
            }
        }
        return selectItems;
    }

    public void initCollectConfInfoItem(List<Item> selectItems) {
        Enumeration<TreeNode> e = this.collectlayout.getItemRootNode().preorderEnumeration();
        while (e.hasMoreElements()) {
            CheckTreeNode currentNode = (CheckTreeNode)e.nextElement();
            currentNode.setSelected(selectItems.contains(currentNode.getUserObject()));
        }
    }

    public void initCollectItemTree(GrabDevNode2 devNode) {
        this.deviceNode = devNode;
        this.collectlayout.getItemRootNode().removeAllChildren();
        this.attachItemTreeNode(devNode);
        DefaultTreeModel newTreeModel = new DefaultTreeModel(this.collectlayout.getItemRootNode(), false);
        this.collectlayout.getItemTree().setModel(newTreeModel);
        this.collectlayout.getItemTree().setRootVisible(true);
        this.collectlayout.getItemTree().setShowsRootHandles(true);
        this.collectlayout.getItemTree().expandAll(true);
        this.initRootHyperLinkLayout();
    }

    public void initRootHyperLinkLayout() {
        if (this.deviceNode.getItDeviceType().equals((Object)ItDeviceType.Host) && !this.deviceNode.getDevTypeLevel2().toString().contains("Windows") && !this.deviceNode.getDevTypeLevel2().toString().contains("VMware")) {
            LOGGER.info("init  root hyperlink layout{}{}", (Object)this.deviceNode.getLoginUser().getUserName(), (Object)StringUtils.isEmpty((CharSequence)this.deviceNode.getLoginUser().getUserName()));
            String ip = this.deviceNode.getIp();
            User user = GrabContext.getInstance().getAdminNameAndPassMap().get(ip);
            String name = "";
            if (user != null) {
                name = user.getUserName();
            }
            if (this.deviceNode.getLoginUser().getUserName().equals("root") || name.equals("root")) {
                this.collectlayout.getSwitchLink().setVisible(false);
                this.collectlayout.getSwichRootDesc().setText(ResourceUtil.getString((String)"infograb.no_need_switch_root_desc"));
            } else {
                this.collectlayout.getSwitchLink().setVisible(true);
                this.collectlayout.getSwichRootDesc().setText(ResourceUtil.getString((String)"infograb.switch_root_desc"));
            }
        } else {
            this.collectlayout.getSwichRootDesc().setVisible(false);
            this.collectlayout.getSwitchLink().setVisible(false);
            this.collectlayout.getDot().setVisible(false);
        }
    }

    public boolean addItem(Item item) {
        CheckTreeNode root = this.collectlayout.getItemRootNode();
        CheckTreeNode moduleNode = (CheckTreeNode)root.getFirstChild();
        CheckTreeNode itemNode = new CheckTreeNode(item, false, true);
        moduleNode.add(itemNode);
        SwingUtilities.updateComponentTreeUI(this.collectlayout);
        Map<ItDeviceType, GrabFlow> currType2FlowMap = GrabContext.getInstance().getSysType2FlowMap();
        List<Module> currModules = currType2FlowMap.get(this.deviceNode.getItDeviceType()).getModuleList();
        for (Module module : currModules) {
            if (!module.getTitle().equalsIgnoreCase(moduleNode.getUserObject().toString())) continue;
            List<Item> items = module.getItemList();
            items.add(item);
        }
        return true;
    }

    private void attachItemTreeNode(GrabDevNode2 devNode) {
        this.collectlayout.getItemRootNode().setUserObject(devNode.getIp());
        this.collectlayout.getItemRootNode().setToolTips(devNode.getIp());
        List<Module> moduleList = this.findAllModule(devNode);
        for (Module module : moduleList) {
            CheckTreeNode moduleNode = new CheckTreeNode(module, true, true);
            this.collectlayout.getItemRootNode().add(moduleNode);
            for (Item item : module.getItemList()) {
                CheckTreeNode itemNode = new CheckTreeNode(item, false, true);
                itemNode.setSelected(this.checkEnableItemStatus(devNode, item));
                moduleNode.add(itemNode);
                if (item.getCategory().contains(ResourceUtil.getString((String)"infograb.item.category.campatibility"))) {
                    this.campatibilityItems.add(item.getTitle());
                }
                if (item.getCategory().contains(ResourceUtil.getString((String)"infograb.item.category.data_migration"))) {
                    this.dataMigrationItems.add(item.getTitle());
                }
                if (item.getCategory().contains(ResourceUtil.getString((String)"infograb.item.category.minicomputer_migration"))) {
                    this.miniComputerItems.add(item.getTitle());
                }
                if (item.getCategory().contains(ResourceUtil.getString((String)"infograb.item.category.pre_update_exploration"))) {
                    this.preUpdateExplorationItems.add(item.getTitle());
                }
                if (item.getCategory().contains(ResourceUtil.getString((String)"infograb.item.category.other"))) {
                    this.hypermetroItems.add(item.getTitle());
                }
                if (item.getCategory().contains(ResourceUtil.getString((String)"infograb.item.category.other"))) {
                    this.networkDiscoveryItems.add(item.getTitle());
                }
                if (!item.getCategory().contains("allApplicationScenariosFlag")) continue;
                this.allAppScenarios.add(item.getTitle());
            }
        }
        this.checkCollectlayout();
    }

    private void checkCollectlayout() {
        if (this.campatibilityItems.isEmpty()) {
            this.collectlayout.getCategoryCampatibility().setEnabled(false);
        }
        if (this.dataMigrationItems.isEmpty()) {
            this.collectlayout.getCategoryMigration().setEnabled(false);
        }
        if (this.miniComputerItems.isEmpty()) {
            this.collectlayout.getCategoryMiniComputer().setEnabled(false);
        }
        if (this.preUpdateExplorationItems.isEmpty()) {
            this.collectlayout.getCategoryPreUpdate().setEnabled(false);
        }
        if (this.hypermetroItems.isEmpty()) {
            this.collectlayout.getCategoryOther().setEnabled(false);
            this.collectlayout.getOtherTaskTypecomboBox().setEnabled(false);
        }
        if (this.networkDiscoveryItems.isEmpty()) {
            this.collectlayout.getCategoryOther().setEnabled(false);
            this.collectlayout.getOtherTaskTypecomboBox().setEnabled(false);
        }
    }

    private boolean checkEnableItemStatus(GrabDevNode2 devNode, Item currItem) {
        if (currItem.getCategory().contains("allApplicationScenariosFlag")) {
            return true;
        }
        List<Module> moduleList = this.findAllStandardFlow(devNode);
        for (Module module : moduleList) {
            if (!module.getTitle().equalsIgnoreCase(devNode.getDevTypeLevel2().toString())) continue;
            List<Item> nodeFlowItems = GrabFlowAdapter.getInstance().getNodeGrabFlowMap().get((Object)devNode);
            if (nodeFlowItems == null) {
                return true;
            }
            List<Item> nodeFlowAllItems = module.getItemList();
            if (!nodeFlowItems.contains(currItem) || !nodeFlowAllItems.contains(currItem)) continue;
            return true;
        }
        return false;
    }

    private List<Module> findAllStandardFlow(GrabDevNode2 devNode) {
        return GrabContext.getInstance().getSysType2FlowMap().get(devNode.getItDeviceType()).getModuleList();
    }

    private List<Module> findAllModule(GrabDevNode2 devNode) {
        Map<ItDeviceType, GrabFlow> currType2FlowMap = OfflineImportUtils.getType2Flow(devNode);
        List<Module> currModules = currType2FlowMap.get(devNode.getItDeviceType()).getModuleList();
        LinkedList<Module> resultModules = new LinkedList<Module>();
        for (Module module : currModules) {
            String moduleName = module.getTitle();
            if (moduleName.equalsIgnoreCase("oracle_jdbc") && moduleName.contains(devNode.getDevTypeLevel2().toString()) && devNode.isUseJdbc()) {
                resultModules.add(module);
            }
            if (moduleName.equalsIgnoreCase("oracle_ssh") && moduleName.contains(devNode.getDevTypeLevel2().toString()) && !devNode.isUseJdbc()) {
                resultModules.add(module);
            }
            if (!module.getTitle().equalsIgnoreCase(devNode.getDevTypeLevel2().toString())) continue;
            resultModules.add(module);
        }
        return resultModules;
    }

    private void addListener() {
        DeviceSelectionListener listener = new DeviceSelectionListener(this);
        this.collectlayout.getDeviceTree().addTreeSelectionListener(listener);
        JButton app = this.getAppBtn();
        app.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IntegrateGrabSetupDialog.this.devChooseDialog == null) {
                    IntegrateGrabSetupDialog.this.devChooseDialog = new DevChooseDialog(IntegrateGrabSetupDialog.this);
                }
                IntegrateGrabSetupDialog.this.devChooseDialog.initData(IntegrateGrabSetupDialog.this.filterChooseDevs());
                IntegrateGrabSetupDialog.this.devChooseDialog.setVisible(true);
            }
        });
        JButton canb = this.getCancelBtn();
        canb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntegrateGrabSetupDialog.this.dispose();
            }
        });
        JButton okb = this.getOkBtn();
        okb.addActionListener(new OkButtonListener(listener));
        ToolHyperLinkLabel link = this.collectlayout.getLink();
        link.addClickListener(new ToolHyperLinkLabel.ClickListener(){

            @Override
            public void clickLink(MouseEvent e) {
                IntegrateGrabSetupDialog.this.modifyClickApply();
            }
        });
        ToolHyperLinkLabel switchLink = this.collectlayout.getSwitchLink();
        switchLink.addClickListener(new ToolHyperLinkLabel.ClickListener(){

            @Override
            public void clickLink(MouseEvent e) {
                List<GrabDevNode2> devsInSwitch = InfoGrabService.getInstance().getAllDevNode();
                SwitchRootDialog dialog = new SwitchRootDialog(IntegrateGrabSetupDialog.this, IntegrateGrabSetupDialog.this.deviceNode, devsInSwitch);
                dialog.setVisible(true);
            }
        });
        this.addCategoryCompatibilityListener();
        this.addCategoryPreUpdateListener();
        this.addCategoryMigrationListener();
        this.addCategoryMiniComputerListener();
        this.addCategoryHypermetroListener();
    }

    private void addCategoryMiniComputerListener() {
        this.collectlayout.getCategoryMiniComputer().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntegrateGrabSetupDialog.this.refreshTreeNode();
            }
        });
    }

    private void addCategoryMigrationListener() {
        this.collectlayout.getCategoryMigration().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntegrateGrabSetupDialog.this.refreshTreeNode();
            }
        });
    }

    private void addCategoryPreUpdateListener() {
        this.collectlayout.getCategoryPreUpdate().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntegrateGrabSetupDialog.this.refreshTreeNode();
            }
        });
    }

    private void addCategoryCompatibilityListener() {
        this.collectlayout.getCategoryCampatibility().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntegrateGrabSetupDialog.this.refreshTreeNode();
            }
        });
    }

    private void addCategoryHypermetroListener() {
        this.collectlayout.getCategoryOther().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntegrateGrabSetupDialog.this.collectlayout.getOtherTaskTypecomboBox().setEnabled(false);
                IntegrateGrabSetupDialog.this.refreshTreeNode();
            }
        });
    }

    public void refreshTreeNode() {
        CheckTreeNode rootNode = this.collectlayout.getItemRootNode();
        this.selectedItems.clear();
        if (this.collectlayout.getCategoryCampatibility().isSelected()) {
            this.selectedItems.addAll(this.campatibilityItems);
        }
        if (this.collectlayout.getCategoryMigration().isSelected()) {
            this.selectedItems.addAll(this.dataMigrationItems);
        }
        if (this.collectlayout.getCategoryMiniComputer().isSelected()) {
            this.selectedItems.addAll(this.miniComputerItems);
        }
        if (this.collectlayout.getCategoryPreUpdate().isSelected()) {
            this.selectedItems.addAll(this.preUpdateExplorationItems);
        }
        if (this.collectlayout.getCategoryOther().isSelected()) {
            this.selectedItems.addAll(this.hypermetroItems);
            this.selectedItems.addAll(this.networkDiscoveryItems);
        }
        this.selectedItems.addAll(this.allAppScenarios);
        this.checkRootNode(rootNode);
        SwingUtilities.updateComponentTreeUI(this.collectlayout);
    }

    private void checkRootNode(CheckTreeNode rootNode) {
        Enumeration<TreeNode> enumeration = rootNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode object = enumeration.nextElement();
            if (!(object instanceof CheckTreeNode)) continue;
            this.checkElementNode((CheckTreeNode)object);
        }
    }

    private void checkElementNode(CheckTreeNode node) {
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            TreeNode object = en.nextElement();
            if (!(object instanceof CheckTreeNode)) continue;
            CheckTreeNode itemNode = (CheckTreeNode)object;
            itemNode.setSelected(false);
            this.checkSelectedItems(itemNode);
        }
    }

    private void checkSelectedItems(CheckTreeNode itemNode) {
        Object userObject = itemNode.getUserObject();
        if (!(userObject instanceof CheckTreeNode)) {
            return;
        }
        Item item = (Item)userObject;
        for (String itemTitle : this.selectedItems) {
            if (!item.getTitle().equals(itemTitle)) continue;
            itemNode.setSelected(true);
            break;
        }
    }

    private void modifyClickApply() {
        IDeviceManageUI idm = (IDeviceManageUI)PublicUiManage.getInstance().getUi(IDeviceManageUI.class);
        List<GrabDevNode2> devs = InfoGrabService.getInstance().getAllDevNode();
        ArrayList<GrabDevNode2> modifyDevs = new ArrayList<GrabDevNode2>();
        for (GrabDevNode2 devNode : devs) {
            modifyDevs.add(devNode);
        }
        boolean isSuccess = idm.showModifyDeviceDialog((Window)this, this.deviceNode.getDeviceSerialNumber(), modifyDevs, false);
        if (isSuccess) {
            this.initRootHyperLinkLayout();
        }
    }

    private List<GrabDevNode2> filterChooseDevs() {
        LinkedList<GrabDevNode2> currResults = new LinkedList<GrabDevNode2>();
        List<GrabDevNode2> devs = InfoGrabService.getInstance().getAllDevNode();
        for (GrabDevNode2 devNode : devs) {
            if (!InfoGrabService.getInstance().checkSameType(this.deviceNode, devNode) || this.deviceNode.equals((Object)devNode) || OfflineImportUtils.isOfflineHost(devNode)) continue;
            currResults.add(devNode);
        }
        return currResults;
    }

    public List<Item> parseChooseCollectItem() {
        if (this.collectlayout.getItemRootNode().getChildCount() == 0) {
            LOGGER.info("Not support device!!!!!");
            return new ArrayList<Item>();
        }
        Enumeration<TreeNode> e = this.collectlayout.getItemRootNode().preorderEnumeration();
        ArrayList<Item> selectItems = new ArrayList<Item>();
        while (e.hasMoreElements()) {
            CheckTreeNode current = (CheckTreeNode)e.nextElement();
            Object object = current.getUserObject();
            if (!current.isSelected() || !(object instanceof Item)) continue;
            selectItems.add((Item)object);
        }
        return selectItems;
    }

    public List<String> parseChooseCategory() {
        ArrayList<String> selectCategory = new ArrayList<String>();
        if (this.collectlayout.getCategoryCampatibility().isSelected()) {
            selectCategory.add(this.collectlayout.getCategoryCampatibility().getText());
        }
        if (this.collectlayout.getCategoryMigration().isSelected()) {
            selectCategory.add(this.collectlayout.getCategoryMigration().getText());
        }
        if (this.collectlayout.getCategoryMiniComputer().isSelected()) {
            selectCategory.add(this.collectlayout.getCategoryMiniComputer().getText());
        }
        if (this.collectlayout.getCategoryPreUpdate().isSelected()) {
            selectCategory.add(this.collectlayout.getCategoryPreUpdate().getText());
        }
        if (this.collectlayout.getCategoryOther().isSelected() && this.collectlayout.getOtherTaskTypecomboBox().getSelectedItem() != null) {
            selectCategory.add(String.valueOf(this.collectlayout.getOtherTaskTypecomboBox().getSelectedItem()));
        }
        return selectCategory;
    }

    public void parseChooseSelectedNode() {
        Enumeration<TreeNode> e = this.collectlayout.getDeviceRootNode().preorderEnumeration();
        StringBuffer integrateName = new StringBuffer();
        while (e.hasMoreElements()) {
            CheckTreeNode current = (CheckTreeNode)e.nextElement();
            if (!current.isSelected() || !current.isLeaf()) continue;
            integrateName.append(current.getUserObject());
            integrateName.append(',');
        }
        if (integrateName.length() != 0) {
            integrateName.deleteCharAt(integrateName.lastIndexOf(","));
        }
    }

    public GrabSetupLayout getCollectlayout() {
        return this.collectlayout;
    }

    public GrabDevNode2 getDeviceNode() {
        return this.deviceNode;
    }

    public DevChooseDialog getDevChooseDialog() {
        return this.devChooseDialog;
    }

    public List<GrabDevNode2> getDevNodes() {
        return this.devNodes;
    }

    public Map<GrabDevNode2, List<Item>> getAllCollectItems() {
        return this.allCollectItems;
    }

    public String getIntegrateXMLFile() {
        return this.integrateXML;
    }

    private static final class OkButtonListener
    implements ActionListener {
        private DeviceSelectionListener listener;

        public OkButtonListener(DeviceSelectionListener listener) {
            this.listener = listener;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.listener.actionPerformed(e);
        }
    }
}

