/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui;

import com.huawei.ism.tool.infograb.entity.OneFunctionPanelParam;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MoreFunctionLayout
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_LAYOUT_ROW_COUNT = 3;
    private static final int COLUMN_COUNT_ONE_ROW = 3;
    private static final int MARGIN_BIG = 45;
    private static final Dimension PREFERRED_SIZE = new Dimension(185, 70);
    private static final Dimension RIGID_AREA_FILL_SPACE = new Dimension(190, 70);
    private List<JComponent> allFuncComponent = new ArrayList<JComponent>();

    public MoreFunctionLayout(List<OneFunctionPanelParam> allParams) {
        this.initData(allParams);
        this.initUI();
    }

    private void initData(List<OneFunctionPanelParam> allParams) {
        this.allFuncComponent = allParams.stream().map(this::getFunctionPanel).collect(Collectors.toList());
    }

    private void initUI() {
        JScrollPane pane = new JScrollPane(UiMethod.buildFrameSpace(this.getAllCompsBox(this.getRowCount()), 8));
        this.add(pane);
    }

    private JComponent getAllCompsBox(int rowCount) {
        Component[] rowComps = new JComponent[rowCount];
        IntStream.range(0, rowCount).boxed().forEach(arg_0 -> this.lambda$getAllCompsBox$0((JComponent[])rowComps, arg_0));
        return UCD.buildVBoxTop((int)45, (Component[])rowComps);
    }

    private JComponent getRowComp(int rowIndex) {
        int compIndex = rowIndex * 3;
        return UCD.buildHBoxLeft((int)45, (Component[])new Component[]{this.getRowComponent(compIndex), this.getRowComponent(compIndex + 1), this.getRowComponent(compIndex + 2)});
    }

    private int getRowCount() {
        int trueRowCount = this.allFuncComponent.size() / 3;
        if (3 < trueRowCount + 1) {
            return this.allFuncComponent.size() % 3 == 0 ? trueRowCount : trueRowCount + 1;
        }
        return 3;
    }

    private Component getRowComponent(int index) {
        if (index < this.allFuncComponent.size()) {
            return this.allFuncComponent.get(index);
        }
        return Box.createRigidArea(index > 9 ? PREFERRED_SIZE : RIGID_AREA_FILL_SPACE);
    }

    private JPanel getFunctionPanel(OneFunctionPanelParam param) {
        JPanel functionPanel = new JPanel();
        functionPanel.setLayout(new BoxLayout(functionPanel, 1));
        functionPanel.add(UCD.buildHBoxLeft((Component[])new Component[]{this.getFunctionLable(param)}));
        functionPanel.setPreferredSize(PREFERRED_SIZE);
        functionPanel.setBackground(Color.WHITE);
        functionPanel.setBorder(BorderFactory.createTitledBorder(""));
        functionPanel.setCursor(new Cursor(12));
        functionPanel.addMouseListener(param.getMouseAdapter());
        return functionPanel;
    }

    private JLabel getFunctionLable(OneFunctionPanelParam param) {
        JLabel functionLabel = new JLabel(param.getDesc(), param.getIcon(), 0);
        functionLabel.setName("Function_Label_" + this.allFuncComponent.size());
        return functionLabel;
    }

    private /* synthetic */ void lambda$getAllCompsBox$0(JComponent[] rowComps, Integer rowIndex) {
        rowComps[rowIndex.intValue()] = this.getRowComp(rowIndex);
    }
}

