/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableScrollPane;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.UUID;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.table.TableModel;

public class MultiWarningContnueDialog
extends JDialog {
    public static final int CONFIRM_CLICKED = 0;
    public static final int CANCEL_CLICKED = 1;
    private static final long serialVersionUID = 3374635204788409020L;
    private static final Dimension DIALOG_SIZE = new Dimension(600, 450);
    private JButton continueBtn = UiMethod.createButton(ResourceUtil.getString((String)"infograb.collect.windows.connection.warning.dialog.ensure"), 'O');
    private JButton closeBtn = UiMethod.createButton(ResourceUtil.getString((String)"infograb.collect.windows.connection.warning.dialog.cancel"), 'C');
    private int clickValue = -1;

    public MultiWarningContnueDialog(Window parent, String desc, String[] infoHeader, List<List<String>> messages) {
        this(parent, desc, infoHeader, messages, ResourceUtil.getString((String)"infograb.collect.windows.connection.warning.dialog.title"), "comfirmdialog_warn.png");
    }

    public MultiWarningContnueDialog(Window parent, String desc, String[] infoHeader, List<List<String>> messages, String title, String img) {
        super(parent);
        this.initUI(desc, title, img, infoHeader, messages);
        this.addListeners();
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
    }

    public int getClickValue() {
        return this.clickValue;
    }

    private void addListeners() {
        this.continueBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiWarningContnueDialog.this.clickValue = 0;
                MultiWarningContnueDialog.this.dispose();
            }
        });
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiWarningContnueDialog.this.clickValue = 1;
                MultiWarningContnueDialog.this.dispose();
            }
        });
    }

    private void initUI(String desc, String title, String img, String[] infoHeader, List<List<String>> messages) {
        JLabel descLabel = new JLabel("<html>" + desc + "</html>");
        descLabel.setIcon(ResourceUtil.getImage((String)img));
        JComponent mainCom = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft(descLabel), this.createMainPanel(infoHeader, messages)});
        this.setTitle(title);
        this.setModal(true);
        this.setPreferredSize(DIALOG_SIZE);
        this.setLayout(new BorderLayout());
        this.add(UiMethod.buildFrameSpace(mainCom, 12));
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
    }

    private JComponent createMainPanel(String[] infoHeader, List<List<String>> messages) {
        DefaultTableModel infoTableModel = new DefaultTableModel(infoHeader, new int[0]);
        IsmTable infoTable = new IsmTable((TableModel)infoTableModel);
        if (null != messages) {
            for (List<String> rowDatas : messages) {
                DefaultTableRow row = new DefaultTableRow(infoHeader.length, (Object)UUID.randomUUID().toString());
                row.setValues(rowDatas);
                infoTableModel.addRow(new TableRow[]{row});
            }
        }
        this.getRootPane().setDefaultButton(this.closeBtn);
        return UCD.buildVerticalBox(null, (Component[])new Component[]{new IsmTableScrollPane(infoTable, false), UCD.buildHorizontalBoxRight((Component)UCD.buildHorizotalBox(null, (Component[])new Component[]{this.continueBtn, this.closeBtn}))});
    }

    @Override
    public void processWindowEvent(WindowEvent event) {
        switch (event.getID()) {
            case 200: {
                this.closeBtn.requestFocus();
                break;
            }
            case 201: {
                this.dispose();
                break;
            }
        }
    }
}

