/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IDeviceManage;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeObserver;
import com.huawei.ism.tool.infograb.base.IDetailContainer;
import com.huawei.ism.tool.infograb.base.ITaskDetailRefreshUI;
import com.huawei.ism.tool.infograb.context.CollectStatusEnum;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.GrabFlow;
import com.huawei.ism.tool.infograb.entity.GrabResultEntity;
import com.huawei.ism.tool.infograb.entity.Item;
import com.huawei.ism.tool.infograb.entity.RealTimeTask;
import com.huawei.ism.tool.infograb.grab.GrabFlowAdapter;
import com.huawei.ism.tool.infograb.service.CollectStatusCache;
import com.huawei.ism.tool.infograb.service.InfoGrabService;
import com.huawei.ism.tool.infograb.ui.InfoGrabIsmTable;
import com.huawei.ism.tool.infograb.ui.InfoGrabMainFrame;
import com.huawei.ism.tool.infograb.ui.RealTimeTaskPanel;
import com.huawei.ism.tool.infograb.ui.action.AddDeviceAction;
import com.huawei.ism.tool.infograb.ui.action.BatchImportAction;
import com.huawei.ism.tool.infograb.ui.action.CollectDeviceAction;
import com.huawei.ism.tool.infograb.ui.action.CompleteHyperlinkAction;
import com.huawei.ism.tool.infograb.ui.action.DelDeviceAction;
import com.huawei.ism.tool.infograb.ui.action.DetailListerListener;
import com.huawei.ism.tool.infograb.ui.action.FailedHyperlinkAction;
import com.huawei.ism.tool.infograb.ui.action.ListMouseAdapter;
import com.huawei.ism.tool.infograb.ui.action.ListSelectListener;
import com.huawei.ism.tool.infograb.ui.action.StopCollectAction;
import com.huawei.ism.tool.infograb.ui.render.ItemListCellRender;
import com.huawei.ism.tool.infograb.ui.support.DeviceSetupIcon;
import com.huawei.ism.tool.infograb.utils.OfflineImportUtils;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.ui.tablecompositer.IpAddressStrategy;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.RolloverButton;
import com.huawei.ism.ui.swing.plaf.armor.ArmorListUI;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ListUI;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealTimeTaskDetailContainer
extends JSplitPane
implements ITaskDetailRefreshUI,
IDetailContainer {
    private static final long serialVersionUID = 2140171394729732481L;
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoGrabMainFrame.class);
    private static final String COLLECTING_STRING = CollectStatusEnum.COLLECTING.toString();
    private transient CollectDeviceAction collectDeviceAction;
    private final transient StopCollectAction stopCollectAction = new StopCollectAction();
    private final transient CollectStatusCache statusCache = CollectStatusCache.getInstance();
    private final ReentrantLock lockUI = new ReentrantLock();
    private int deviceType = 0;
    private int deviceName = 1;
    private int deviceModel = 2;
    private int snNumber = 3;
    private int deviceIP = 4;
    private int statusNumber = 5;
    private int processNumber = 6;
    private int checkResultNumber = 7;
    private int setLinkNumber = 8;
    private JLabel nodevLabel = new JLabel(ResourceUtil.getString((String)"infograb.init.tips.nodevadded.tip"));
    private JComponent nodevCopmp;
    private Component noDevFilter;
    private JComponent taskDetailArea;
    private Dimension defaultSize;
    private static final ThreadLocal<GrabDevNode2> CURGRAB_DEV = new ThreadLocal();
    private JButton addDevBtn;
    private JButton deleteDevBtn;
    private RolloverButton batchImportBtn;
    private JButton collectBtn;
    private JButton stopCollectBtn;
    private final String[] tableHeaders = this.initColumnName();
    private JScrollPane detailListScrolPane;
    private DefaultTableModel deviceTableModel;
    private InfoGrabIsmTable devTable;
    private JList detailList;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private DefaultListModel detailListMode = null;
    private List<String> hostdeviceTypeL2 = new LinkedList<String>();
    private List<String> dataBasedeviceTypeL2 = new LinkedList<String>();
    private List<String> switchdeviceTypeL2 = new LinkedList<String>();
    private RealTimeTaskPanel taskPanel;
    private TableScrollPane tsp;

    public RealTimeTaskDetailContainer(RealTimeTaskPanel taskPanel) {
        super(0, true);
        this.taskPanel = taskPanel;
        this.initUIComponent();
        this.layoutComponent();
        this.initListener();
        this.initDevType();
    }

    @Override
    public void initDevThread(GrabDevNode2 dev) {
        CURGRAB_DEV.set(dev);
    }

    public JLabel getNodevLabel() {
        return this.nodevLabel;
    }

    public void setNodevLabel(JLabel nodevLabel) {
        this.nodevLabel = nodevLabel;
    }

    private void initUIComponent() {
        this.defaultSize = new Dimension(800, 300);
        this.addDevBtn = UiMethod.createButton(ResourceUtil.getString((String)"infograb.button.adddevice"), 'A');
        this.deleteDevBtn = UiMethod.createButton(ResourceUtil.getString((String)"infograb.button.deletedevice"), 'E');
        this.batchImportBtn = new RolloverButton(ResourceUtil.getString((String)"infograb.button.batchimport"));
        this.batchImportBtn.setMnemonic('B');
        this.batchImportBtn.setVisible(false);
        this.collectBtn = UiMethod.createButton(ResourceUtil.getString((String)"infograb.button.dograb"), 'O');
        this.stopCollectBtn = UiMethod.createButton(ResourceUtil.getString((String)"infograb.button.stopcollect"), 'S');
        this.detailListScrolPane = null;
        this.detailListMode = new DefaultListModel();
        this.detailList = new JList(this.detailListMode);
        this.detailList.setName("_List_detailList");
        this.deviceTableModel = new DefaultTableModel(this.tableHeaders, new int[0]);
        this.devTable = new InfoGrabIsmTable((TableModel)this.deviceTableModel);
        this.devTable.setName("_Table_devTable");
        this.addNodeObserver();
    }

    private void addNodeObserver() {
        IDeviceManage devMng = (IDeviceManage)PublicServiceManage.getInstance().getService(IDeviceManage.class);
        devMng.addInfoGrabNodeObservers((INodeObserver)this);
    }

    private void layoutComponent() {
        this.detailList.setCellRenderer(new ItemListCellRender());
        this.detailList.setSelectionMode(0);
        this.buttonGroup.add(this.collectBtn);
        this.buttonGroup.add(this.stopCollectBtn);
        JComponent tableTopBtnArea = UiMethod.buildCompsLeft(this.addDevBtn, this.deleteDevBtn, this.collectBtn, this.stopCollectBtn);
        TableScrollPane tableArea = this.tablePanel();
        this.noDevFilter = Box.createHorizontalStrut(245);
        this.nodevCopmp = UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxCentert((Component[])new Component[]{this.nodevLabel}), Box.createVerticalStrut(204)});
        this.taskDetailArea = UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{tableTopBtnArea, new JSeparator(), tableArea});
        this.addNodevTips();
        this.taskDetailArea.setAlignmentX(0.5f);
        JComponent detailArea = this.detailPanel();
        detailArea.setAlignmentX(0.0f);
        this.setTopComponent(this.taskDetailArea);
        this.setBottomComponent(detailArea);
        this.setDividerLocation(320);
        this.setEnabled(false);
        this.setAlignmentX(0.0f);
        this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
    }

    private void initListener() {
        this.collectDeviceAction = new CollectDeviceAction(this.taskPanel);
        this.addDevBtn.addActionListener(new AddDeviceAction());
        this.deleteDevBtn.addActionListener(new DelDeviceAction());
        this.batchImportBtn.addActionListener((ActionListener)((Object)new BatchImportAction(GrabContext.getInstance().getCurrInfoGrabFrame())));
        this.collectBtn.addActionListener(this.collectDeviceAction);
        this.stopCollectBtn.addActionListener(this.stopCollectAction);
        this.getDetailList().addMouseListener(new ListMouseAdapter());
        this.getDevTable().addMouseListener(new DetailListerListener());
        this.getDevTable().getSelectionModel().addListSelectionListener(new ListSelectListener());
    }

    private TableScrollPane tablePanel() {
        this.tsp = new TableScrollPane((IsmTable)this.devTable, true, true, true);
        this.tsp.setMinimumSize(new Dimension(this.tsp.getPreferredSize().width, 10));
        this.tsp.setBorder(null);
        this.tsp.setVerticalScrollBarPolicy(21);
        return this.tsp;
    }

    public TableScrollPane getTsp() {
        return this.tsp;
    }

    public void addNodevTips() {
        this.taskDetailArea.add(this.nodevCopmp);
        this.setDividerLocation(320);
        this.setEnabled(false);
    }

    public Component getNoDevFilter() {
        return this.noDevFilter;
    }

    private JComponent detailPanel() {
        this.detailListScrolPane = new JScrollPane(this.detailList);
        this.detailListScrolPane.setPreferredSize(this.defaultSize);
        this.detailListScrolPane.setBorder(null);
        return this.detailListScrolPane;
    }

    private String[] initColumnName() {
        String[] columnName = new String[]{ResourceUtil.getString((String)"infograb.devicetable.head.devicetype"), ResourceUtil.getString((String)"infograb.devicetable.head.devicetype2"), ResourceUtil.getString((String)"infograb.devicetable.head.devicemodel"), ResourceUtil.getString((String)"infograb.devicetable.head.sn"), ResourceUtil.getString((String)"infograb.devicetable.head.ip"), ResourceUtil.getString((String)"infograb.devicetable.head.status"), ResourceUtil.getString((String)"infograb.devicetable.head.progress"), ResourceUtil.getString((String)"infograb.devicetable.head.result"), ResourceUtil.getString((String)"infograb.devicetable.head.operation")};
        return columnName;
    }

    private TableRow<GrabDevNode2, String> createTableRow(GrabDevNode2 dev) {
        DefaultTableRow row = new DefaultTableRow(this.getTableColumn(), (Object)dev, (Object)dev.getDeviceSerialNumber());
        row.setValueAt(this.deviceType, (Object)dev.getItDeviceType().toString());
        row.setValueAt(this.deviceName, (Object)dev.getDeviceName());
        row.setValueAt(this.deviceModel, (Object)dev.getDeviceType());
        row.setValueAt(this.snNumber, (Object)dev.getDeviceSerialNumber());
        row.setValueAt(this.deviceIP, (Object)new IpAddressStrategy(dev.getIp()));
        row.setValueAt(this.statusNumber, (Object)this.getStatusCell(CollectStatusEnum.NOT_COLLECT));
        row.setValueAt(this.processNumber, (Object)new IsmTableCell.ProgressCell(0));
        row.setValueAt(this.checkResultNumber, (Object)ResourceUtil.getString((String)"infograb.notstarted"));
        if (!"NAS".equals(dev.getMigrType())) {
            row.setValueAt(this.setLinkNumber, (Object)new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"infograb.setup"), new DeviceSetupIcon(dev, this).getAction()));
        }
        return row;
    }

    private IsmTableCell getStatusCell(CollectStatusEnum status) {
        return this.statusCache.getTableCellFromStatus(status);
    }

    @Override
    public List<GrabDevNode2> getSelectedDevNode() {
        int[] rowIndexs = this.getDevTable().getSelectedRows();
        ArrayList<GrabDevNode2> results = new ArrayList<GrabDevNode2>();
        if (rowIndexs == null || rowIndexs.length == 0) {
            return results;
        }
        for (int index : rowIndexs) {
            index = this.getDevTable().convertRowIndexToModel(index);
            TableRow row = this.getDeviceTableModel().getRow(index);
            GrabDevNode2 devNode = (GrabDevNode2)((Object)row.getUserObject());
            results.add(devNode);
        }
        return results;
    }

    @Override
    public List<GrabDevNode2> getAllDevNode() {
        List rows = this.getDevTable().getAllRows();
        ArrayList<GrabDevNode2> results = new ArrayList<GrabDevNode2>();
        GrabDevNode2 devNode = null;
        if (rows == null || rows.isEmpty()) {
            return results;
        }
        for (TableRow row : rows) {
            devNode = (GrabDevNode2)((Object)row.getUserObject());
            results.add(devNode);
        }
        return results;
    }

    private void initDevType() {
        this.hostdeviceTypeL2.add("Linux");
        this.hostdeviceTypeL2.add("AIX");
        this.hostdeviceTypeL2.add("HP-UX");
        this.hostdeviceTypeL2.add("Solaris");
        this.hostdeviceTypeL2.add("VMware");
        this.hostdeviceTypeL2.add("Windows");
        this.hostdeviceTypeL2.add("FusionSphere");
        this.dataBasedeviceTypeL2.add("Oracle");
        this.dataBasedeviceTypeL2.add("MySQL");
        this.dataBasedeviceTypeL2.add("SQLServer");
        this.dataBasedeviceTypeL2.add("DB2");
        this.switchdeviceTypeL2.add("Brocade");
        this.switchdeviceTypeL2.add("Cisco");
    }

    @Override
    public void saveData2Scene() {
        List allDevices = this.getDeviceTableModel().getAllRows();
        for (TableRow device : allDevices) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("toolId", "InfoGrab");
            IpAddressStrategy ip = (IpAddressStrategy)device.getValueAt(4);
            resultMap.put("IP", ip.toString());
            String devType = (String)device.getValueAt(1);
            if (this.checkDevType(this.hostdeviceTypeL2, devType)) {
                resultMap.put("SN", ItDeviceType.Host.getName());
            } else if (this.checkDevType(this.dataBasedeviceTypeL2, devType)) {
                resultMap.put("SN", ItDeviceType.Database.getName());
            } else if (this.checkDevType(this.switchdeviceTypeL2, devType)) {
                resultMap.put("SN", ItDeviceType.Switch.getName());
            }
            String status = device.getValueAt(5).toString();
            if (status.equalsIgnoreCase(ResourceUtil.getString((String)"infograb.dev.status.collectfinish"))) {
                resultMap.put("status", "Success");
            } else if (status.equalsIgnoreCase(ResourceUtil.getString((String)"infograb.dev.status.succ.noall"))) {
                resultMap.put("status", "PartSuccess");
            } else {
                if (!status.equalsIgnoreCase(ResourceUtil.getString((String)"infograb.failed"))) continue;
                resultMap.put("status", "Failure");
            }
            resultMap.put("fileName", "scenedata.xml");
            Date date = new Date();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            resultMap.put("endTime", format.format(date));
            boolean needAdd = true;
            for (Map<String, String> result : GrabContext.getInstance().getResultList()) {
                if (!result.get("SN").equalsIgnoreCase((String)resultMap.get("SN")) || !result.get("IP").equalsIgnoreCase((String)resultMap.get("IP"))) continue;
                needAdd = false;
            }
            if (!needAdd || StringUtils.isNULLStr((String)resultMap.get("status"))) continue;
            GrabContext.getInstance().getResultList().add(resultMap);
        }
    }

    private boolean checkDevType(List<String> deviceTypeList, String devType) {
        for (String dev : deviceTypeList) {
            if (!dev.equalsIgnoreCase(devType)) continue;
            return true;
        }
        return false;
    }

    public int getListIndex(Point point, JList detailListPara) {
        ListUI obj = detailListPara.getUI();
        if (obj instanceof ArmorListUI) {
            ArmorListUI ui = (ArmorListUI)detailListPara.getUI();
            return ui.locationToRow(point);
        }
        return detailListPara.getSelectedIndex();
    }

    public void fireNodeAdd(DevNode device) {
        GrabDevNode2 dev = ToolUtils.toGrabNewNode(device);
        if (this.taskPanel.getTask().getId().equals(GrabContext.getInstance().getCurrentTask().getTask().getId())) {
            this.fireNodeAddThread(dev);
            int oldMaxProcess = ((RealTimeTask)this.taskPanel.getTask()).getTaskMaxProcess();
            int newMaxProcess = ++oldMaxProcess;
            ((RealTimeTask)this.taskPanel.getTask()).setTaskMaxProcess(newMaxProcess);
            this.taskPanel.refreshTaskProcess();
            List<String> selectedCategory = ((RealTimeTask)this.taskPanel.getTask()).getTaskCategory();
            Map<ItDeviceType, GrabFlow> currType2FlowMap = OfflineImportUtils.getType2Flow(device);
            List<Item> allItems = GrabFlowAdapter.getInstance().findAllFlow(currType2FlowMap, dev);
            ArrayList<Item> categoryItems = new ArrayList();
            if (null != allItems) {
                if (null == selectedCategory || selectedCategory.contains(ResourceUtil.getString((String)"infograb.item.category.all"))) {
                    categoryItems = allItems;
                } else {
                    ToolUtils.findCategoryItems(selectedCategory, allItems, categoryItems);
                }
            }
            GrabFlowAdapter.getInstance().getNodeSelectedCategoryMap().put(dev, selectedCategory);
            GrabFlowAdapter.getInstance().getNodeGrabFlowMap().put(dev, categoryItems);
            GrabContext.getInstance().getTaskMap().put(dev, this.taskPanel.getTask());
            AtomicInteger devCount = GrabContext.getInstance().getDevCount();
            devCount.set(devCount.incrementAndGet());
            GrabContext.getInstance().setDevCount(devCount);
        }
    }

    private void fireNodeAddThread(final GrabDevNode2 dev) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableRow row;
                GrabDevNode2 lastNode = GrabContext.getInstance().getCurrentChosenDevNode();
                if (lastNode != null && (row = RealTimeTaskDetailContainer.this.getDeviceTableModel().getTableRowBy((Object)lastNode.getDeviceSerialNumber())) != null) {
                    row.setValueAt(RealTimeTaskDetailContainer.this.deviceType, (Object)lastNode.getItDeviceType().toString());
                }
                GrabContext.getInstance().setCurrentChosenDevNode(null);
                row = RealTimeTaskDetailContainer.this.createTableRow(dev);
                List oldRows = RealTimeTaskDetailContainer.this.getDeviceTableModel().getAllRows();
                if (!oldRows.contains(row)) {
                    oldRows.add(0, row);
                }
                RealTimeTaskDetailContainer.this.tsp.setVerticalScrollBarPolicy(22);
                RealTimeTaskDetailContainer.this.taskDetailArea.remove(RealTimeTaskDetailContainer.this.nodevCopmp);
                RealTimeTaskDetailContainer.this.setEnabled(true);
                RealTimeTaskDetailContainer.this.getDevTable().getRowSorter().setSortKeys(new ArrayList());
                if ("NAS".equals(dev.getMigrType())) {
                    RealTimeTaskDetailContainer.this.getDeviceTableModel().setCustomVisibleColumns(new int[]{0, 1, 2, 3, 4, 5, 6, 7});
                }
                RealTimeTaskDetailContainer.this.getDeviceTableModel().removeAll();
                RealTimeTaskDetailContainer.this.getDeviceTableModel().addRows(oldRows);
            }
        });
    }

    public void fireNodeDelete(DevNode dev) {
        if (this.taskPanel.getTask().getId().equals(GrabContext.getInstance().getCurrentTask().getTask().getId())) {
            TableRow row = this.getDeviceTableModel().getTableRowBy((Object)dev.getDeviceSerialNumber().toUpperCase(Locale.ENGLISH));
            this.getDeviceTableModel().removeRow(new TableRow[]{row});
            int oldMaxProcess = ((RealTimeTask)this.taskPanel.getTask()).getTaskMaxProcess();
            int newMaxProcess = --oldMaxProcess;
            if (null != row && row.getValueAt(this.statusNumber).toString().equals(ResourceUtil.getString((String)"infograb.dev.status.collectfinished"))) {
                int oldProcess = ((RealTimeTask)this.taskPanel.getTask()).getTaskCurruentProcess();
                int newProcess = oldProcess - 1;
                ((RealTimeTask)this.taskPanel.getTask()).setTaskCurruentProcess(newProcess);
            }
            ((RealTimeTask)this.taskPanel.getTask()).setTaskMaxProcess(newMaxProcess);
            this.taskPanel.refreshTaskProcess();
            AtomicInteger devCount = GrabContext.getInstance().getDevCount();
            devCount.set(devCount.decrementAndGet());
            if (devCount.get() == 0) {
                this.addNodevTips();
            }
            GrabContext.getInstance().setDevCount(devCount);
        }
    }

    public void fireNodeModify(DevNode dev) {
        GrabDevNode2 node;
        TableRow row;
        if (this.taskPanel.getTask().getId().equals(GrabContext.getInstance().getCurrentTask().getTask().getId()) && (row = this.getDeviceTableModel().getTableRowBy((Object)dev.getDeviceSerialNumber())) != null && (node = (GrabDevNode2)((Object)row.getUserObject())) != null) {
            node.setLoginUser(dev.getLoginUser());
            node.setPort(dev.getPort());
            node.setDevInfoPkgPath(dev.getDevInfoPkgPath());
            node.setSudoGrab(dev.isSudoGrab());
        }
    }

    private List<TableRow> findLoadingRows() {
        LinkedList<TableRow> loadingRows = new LinkedList<TableRow>();
        List<TableRow> allRows = this.getAllTableRow();
        for (TableRow row : allRows) {
            if (!this.isLoadingRow((TableRow<GrabDevNode2, String>)row)) continue;
            loadingRows.add(row);
        }
        return loadingRows;
    }

    private List<TableRow> getAllTableRow() {
        return this.getDeviceTableModel().getAllRows();
    }

    private boolean isLoadingRow(TableRow<GrabDevNode2, String> row) {
        IsmTableCell.IconCell iconCell = (IsmTableCell.IconCell)row.getValueAt(this.statusNumber);
        return iconCell.toString().equals(COLLECTING_STRING);
    }

    @Override
    public void changeSelectNodeStatus(GrabDevNode2 devNode) {
        SwingUtilities.invokeLater(() -> {
            TableRow<GrabDevNode2, String> changeRow = this.getTableRow(devNode.getDeviceSerialNumber());
            if (null != changeRow) {
                changeRow.setValueAt(this.statusNumber, (Object)this.getStatusCell(CollectStatusEnum.COLLECTING));
                changeRow.setValueAt(this.checkResultNumber, (Object)ResourceUtil.getString((String)"infograb.processing"));
                changeRow.setValueAt(this.processNumber, (Object)new IsmTableCell.ProgressCell(0));
            }
            this.getDevTable().repaint();
        });
    }

    private TableRow<GrabDevNode2, String> getTableRow(String id) {
        List tableRows = this.getDeviceTableModel().getAllRows();
        for (TableRow row : tableRows) {
            String rowId = (String)row.getIdentifier();
            if (!rowId.equals(id)) continue;
            return row;
        }
        return null;
    }

    @Override
    public void collectCallback(GrabDevNode2 devNode) {
        this.refurbishDetailList();
        this.getBottomDetailList(devNode);
    }

    @Override
    public void refurbishDetailList() {
        TableRow row;
        GrabDevNode2 lastNode = GrabContext.getInstance().getCurrentChosenDevNode();
        GrabDevNode2 devNode = this.getCurrentChosenDevNode();
        if (lastNode != null && (row = this.getDeviceTableModel().getTableRowBy((Object)lastNode.getDeviceSerialNumber())) != null) {
            row.setValueAt(this.deviceType, (Object)lastNode.getItDeviceType().toString());
        }
        if (devNode != null && null != (row = this.getDeviceTableModel().getTableRowBy((Object)devNode.getDeviceSerialNumber()))) {
            row.setValueAt(this.deviceType, (Object)new IsmTableCell.ComboCell(new IsmTableCell[]{new IsmTableCell.LabelCell(devNode.getItDeviceType().toString()), new IsmTableCell.IconCell((Icon)GrabContext.SEE_IMAGE, "")}));
        }
        GrabContext.getInstance().setCurrentChosenDevNode(devNode);
        this.setListData(devNode);
        this.getDevTable().repaint();
    }

    private void setListData(GrabDevNode2 devNode) {
        if (devNode == null) {
            LOGGER.info("No devNode msg");
            this.getDetailList().setListData(new ExecuteResult[0]);
            return;
        }
        GrabContext currGrabCtx = GrabContext.getInstance();
        List<ExecuteResult> execResultList = currGrabCtx.getExecuteResultMap().get((Object)devNode);
        if (null != execResultList && !execResultList.isEmpty()) {
            this.getDetailList().setListData(execResultList.toArray());
        } else {
            this.getDetailList().setListData(new ArrayList().toArray());
        }
    }

    public GrabDevNode2 getCurrentChosenDevNode() {
        int[] rows = this.getDevTable().getSelectedRows();
        if (rows == null || rows.length == 0) {
            LOGGER.info("Not select devNode.");
            return null;
        }
        int index = this.getDevTable().convertRowIndexToModel(rows[0]);
        TableRow row = this.getDeviceTableModel().getRow(index);
        return (GrabDevNode2)((Object)row.getUserObject());
    }

    public void refreshStopStatus(GrabDevNode2 dev) {
        this.lockUI.lock();
        try {
            TableRow<GrabDevNode2, String> changeRow = this.getTableRow(dev.getDeviceSerialNumber());
            if (null != changeRow) {
                changeRow.setValueAt(this.statusNumber, (Object)this.getStatusCell(CollectStatusEnum.COLLECT_STOP));
                changeRow.setValueAt(this.checkResultNumber, (Object)ResourceUtil.getString((String)"infograb.dev.status.collectstopped"));
            }
            this.getDevTable().repaint();
        }
        finally {
            this.lockUI.unlock();
        }
    }

    private void getBottomDetailList(GrabDevNode2 itemDevNode) {
        if (this.getCurrentChosenDevNode() == null) {
            return;
        }
        if (!itemDevNode.getDeviceSerialNumber().equals(this.getCurrentChosenDevNode().getDeviceSerialNumber())) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GrabDevNode2 devNode = RealTimeTaskDetailContainer.this.getCurrentChosenDevNode();
                if (devNode != null) {
                    JScrollBar bar = RealTimeTaskDetailContainer.this.getDetailListScrolPane().getVerticalScrollBar();
                    bar.setValue(bar.getMaximum());
                }
            }
        });
    }

    @Override
    public void fireItemFinished(Item item, GrabDevNode2 devNode) {
    }

    @Override
    public void refreshPregress(List<ExecuteResult> currResults) {
        if (currResults.isEmpty()) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(() -> {
                for (ExecuteResult currResult : currResults) {
                    if (currResult == null) continue;
                    GrabDevNode2 dev = currResult.getDevNode();
                    TableRow<GrabDevNode2, String> changeRow = this.getTableRow(dev.getDeviceSerialNumber());
                    if (null == changeRow) {
                        LOGGER.error("Collect call back error,no such devNode .");
                        return;
                    }
                    this.lockUI.lock();
                    try {
                        changeRow.setValueAt(this.statusNumber, (Object)this.getStatusCell(currResult.getNowStatus()));
                    }
                    finally {
                        this.lockUI.unlock();
                    }
                    if (currResult.getProgress() >= 0) {
                        changeRow.setValueAt(this.processNumber, (Object)new IsmTableCell.ProgressCell(currResult.getProgress()));
                    }
                    this.refreshRowStatus(currResult, changeRow);
                    this.refreshTaskStatus();
                }
                this.getDevTable().repaint();
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.warn("refreshProgress error", (Throwable)e);
        }
    }

    private void refreshRowStatus(ExecuteResult currResult, TableRow<GrabDevNode2, String> changeRow) {
        if (ResourceUtil.getString((String)"infograb.complete").equals(currResult.getCheckResult())) {
            currResult.getDevNode().setCollectDone(true);
            if (!"NAS".equals(currResult.getDevNode().getMigrType())) {
                changeRow.setValueAt(this.checkResultNumber, (Object)new IsmTableCell.HyperlinkCell(currResult.getCheckResult(), (ActionListener)new CompleteHyperlinkAction(currResult.getDevNode())));
            } else {
                changeRow.setValueAt(this.checkResultNumber, (Object)currResult.getCheckResult());
            }
            int oldProcess = this.taskPanel.getTask().getTaskCurruentProcess();
            int newProcess = oldProcess + 1;
            this.taskPanel.getTask().setTaskCurruentProcess(newProcess);
            this.taskPanel.refreshTaskProcess();
        } else if (ResourceUtil.getString((String)"infograb.failed").equals(currResult.getCheckResult())) {
            if (!"NAS".equals(currResult.getDevNode().getMigrType())) {
                changeRow.setValueAt(this.checkResultNumber, (Object)new IsmTableCell.HyperlinkCell(currResult.getCheckResult(), (ActionListener)new FailedHyperlinkAction(currResult.getDevNode())));
            } else {
                changeRow.setValueAt(this.checkResultNumber, (Object)currResult.getCheckResult());
            }
        } else {
            changeRow.setValueAt(this.checkResultNumber, (Object)currResult.getCheckResult());
        }
    }

    public void refreshTaskStatus() {
        List rows = this.devTable.getAllRows();
        ArrayList<String> devStatus = new ArrayList<String>();
        for (TableRow tableRow : rows) {
            devStatus.add(tableRow.getValueAt(this.statusNumber).toString());
        }
        this.taskPanel.refreshTaskStatus(devStatus);
    }

    public int getTableColumn() {
        return this.tableHeaders.length;
    }

    public JList getDetailList() {
        return this.detailList;
    }

    public void setDetailList(JList detailList) {
        this.detailList = detailList;
    }

    public JScrollPane getDetailListScrolPane() {
        return this.detailListScrolPane;
    }

    public void setAddDevBtn(RolloverButton addDevBtn) {
        this.addDevBtn = addDevBtn;
    }

    public RolloverButton getBatchImportBtn() {
        return this.batchImportBtn;
    }

    public void setBatchImportBtn(RolloverButton batchImportBtn) {
        this.batchImportBtn = batchImportBtn;
    }

    public void setDeleteDevBtn(RolloverButton deleteDevBtn) {
        this.deleteDevBtn = deleteDevBtn;
    }

    public void setCollectBtn(RolloverButton collectBtn) {
        this.collectBtn = collectBtn;
    }

    public DefaultTableModel getDeviceTableModel() {
        return this.deviceTableModel;
    }

    public void setDeviceTableModel(DefaultTableModel deviceTableModel) {
        this.deviceTableModel = deviceTableModel;
    }

    public InfoGrabIsmTable getDevTable() {
        return this.devTable;
    }

    public void setDevTable(InfoGrabIsmTable devTable) {
        this.devTable = devTable;
    }

    public DefaultListModel getDetailListMode() {
        return this.detailListMode;
    }

    public void setDetailListMode(DefaultListModel detailListMode) {
        this.detailListMode = detailListMode;
    }

    public StopCollectAction getStopCollectAction() {
        return this.stopCollectAction;
    }

    public CollectDeviceAction getCollectDeviceAction() {
        return this.collectDeviceAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshLoadingPic() {
        this.lockUI.lock();
        try {
            List<TableRow> loadingRows = this.findLoadingRows();
            if (loadingRows.isEmpty()) {
                InfoGrabService.getInstance().stopGifLoading();
                return;
            }
            for (TableRow row : loadingRows) {
                row.setValueAt(this.statusNumber, (Object)this.getStatusCell(CollectStatusEnum.COLLECTING));
            }
        }
        finally {
            this.lockUI.unlock();
        }
        this.getDevTable().repaint();
    }

    public RealTimeTaskPanel getTaskPanel() {
        return this.taskPanel;
    }

    public void setTaskPanel(RealTimeTaskPanel taskPanel) {
        this.taskPanel = taskPanel;
    }

    @Override
    public void updateProgress(int progress) {
        GrabDevNode2 devNode = CURGRAB_DEV.get();
        ExecuteResult result = this.isNeedShowDetailList(devNode);
        if (result == null) {
            return;
        }
        int curProg = result.getCurItemProgress();
        if (progress < curProg) {
            LOGGER.error("progress in valid.");
            return;
        }
        result.setCurItemProgress(progress > 100 ? 100 : progress);
        result.setShowProgress(progress >= 0 && progress < 100);
        this.updateItemProgress(devNode);
    }

    public ExecuteResult isNeedShowDetailList(GrabDevNode2 devNode) {
        GrabDevNode2 showDev;
        ListModel listModel = this.getDetailList().getModel();
        if (listModel.getSize() < 1) {
            return null;
        }
        Object object = listModel.getElementAt(listModel.getSize() - 1);
        boolean updateValid = object instanceof ExecuteResult;
        ExecuteResult result = updateValid ? (ExecuteResult)object : null;
        GrabDevNode2 grabDevNode2 = showDev = result != null ? result.getDevNode() : null;
        if (showDev != null && !devNode.getDeviceSerialNumber().equals(showDev.getDeviceSerialNumber())) {
            return null;
        }
        return result;
    }

    @Override
    public GrabDevNode2 getGrabDevNode() {
        return CURGRAB_DEV.get();
    }

    @Override
    public void updateItemProgress(GrabDevNode2 devNode) {
        try {
            GrabDevNode2 chDevNode = this.getCurrentChosenDevNode();
            if (chDevNode == null || !chDevNode.getDeviceSerialNumber().equals(devNode.getDeviceSerialNumber())) {
                return;
            }
            this.setListData(devNode);
            this.getDetailList().repaint();
            ConnUtils.sleep(200);
        }
        catch (Exception e) {
            LOGGER.error("update progress error", (Throwable)e);
        }
    }

    @Override
    public void addItemProgress(int progress) {
        try {
            GrabDevNode2 devNode = CURGRAB_DEV.get();
            if (devNode == null) {
                LOGGER.warn("devNode is null.");
                return;
            }
            ExecuteResult result = this.isNeedShowDetailList(devNode);
            if (result == null) {
                return;
            }
            int curProg = result.getCurItemProgress() + progress;
            curProg = curProg > 99 ? 99 : curProg;
            result.setCurItemProgress(curProg);
            result.setShowProgress(progress >= 0 && progress < 100);
            this.updateItemProgress(devNode);
        }
        catch (Exception e) {
            LOGGER.error("add progress error", (Throwable)e);
        }
    }

    @Override
    public void notifyDevGrabEnd(GrabResultEntity entity) {
    }

    @Override
    public void refreshPregress(GrabResultEntity entity) {
    }

    private boolean containMigrSAN() {
        List<String> taskCategory = ((RealTimeTask)this.taskPanel.getTask()).getTaskCategory();
        String migrType = this.taskPanel.getTask().getMigrType();
        return taskCategory.contains(ResourceUtil.getString((String)"infograb.item.category.data_migration")) && "SAN".equals(migrType);
    }

    public JButton getAddDevBtn() {
        return this.addDevBtn;
    }

    public JButton getDeleteDevBtn() {
        return this.deleteDevBtn;
    }

    public JButton getCollectBtn() {
        return this.collectBtn;
    }

    public JButton getStopCollectBtn() {
        return this.stopCollectBtn;
    }
}

