/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.infograb.base.BaseTask;
import com.huawei.ism.tool.infograb.base.BaseTaskPanel;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.RealTimeTask;
import com.huawei.ism.tool.infograb.ui.RealTimeTaskDetailContainer;
import com.huawei.ism.tool.infograb.ui.TaskDetailDialog;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class RealTimeTaskPanel
extends BaseTaskPanel {
    private static final long serialVersionUID = 9158801906575224480L;
    private JLabel taskStatus;
    private JLabel taskProcess;
    private JLabel taskNameLabel;
    private JLabel taskTypeLabel;
    private transient BaseTask task = this.getTask();
    private JComponent contentPan = this.getContentPan();
    private ToolHyperLinkLabel taskCategory;
    private RealTimeTaskDetailContainer taskDetailContainer;

    public RealTimeTaskPanel(BaseTask task) {
        super(task);
        this.initUI();
        this.initLayout();
        this.initListener();
    }

    private void initListener() {
        this.taskCategory.addClickListener(new ToolHyperLinkLabel.ClickListener(){

            @Override
            public void clickLink(MouseEvent e) {
                new TaskDetailDialog((Window)GrabContext.getInstance().getCurrInfoGrabFrame(), RealTimeTaskPanel.this.task).setVisible(true);
            }
        });
    }

    private void initUI() {
        this.taskStatus = new JLabel(ResourceUtil.getString((String)"infograb.task.status.not_add_device"));
        this.taskStatus.setIcon(ResourceUtil.getImage((String)"warning.png"));
        this.taskProcess = new JLabel("0/0");
        this.taskCategory = new ToolHyperLinkLabel(ResourceUtil.getString((String)"infograb.devicetable.cell.details"));
        String taskName = ((RealTimeTask)this.task).getTaskName();
        this.taskNameLabel = new JLabel(taskName);
        String taskType = ResourceUtil.getString((String)"infograb.task.task.type") + " : " + this.task.getTaskType();
        this.taskTypeLabel = new JLabel(taskType);
        this.setBackground(Color.white);
    }

    private void initLayout() {
        JPanel topPan = new JPanel();
        topPan.setLayout(new BoxLayout(topPan, 0));
        topPan.add(Box.createHorizontalStrut(3));
        topPan.add(this.taskNameLabel);
        topPan.add(Box.createHorizontalGlue());
        topPan.add(this.taskCategory);
        topPan.add(Box.createHorizontalStrut(3));
        JPanel bottomPan = new JPanel();
        bottomPan.setLayout(new BoxLayout(bottomPan, 0));
        bottomPan.add(Box.createHorizontalStrut(3));
        bottomPan.add(this.taskTypeLabel);
        bottomPan.add(Box.createHorizontalGlue());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Box.createHorizontalStrut(3));
        panel.add(topPan);
        panel.add(Box.createHorizontalStrut(3));
        panel.add(Box.createHorizontalStrut(3));
        panel.add(bottomPan);
        panel.add(Box.createHorizontalStrut(3));
        JPanel bottomPan0 = new JPanel();
        bottomPan0.setLayout(new BoxLayout(bottomPan0, 0));
        bottomPan0.add(Box.createHorizontalStrut(3));
        bottomPan0.add(this.taskStatus);
        bottomPan0.add(Box.createHorizontalGlue());
        bottomPan0.add(this.taskProcess);
        bottomPan0.add(Box.createHorizontalStrut(3));
        panel.add(Box.createHorizontalStrut(3));
        panel.add(new JSeparator(0));
        panel.add(bottomPan0);
        panel.add(Box.createVerticalStrut(3));
        this.contentPan.setLayout(new BoxLayout(this.contentPan, 0));
        this.contentPan.add(panel);
        this.contentPan.setBorder(BorderFactory.createLineBorder(new Color(Integer.parseInt("990000", 16)), 1));
        this.contentPan.setPreferredSize(new Dimension(200, 58));
        this.setMaximumSize(new Dimension(200, 63));
        this.add(this.contentPan);
    }

    @Override
    public void refreshTaskProcess() {
        RealTimeTask mTask = (RealTimeTask)this.getTask();
        if (mTask.getTaskMaxProcess() == 0) {
            this.taskStatus.setText(ResourceUtil.getString((String)"infograb.task.status.not_add_device"));
            this.taskStatus.setIcon(ResourceUtil.getImage((String)"warning.png"));
            this.taskProcess.setText("0/0");
            mTask.setTaskCurruentProcess(0);
        } else {
            if (mTask.getTaskCurruentProcess() == 0) {
                this.taskStatus.setText(ResourceUtil.getString((String)"infograb.task.status.not_start_collect"));
                this.taskStatus.setIcon(ResourceUtil.getImage((String)"warning.png"));
            }
            this.taskProcess.setText(mTask.getTaskCurruentProcess() + "/" + mTask.getTaskMaxProcess());
        }
        this.repaint();
    }

    public void refreshTaskStatus(List<String> devStatus) {
        if (devStatus.contains(ResourceUtil.getString((String)"infograb.dev.status.waittogo")) || devStatus.contains(ResourceUtil.getString((String)"infograb.dev.status.collecting"))) {
            this.taskStatus.setText(ResourceUtil.getString((String)"infograb.task.status.collecting"));
            this.taskStatus.setIcon(ResourceUtil.getImage((String)"loading.gif"));
        } else if (devStatus.contains(ResourceUtil.getString((String)"infograb.dev.status.noecollect")) || devStatus.contains(ResourceUtil.getString((String)"infograb.dev.status.collectstopped")) || devStatus.contains(ResourceUtil.getString((String)"infograb.dev.status.collectfailed")) || devStatus.contains(ResourceUtil.getString((String)"infograb.dev.status.waittogo"))) {
            this.taskStatus.setText(ResourceUtil.getString((String)"infograb.task.status.part_not_collect"));
            this.taskStatus.setIcon(ResourceUtil.getImage((String)"warning.png"));
        } else {
            this.taskStatus.setText(ResourceUtil.getString((String)"infograb.task.status.all_collect_done"));
            this.taskStatus.setIcon(ResourceUtil.getImage((String)"success.png"));
        }
        this.repaint();
    }

    public void setTaskDetailContainer(RealTimeTaskDetailContainer taskDetailContainer) {
        this.taskDetailContainer = taskDetailContainer;
    }

    public JLabel getTaskNameLabel() {
        return this.taskNameLabel;
    }

    public ToolHyperLinkLabel getTaskCategory() {
        return this.taskCategory;
    }

    public JLabel getTaskStatus() {
        return this.taskStatus;
    }

    public JLabel getTaskProcess() {
        return this.taskProcess;
    }

    @Override
    public JComponent getTaskDetailContainer() {
        return this.taskDetailContainer;
    }
}

