/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.infograb.hostmultipath.pojo.HostBaseInfo;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.InfoGrabDirPropertiesUtil;
import com.huawei.ism.tool.infograb.report.TemplateFactory;
import com.huawei.ism.tool.obase.entity.HostInfo;
import com.huawei.ism.tool.obase.entity.InitiatorEnttiy;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.ui.swing.dialog.DialogsConstants;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorUpAddDevLayout
extends JPanel
implements DialogsConstants {
    private static final long serialVersionUID = -5705818966305782595L;
    private static final Logger LOGGER = LoggerFactory.getLogger(StorUpAddDevLayout.class);
    private Font lastFont = new Font(null, 0, 12);
    private JButton cancelButton;
    private JButton confirmButton;
    private JLabel imageLabel;
    private JCheckBox hostCheckBox = new JCheckBox();
    private JCheckBox dataBaseCheckBox = new JCheckBox();
    private JCheckBox switchCheckBox = new JCheckBox();
    private JCheckBox virtualCheckBox = new JCheckBox();
    private JCheckBox confirmCheckBox = new JCheckBox(ResourceUtil.getString((String)"infograb.add.dev.host.switch.db.alladd.confirm"));
    private JLabel hostCheckLabel = new JLabel(ResourceUtil.getString((String)"infograb.add.dev.check.label.host"));
    private JLabel dbCheckLabel = new JLabel(ResourceUtil.getString((String)"infograb.add.dev.check.label.db"));
    private JLabel swCheckLabel;
    private JLabel vmLabel = new JLabel(ResourceUtil.getString((String)"infograb.add.dev.check.label.vm"));
    private ToolHyperLinkLabel viewHostsLink = new ToolHyperLinkLabel(ResourceUtil.getString((String)"infograb.pre.grab.hosts.bnutton.view"));
    private List<HostInfo> notaddHostInfos;
    private boolean isUpgradeEval;

    public StorUpAddDevLayout(List<HostInfo> notaddHostInfos) {
        if (this.isEngliseEnv()) {
            this.lastFont = new Font("Arial", 0, 12);
        }
        this.notaddHostInfos = notaddHostInfos;
        this.initJLabel();
        this.initComponent();
        this.initUi();
        this.setConfirmEnabled();
        this.setReadEnabled();
    }

    public StorUpAddDevLayout(boolean isUpgradeEval) {
        if (this.isEngliseEnv()) {
            this.lastFont = new Font("Arial", 0, 12);
        }
        this.isUpgradeEval = isUpgradeEval;
        this.notaddHostInfos = new ArrayList<HostInfo>();
        this.initJLabel();
        this.initComponent();
        this.initUi();
        this.setConfirmEnabled();
        this.setReadEnabled();
    }

    public void initJLabel() {
        this.swCheckLabel = new JLabel(ResourceUtil.getString((String)(this.isUpgradeEval ? "infograb.add.dev.check.label.relation" : "infograb.add.dev.check.label.sw")));
    }

    public ToolHyperLinkLabel getViewHostsLink() {
        return this.viewHostsLink;
    }

    private void initComponent() {
        this.cancelButton = UCD.createButton((String)ResourceManager.getString((String)"COMMON.TXT.CANCEL"), (char)'C');
        this.confirmButton = UCD.createButton((String)ResourceManager.getString((String)"COMMON.TXT.CONFIRM"), (char)'O');
        this.imageLabel = new JLabel();
        ImageIcon imageIcon = ResourceManager.getImage((String)"comfirmdialog_warn.png");
        this.imageLabel.setIcon(imageIcon);
    }

    private void initUi() {
        this.setLayout(new BorderLayout());
        this.add((Component)UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createVerticalStrut(12)}), "North");
        JPanel centerPanel = this.buildCenterComp();
        centerPanel.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.add((Component)centerPanel, "Center");
        this.add((Component)this.buildWestComp(), "West");
        this.add((Component)this.buildBottonComp(), "South");
        this.add((Component)UCD.buildVerticalBox(null, (Component[])new Component[]{new JPanel(), Box.createHorizontalStrut(20)}), "East");
    }

    private boolean hostCkbOk() {
        return this.hostCheckBox.isSelected();
    }

    public void setConfirmEnabled() {
        if (this.hostCkbOk() && this.dataBaseCheckBox.isSelected() && this.switchCheckBox.isSelected() && this.confirmCheckBox.isSelected()) {
            this.confirmButton.setEnabled(true);
        } else {
            this.confirmButton.setEnabled(false);
        }
    }

    public void setReadEnabled() {
        if (this.hostCkbOk() && this.dataBaseCheckBox.isSelected() && this.switchCheckBox.isSelected()) {
            this.confirmCheckBox.setEnabled(true);
        } else {
            this.confirmCheckBox.setEnabled(false);
        }
    }

    private JComponent buildWestComp() {
        return UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), this.imageLabel, new JLabel()}), Box.createVerticalStrut(220)});
    }

    private JPanel buildCenterComp() {
        JPanel contenPanel = new JPanel();
        JComponent vBox = UCD.buildVerticalBox(null, (Component[])new Component[]{this.buildAddDevTipComp()});
        vBox.add(Box.createVerticalStrut(20));
        vBox.add(this.buildCheckBoxComp());
        contenPanel.setBackground(Color.WHITE);
        contenPanel.add(vBox);
        return contenPanel;
    }

    private void setCheckBoxName() {
        this.hostCheckBox.setName("addDevHostCheck");
        this.dataBaseCheckBox.setName("addDevDataBaseCheck");
        this.switchCheckBox.setName("addDevSwitchCheck");
        this.confirmCheckBox.setName("addDevConfirmCheck");
    }

    private JComponent buildAddDevTipComp() {
        JLabel confirmLabel0 = null;
        JLabel confirmLabel1 = null;
        JLabel confirmLabel2 = null;
        JLabel confirmLabel3 = null;
        JLabel confirmLabel4 = null;
        confirmLabel0 = new JLabel(ResourceUtil.getString((String)(this.isUpgradeEval ? "infograb.add.dev.alltype.upgradeEva0" : "infograb.add.dev.alltype.tips0")));
        confirmLabel1 = new JLabel(ResourceUtil.getString((String)(this.isUpgradeEval ? "infograb.add.dev.alltype.upgradeEva1" : "infograb.add.dev.alltype.tips1")));
        confirmLabel2 = new JLabel(ResourceUtil.getString((String)(this.isUpgradeEval ? "infograb.add.dev.alltype.tips4" : "infograb.add.dev.alltype.tips2")));
        confirmLabel3 = new JLabel(ResourceUtil.getString((String)(this.isUpgradeEval ? "infograb.add.dev.alltype.tips4" : "infograb.add.dev.alltype.tips3")));
        if (this.isEngliseEnv()) {
            confirmLabel4 = new JLabel(ResourceUtil.getString((String)"infograb.add.dev.alltype.tips4"));
            confirmLabel4.setFont(this.lastFont);
        }
        confirmLabel0.setFont(this.lastFont);
        confirmLabel1.setFont(this.lastFont);
        confirmLabel2.setFont(this.lastFont);
        confirmLabel3.setFont(this.lastFont);
        Box tipBox = StorUpAddDevLayout.buildVBoxTop(0, UCD.buildHBoxLeft((Component[])new Component[]{confirmLabel0}), UCD.buildHBoxLeft((Component[])new Component[]{confirmLabel1}));
        if (this.isEngliseEnv()) {
            tipBox.add(UCD.buildHBoxLeft((Component[])new Component[]{confirmLabel2}));
            tipBox.add(UCD.buildHBoxLeft((Component[])new Component[]{confirmLabel3}));
            tipBox.add(UCD.buildHBoxLeft((Component[])new Component[]{confirmLabel4}));
        } else {
            tipBox.add(Box.createVerticalStrut(5));
            tipBox.add(UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{confirmLabel2})}));
            tipBox.add(Box.createVerticalStrut(3));
        }
        return tipBox;
    }

    public static Box buildVBoxTop(int compMargin, Component ... components) {
        Box vBox = Box.createVerticalBox();
        JComponent box = UCD.buildVerticalBox(null, (int)compMargin, (Component[])components);
        vBox.add(box);
        vBox.add(Box.createVerticalGlue());
        return vBox;
    }

    private JComponent buildCheckBoxComp() {
        this.setCheckBoxName();
        JLabel hostLabel1 = new JLabel(ResourceUtil.getString((String)"infograb.need.add.tips.host1"));
        Object hostLabel2 = null;
        Box hostTipBox0 = null;
        Box hostTipBox1 = null;
        Object swLabel1 = null;
        Box swTipBox = null;
        Object dbLabel1 = null;
        Box dbTipBox = null;
        hostTipBox0 = Box.createHorizontalBox();
        hostTipBox1 = Box.createHorizontalBox();
        swTipBox = Box.createHorizontalBox();
        dbTipBox = Box.createHorizontalBox();
        JLabel hostLabel0 = new JLabel(ResourceUtil.getString((String)"infograb.need.add.tips.host0"));
        hostLabel0.setFont(this.lastFont);
        this.hostCheckLabel.setFont(this.lastFont);
        Box hostCheckHBox = Box.createHorizontalBox();
        hostCheckHBox.add(this.hostCheckBox);
        hostCheckHBox.add(this.hostCheckLabel);
        Box hostBox = UCD.buildHBoxLeft((Component[])new Component[]{hostCheckHBox, hostLabel0});
        JLabel swLabel0 = new JLabel(ResourceUtil.getString((String)(this.isUpgradeEval ? "infograb.need.add.tips.relation" : "infograb.need.add.tips.switch0")));
        swLabel0.setFont(this.lastFont);
        this.swCheckLabel.setFont(this.lastFont);
        this.vmLabel.setFont(this.lastFont);
        Box swHBox = Box.createHorizontalBox();
        swHBox.add(this.switchCheckBox);
        swHBox.add(this.swCheckLabel);
        swHBox.add(swLabel0);
        Box swBox = UCD.buildHBoxLeft((Component[])new Component[]{swHBox, swLabel0});
        JLabel dataLabel0 = new JLabel(ResourceUtil.getString((String)"infograb.need.add.tips.database0"));
        dataLabel0.setFont(this.lastFont);
        Box dbCheckBox = Box.createHorizontalBox();
        this.checkDbCheckBox(dataLabel0, dbCheckBox);
        Box dbBox = UCD.buildHBoxLeft((Component[])new Component[]{dbCheckBox});
        JLabel vmdetailTail1 = null;
        Box checkVBox = this.checkEnglishEnv(hostLabel1, hostTipBox1, hostBox, swBox, dbBox, vmdetailTail1);
        return checkVBox;
    }

    private void checkDbCheckBox(JLabel dataLabel0, Box dbCheckBox) {
        dbCheckBox.add(this.dataBaseCheckBox);
        this.dbCheckLabel.setFont(this.lastFont);
        dbCheckBox.add(this.dbCheckLabel);
        if (this.isEngliseEnv()) {
            dbCheckBox.add(Box.createHorizontalStrut(15));
        } else {
            dbCheckBox.add(Box.createHorizontalStrut(12));
        }
        dbCheckBox.add(dataLabel0);
    }

    private Box checkEnglishEnv(JLabel hostLabel1, Box hostTipBox1, Box hostBox, Box swBox, Box dbBox, JLabel vmdetailTail1) {
        Box dbTipBox;
        Box swTipBox;
        Box hostTipBox0;
        if (this.isEngliseEnv()) {
            vmdetailTail1 = new JLabel(ResourceUtil.getString((String)"infograb.grab.dev.missing.dev.add.tip.tail1"));
            vmdetailTail1.setFont(this.lastFont);
            JLabel hostLabel2 = new JLabel(ResourceUtil.getString((String)"infograb.need.add.tips.host2"));
            hostTipBox0 = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(58), hostLabel1});
            hostTipBox1 = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(58), hostLabel2});
            JLabel swLabel1 = new JLabel(ResourceUtil.getString((String)(this.isUpgradeEval ? "infograb.need.add.tips.host2" : "infograb.need.add.tips.switch1")));
            swTipBox = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(80), swLabel1});
            JLabel dbLabel1 = new JLabel(ResourceUtil.getString((String)"infograb.need.add.tips.database1"));
            dbTipBox = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(73), dbLabel1});
            hostLabel1.setFont(this.lastFont);
            hostLabel2.setFont(this.lastFont);
            swLabel1.setFont(this.lastFont);
            dbLabel1.setFont(this.lastFont);
        } else {
            JLabel swLabel1 = new JLabel("");
            JLabel hostLabel2 = new JLabel("");
            hostTipBox0 = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(74), hostLabel1});
            swTipBox = UCD.buildHBoxLeft((Component[])new Component[]{swLabel1, hostLabel2});
            JLabel dbLabel1 = new JLabel();
            dbTipBox = UCD.buildHBoxLeft((Component[])new Component[]{dbLabel1});
        }
        Box checkVBox = UCD.buildVBoxTop((int)0, (Component[])new Component[]{Box.createVerticalStrut(1)});
        checkVBox.add(hostBox);
        checkVBox.add(hostTipBox0);
        checkVBox.add(hostTipBox1);
        checkVBox.add(Box.createVerticalStrut(5));
        checkVBox.add(dbBox);
        boolean needShowHosts = this.needShotHosts();
        if (this.notaddHostInfos != null && needShowHosts && !this.notaddHostInfos.isEmpty()) {
            this.showNotAddHostTips(checkVBox, this.notaddHostInfos);
            if (this.isEngliseEnv()) {
                checkVBox.add(UCD.buildHBoxLeft((int)0, (Component[])new Component[]{Box.createHorizontalStrut(105), vmdetailTail1}));
            }
        }
        this.setCheckVBox(swBox, dbBox, swTipBox, dbTipBox, checkVBox);
        return checkVBox;
    }

    private void setCheckVBox(Box swBox, Box dbBox, Box swTipBox, Box dbTipBox, Box checkVBox) {
        checkVBox.add(Box.createVerticalStrut(12));
        checkVBox.add(dbBox);
        checkVBox.add(dbTipBox);
        checkVBox.add(Box.createVerticalStrut(12));
        checkVBox.add(swBox);
        checkVBox.add(swTipBox);
        checkVBox.add(Box.createVerticalStrut(12));
    }

    private void showNotAddHostTips(Box checkVBox, List<HostInfo> notaddHostInfoList) {
        byte[] space = new byte[LanguageManager.isEnglish() ? 30 : 20];
        Arrays.fill(space, (byte)32);
        this.prepareAndWriteToFileTxt(notaddHostInfoList);
        this.prepareAndWriteToFileHtml(notaddHostInfoList);
        JLabel viewLabelSpace = new JLabel(new String(space, Charset.defaultCharset()));
        JLabel viewTextLabelhead = new JLabel(ResourceUtil.getStringWithParams((String)"infograb.grab.dev.missing.dev.add.tip.head", (Object[])new Object[]{notaddHostInfoList.size()}));
        JLabel viewTextLabelTail = new JLabel(ResourceUtil.getString((String)"infograb.grab.dev.missing.dev.add.tip.tail"));
        viewLabelSpace.setFont(this.lastFont);
        viewTextLabelhead.setFont(this.lastFont);
        viewTextLabelTail.setFont(this.lastFont);
        this.viewHostsLink.setFont(this.lastFont);
        Box viewHostsDetail = UCD.buildHBoxLeft((int)0, (Component[])new Component[]{Box.createHorizontalStrut(this.isEngliseEnv() ? 68 : 75), viewTextLabelhead, this.viewHostsLink, viewTextLabelTail});
        checkVBox.add(viewHostsDetail);
    }

    private void prepareAndWriteToFileTxt(List<HostInfo> notaddHosts) {
        String separator = "------------------------------";
        StringBuilder finalResult = new StringBuilder();
        HashMap<String, StringBuilder> devBuilder = new HashMap<String, StringBuilder>();
        for (HostInfo hostInfo : notaddHosts) {
            this.appendHost(separator, devBuilder, hostInfo);
        }
        for (Map.Entry entry : devBuilder.entrySet()) {
            finalResult.append((CharSequence)entry.getValue());
        }
        try {
            String filePath = InfoGrabDirPropertiesUtil.getProperty() + File.separator + "hostInfo4PreUpgradeCheck.txt";
            Files.write(Paths.get(filePath, new String[0]), finalResult.toString().getBytes(Charset.defaultCharset()), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("write error", (Throwable)e);
        }
    }

    private boolean prepareAndWriteToFileHtml(List<HostInfo> notaddHosts) {
        try {
            String hostInfoHmtlFilePath = InfoGrabDirPropertiesUtil.getProperty() + File.separator + "hostInfo4PreUpgradeCheck.html";
            HashMap<String, ArrayList<HostBaseInfo>> hostInfoData = this.getUnAddedHostInfo(notaddHosts);
            HashMap<String, String> storageInfoData = this.getStorageInfo(notaddHosts);
            Set<String> devSNsData = storageInfoData.keySet();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("storageInfoData", storageInfoData);
            data.put("hostInfoData", hostInfoData);
            data.put("devSNsData", devSNsData);
            return TemplateFactory.processorFtl("hostInfo.html", data, hostInfoHmtlFilePath);
        }
        catch (Exception e) {
            LOGGER.error("prepareAndWriteToFileHtml error", (Throwable)e);
            return false;
        }
    }

    public HashMap<String, String> getStorageInfo(List<HostInfo> notaddHosts) {
        HashMap<String, String> data = new HashMap<String, String>();
        if (notaddHosts == null || notaddHosts.isEmpty()) {
            return data;
        }
        for (HostInfo host : notaddHosts) {
            String devSN = host.getStorageSn();
            String devIP = host.getStorageIp() == null ? "" : host.getStorageIp();
            data.put(devSN, devIP);
        }
        return data;
    }

    public HashMap<String, ArrayList<HostBaseInfo>> getUnAddedHostInfo(List<HostInfo> notaddHosts) {
        HashMap<String, ArrayList<HostBaseInfo>> data = new HashMap<String, ArrayList<HostBaseInfo>>();
        if (notaddHosts == null || notaddHosts.isEmpty()) {
            return data;
        }
        for (HostInfo host : notaddHosts) {
            String devSN = host.getStorageSn();
            String hostName = host.getHostName();
            StringBuilder hostWWNStr = new StringBuilder();
            List<InitiatorEnttiy> initors = host.getHostInit();
            if (initors != null && !initors.isEmpty()) {
                for (InitiatorEnttiy initor : initors) {
                    if (initor.getWwn() != null) {
                        hostWWNStr.append(initor.getWwn());
                    } else {
                        hostWWNStr.append(initor.getIscsiIQN());
                    }
                    hostWWNStr.append("\t");
                }
            }
            String hostWWN = hostWWNStr.toString();
            HostBaseInfo hostBase = new HostBaseInfo();
            hostBase.setInitiatorWWN(hostWWN);
            hostBase.setName(hostName);
            ArrayList<HostBaseInfo> hosts = data.get(devSN);
            if (hosts == null || hosts.isEmpty()) {
                hosts = new ArrayList();
            }
            hosts.add(hostBase);
            data.put(devSN, hosts);
        }
        return data;
    }

    public void appendHost(String separator, Map<String, StringBuilder> devBuilder, HostInfo hostInfo) {
        String deviceSn = hostInfo.getStorageSn();
        StringBuilder builder = devBuilder.get(deviceSn);
        if (builder == null) {
            builder = new StringBuilder();
            builder.append(separator).append(deviceSn);
            if (!StringUtils.isNULLStr((String)hostInfo.getStorageIp())) {
                builder.append('(').append(hostInfo.getStorageIp()).append(')');
            }
            builder.append(separator);
            builder.append(System.lineSeparator());
            devBuilder.put(deviceSn, builder);
        }
        builder.append("Host Name:\t").append(hostInfo.getHostName()).append(',');
        if (!hostInfo.getHostInit().isEmpty()) {
            builder.append("\t\tHost initiator WWN:");
        }
        for (InitiatorEnttiy entity : hostInfo.getHostInit()) {
            if (entity.getWwn() != null) {
                builder.append(entity.getWwn());
            } else {
                builder.append(entity.getIscsiIQN());
            }
            builder.append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(System.lineSeparator());
    }

    public boolean isEngliseEnv() {
        return LanguageManager.getInstance().getCurrentLanguage().equals(Locale.ENGLISH);
    }

    private JComponent buildBottonComp() {
        this.confirmCheckBox.setFont(this.lastFont);
        return UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{Box.createVerticalStrut(5)}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(60), this.confirmCheckBox}), new JSeparator(), UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(40), this.confirmButton, this.cancelButton}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createVerticalStrut(5)})});
    }

    public JButton getCannelButton() {
        return this.cancelButton;
    }

    public JButton getConfirmButton() {
        return this.confirmButton;
    }

    public JCheckBox getHostCheckBox() {
        return this.hostCheckBox;
    }

    public JCheckBox getDataBaseCheckBox() {
        return this.dataBaseCheckBox;
    }

    public JCheckBox getSwitchCheckBox() {
        return this.switchCheckBox;
    }

    public JCheckBox getConfirmCheckBox() {
        return this.confirmCheckBox;
    }

    public boolean needShotHosts() {
        return !SceneUtils.isScene() || SceneUtils.isScene() && (this.notaddHostInfos == null || !this.notaddHostInfos.isEmpty());
    }
}

