/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui;

import com.huawei.ism.tool.base.utils.Base64EncodeUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.service.task.DevResultDisplayer;
import com.huawei.ism.tool.devicemanager.service.task.DeviceModifyObserver;
import com.huawei.ism.tool.devicemanager.service.task.IDeviceOperaObserver;
import com.huawei.ism.tool.devicemanager.ui.dialog.ApplyDialog;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.User;
import com.huawei.ism.tool.infograb.connection.DbConnectionManager;
import com.huawei.ism.tool.infograb.connection.SshConnectionHelper;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode1;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.ui.IntegrateGrabSetupDialog;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.obase.connection.IGrabCliConnection;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.win.WmicConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTask;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTaskExecutor;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.ui.dialogs.ProgressNumDialog;
import com.huawei.ism.tool.obase.utils.ArrayUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import org.apache.log4j.Logger;

public class SwitchRootDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 4810962662314199397L;
    private GrabDevNode2 device;
    private List<GrabDevNode1> deviceNodes = new ArrayList<GrabDevNode1>();
    private transient IsmTextField username;
    private JLabel deviceType;
    private JLabel deviceName;
    private transient JLabel deviceSerialNumber;
    private transient JPasswordField password;
    private transient JLabel ipAddress;
    private JButton confirm;
    private JButton cancel;
    private JButton applyTo;
    private List<GrabDevNode1> selectDevNode = new ArrayList<GrabDevNode1>();
    private IntegrateGrabSetupDialog parent;

    public SwitchRootDialog(IntegrateGrabSetupDialog parent, GrabDevNode2 device) {
        super(parent);
        this.parent = parent;
        this.device = device;
        this.init();
    }

    public SwitchRootDialog(IntegrateGrabSetupDialog panel, GrabDevNode2 device, List<GrabDevNode2> devNodes) {
        super(panel);
        this.parent = panel;
        this.device = device;
        this.deviceNodes = ToolUtils.obaseNodetoGrabDevNode1(devNodes);
        this.init();
    }

    private void init() {
        this.setMinimumSize(new Dimension(320, 300));
        this.initComponent();
        this.setResizable(false);
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
        UiMethod.setBatchButtonMnemonic(this.confirm);
        UiMethod.setCloseWhenEscKeyPressed(this);
        this.setModal(true);
    }

    private void initComponent() {
        this.username = UiMethod.getUsernameFiled();
        this.username.setText("root");
        this.username.setEditable(false);
        this.password = UiMethod.getPasswordFiled();
        this.deviceName = new JLabel(this.device.getDeviceName());
        this.deviceType = new JLabel(this.device.getDeviceType().toString());
        this.deviceSerialNumber = new JLabel(this.device.getDeviceSerialNumber());
        this.ipAddress = new JLabel(this.device.getIp());
        this.confirm = UiMethod.createButton(ResourceUtil.getString((String)"infograb.switch_root_confirm"), 'O');
        this.cancel = UiMethod.createButton(ResourceUtil.getString((String)"infograb.switch_root_cancel"), 'C');
        this.applyTo = UiMethod.createButton(ResourceUtil.getString((String)"devicemanager.layout.device.applyto"), 'A');
        this.confirm.addActionListener(this);
        this.cancel.addActionListener(this);
        this.applyTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                ApplyDialog applyDialog = new ApplyDialog((JDialog)SwitchRootDialog.this);
                applyDialog.initData(SwitchRootDialog.this.getNodes());
                applyDialog.setVisible(true);
                if (!applyDialog.isCancelClose()) {
                    SwitchRootDialog.this.selectDevNode = ToolUtils.obaseToNewNode1List(applyDialog.getSelectRow());
                }
                SwitchRootDialog.this.selectDevNode.add(ToolUtils.grabNode2ToNode1(SwitchRootDialog.this.device));
            }
        });
        UiMethod.setComponentSize(new Dimension(150, 21), new Component[]{this.username, this.password, this.deviceName, this.deviceType, this.deviceSerialNumber, this.ipAddress});
        this.getRootPane().setDefaultButton(this.confirm);
        this.setTitle(ResourceUtil.getString((String)"infograb.switch_root_title"));
        this.setLayout(new BorderLayout());
        this.add(UiMethod.buildFrameSpace(UCD.buildVerticalBox(null, (Component[])new Component[]{this.createCom(), UCD.buildHBoxRight((Component[])new Component[]{this.confirm, this.applyTo, this.cancel})}), 12));
    }

    private List<DevNode> getNodes() {
        ArrayList<DevNode> nodes = new ArrayList<DevNode>();
        ArrayList<GrabDevNode1> deivces = new ArrayList<GrabDevNode1>();
        if (null != this.deviceNodes) {
            deivces.addAll(this.deviceNodes);
        } else {
            deivces.addAll(DefaultNodeProviderImpl.getInstance().getNodeList());
        }
        GrabDevNode1 devToComparison = ToolUtils.grabNode2ToNode1(this.device);
        for (DevNode devNode : deivces) {
            if (devNode.equals(devToComparison) || !devNode.getDevTypeLevel2().equals(devToComparison.getDevTypeLevel2())) continue;
            nodes.add(devNode);
        }
        return nodes;
    }

    private JComponent createCom() {
        JLabel deviceTypeLable = new JLabel(ResourceUtil.getString((String)"infograb.switch_root_device_type"));
        JLabel deviceNameLable = new JLabel(ResourceUtil.getString((String)"infograb.switch_root_device_name"));
        JLabel ipAddressLable = new JLabel(ResourceUtil.getString((String)"infograb.switch_root_device_ip"));
        JLabel serialLabel = new JLabel(ResourceUtil.getString((String)"infograb.switch_root_device_serial"));
        JLabel usernameLable = new JLabel(ResourceUtil.getString((String)"infograb.switch_root_device_admin_name"));
        JLabel passwordLabel = new JLabel(ResourceUtil.getString((String)"infograb.switch_root_device_admin_pass"));
        UiMethod.setComponentSameMaxWidthSize(deviceTypeLable, deviceNameLable, ipAddressLable, serialLabel, usernameLable, passwordLabel);
        Box devtypecom = UCD.buildHBoxLeft((Component[])new Component[]{deviceTypeLable, this.deviceType});
        Box devnamecom = UCD.buildHBoxLeft((Component[])new Component[]{deviceNameLable, this.deviceName});
        Box ipcom = UCD.buildHBoxLeft((Component[])new Component[]{ipAddressLable, this.ipAddress});
        Box sncom = UCD.buildHBoxLeft((Component[])new Component[]{serialLabel, this.deviceSerialNumber});
        Box namecom = UCD.buildHBoxLeft((Component[])new Component[]{usernameLable, this.username});
        Box pwdcom = UCD.buildHBoxLeft((Component[])new Component[]{passwordLabel, this.password});
        if (null != this.device.getPriKey()) {
            return UCD.buildVerticalBox(null, (Component[])new Component[]{devtypecom, devnamecom, ipcom, sncom, namecom, pwdcom, Box.createVerticalStrut(12)});
        }
        return UCD.buildVerticalBox(null, (Component[])new Component[]{devtypecom, devnamecom, ipcom, sncom, namecom, pwdcom, Box.createVerticalStrut(12)});
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (null != event) {
            Object source = event.getSource();
            if (source == this.confirm) {
                char[] pwdChars;
                String pass;
                String name = this.username.getText();
                if (StringUtils.hasNULLStr(name, pass = Base64EncodeUtils.encode((String)new String(pwdChars = this.password.getPassword())))) {
                    DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.switch_root_info"));
                    return;
                }
                User rootUser = new User(name, pass);
                ArrayUtils.clearCharArray(pwdChars);
                ProgressNumDialog progressDialog = null;
                progressDialog = null != this.parent ? new ProgressNumDialog((Window)this.parent) : new ProgressNumDialog((Window)this);
                DevResultDisplayer displayer = new DevResultDisplayer();
                ServiceTaskExecutor taskExecutor = new ServiceTaskExecutor(progressDialog);
                if (this.selectDevNode.isEmpty()) {
                    this.selectDevNode.add(ToolUtils.grabNode2ToNode1(this.device));
                }
                DeviceCheckTask queryTypeTask = new DeviceCheckTask(this.selectDevNode, rootUser, progressDialog, this.parent);
                queryTypeTask.setDeviceModifyObserver((IDeviceOperaObserver)new DeviceModifyObserver(displayer));
                this.setVisible(false);
                taskExecutor.execute(queryTypeTask);
                displayer.showResult((Window)this);
            } else if (source == this.cancel) {
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    private static class DeviceCheckTask
    extends ServiceTask {
        private static final Logger LOGGER = Logger.getLogger(DeviceCheckTask.class);
        private User mRootUser;
        private IGrabCliConnection devCon;
        private List<GrabDevNode1> selectDecExce;
        private ProgressNumDialog progressDialog;
        private IDeviceOperaObserver deviceModifyObserver = null;
        private IntegrateGrabSetupDialog parent;

        public DeviceCheckTask(List<GrabDevNode1> selectDevNode, User rootUser, ProgressNumDialog progressDialog, IntegrateGrabSetupDialog parent) {
            this.selectDecExce = selectDevNode;
            this.mRootUser = rootUser;
            this.progressDialog = progressDialog;
            this.parent = parent;
        }

        public void setDeviceModifyObserver(IDeviceOperaObserver observer) {
            this.deviceModifyObserver = observer;
        }

        private int refreshProgress(int count) {
            int progress = ++count * 100 / this.selectDecExce.size();
            this.progressDialog.updateProgress(progress);
            return count;
        }

        @Override
        protected TaskResult doTask() {
            int count = 0;
            TaskResult result = null;
            for (GrabDevNode1 dev : this.selectDecExce) {
                result = this.checkDevice(ToolUtils.toGrabNewNode(dev));
                this.deviceModifyObserver.observe(result, dev.getIp());
                count = this.refreshProgress(count);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TaskResult checkDevice(GrabDevNode2 dev) {
            TaskResult taskResult = new TaskResult();
            this.devCon = null;
            try {
                this.createProperCon(dev);
                dev.setRootUser(this.mRootUser);
                if (null != this.devCon) {
                    this.devCon.execSwitchRootCmd(dev);
                    String echoCurrent = this.devCon.execCmd("whoami");
                    LOGGER.info((Object)("whoami : ******; switch " + this.mRootUser.getUserName()));
                    if (SshConnection.isSwitchRoot(echoCurrent)) {
                        taskResult.setResult(TaskResult.Result.SUCCESS);
                        GrabContext.getInstance().getAdminNameAndPassMap().put(dev.getIp(), this.mRootUser);
                        this.parent.initRootHyperLinkLayout();
                    } else {
                        taskResult.setResult(TaskResult.Result.FAILED);
                        if (SshConnection.checkWhoAmICommond(echoCurrent)) {
                            taskResult.setErrorLocaleDescription(ResourceUtil.getString((String)"infograb.check.whoami.error"));
                        } else {
                            taskResult.setErrorLocaleDescription(ResourceUtil.getString((String)"infograb.switchroot.passwd.error"));
                        }
                    }
                }
            }
            catch (ToolException e) {
                LOGGER.error((Object)"This Node *** has some error in excute item");
            }
            finally {
                if (this.devCon != null) {
                    this.devCon.close();
                }
            }
            return taskResult;
        }

        private void createProperCon(GrabDevNode2 dev) throws ToolException {
            GrabDevNode1 oldDevNode = ToolUtils.grabNode2ToNode1(dev);
            if (ItDeviceType.Host.equals((Object)dev.getItDeviceType()) || ItDeviceType.Switch.equals((Object)dev.getItDeviceType())) {
                if ("windows".equalsIgnoreCase(dev.getDevTypeLevel2().toString())) {
                    this.devCon = (IGrabCliConnection)WmicConnectionManager.getWmicConnection(oldDevNode);
                    return;
                }
                this.devCon = (IGrabCliConnection)SshConnectionHelper.getSshConnection(oldDevNode);
                return;
            }
            if (ItDeviceType.Database.equals((Object)dev.getItDeviceType())) {
                this.devCon = DbConnectionManager.getDbConnection(oldDevNode);
            }
        }
    }
}

