/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.infograb.base.BaseTask;
import com.huawei.ism.tool.infograb.entity.MigrationType;
import com.huawei.ism.tool.infograb.entity.OtherScenariosEntity;
import com.huawei.ism.tool.infograb.entity.RealTimeTask;
import com.huawei.ism.tool.infograb.ui.CollectScenariosLayout;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class TaskDetailDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -8478875848321316447L;
    private JLabel taskNameLabel = null;
    private JLabel taskTypeLabel = null;
    private JLabel storageModelLabel = null;
    private JCheckBox categoryMigration = null;
    private JComboBox<OtherScenariosEntity> migrTypecomboBox = null;
    private JCheckBox categoryCampatibility = null;
    private JCheckBox categoryPreUpdate = null;
    private JCheckBox categoryOther = null;
    private JComboBox otherTaskTypecomboBox = null;
    private final CollectScenariosLayout categoryAllBox = new CollectScenariosLayout();
    private JButton closeBtn = null;
    private transient RealTimeTask task = null;

    public TaskDetailDialog(Window parent, BaseTask task) {
        super(parent);
        this.setMinimumSize(new Dimension(450, 280));
        this.setResizable(false);
        this.setTitle(ResourceUtil.getString((String)"ingograb.task.detail"));
        if (task instanceof RealTimeTask) {
            this.task = (RealTimeTask)task;
        }
        this.initUI();
        this.initFrameSize();
        this.setResizable(false);
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
        this.setModal(true);
        this.initData();
        this.initLayout();
    }

    private void initFrameSize() {
        this.setMinimumSize(new Dimension(450, 320));
    }

    private void initLayout() {
        this.add((Component)UiMethod.buildFrameSpace(this.packContentArea(this.categoryAllBox), 12), "Center");
        this.categoryAllBox.setAllComponentsEnabled(false);
    }

    private JComponent packContentArea(JComponent categoryBox) {
        Box contentArea = null;
        contentArea = !"".equals(this.task.getStorageModel()) ? UiMethod.createVerticalBox(UCD.buildHBoxLeft((Component[])new Component[]{this.taskNameLabel}), UCD.buildHBoxLeft((Component[])new Component[]{this.taskTypeLabel}), UCD.buildHBoxLeft((Component[])new Component[]{this.storageModelLabel}), categoryBox, UCD.buildHBoxRight((Component[])new Component[]{this.closeBtn})) : UiMethod.createVerticalBox(UCD.buildHBoxLeft((Component[])new Component[]{this.taskNameLabel}), UCD.buildHBoxLeft((Component[])new Component[]{this.taskTypeLabel}), categoryBox, UCD.buildHBoxRight((Component[])new Component[]{this.closeBtn}));
        return contentArea;
    }

    private void initData() {
        this.taskNameLabel.setText(ResourceUtil.getString((String)"infograb.task.name") + this.task.getTaskName());
        this.taskTypeLabel.setText(ResourceUtil.getString((String)"infograb.task.type") + this.task.getTaskType());
        if (this.task.getTaskCategory().contains(this.categoryCampatibility.getText())) {
            this.categoryCampatibility.setSelected(true);
            this.storageModelLabel.setText(ResourceUtil.getString((String)"infograb.item.category") + " \uff1a " + this.task.getStorageModel());
        }
        if (this.task.getTaskCategory().contains(this.categoryMigration.getText())) {
            this.categoryMigration.setSelected(true);
        }
        if (MigrationType.NAS.getName().equals(this.task.getMigrType())) {
            this.migrTypecomboBox.setSelectedIndex(1);
        }
        if (this.task.getTaskCategory().contains(this.categoryPreUpdate.getText())) {
            this.categoryPreUpdate.setSelected(true);
            this.storageModelLabel.setText(ResourceUtil.getString((String)"infograb.item.category") + " \uff1a " + this.task.getStorageModel());
        }
        for (int i = 0; i < this.otherTaskTypecomboBox.getItemCount(); ++i) {
            if (!this.task.getTaskCategory().contains(this.otherTaskTypecomboBox.getItemAt(i).toString())) continue;
            this.otherTaskTypecomboBox.setSelectedIndex(i);
            this.categoryOther.setSelected(true);
            this.otherTaskTypecomboBox.setEnabled(false);
            this.storageModelLabel.setText(ResourceUtil.getString((String)"infograb.item.category") + " \uff1a " + this.task.getStorageModel());
            break;
        }
    }

    private void initUI() {
        this.taskTypeLabel = new JLabel();
        this.taskNameLabel = new JLabel();
        this.storageModelLabel = new JLabel();
        this.categoryMigration = this.categoryAllBox.getCategoryMigration();
        this.migrTypecomboBox = this.categoryAllBox.getMigrTypecomboBox();
        this.categoryCampatibility = this.categoryAllBox.getCategoryCampatibility();
        this.categoryPreUpdate = this.categoryAllBox.getCategoryPreUpdate();
        this.categoryOther = this.categoryAllBox.getCategoryOther();
        this.otherTaskTypecomboBox = this.categoryAllBox.getOtherTaskTypecomboBox();
        this.closeBtn = UiMethod.createButton(ResourceUtil.getString((String)"infograb.button.close"), 'C');
        this.closeBtn.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source;
        if (null != event && (source = event.getSource()) == this.closeBtn) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

